/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.wechatenterprise.service.common;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DateUtil {
    public static String ymdhms = "yyyy-MM-dd HH:mm:ss";
    public static String ymdhmsS = "yyyy-MM-dd HH:mm:ss SSS";
    public static String ymd = "yyyy-MM-dd";
    public static SimpleDateFormat ymdSDF = new SimpleDateFormat(ymd);
    private static String year = "yyyy";
    private static String month = "MM";
    private static String day = "dd";
    public static SimpleDateFormat yyyyMMddHHmmss = new SimpleDateFormat(ymdhms);
    public static SimpleDateFormat yearSDF = new SimpleDateFormat(year);
    public static SimpleDateFormat monthSDF = new SimpleDateFormat(month);
    public static SimpleDateFormat daySDF = new SimpleDateFormat(day);
    public static SimpleDateFormat yyyyMMddHHmm = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    public static SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyy-MM-dd");
    public static SimpleDateFormat yyyyMMddHH_NOT_ = new SimpleDateFormat("yyyyMMdd");
    public static long DATEMM = 86400L;

    public static Long getTimeStampSeconds(int timeStamp) {
        Calendar instance = Calendar.getInstance();
        instance.add(13, timeStamp);
        return instance.getTimeInMillis();
    }

    public static void main(String[] args) {
        System.out.println("\u5f53\u524d\u65f6\u95f4:" + System.currentTimeMillis());
    }

    public static String getCurrentTime() {
        return yyyyMMddHHmmss.format(new Date());
    }

    public static Date getStrDateByDay(Date date, Integer day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, day);
        date = calendar.getTime();
        return date;
    }

    public static String getStrDateByDay(String backDay) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, Integer.parseInt("-" + backDay));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String back = sdf.format(calendar.getTime());
        return back;
    }

    public static String getStrDateByMonth(String backMonth) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, Integer.parseInt("-" + backMonth));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String back = sdf.format(calendar.getTime());
        return back;
    }

    public static String getCurrentYear() {
        return yearSDF.format(new Date());
    }

    public static String getCurrentMonth() {
        return monthSDF.format(new Date());
    }

    public static String getCurrentDay() {
        return daySDF.format(new Date());
    }

    public static String getCurrentymd() {
        return ymdSDF.format(new Date());
    }

    public static long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static long getTimeNumberToday() {
        Date date = new Date();
        String str = yyyyMMdd.format(date);
        try {
            date = yyyyMMdd.parse(str);
            return date.getTime() / 1000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static String getTodateString() {
        String str = yyyyMMddHH_NOT_.format(new Date());
        return str;
    }

    public static Date getBeforeDayZeroHour(int date) {
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.get(5) - date);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        return cal.getTime();
    }

    public static Date getStartDateOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        return cal.getTime();
    }

    public static Date getEndDateOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(13, 59);
        cal.set(12, 59);
        cal.set(11, 23);
        return cal.getTime();
    }

    public static String longToString(long date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date dt2 = new Date(date * 1000L);
        String sDateTime = sdf.format(dt2);
        return sDateTime;
    }

    public static Date getTodayZeroHour() {
        Calendar cal = Calendar.getInstance();
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        return cal.getTime();
    }

    public static Date getBeforeDay24Hour(int date) {
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.get(5) - date);
        cal.set(13, 59);
        cal.set(12, 59);
        cal.set(11, 23);
        return cal.getTime();
    }

    public static Date stringToDate(String date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            return sdf.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getStartDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(7, 1);
        date = c.getTime();
        return date;
    }

    public static Date getLastDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(7, 7);
        date = c.getTime();
        return date;
    }

    public static Date getStartDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        date = c.getTime();
        return date;
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        c.add(2, 1);
        c.add(5, -1);
        date = c.getTime();
        return date;
    }

    public static Date getStartDayOfNextMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, 1);
        c.set(5, 1);
        date = c.getTime();
        return date;
    }

    public static Date getLastDayOfNextMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        c.add(2, 2);
        c.add(5, -1);
        date = c.getTime();
        return date;
    }

    public static String givedTimeToBefer(String givedTime, long interval, String format_Date_Sign) {
        String tomorrow = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format_Date_Sign);
            Date gDate = sdf.parse(givedTime);
            long current = gDate.getTime();
            long beforeOrAfter = current - interval * 1000L;
            Date date = new Date(beforeOrAfter);
            tomorrow = new SimpleDateFormat(format_Date_Sign).format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return tomorrow;
    }

    public static long stringToLong(String date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date dt2 = null;
        long lTime = 0L;
        try {
            dt2 = sdf.parse(date);
            lTime = dt2.getTime() / 1000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return lTime;
    }

    public static Map<String, String> getTwoDay(String endTime, String beginTime, boolean isEndTime) {
        Map<String, String> result = new HashMap<String, String>();
        if (endTime == null || "".equals(endTime) || beginTime == null || "".equals(beginTime)) {
            return null;
        }
        try {
            Date date = ymdSDF.parse(endTime);
            endTime = ymdSDF.format(date);
            Date mydate = ymdSDF.parse(beginTime);
            long day = (date.getTime() - mydate.getTime()) / 86400000L;
            result = DateUtil.getDate(endTime, Integer.parseInt(day + ""), isEndTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static Integer getTwoDayInterval(String endTime, String beginTime, boolean isEndTime) {
        if (endTime == null || "".equals(endTime) || beginTime == null || "".equals(beginTime)) {
            return 0;
        }
        Long day = 0L;
        try {
            Date date = ymdSDF.parse(endTime);
            endTime = ymdSDF.format(date);
            Date mydate = ymdSDF.parse(beginTime);
            day = (date.getTime() - mydate.getTime()) / 86400000L;
        }
        catch (Exception e) {
            return 0;
        }
        return Integer.parseInt(day + "");
    }

    public static Map<String, String> getDate(String endTime, Integer interval, boolean isEndTime) {
        HashMap<String, String> result = new HashMap<String, String>();
        if ((interval == 0 || isEndTime) && isEndTime) {
            result.put(endTime, endTime);
        }
        if (interval > 0) {
            int begin;
            for (int i = begin = 0; i < interval; ++i) {
                endTime = DateUtil.givedTimeToBefer(endTime, DATEMM, ymd);
                result.put(endTime, endTime);
            }
        }
        return result;
    }

    public static List<Long> getDatesBetweenTwoDate(String beginDate, String endDate) throws ParseException {
        Date bDate = ymdSDF.parse(beginDate);
        Date eDate = ymdSDF.parse(endDate);
        ArrayList<Long> lDate = new ArrayList<Long>();
        lDate.add(bDate.getTime());
        Calendar cal = Calendar.getInstance();
        cal.setTime(bDate);
        boolean bContinue = true;
        while (bContinue) {
            cal.add(5, 1);
            if (!eDate.after(cal.getTime())) break;
            lDate.add(cal.getTime().getTime());
        }
        lDate.add(eDate.getTime());
        return lDate;
    }

    public static String format(Date date, String pattern) {
        String returnValue = "";
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            returnValue = df.format(date);
        }
        return returnValue;
    }

    public static Date parse(String strDate, String pattern) {
        if (StringUtils.isEmpty((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String interceptFormat(String strDate, String originPattern, String newPattern) {
        if (StringUtils.isEmpty((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(newPattern);
        return df.format(DateUtil.stringToDate(strDate, originPattern));
    }

    public static String interceptFormat(String strDate) {
        if (StringUtils.isEmpty((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(ymd);
        return df.format(DateUtil.stringToDate(strDate, ymdhms));
    }

    public static Date addMonth(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, n);
        return cal.getTime();
    }

    public static Long getIntervalMinutes(Date date, Date otherDate) {
        long time = Math.abs(date.getTime() - otherDate.getTime());
        return time == 0L ? 0L : time / 60000L;
    }

    public static Date truncate(Date date, int field) {
        return DateUtils.truncate((Date)date, (int)field);
    }

    public int getDayOfMonth() {
        Calendar aCalendar = Calendar.getInstance(Locale.CHINA);
        int day = aCalendar.getActualMaximum(5);
        return day;
    }

    public static String getNow(String format) {
        return DateUtil.format(new Date(), format);
    }

    public static String getBirthFirst(String year) {
        if (StringUtils.isBlank((CharSequence)year)) {
            year = "0";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        return String.valueOf(Integer.parseInt(format.format(new Date())) - Integer.valueOf(year)) + "-12-31";
    }

    public static String getBirthLast(String year) {
        if (StringUtils.isBlank((CharSequence)year)) {
            year = "100";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        return String.valueOf(Integer.parseInt(format.format(new Date())) - Integer.valueOf(year)) + "-01-01";
    }

    public static String formatDateByPattern(Date date, String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        String formatTimeStr = null;
        if (date != null) {
            formatTimeStr = sdf.format(date);
        }
        return formatTimeStr;
    }

    public static String getCronExpression(Date date) {
        String dateFormat = "ss mm HH dd MM ? yyyy";
        return DateUtil.formatDateByPattern(date, dateFormat);
    }

    public static Date getZeroTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date zero = calendar.getTime();
        return zero;
    }

    public static String getFirstAndLastOfMonth(String dataStr, String dateFormat, String resultDateFormat) throws ParseException {
        Calendar c = Calendar.getInstance();
        c.setTime(new SimpleDateFormat(dateFormat).parse(dataStr));
        c.add(2, 0);
        c.set(5, 1);
        String first = new SimpleDateFormat(resultDateFormat).format(c.getTime());
        Calendar cal = Calendar.getInstance();
        cal.set(1, Integer.parseInt(dataStr.split("-")[0]));
        cal.set(2, Integer.parseInt(dataStr.split("-")[1]) - 1);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String last = sdf.format(cal.getTime());
        return first + "_" + last;
    }

    public static String getFirstAndLastOfWeek(String dataStr, String dateFormat, String resultDateFormat) throws ParseException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new SimpleDateFormat(dateFormat).parse(dataStr));
        int d = 0;
        d = cal.get(7) == 1 ? -6 : 2 - cal.get(7);
        cal.add(7, d);
        String data1 = new SimpleDateFormat(resultDateFormat).format(cal.getTime());
        cal.add(7, 6);
        String data2 = new SimpleDateFormat(resultDateFormat).format(cal.getTime());
        return data1 + "_" + data2;
    }

    public static int getIntervalDays(Date date, Date otherDate) {
        long time = date.getTime() - otherDate.getTime();
        return (int)(time / 86400000L);
    }

    public static int getIntervalDaysAbs(Date date, Date otherDate) {
        long time = date.getTime() - otherDate.getTime();
        return Math.abs((int)(time / 86400000L));
    }

    public static int getIntervalHours(Date date, Date otherDate) {
        long time = date.getTime() - otherDate.getTime();
        return (int)(time / 3600000L);
    }

    public static int daysBetweenAbs(Date smdate, Date bdate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            smdate = sdf.parse(sdf.format(smdate));
            bdate = sdf.parse(sdf.format(bdate));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Math.abs(Integer.parseInt(String.valueOf(between_days)));
    }

    public static int daysBetween(Date smdate, Date bdate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            smdate = sdf.parse(sdf.format(smdate));
            bdate = sdf.parse(sdf.format(bdate));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Math.abs(Integer.parseInt(String.valueOf(between_days)));
    }

    public static Date addDay(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, n);
        return cal.getTime();
    }

    public static Date addHour(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(10, n);
        return cal.getTime();
    }

    public static Date addMinute(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(12, n);
        return cal.getTime();
    }

    public static int getYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1);
        return year;
    }

    public static int getMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int month = cal.get(2) + 1;
        return month;
    }

    public static int getDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int day = cal.get(5);
        return day;
    }

    public static int getHour(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int hour = cal.get(10);
        return hour;
    }

    public static boolean hourMinuteBetween(String nowDate, String startDate, String endDate) throws Exception {
        SimpleDateFormat format = new SimpleDateFormat("HH:mm");
        Date now = format.parse(nowDate);
        Date start = format.parse(startDate);
        Date end = format.parse(endDate);
        long nowTime = now.getTime();
        long startTime = start.getTime();
        long endTime = end.getTime();
        return nowTime >= startTime && nowTime <= endTime;
    }

    public static String getTime(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        String time = format.format(date);
        return time;
    }
}

