/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.unifiedreg.service.po.impl;

import com.alibaba.fastjson.JSON;
import com.bizvane.unifiedreg.common.enums.RegStatusEnum;
import com.bizvane.unifiedreg.common.exception.UnifiedRegException;
import com.bizvane.unifiedreg.mapper.MbrMembersRegTraceRecordPoMapper;
import com.bizvane.unifiedreg.model.po.MbrMembersRegTraceRecordPoExample;
import com.bizvane.unifiedreg.model.po.MbrMembersRegTraceRecordPoWithBLOBs;
import com.bizvane.unifiedreg.model.vo.UnifiedRegisterVo;
import com.bizvane.unifiedreg.service.po.MbrMembersRegTraceRecordPoService;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MbrMembersRegTraceRecordPoImpl
implements MbrMembersRegTraceRecordPoService {
    private static final Logger log = LoggerFactory.getLogger(MbrMembersRegTraceRecordPoImpl.class);
    @Resource
    private MbrMembersRegTraceRecordPoMapper mbrMembersRegTraceRecordPoMapper;

    public MbrMembersRegTraceRecordPoWithBLOBs insertMbrMembersRegTraceRecord(UnifiedRegisterVo registerVo, String memberCode) {
        MbrMembersRegTraceRecordPoWithBLOBs mbrMembersRegTraceRecordPoWithBLOBs = new MbrMembersRegTraceRecordPoWithBLOBs();
        mbrMembersRegTraceRecordPoWithBLOBs.setMemberCode(memberCode);
        mbrMembersRegTraceRecordPoWithBLOBs.setTraceValue(JSON.toJSONString((Object)registerVo));
        mbrMembersRegTraceRecordPoWithBLOBs.setRegStatus(RegStatusEnum.GO_TO_OFFLINE_REGISTER.getCode());
        mbrMembersRegTraceRecordPoWithBLOBs.setLastTrace(MDC.get((String)"traceId"));
        int i = this.mbrMembersRegTraceRecordPoMapper.insertSelective(mbrMembersRegTraceRecordPoWithBLOBs);
        if (i == 0) {
            throw new UnifiedRegException("\u65b0\u589e\u4f1a\u5458\u5f00\u5361\u8bb0\u5f55\u8868\u5931\u8d25!");
        }
        return mbrMembersRegTraceRecordPoWithBLOBs;
    }

    public void modifyErrorMsg(Long mbrRegTraceRecordId, String errorMsg, Integer regStatus) {
        if (mbrRegTraceRecordId == null) {
            log.error("\u66f4\u65b0\u4f1a\u5458\u5f00\u5361\u8bb0\u5f55\u8868\u5931\u8d25,\u4e3b\u952eid\u4e3a\u7a7a");
            return;
        }
        MbrMembersRegTraceRecordPoWithBLOBs mbrMembersRegTraceRecordPoWithBLOBs = new MbrMembersRegTraceRecordPoWithBLOBs();
        mbrMembersRegTraceRecordPoWithBLOBs.setMbrRegTraceRecordId(mbrRegTraceRecordId);
        mbrMembersRegTraceRecordPoWithBLOBs.setErrorMsg(errorMsg);
        mbrMembersRegTraceRecordPoWithBLOBs.setRegStatus(regStatus);
        mbrMembersRegTraceRecordPoWithBLOBs.setLastTrace(MDC.get((String)"traceId"));
        this.mbrMembersRegTraceRecordPoMapper.updateByPrimaryKeySelective(mbrMembersRegTraceRecordPoWithBLOBs);
    }

    public void modifyRegStatus(Long mbrRegTraceRecordId, Integer regStatus) {
        this.modifyErrorMsg(mbrRegTraceRecordId, null, regStatus);
    }

    public void modifyRegSuccess(Long mbrRegTraceRecordId, Integer regStatus) {
        MbrMembersRegTraceRecordPoWithBLOBs mbrMembersRegTraceRecordPoWithBLOBs = this.mbrMembersRegTraceRecordPoMapper.selectByPrimaryKey(mbrRegTraceRecordId);
        mbrMembersRegTraceRecordPoWithBLOBs.setLastTrace(MDC.get((String)"traceId"));
        mbrMembersRegTraceRecordPoWithBLOBs.setRegStatus(regStatus);
        mbrMembersRegTraceRecordPoWithBLOBs.setErrorMsg(null);
        this.mbrMembersRegTraceRecordPoMapper.updateByPrimaryKeyWithBLOBs(mbrMembersRegTraceRecordPoWithBLOBs);
    }

    public MbrMembersRegTraceRecordPoWithBLOBs findByMemberCode(String memberCode, String channelCode) {
        MbrMembersRegTraceRecordPoExample mbrMembersRegTraceRecordPoExample = new MbrMembersRegTraceRecordPoExample();
        mbrMembersRegTraceRecordPoExample.setOrderByClause("mbrRegTraceRecordId desc");
        mbrMembersRegTraceRecordPoExample.createCriteria().andMemberCodeEqualTo(memberCode).andValidEqualTo(Boolean.TRUE).andRegStatusNotEqualTo(RegStatusEnum.OFFLINE_AND_ONLINE_REGISTER_SUCCESS.getCode());
        List mbrMembersRegTraceRecordPoWithBLOBs = this.mbrMembersRegTraceRecordPoMapper.selectByExampleWithBLOBs(mbrMembersRegTraceRecordPoExample);
        if (CollectionUtils.isEmpty((Collection)mbrMembersRegTraceRecordPoWithBLOBs)) {
            return null;
        }
        return (MbrMembersRegTraceRecordPoWithBLOBs)mbrMembersRegTraceRecordPoWithBLOBs.get(0);
    }
}

