/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.unifiedreg.service.mq.producer;

import cn.bizvane.rocketmq.spring.core.MessageDelayLevel;
import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.members.facade.service.card.response.PushMbrModel;
import com.bizvane.unifiedreg.model.vo.mq.ForeignCallBackPointVo;
import com.bizvane.unifiedreg.model.vo.mq.ForeignRegisterMqVo;
import com.bizvane.unifiedreg.model.vo.mq.OfflineUnifiedRegisterMqVo;
import com.bizvane.unifiedreg.model.vo.mq.OfflineUnifiedRegisterSuccessMqVo;
import com.bizvane.unifiedreg.model.vo.mq.OnlineUnifiedRegisterSuccessBindMqVo;
import com.bizvane.unifiedreg.model.vo.mq.OnlineUnifiedRegisterSuccessMqVo;
import com.bizvane.unifiedreg.service.copy.config.RocketMQConfig;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnifiedRegRocketMqProducer {
    private static final Logger log = LoggerFactory.getLogger(UnifiedRegRocketMqProducer.class);
    @Autowired
    private RocketMQTemplate rocketMqTemplate;
    @Autowired
    private RocketMQConfig rocketMqConfig;

    public void pushGoToOfflineRegister(OfflineUnifiedRegisterMqVo offlineUnifiedRegisterMqVo) {
        String paramJson = JSONObject.toJSONString((Object)offlineUnifiedRegisterMqVo);
        log.info("\u53d1\u9001\u7ebf\u4e0b\u6ce8\u518cmq,\u5f00\u59cb,OfflineUnifiedRegisterMqVo:{}", (Object)paramJson);
        Destination destination = new Destination();
        destination.setTopic("UNIFIED_REG_REGISTER");
        destination.setTag("GO_TO_OFFLINE_REGISTER");
        SendResult sendResult = this.rocketMqTemplate.send(destination, (Object)paramJson);
        log.info("\u53d1\u9001\u7ebf\u4e0b\u6ce8\u518cmq,\u7ed3\u675f,SendResult:{}", (Object)JSON.toJSONString((Object)sendResult));
    }

    public void pushGoToOfflineRegisterDelay(OfflineUnifiedRegisterMqVo offlineUnifiedRegisterMqVo, MessageDelayLevel messageDelayLevel) {
        String paramJson = JSONObject.toJSONString((Object)offlineUnifiedRegisterMqVo);
        log.info("\u53d1\u9001\u5ef6\u8fdf\u7ebf\u4e0b\u6ce8\u518cmq,\u5f00\u59cb,OfflineUnifiedRegisterMqVo:{}", (Object)paramJson);
        Destination destination = new Destination();
        destination.setTopic("UNIFIED_REG_REGISTER");
        destination.setTag("GO_TO_OFFLINE_REGISTER");
        destination.setDelayLevel(messageDelayLevel);
        SendResult sendResult = this.rocketMqTemplate.send(destination, (Object)paramJson);
        log.info("\u53d1\u9001\u5ef6\u8fdf\u7ebf\u4e0b\u6ce8\u518cmq,\u7ed3\u675f,SendResult:{}", (Object)JSON.toJSONString((Object)sendResult));
    }

    public void pushOfflineRegisterSuccessCallbackOnline(OfflineUnifiedRegisterSuccessMqVo offlineUnifiedRegisterSuccessMqVo) {
        String paramJson = JSONObject.toJSONString((Object)offlineUnifiedRegisterSuccessMqVo);
        log.info("\u53d1\u9001\u7ebf\u4e0b\u5f00\u5361\u6210\u529f\u56de\u8c03\u7ebf\u4e0amq,\u5f00\u59cb,OfflineUnifiedRegisterSuccessMqVo:{}", (Object)paramJson);
        Destination destination = new Destination();
        destination.setTopic("UNIFIED_REG_REGISTER");
        destination.setTag("OFFLINE_REGISTER_SUCCESS_CALLBACK_ONLINE");
        SendResult sendResult = this.rocketMqTemplate.send(destination, (Object)paramJson);
        log.info("\u53d1\u9001\u7ebf\u4e0b\u5f00\u5361\u6210\u529f\u56de\u8c03\u7ebf\u4e0amq,\u7ed3\u675f,SendResult:{}", (Object)JSON.toJSONString((Object)sendResult));
    }

    public void pushRegisterSuccessEvent(OnlineUnifiedRegisterSuccessMqVo onlineUnifiedRegisterSuccessMqVo) {
        String paramJson = JSONObject.toJSONString((Object)onlineUnifiedRegisterSuccessMqVo);
        log.info("\u53d1\u9001\u901a\u77e5\u6e20\u9053\u670d\u52a1\u5f00\u5361\u6210\u529fmq,\u5f00\u59cb,OfflineUnifiedRegisterSuccessMqVo:{}", (Object)paramJson);
        Destination destination = new Destination();
        destination.setTopic("UNIFIED_REG_REGISTER_SUCCESS_EVENT");
        destination.setTag("REGISTER_SUCCESS_EVENT");
        SendResult sendResult = this.rocketMqTemplate.send(destination, (Object)paramJson);
        log.info("\u53d1\u9001\u901a\u77e5\u6e20\u9053\u670d\u52a1\u5f00\u5361\u6210\u529fmq,\u7ed3\u675f,SendResult:{}", (Object)JSON.toJSONString((Object)sendResult));
    }

    public void pushBindSuccessEvent(OnlineUnifiedRegisterSuccessBindMqVo onlineUnifiedRegisterSuccessBindMqVo) {
        String paramJson = JSONObject.toJSONString((Object)onlineUnifiedRegisterSuccessBindMqVo);
        log.info("\u53d1\u9001\u901a\u77e5\u6e20\u9053\u670d\u52a1\u7ed1\u5361\u6210\u529fmq,\u5f00\u59cb,OfflineUnifiedRegisterSuccessMqVo:{}", (Object)paramJson);
        Destination destination = new Destination();
        destination.setTopic("UNIFIED_REG_REGISTER_SUCCESS_EVENT");
        destination.setTag("BIND_SUCCESS_EVENT");
        SendResult sendResult = this.rocketMqTemplate.send(destination, (Object)paramJson);
        log.info("\u53d1\u9001\u901a\u77e5\u6e20\u9053\u670d\u52a1\u7ed1\u5361\u6210\u529fmq,\u7ed3\u675f,SendResult:{}", (Object)JSON.toJSONString((Object)sendResult));
    }

    public void pushOpenCardActivityEvent(PushMbrModel pushMbrModel) {
        String paramJson = JSONObject.toJSONString((Object)pushMbrModel);
        log.info("\u53d1\u9001\u901a\u77e5\u5f00\u5361\u6d3b\u52a8mq,\u5f00\u59cb,pushOpenCardActivityEvent:{}", (Object)paramJson);
        Destination destination = new Destination();
        destination.setTopic(this.rocketMqConfig.rmqRegisteredTopic);
        destination.setTag(this.rocketMqConfig.rmqRegisteredTag);
        SendResult sendResult = this.rocketMqTemplate.send(destination, (Object)paramJson);
        log.info("\u53d1\u9001\u901a\u77e5\u5f00\u5361\u6d3b\u52a8mq,\u7ed3\u675f,pushOpenCardActivityEvent:{}", (Object)JSON.toJSONString((Object)sendResult));
    }

    public void pushwriteForeignMessageEvent(ForeignRegisterMqVo foreignRegisterMqVo) {
        String paramJson = JSONObject.toJSONString((Object)foreignRegisterMqVo);
        Destination destination = new Destination();
        destination.setTopic("FOREIGN_UNIFIED_REG_REGISTER_MESSAGE");
        SendResult sendResult = this.rocketMqTemplate.send(destination, (Object)paramJson);
        log.info("\u4e3a\u5916\u90e8\u5f00\u5361\u6210\u529f\u56de\u663e\u4fe1\u606f,\u7ed3\u675f,pushwriteForeignMessageEvent:{}", (Object)JSON.toJSONString((Object)sendResult));
    }

    public void pushWriteTianmaoMq(ForeignCallBackPointVo foreignCallBackPointVo) {
        String paramJson = JSONObject.toJSONString((Object)foreignCallBackPointVo);
        log.info("\u5c06\u79ef\u5206\u4fe1\u606f\u5199\u5165\u5929\u732btopic:{}", (Object)paramJson);
        Destination destination = new Destination();
        destination.setTopic("TOPIC_TMALL_INFO_SYNC");
        SendResult sendResult = this.rocketMqTemplate.send(destination, (Object)paramJson);
        log.info("\u5c06\u79ef\u5206\u4fe1\u606f\u5199\u5165\u5929\u732btopic,\u7ed3\u675f,pushWriteTianmaoMq:{}", (Object)JSON.toJSONString((Object)sendResult));
    }
}

