/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.unifiedreg.service.mq;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSON;
import com.bizvane.unifiedreg.model.vo.mq.OfflineUnifiedRegisterMqVo;
import com.bizvane.unifiedreg.service.MemberChannelRegistrationAsyncService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

@RocketMQMessageListener(topic="UNIFIED_REG_REGISTER", tags={"GO_TO_OFFLINE_REGISTER"})
@ConditionalOnProperty(value={"spring.application.name"}, havingValue="unified-reg")
public class GoToOfflineRegisterMqListener
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(GoToOfflineRegisterMqListener.class);
    @Autowired
    private MemberChannelRegistrationAsyncService memberChannelRegistrationAsyncService;

    public void onMessage(ConsumerMessage<String> consumerMessage) {
        log.info("==============================\u7ebf\u4e0b\u6ce8\u518c\u6d88\u8d39mq==============================");
        String consumerMessageString = new String(consumerMessage.getBody());
        log.info("\u7ebf\u4e0b\u6d88\u8d39\u6ce8\u518cmq message:{}", (Object)consumerMessageString);
        OfflineUnifiedRegisterMqVo offlineUnifiedRegisterMqVo = (OfflineUnifiedRegisterMqVo)JSON.parseObject((String)consumerMessageString, OfflineUnifiedRegisterMqVo.class);
        this.memberChannelRegistrationAsyncService.asyncOnlineUnifiedRegister(offlineUnifiedRegisterMqVo);
    }
}

