/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.unifiedreg.service.module.impl;

import com.bizvane.centerstageservice.models.po.SysStaffPo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.rpc.StaffServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.unifiedreg.service.module.CenterStageInterfaceService;
import com.bizvane.unifiedreg.tools.CustomExtractUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CenterStageInterfaceServiceImpl
implements CenterStageInterfaceService {
    private static final Logger log = LoggerFactory.getLogger(CenterStageInterfaceServiceImpl.class);
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private StaffServiceRpc staffServiceRpc;

    public SysStorePo querySysStoreInfo(Long sysStoreId) {
        ResponseData sysStoreVoResponseData = this.storeServiceRpc.getSysStoreById(sysStoreId);
        if (CustomExtractUtil.dataIsNull((ResponseData)sysStoreVoResponseData)) {
            return null;
        }
        return (SysStorePo)sysStoreVoResponseData.getData();
    }

    public SysStorePo querySysStoreInfoByCodeAndCompanyId(String storeCode, Long sysCompanyId) {
        ResponseData storeInfoByCodeAndSysCompanyId = this.storeServiceRpc.getStoreInfoByCodeAndSysCompanyId(storeCode, sysCompanyId);
        if (CustomExtractUtil.dataIsNull((ResponseData)storeInfoByCodeAndSysCompanyId)) {
            return null;
        }
        return (SysStorePo)storeInfoByCodeAndSysCompanyId.getData();
    }

    public SysStaffPo querySysStaffInfo(Long sysStaffId) {
        ResponseData sysStaffPoResponseData = this.staffServiceRpc.getStaffById(sysStaffId);
        if (CustomExtractUtil.dataIsNull((ResponseData)sysStaffPoResponseData)) {
            return null;
        }
        return (SysStaffPo)sysStaffPoResponseData.getData();
    }

    public SysStaffPo querySysStaffInfoByCodeAndCompanyId(String staffCode, Long sysCompanyId) {
        ResponseData staffInfoByCode = this.staffServiceRpc.getStaffInfoByCode(staffCode, sysCompanyId);
        if (CustomExtractUtil.dataIsNull((ResponseData)staffInfoByCode)) {
            return null;
        }
        return (SysStaffPo)staffInfoByCode.getData();
    }
}

