/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.unifiedreg.service.impl;

import com.alibaba.fastjson.JSON;
import com.bizvane.connectorservice.entity.common.MemberOpenCardResponseVO;
import com.bizvane.members.facade.service.card.response.PushMbrModel;
import com.bizvane.unifiedreg.common.constants.UnifiedRegRegisterConstants;
import com.bizvane.unifiedreg.common.enums.UnifiedRegRegisterRetryEnum;
import com.bizvane.unifiedreg.model.po.MbrMembersPo;
import com.bizvane.unifiedreg.model.vo.UnifiedRegisterVo;
import com.bizvane.unifiedreg.model.vo.mq.ForeignCallBackPointVo;
import com.bizvane.unifiedreg.model.vo.mq.ForeignRegisterMqVo;
import com.bizvane.unifiedreg.model.vo.mq.OfflineUnifiedRegisterMqVo;
import com.bizvane.unifiedreg.model.vo.mq.OfflineUnifiedRegisterSuccessMqVo;
import com.bizvane.unifiedreg.model.vo.mq.OnlineUnifiedRegisterSuccessBindMqVo;
import com.bizvane.unifiedreg.model.vo.mq.OnlineUnifiedRegisterSuccessMqVo;
import com.bizvane.unifiedreg.service.UnifiedRegWriteMqService;
import com.bizvane.unifiedreg.service.mq.producer.UnifiedRegRocketMqProducer;
import com.bizvane.unifiedreg.service.po.MbrMembersRegTraceRecordPoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class UnifiedRegWriteMqServiceImpl
implements UnifiedRegWriteMqService {
    private static final Logger log = LoggerFactory.getLogger(UnifiedRegWriteMqServiceImpl.class);
    @Autowired
    private UnifiedRegRocketMqProducer unifiedRegRocketMqProducer;
    @Autowired
    private MbrMembersRegTraceRecordPoService mbrMembersRegTraceRecordPoService;

    @Async
    public void writeOfflineUnifiedRegisterMq(UnifiedRegisterVo registerVo, MbrMembersPo mbrMembersPo) {
        log.info("UnifiedRegWriteMqServiceImpl_writeOfflineUnifiedRegisterMq_success:{}", (Object)"\u5199\u5165\u7ebf\u4e0b\u5f00\u5361\u961f\u5217");
        OfflineUnifiedRegisterMqVo offlineUnifiedRegisterMqVo = OfflineUnifiedRegisterMqVo.builder().memberCode(mbrMembersPo.getMemberCode()).registerVo(registerVo).build();
        this.unifiedRegRocketMqProducer.pushGoToOfflineRegister(offlineUnifiedRegisterMqVo);
    }

    @Async
    public void writeOfflineUnifiedRegisterRetryMq(UnifiedRegisterVo registerVo, MbrMembersPo mbrMembersPo, Integer retryCount, String errorMsg) {
        if (retryCount > UnifiedRegRegisterConstants.UNIFIED_REG_REGISTER_RETRY_MAX_COUNT) {
            log.warn("UnifiedRegWriteMqServiceImpl_writeOfflineUnifiedRegisterRetryMq_error:{}", (Object)"\u5df2\u7ecf\u8d85\u8fc7\u6700\u5927\u91cd\u8bd5\u6b21\u6570:{},\u53d6\u6d88\u6295\u9012mq", (Object)UnifiedRegRegisterConstants.UNIFIED_REG_REGISTER_RETRY_MAX_COUNT);
            return;
        }
        log.info("UnifiedRegWriteMqServiceImpl_writeOfflineUnifiedRegisterRetryMq_success:{}", (Object)"\u5199\u5165\u7ebf\u4e0b\u5f00\u5361\u91cd\u8bd5\u961f\u5217");
        OfflineUnifiedRegisterMqVo offlineUnifiedRegisterMqVo = OfflineUnifiedRegisterMqVo.builder().memberCode(mbrMembersPo.getMemberCode()).registerVo(registerVo).retryCount(retryCount).retryErrorMessage(errorMsg).build();
        UnifiedRegRegisterRetryEnum unifiedRegRegisterRetryEnum = UnifiedRegRegisterRetryEnum.getUnifiedRegRegisterRetryEnum((Integer)retryCount);
        if (unifiedRegRegisterRetryEnum == null) {
            log.warn("UnifiedRegWriteMqServiceImpl_writeOfflineUnifiedRegisterRetryMq_error:{}", (Object)"\u83b7\u53d6\u5ef6\u8fdf\u63a8\u9001\u4fe1\u606f\u4e3a\u7a7a!,\u53d6\u6d88\u6295\u9012mq");
            return;
        }
        this.unifiedRegRocketMqProducer.pushGoToOfflineRegisterDelay(offlineUnifiedRegisterMqVo, unifiedRegRegisterRetryEnum.getMessageDelayLevel());
    }

    @Async
    public void writeOfflineUnifiedRegisterSuccessMq(UnifiedRegisterVo registerVo, MemberOpenCardResponseVO memberOpenCardResponseVO, MbrMembersPo mbrMembersPo) {
        log.info("UnifiedRegWriteMqServiceImpl_writeOfflineUnifiedRegisterSuccessMq_success:{}", (Object)"\u5199\u5165\u7ebf\u4e0b\u5f00\u5361\u6210\u529f\u961f\u5217");
        OfflineUnifiedRegisterSuccessMqVo offlineUnifiedRegisterSuccessMqVo = OfflineUnifiedRegisterSuccessMqVo.builder().registerVo(registerVo).memberCode(mbrMembersPo.getMemberCode()).memberOpenCardResponseVO(memberOpenCardResponseVO).build();
        this.unifiedRegRocketMqProducer.pushOfflineRegisterSuccessCallbackOnline(offlineUnifiedRegisterSuccessMqVo);
    }

    @Async
    public void writeOnlineUnifiedRegisterMq(UnifiedRegisterVo registerVo, MbrMembersPo mbrMembersPo) {
        log.info("UnifiedRegWriteMqServiceImpl_writeOnlineUnifiedRegisterMq_success:{}", (Object)"\u5199\u5165\u7ebf\u4e0a\u5f00\u5361\u6210\u529f\u961f\u5217");
        OnlineUnifiedRegisterSuccessMqVo onlineUnifiedRegisterSuccessMqVo = OnlineUnifiedRegisterSuccessMqVo.builder().memberCode(mbrMembersPo.getMemberCode()).registerVo(registerVo).channelCode(registerVo.getChannelCode()).build();
        this.unifiedRegRocketMqProducer.pushRegisterSuccessEvent(onlineUnifiedRegisterSuccessMqVo);
    }

    @Async
    public void writeOnlineUnifiedBindMq(UnifiedRegisterVo registerVo, MbrMembersPo mbrMembersPo) {
        log.info("UnifiedRegWriteMqServiceImpl_writeOnlineUnifiedBindMq_success:{}", (Object)"\u5199\u5165\u7ebf\u4e0a\u7ed1\u5361\u6210\u529f\u961f\u5217");
        OnlineUnifiedRegisterSuccessBindMqVo onlineUnifiedRegisterSuccessBindMqVo = OnlineUnifiedRegisterSuccessBindMqVo.builder().memberCode(mbrMembersPo.getMemberCode()).registerVo(registerVo).channelCode(registerVo.getChannelCode()).build();
        this.unifiedRegRocketMqProducer.pushBindSuccessEvent(onlineUnifiedRegisterSuccessBindMqVo);
    }

    public void writeOnRegisterActivityMq(PushMbrModel pushMbrModel) {
        this.unifiedRegRocketMqProducer.pushOpenCardActivityEvent(pushMbrModel);
    }

    public void writeForeignMessageMq(ForeignRegisterMqVo foreignRegisterMqVo) {
        log.info("UnifiedRegWriteMqServiceImpl_writeForeignMessageMq:{}", (Object)JSON.toJSONString((Object)foreignRegisterMqVo));
        this.unifiedRegRocketMqProducer.pushwriteForeignMessageEvent(foreignRegisterMqVo);
    }

    public void writeTianmaoMq(ForeignCallBackPointVo foreignCallBackPointVo) {
        this.unifiedRegRocketMqProducer.pushWriteTianmaoMq(foreignCallBackPointVo);
    }
}

