/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.unifiedreg.service.impl;

import com.bizvane.redis.canal.dto.BrandCacheDto;
import com.bizvane.redis.canal.dto.CompanyCacheDto;
import com.bizvane.redis.canal.service.IRedisCacheService;
import com.bizvane.unifiedreg.common.exception.UnifiedRegException;
import com.bizvane.unifiedreg.model.po.MbrChannelPo;
import com.bizvane.unifiedreg.service.UnifiedRegCacheService;
import com.bizvane.unifiedreg.service.po.MbrChannelPoService;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UnifiedRegCacheServiceImpl
implements UnifiedRegCacheService {
    @Autowired
    private MbrChannelPoService mbrChannelPoService;
    @Autowired
    private IRedisCacheService iRedisCacheService;

    public MbrChannelPo findByChannelCode(String channelCode) {
        List allChannel = this.mbrChannelPoService.findAllChannel();
        MbrChannelPo mbrChannelPo = CollectionUtils.isEmpty((Collection)allChannel) ? null : (MbrChannelPo)allChannel.stream().filter(mbrChannel -> mbrChannel.getChannelCode().equalsIgnoreCase(channelCode)).findFirst().orElse(null);
        if (mbrChannelPo == null) {
            throw new UnifiedRegException(channelCode + ":\u6e20\u9053code\u4e0d\u5b58\u5728");
        }
        return mbrChannelPo;
    }

    public CompanyCacheDto getCompanyByRedis(Long sysCompanyId) {
        CompanyCacheDto onlineCompany = this.iRedisCacheService.getOnlineCompany(sysCompanyId);
        if (onlineCompany == null) {
            throw new UnifiedRegException(sysCompanyId + ":\u4f01\u4e1aid\u65e0\u6cd5\u67e5\u5230\u4f01\u4e1a\u4fe1\u606f");
        }
        return onlineCompany;
    }

    public BrandCacheDto getBrandByRedis(Long sysCompanyId, Long sysBrandId) {
        BrandCacheDto onlineBrand = this.iRedisCacheService.getOnlineBrand(sysCompanyId, sysBrandId);
        if (onlineBrand == null) {
            throw new UnifiedRegException(sysBrandId + ": \u54c1\u724cid\u65e0\u6cd5\u67e5\u5230\u54c1\u724c\u4fe1\u606f!");
        }
        return onlineBrand;
    }
}

