/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.unifiedreg.service.impl;

import com.alibaba.fastjson.JSON;
import com.bizvane.centerstageservice.models.po.SysStaffPo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.members.facade.enums.CardStatusEnum;
import com.bizvane.members.facade.enums.FirstLandEnum;
import com.bizvane.members.facade.enums.GeneralizeChannelEnum;
import com.bizvane.members.facade.enums.OpenCardChannelEnum;
import com.bizvane.redis.canal.dto.BrandCacheDto;
import com.bizvane.redis.canal.dto.CompanyCacheDto;
import com.bizvane.unifiedreg.common.exception.UnifiedRegException;
import com.bizvane.unifiedreg.model.po.MbrChannelPo;
import com.bizvane.unifiedreg.model.po.MbrLevelDefPo;
import com.bizvane.unifiedreg.model.po.MbrMembersChannelRelPo;
import com.bizvane.unifiedreg.model.po.MbrMembersPo;
import com.bizvane.unifiedreg.model.po.MbrMembersRegTraceRecordPoWithBLOBs;
import com.bizvane.unifiedreg.model.po.MbrMembersSysDefPo;
import com.bizvane.unifiedreg.model.vo.UnifiedRegisterMemberVo;
import com.bizvane.unifiedreg.model.vo.UnifiedRegisterRetryVo;
import com.bizvane.unifiedreg.model.vo.UnifiedRegisterVo;
import com.bizvane.unifiedreg.service.MemberChannelRegistrationService;
import com.bizvane.unifiedreg.service.UnifiedRegCacheService;
import com.bizvane.unifiedreg.service.UnifiedRegWriteMqService;
import com.bizvane.unifiedreg.service.module.CenterStageInterfaceService;
import com.bizvane.unifiedreg.service.po.MbrLevelDefPoService;
import com.bizvane.unifiedreg.service.po.MbrMembersChannelRelPoService;
import com.bizvane.unifiedreg.service.po.MbrMembersPoService;
import com.bizvane.unifiedreg.service.po.MbrMembersRegTraceRecordPoService;
import com.bizvane.unifiedreg.service.po.MbrMembersSysDefPoService;
import com.bizvane.unifiedreg.tools.CollectionUtil;
import com.bizvane.unifiedreg.tools.UUIDUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MemberChannelRegistrationServiceImpl
implements MemberChannelRegistrationService {
    private static final Logger log = LoggerFactory.getLogger(MemberChannelRegistrationServiceImpl.class);
    @Autowired
    private MbrMembersPoService mbrMembersPoService;
    @Autowired
    private MbrMembersChannelRelPoService mbrMembersChannelRelPoService;
    @Autowired
    private UnifiedRegCacheService unifiedRegCacheService;
    @Autowired
    private MbrMembersSysDefPoService mbrMembersSysDefPoService;
    @Autowired
    private MbrLevelDefPoService mbrLevelDefPoService;
    @Autowired
    private UnifiedRegWriteMqService unifiedRegWriteMqService;
    @Autowired
    private CenterStageInterfaceService centerStageInterfaceService;
    @Autowired
    private MbrMembersRegTraceRecordPoService mbrMembersRegTraceRecordPoService;

    @Transactional(rollbackFor={Exception.class})
    public UnifiedRegisterMemberVo unifiedRegister(@Valid UnifiedRegisterVo registerVo) {
        MbrChannelPo mbrChannelPo = this.unifiedRegCacheService.findByChannelCode(registerVo.getChannelCode());
        log.info("\u5f53\u524d\u6e20\u9053:{}", (Object)mbrChannelPo.getChannelName());
        MbrMembersPo memberInfoByMobileWithBrand = this.mbrMembersPoService.findMemberInfoByPhoneWithBrand(registerVo.getPhone(), registerVo.getSysBrandId(), registerVo.getSysCompanyId());
        if (memberInfoByMobileWithBrand != null) {
            MbrMembersChannelRelPo mbrChannelRelByMemberCodeWithChannelCode = this.mbrMembersChannelRelPoService.findMbrChannelRelByMemberCodeWithChannelCode(memberInfoByMobileWithBrand.getMemberCode(), registerVo.getChannelCode(), registerVo.getSysBrandId());
            if (mbrChannelRelByMemberCodeWithChannelCode != null) {
                this.mbrMembersChannelRelPoService.modifyMbrChannelRelVersion(mbrChannelRelByMemberCodeWithChannelCode.getMembersChannelRelId(), mbrChannelRelByMemberCodeWithChannelCode.getVersion());
                this.unifiedRegWriteMqService.writeOnlineUnifiedBindMq(registerVo, memberInfoByMobileWithBrand);
            } else {
                MbrMembersChannelRelPo mbrMembersChannelRelPo;
                mbrChannelRelByMemberCodeWithChannelCode = mbrMembersChannelRelPo = this.insertOpenMemberChannelRelPoSimple(registerVo, memberInfoByMobileWithBrand);
                this.unifiedRegWriteMqService.writeOfflineUnifiedRegisterMq(registerVo, memberInfoByMobileWithBrand);
            }
            this.mbrMembersPoService.modifyMemberChannel(memberInfoByMobileWithBrand, mbrChannelPo.getMbrChannelId());
            UnifiedRegisterMemberVo unifiedRegisterMemberVo = this.buildRegisterMemberInfoResponseData(registerVo, mbrChannelRelByMemberCodeWithChannelCode.getMemberCode(), Boolean.FALSE);
            return unifiedRegisterMemberVo;
        }
        MbrMembersSysDefPo memberSysDefByBrandId = this.mbrMembersSysDefPoService.findMemberSysDefByBrandId(registerVo.getSysBrandId());
        if (memberSysDefByBrandId == null || memberSysDefByBrandId.getNewLevelId() == null) {
            throw new UnifiedRegException("crm\u5f02\u5e38:\u4f1a\u5458\u5361\u4f53\u7cfb\u4fe1\u606f\u672a\u914d\u7f6e!");
        }
        log.info("\u4f1a\u5458\u7b49\u7ea7\u914d\u7f6e:{}", (Object)JSON.toJSONString((Object)memberSysDefByBrandId));
        MbrMembersPo mbrMembersPo = this.insertOpenCardMemberPoSimple(registerVo, mbrChannelPo, memberSysDefByBrandId);
        log.info("\u65b0\u589e\u4f1a\u5458:{}", (Object)JSON.toJSONString((Object)mbrMembersPo));
        MbrMembersChannelRelPo mbrMembersChannelRelPo = this.insertOpenMemberChannelRelPoSimple(registerVo, mbrMembersPo);
        this.unifiedRegWriteMqService.writeOfflineUnifiedRegisterMq(registerVo, mbrMembersPo);
        UnifiedRegisterMemberVo unifiedRegisterMemberVo = this.buildRegisterMemberInfoResponseData(registerVo, mbrMembersChannelRelPo.getMemberCode(), Boolean.FALSE);
        return unifiedRegisterMemberVo;
    }

    public UnifiedRegisterMemberVo unifiedRegisterRetry(UnifiedRegisterRetryVo unifiedRegisterRetryVo) {
        MbrMembersPo memberInfoByMemberCode = this.mbrMembersPoService.findMemberInfoByMemberCode(unifiedRegisterRetryVo.getMemberCode());
        if (memberInfoByMemberCode == null) {
            log.info("\u4f1a\u5458code\u4e0d\u5b58\u5728,\u76f4\u63a5return");
            return null;
        }
        MbrMembersRegTraceRecordPoWithBLOBs MbrMembersRegTraceRecordPo = this.mbrMembersRegTraceRecordPoService.findByMemberCode(unifiedRegisterRetryVo.getMemberCode(), unifiedRegisterRetryVo.getChannelCode());
        if (MbrMembersRegTraceRecordPo == null) {
            log.info("\u5f53\u524d\u4e0d\u5b58\u5728\u5931\u8d25\u8bb0\u5f55,\u76f4\u63a5return");
            return null;
        }
        String traceValue = MbrMembersRegTraceRecordPo.getTraceValue();
        UnifiedRegisterVo unifiedRegisterVo = (UnifiedRegisterVo)JSON.parseObject((String)traceValue, UnifiedRegisterVo.class);
        log.info("unifiedRegisterRetry_\u624b\u52a8\u91cd\u8bd5\u5199\u5165mq");
        this.unifiedRegWriteMqService.writeOfflineUnifiedRegisterMq(unifiedRegisterVo, memberInfoByMemberCode);
        UnifiedRegisterMemberVo unifiedRegisterMemberVo = this.buildRegisterMemberInfoResponseData(unifiedRegisterVo, memberInfoByMemberCode.getMemberCode(), Boolean.FALSE);
        return unifiedRegisterMemberVo;
    }

    private MbrMembersChannelRelPo insertOpenMemberChannelRelPoSimple(UnifiedRegisterVo registerVo, MbrMembersPo mbrMembersPo) {
        MbrMembersChannelRelPo mbrMembersChannelRelPo = new MbrMembersChannelRelPo();
        mbrMembersChannelRelPo.setSysCompanyId(registerVo.getSysCompanyId());
        mbrMembersChannelRelPo.setBrandId(registerVo.getSysBrandId());
        mbrMembersChannelRelPo.setMemberCode(mbrMembersPo.getMemberCode());
        mbrMembersChannelRelPo.setChannelCode(registerVo.getChannelCode());
        mbrMembersChannelRelPo.setChannelUniqueMemberCode(registerVo.getChannelUniqueMemberCode());
        int memberChannelRelInsertResult = this.mbrMembersChannelRelPoService.insertMbrMembersChannelRelInfo(mbrMembersChannelRelPo);
        if (memberChannelRelInsertResult < 1) {
            throw new UnifiedRegException("\u63d2\u5165\u4f1a\u5458\u6e20\u9053\u5173\u8054\u4fe1\u606f\u5931\u8d25");
        }
        return mbrMembersChannelRelPo;
    }

    private MbrMembersPo insertOpenCardMemberPoSimple(UnifiedRegisterVo registerVo, MbrChannelPo byChannelCode, MbrMembersSysDefPo memberSysDefByBrandId) {
        Date date = new Date();
        String memberCode = UUIDUtil.getUuid16();
        MbrMembersPo mbrMembersPo = new MbrMembersPo();
        mbrMembersPo.setMemberCode(memberCode);
        mbrMembersPo.setErpId(memberCode);
        mbrMembersPo.setPhone(registerVo.getPhone());
        String generalizeChannelEnumParam = registerVo.getGeneralizeChannelEnum();
        GeneralizeChannelEnum generalizeChannelEnum = Arrays.stream(GeneralizeChannelEnum.values()).filter(generalizeChannel -> generalizeChannel.getCode().equalsIgnoreCase(generalizeChannelEnumParam)).findFirst().orElse(GeneralizeChannelEnum.NO);
        mbrMembersPo.setGeneralizeChannel(generalizeChannelEnum.getMsg());
        mbrMembersPo.setSysCompanyId(registerVo.getSysCompanyId());
        mbrMembersPo.setMemberSysId(memberSysDefByBrandId.getMemberSysDefId().toString());
        mbrMembersPo.setLevelId(memberSysDefByBrandId.getNewLevelId());
        MbrLevelDefPo mbrLevelById = this.mbrLevelDefPoService.findMbrLevelById(mbrMembersPo.getLevelId());
        mbrMembersPo.setOfflineLevelCode(mbrLevelById.getOfflineLevelCode());
        CompanyCacheDto companyByRedis = this.unifiedRegCacheService.getCompanyByRedis(registerVo.getSysCompanyId());
        mbrMembersPo.setSysCompanyId(companyByRedis.getCompanyId());
        mbrMembersPo.setOfflineCompanyCode(companyByRedis.getCompanyCode());
        BrandCacheDto brandByRedis = this.unifiedRegCacheService.getBrandByRedis(registerVo.getSysCompanyId(), registerVo.getSysBrandId());
        mbrMembersPo.setBrandId(Integer.valueOf(brandByRedis.getBrandId().intValue()));
        mbrMembersPo.setOfflineBrandCode(brandByRedis.getBrandCode());
        mbrMembersPo.setOpenCardTime(date);
        mbrMembersPo.setOpenCardChannelId(byChannelCode.getMbrChannelId());
        Long sysStoreId = registerVo.getSysStoreId();
        Long sysGuideId = registerVo.getSysGuideId();
        if (sysStoreId == null) {
            if (sysGuideId != null) {
                sysGuideId = null;
            }
            sysStoreId = memberSysDefByBrandId.getOpenCardStoreId();
            sysGuideId = memberSysDefByBrandId.getOpenCardGuideId();
        }
        if (sysStoreId != null) {
            SysStorePo sysStorePo = this.centerStageInterfaceService.querySysStoreInfo(sysStoreId);
            mbrMembersPo.setOpenCardStoreId(sysStorePo.getSysStoreId());
            mbrMembersPo.setOpenCardStoreCode(sysStorePo.getSysStoreOnlineCode());
            mbrMembersPo.setServiceStoreId(sysStorePo.getSysStoreId());
            mbrMembersPo.setServiceStoreCode(sysStorePo.getSysStoreOnlineCode());
        }
        if (sysGuideId != null) {
            SysStaffPo sysStaffPo = this.centerStageInterfaceService.querySysStaffInfo(sysGuideId);
            mbrMembersPo.setOpenCardGuideId(sysStaffPo.getSysStaffId());
            mbrMembersPo.setOpenCardGuideCode(sysStaffPo.getStaffCode());
            mbrMembersPo.setServiceGuideId(sysStaffPo.getSysStaffId());
            mbrMembersPo.setServiceGuideCode(sysStaffPo.getStaffCode());
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(byChannelCode.getMbrChannelId().toString());
        list.add(OpenCardChannelEnum.OFFLINE_CHANNEL.getCode().toString());
        String allChannelIds = CollectionUtil.convertListToString(list, (String)",");
        mbrMembersPo.setAllChannelIds(allChannelIds);
        mbrMembersPo.setCardStatus(CardStatusEnum.NOT_BIND_CARD.getCode());
        mbrMembersPo.setFirstLandingCheck(FirstLandEnum.FIRST_LAND.getCode());
        mbrMembersPo.setLastEsTime(date);
        int memberInsertResult = this.mbrMembersPoService.insertMemberInfo(mbrMembersPo);
        if (memberInsertResult < 1) {
            throw new UnifiedRegException("\u63d2\u5165\u4f1a\u5458\u4fe1\u606f\u5931\u8d25");
        }
        return mbrMembersPo;
    }

    private UnifiedRegisterMemberVo buildRegisterMemberInfoResponseData(UnifiedRegisterVo registerVo, String memberCode, Boolean offlineSynchronizationStatus) {
        return UnifiedRegisterMemberVo.builder().sysBrandId(registerVo.getSysBrandId()).channelCode(registerVo.getChannelCode()).mobile(registerVo.getPhone()).channelUniqueMemberCode(registerVo.getChannelUniqueMemberCode()).memberCode(memberCode).offlineSynchronizationStatus(offlineSynchronizationStatus).build();
    }
}

