/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.unifiedreg.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.bizvane.centerstageservice.models.po.SysStaffPo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.models.vo.SysStoreVo;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.MemberOpenCardRequestVO;
import com.bizvane.connectorservice.entity.common.MemberOpenCardResponseVO;
import com.bizvane.core.facade.models.po.TraceRecordPO;
import com.bizvane.members.facade.enums.CardStatusEnum;
import com.bizvane.members.facade.enums.OfflineMbrStateEnum;
import com.bizvane.members.facade.enums.OpenCardOperateType;
import com.bizvane.members.facade.exception.BizvaneMembersException;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.card.response.PushMbrModel;
import com.bizvane.unifiedreg.common.constants.UnifiedRegRegisterConstants;
import com.bizvane.unifiedreg.model.po.MbrLevelDefPo;
import com.bizvane.unifiedreg.model.po.MbrMembersPo;
import com.bizvane.unifiedreg.model.vo.UnifiedRegisterMemberVo;
import com.bizvane.unifiedreg.model.vo.UnifiedRegisterVo;
import com.bizvane.unifiedreg.model.vo.mq.ForeignCallBackPointVo;
import com.bizvane.unifiedreg.model.vo.mq.ForeignRegisterMqVo;
import com.bizvane.unifiedreg.model.vo.mq.OfflineUnifiedRegisterMqVo;
import com.bizvane.unifiedreg.model.vo.mq.OfflineUnifiedRegisterSuccessMqVo;
import com.bizvane.unifiedreg.service.MemberChannelRegistrationAsyncService;
import com.bizvane.unifiedreg.service.UnifiedRegWriteMqService;
import com.bizvane.unifiedreg.service.copy.mapper.MemberInfoMapper;
import com.bizvane.unifiedreg.service.copy.tools.StopWatchTime;
import com.bizvane.unifiedreg.service.impl.MemberChannelRegistrationServiceImpl;
import com.bizvane.unifiedreg.service.module.CenterStageInterfaceService;
import com.bizvane.unifiedreg.service.module.ConnectorInterfaceService;
import com.bizvane.unifiedreg.service.po.MbrLevelDefPoService;
import com.bizvane.unifiedreg.service.po.MbrMembersPoService;
import com.bizvane.unifiedreg.tools.CustomExtractUtil;
import com.bizvane.unifiedreg.tools.DateUtils;
import com.bizvane.utils.exception.BizException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MemberChannelRegistrationAsyncServiceImpl
implements MemberChannelRegistrationAsyncService {
    private static final Logger log = LoggerFactory.getLogger(MemberChannelRegistrationAsyncServiceImpl.class);
    @Autowired
    private ConnectorInterfaceService connectorInterfaceService;
    @Autowired
    private CenterStageInterfaceService centerStageInterfaceService;
    @Autowired
    private MbrLevelDefPoService mbrLevelDefPoService;
    @Autowired
    private MbrMembersPoService mbrMembersPoService;
    @Autowired
    private UnifiedRegWriteMqService unifiedRegWriteMqService;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private MemberChannelRegistrationServiceImpl memberChannelRegistrationService;
    @Autowired
    private MemberInfoMapper memberInfoMapper;

    @Transactional(rollbackFor={Exception.class})
    public void asyncOnlineUnifiedRegister(OfflineUnifiedRegisterMqVo offlineUnifiedRegisterMqVo) {
        UnifiedRegisterVo registerVo = offlineUnifiedRegisterMqVo.getRegisterVo();
        String memberCode = offlineUnifiedRegisterMqVo.getMemberCode();
        MbrMembersPo memberInfoByMemberCode = this.mbrMembersPoService.findMemberInfoByMemberCode(memberCode);
        MemberOpenCardResponseVO memberOpenCardResponseVO = null;
        try {
            memberOpenCardResponseVO = this.offlineLoginAndOpenCard(registerVo, memberInfoByMemberCode);
        }
        catch (Exception e) {
            log.error("\u7ebf\u4e0b\u5f00\u5361\u5931\u8d25:{}", (Throwable)e);
            log.error(e.getMessage(), (Throwable)e);
            throw new BizException(-1, "\u5f02\u5e38\u91cd\u8bd5");
        }
        this.unifiedRegWriteMqService.writeOfflineUnifiedRegisterSuccessMq(registerVo, memberOpenCardResponseVO, memberInfoByMemberCode);
    }

    @Transactional(rollbackFor={Exception.class})
    public void asyncOnlineUnifiedRegisterSuccess(OfflineUnifiedRegisterSuccessMqVo offlineUnifiedRegisterSuccessMqVo) {
        UnifiedRegisterVo registerVo = offlineUnifiedRegisterSuccessMqVo.getRegisterVo();
        MemberOpenCardResponseVO memberOpenCardResponseVO = offlineUnifiedRegisterSuccessMqVo.getMemberOpenCardResponseVO();
        MbrMembersPo mbrMembersPo = this.mbrMembersPoService.findMemberInfoByMemberCode(offlineUnifiedRegisterSuccessMqVo.getMemberCode());
        try {
            Integer n = this.onlineLoginAndOpenCard(registerVo, memberOpenCardResponseVO, mbrMembersPo);
        }
        catch (Exception e) {
            log.error("\u7ebf\u4e0a\u540c\u6b65\u7ebf\u4e0b\u5f00\u5361\u4fe1\u606f\u5931\u8d25:{}", (Throwable)e);
            throw e;
        }
        finally {
            if (memberOpenCardResponseVO.getType() == OfflineMbrStateEnum.BINDING.getCode()) {
                this.unifiedRegWriteMqService.writeOnlineUnifiedBindMq(registerVo, mbrMembersPo);
            } else {
                this.unifiedRegWriteMqService.writeOnlineUnifiedRegisterMq(registerVo, mbrMembersPo);
            }
        }
        try {
            log.info("\u5199\u5165\u5929\u732b\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)memberOpenCardResponseVO));
            log.info("asyncOnlineUnifiedRegisterSuccess_mbrMembersPo:{}", (Object)JSON.toJSONString((Object)mbrMembersPo));
            ForeignCallBackPointVo foreignCallBackPointVo = new ForeignCallBackPointVo();
            if (StringUtils.isNotBlank((CharSequence)memberOpenCardResponseVO.getLevelCode())) {
                MbrLevelDefPo mbrLevelDefPo = this.mbrLevelDefPoService.findMbrLevelByOfflineCodeWithBrandId(memberOpenCardResponseVO.getLevelCode(), mbrMembersPo.getBrandId(), mbrMembersPo.getSysCompanyId());
                foreignCallBackPointVo.setLevel(mbrLevelDefPo.getMbrLevelId());
            } else {
                foreignCallBackPointVo.setLevel(mbrMembersPo.getLevelId());
            }
            foreignCallBackPointVo.setMemberCode(mbrMembersPo.getMemberCode());
            foreignCallBackPointVo.setMobile(mbrMembersPo.getPhone());
            foreignCallBackPointVo.setSysCompanyId(mbrMembersPo.getSysCompanyId());
            foreignCallBackPointVo.setPoint(Integer.valueOf(memberOpenCardResponseVO.getCountIntegeral() != null ? memberOpenCardResponseVO.getCountIntegeral() : 0));
            foreignCallBackPointVo.setBrandId(mbrMembersPo.getBrandId());
            this.unifiedRegWriteMqService.writeTianmaoMq(foreignCallBackPointVo);
        }
        catch (Exception e) {
            log.error("\u5199\u5165\u5929\u732b\u4fe1\u606f\u5931\u8d25:{}", (Throwable)e);
            throw e;
        }
        try {
            log.info("\u901a\u77e5\u5f00\u5361\u6d3b\u52a8");
            MemberInfoModel searchMemberInfoModel = new MemberInfoModel();
            searchMemberInfoModel.setPhone(mbrMembersPo.getPhone());
            searchMemberInfoModel.setBrandId(Long.valueOf(mbrMembersPo.getBrandId().intValue()));
            MemberInfoModel memberInfoModel = this.memberInfoMapper.findMemberInfoByMemberModel(searchMemberInfoModel);
            PushMbrModel pushMbrModel = this.createPushMbrModel(memberInfoModel, Integer.valueOf(OpenCardOperateType.REGISTER_CARD.getCode()));
            log.info("pushMbrModel:{}", (Object)JSON.toJSONString((Object)pushMbrModel));
            this.unifiedRegWriteMqService.writeOnRegisterActivityMq(pushMbrModel);
        }
        catch (Exception e) {
            log.error("\u5f00\u5361\u6d3b\u52a8\u901a\u77e5\u5931\u8d25:{}", (Throwable)e);
            throw e;
        }
    }

    public void unifiedRegister(ForeignRegisterMqVo foreignRegisterMqVo) {
        log.info("\u5916\u90e8\u63a5\u53e3\u6d88\u8d39\u5f00\u5361\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)foreignRegisterMqVo));
        UnifiedRegisterVo registerVo = new UnifiedRegisterVo();
        BeanUtils.copyProperties((Object)foreignRegisterMqVo, (Object)registerVo);
        UnifiedRegisterMemberVo unifiedRegisterMemberVo = this.memberChannelRegistrationService.unifiedRegister(registerVo);
        log.info("MemberChannelRegistrationAsyncServiceImpl_unifiedRegister_unifiedRegisterMemberVo:{}", (Object)JSON.toJSONString((Object)unifiedRegisterMemberVo));
        if (Objects.nonNull(unifiedRegisterMemberVo)) {
            foreignRegisterMqVo.setMemberCode(unifiedRegisterMemberVo.getMemberCode());
        }
        this.unifiedRegWriteMqService.writeForeignMessageMq(foreignRegisterMqVo);
    }

    private PushMbrModel createPushMbrModel(MemberInfoModel memberInfoModel, Integer operateType) {
        String sourceWay = null;
        return PushMbrModel.builder().sysCompanyId(memberInfoModel.getSysCompanyId()).brandId(memberInfoModel.getBrandId()).memberCode(memberInfoModel.getMemberCode()).unionId(memberInfoModel.getWxUnionId()).openId(memberInfoModel.getWxOpenId()).address(memberInfoModel.getAddress()).erpId(memberInfoModel.getErpId()).name(memberInfoModel.getName()).gender(memberInfoModel.getGender()).phone(memberInfoModel.getPhone()).email(memberInfoModel.getEmail()).idCard(memberInfoModel.getIdCard()).birthday(memberInfoModel.getBirthday()).birthdayMd(memberInfoModel.getBirthdayMd()).province(memberInfoModel.getProvince()).city(memberInfoModel.getCity()).county(memberInfoModel.getCounty()).address(memberInfoModel.getAddress()).headPortraits(memberInfoModel.getHeadPortraits()).barCode(memberInfoModel.getBarCode()).cardStatus(memberInfoModel.getCardStatus()).cardUseStatus(memberInfoModel.getCardUseStatus()).valid(memberInfoModel.getValid()).openCardTime(memberInfoModel.getOpenCardTime()).bindCardTime(memberInfoModel.getBindCardTime()).inviteRegisterTime(DateUtil.format((Date)memberInfoModel.getOpenCardTime(), (String)DateUtils.ymd)).effectiveTime(memberInfoModel.getEffectiveTime()).levelId(memberInfoModel.getLevelId()).levelName(memberInfoModel.getLevelName()).cardNo(memberInfoModel.getCardNo()).offlineCardNo(memberInfoModel.getOfflineCardNo()).storesName(this.getSoreName(memberInfoModel.getServiceStoreId())).serviceStoreId(memberInfoModel.getServiceStoreId()).openCardGuideId(memberInfoModel.getOpenCardGuideId()).serviceGuideId(memberInfoModel.getServiceGuideId()).openCardStoreId(memberInfoModel.getOpenCardStoreId()).operateType(operateType).sourceWay(sourceWay).offlineCompanyCode(memberInfoModel.getOfflineCompanyCode()).offlineBrandCode(memberInfoModel.getOfflineBrandCode()).openCardStoreCode(memberInfoModel.getOpenCardStoreCode()).openCardGuideCode(memberInfoModel.getOpenCardGuideCode()).serviceStoreCode(memberInfoModel.getServiceStoreCode()).serviceGuideCode(memberInfoModel.getServiceGuideCode()).offlineLevelCode(memberInfoModel.getOfflineLevelCode()).activeStore(memberInfoModel.getActiveStore()).countIntegral(memberInfoModel.getCountIntegral()).addUpIntegral(memberInfoModel.getAddUpIntegral()).aboutExpireIntegral(memberInfoModel.getAboutExpireIntegral()).aboutExpireTime(memberInfoModel.getAboutExpireTime()).offlineUpdateDate(memberInfoModel.getOfflineUpdateDate()).pastDueIntegral(memberInfoModel.getPastDueIntegral()).consumeIntegral(memberInfoModel.getConsumeIntegral()).freezeIntegral(memberInfoModel.getFreezeIntegral()).offlineUpdateIntegralDate(memberInfoModel.getOfflineUpdateIntegralDate()).balance(memberInfoModel.getBalance()).babyBirthday(memberInfoModel.getBabyBirthday()).babyBirthdayMd(memberInfoModel.getBabyBirthdayMd()).petCard(memberInfoModel.getPetCard()).offlineUpdateBalanceDate(memberInfoModel.getOfflineUpdateBalanceDate()).registerType(memberInfoModel.getRegisterType()).emailStatus(memberInfoModel.getEmailStatus()).firstLandingCheck(memberInfoModel.getFirstLandingCheck()).build();
    }

    private boolean traceIsNull(TraceRecordPO traceRecordPo) {
        return null == traceRecordPo || null == traceRecordPo.getTraceId() || 0L == traceRecordPo.getTraceId() || StringUtils.isBlank((CharSequence)traceRecordPo.getTraceValue());
    }

    private String getSoreName(Long getServiceStoreId) {
        SysStoreVo storeVo;
        StopWatchTime.start((String)"jointResponse-getSysStoreById");
        String storeName = "";
        if (getServiceStoreId != null && getServiceStoreId != 0L && (storeVo = (SysStoreVo)this.storeServiceRpc.getSysStoreById(getServiceStoreId).getData()) != null) {
            storeName = storeVo.getStoreName();
        }
        StopWatchTime.stop();
        return storeName;
    }

    private Integer onlineLoginAndOpenCard(UnifiedRegisterVo registerVo, MemberOpenCardResponseVO memberOpenCardResponseVO, MbrMembersPo mbrMembersPo) {
        Long mbrMemberPrimaryId = mbrMembersPo.getMbrMemberId();
        MbrMembersPo mbrMembersPoParam = new MbrMembersPo();
        mbrMembersPoParam.setMbrMemberId(mbrMemberPrimaryId);
        MbrLevelDefPo mbrLevelById = this.mbrLevelDefPoService.findMbrLevelById(mbrMembersPo.getLevelId());
        Integer effectiveYear = (Integer)ObjectUtil.defaultIfNull((Object)mbrLevelById.getEffectiveYear(), (Object)UnifiedRegRegisterConstants.UNIFIED_REG_REGISTER_EFFECTIVE_YEAR);
        Object effectiveTime = null;
        effectiveTime = StringUtil.isNotBlank((CharSequence)memberOpenCardResponseVO.getEffectiveTime()) ? DateUtil.parse((CharSequence)memberOpenCardResponseVO.getEffectiveTime(), (String)"yyyyMMdd") : DateUtil.offsetMonth((Date)mbrMembersPo.getCreateDate(), (int)effectiveYear).toJdkDate();
        mbrMembersPoParam.setErpId(memberOpenCardResponseVO.getErpId());
        mbrMembersPoParam.setCardNo(memberOpenCardResponseVO.getOfflineCardNo());
        mbrMembersPoParam.setOfflineCardNo(memberOpenCardResponseVO.getOfflineCardNo());
        mbrMembersPoParam.setName(memberOpenCardResponseVO.getName());
        mbrMembersPoParam.setEffectiveTime((Date)effectiveTime);
        mbrMembersPoParam.setCountIntegral(memberOpenCardResponseVO.getCountIntegeral());
        mbrMembersPoParam.setAddress(memberOpenCardResponseVO.getAddress());
        mbrMembersPoParam.setCity(memberOpenCardResponseVO.getCity());
        mbrMembersPoParam.setProvince(memberOpenCardResponseVO.getProvince());
        mbrMembersPoParam.setCounty(memberOpenCardResponseVO.getCounty());
        if (memberOpenCardResponseVO.getType() == 1) {
            MbrLevelDefPo mbrLevelByCodeWithBrandId = this.mbrLevelDefPoService.findMbrLevelByCodeWithBrandId(memberOpenCardResponseVO.getLevelCode(), Long.valueOf(mbrMembersPo.getBrandId().intValue()), mbrMembersPo.getSysCompanyId());
            if (mbrLevelByCodeWithBrandId == null) {
                log.error("\u7ebf\u4e0b\u7b49\u7ea7code:{},\u5728\u7ebf\u4e0a\u627e\u4e0d\u5230\u5bf9\u5e94\u7b49\u7ea7", (Object)memberOpenCardResponseVO.getLevelCode());
            } else {
                mbrMembersPoParam.setCardStatus(CardStatusEnum.ALREADY_BIND_CARD.getCode());
                mbrMembersPoParam.setOfflineLevelCode(memberOpenCardResponseVO.getLevelCode());
                mbrMembersPoParam.setLevelId(mbrLevelByCodeWithBrandId.getMbrLevelId());
            }
            String openStoreCode = memberOpenCardResponseVO.getOpenStoreCode();
            SysStorePo sysStorePo = null;
            if (StringUtils.isNotEmpty((CharSequence)openStoreCode) && (sysStorePo = this.centerStageInterfaceService.querySysStoreInfoByCodeAndCompanyId(openStoreCode, registerVo.getSysCompanyId())) == null) {
                log.error("\u7ebf\u4e0b\u5f00\u5361\u95e8\u5e97:{}\u4e0d\u5b58\u5728", (Object)openStoreCode);
            }
            String openGuideCode = memberOpenCardResponseVO.getOpenGuideCode();
            SysStaffPo sysStaffPo = null;
            if (StringUtils.isNotEmpty((CharSequence)openGuideCode) && (sysStaffPo = this.centerStageInterfaceService.querySysStaffInfoByCodeAndCompanyId(openGuideCode, registerVo.getSysCompanyId())) == null) {
                log.error("\u7ebf\u4e0b\u5f00\u5361\u5bfc\u8d2d:{}\u4e0d\u5b58\u5728", (Object)openGuideCode);
            }
            if (sysStorePo != null) {
                mbrMembersPoParam.setOpenCardStoreId(sysStorePo.getSysStoreId());
                mbrMembersPoParam.setOpenCardStoreCode(sysStorePo.getSysStoreOfflineCode());
            }
            if (sysStaffPo != null) {
                mbrMembersPoParam.setOpenCardGuideId(sysStaffPo.getSysStaffId());
                mbrMembersPoParam.setOpenCardGuideCode(sysStaffPo.getStaffCode());
            }
        } else {
            mbrMembersPoParam.setCardStatus(CardStatusEnum.NOT_BIND_CARD.getCode());
        }
        mbrMembersPoParam.setValid(Boolean.TRUE);
        mbrMembersPoParam.setCardUseStatus(Integer.valueOf(1));
        Integer result = null;
        try {
            result = this.mbrMembersPoService.modifyMemberInfo(mbrMembersPoParam);
        }
        catch (DuplicateKeyException e) {
            log.error("crm\u5f02\u5e38:\u5199\u5165\u4f1a\u5458\u5931\u8d25,erpId\u91cd\u590d");
            throw new BizvaneMembersException("\u552f\u4e00\u6807\u8bc6\u91cd\u590d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        return result;
    }

    private MemberOpenCardResponseVO offlineLoginAndOpenCard(UnifiedRegisterVo registerVo, MbrMembersPo mbrMembersPo) {
        MemberOpenCardRequestVO memberOpenCardRequestVO = this.buildOfflineOpenCardParam(registerVo, mbrMembersPo);
        Result memberOpenCardResponseVOResult = this.connectorInterfaceService.loginAndOpenCard(memberOpenCardRequestVO);
        log.info("\u7ebf\u4e0b\u5f00\u7ed1\u5361\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)memberOpenCardResponseVOResult));
        if (memberOpenCardResponseVOResult == null) {
            log.error("\u8fde\u63a5\u5668\u5f02\u5e38:loginAndOpenCard\u7a7a");
            throw new BizvaneMembersException("\u7ebf\u4e0b\u5f00\u5361\u5931\u8d25!");
        }
        if (CustomExtractUtil.isFailResult((Result)memberOpenCardResponseVOResult)) {
            log.error("\u8fde\u63a5\u5668\u5f02\u5e38:loginAndOpenCard\u5931\u8d25,{}", (Object)memberOpenCardResponseVOResult.getMessage());
            throw new BizvaneMembersException(memberOpenCardResponseVOResult.getMessage());
        }
        MemberOpenCardResponseVO memberOpenCardResponseVO = (MemberOpenCardResponseVO)memberOpenCardResponseVOResult.getTData();
        return memberOpenCardResponseVO;
    }

    private MemberOpenCardRequestVO buildOfflineOpenCardParam(UnifiedRegisterVo registerVo, MbrMembersPo mbrMembersPo) {
        log.info("\u8865\u5145\u65e5\u5fd7:{}{}", (Object)registerVo, (Object)mbrMembersPo);
        MemberOpenCardRequestVO memberOpenCardRequestVO = new MemberOpenCardRequestVO();
        memberOpenCardRequestVO.setAddress(registerVo.getAddress());
        memberOpenCardRequestVO.setEmail(registerVo.getEmail());
        SimpleDateFormat sd = new SimpleDateFormat("yyyyMMdd");
        if (registerVo.getBirthday() != null) {
            memberOpenCardRequestVO.setBirthday(sd.format(registerVo.getBirthday()));
        }
        log.info("\u8865\u5145\u65e5\u5fd7:1");
        memberOpenCardRequestVO.setCity(registerVo.getCity());
        memberOpenCardRequestVO.setCounty(registerVo.getCounty());
        if (StringUtils.isNotBlank((CharSequence)registerVo.getGender())) {
            switch (registerVo.getGender()) {
                case "1": {
                    memberOpenCardRequestVO.setGender(Integer.valueOf(0));
                    break;
                }
                case "2": {
                    memberOpenCardRequestVO.setGender(Integer.valueOf(1));
                    break;
                }
                default: {
                    memberOpenCardRequestVO.setGender(Integer.valueOf(2));
                }
            }
        }
        log.info("\u8865\u5145\u65e5\u5fd7:2");
        memberOpenCardRequestVO.setLevelCode(mbrMembersPo.getOfflineLevelCode());
        memberOpenCardRequestVO.setName(registerVo.getName());
        memberOpenCardRequestVO.setPhone(registerVo.getPhone());
        memberOpenCardRequestVO.setProvince(registerVo.getProvince());
        memberOpenCardRequestVO.setOpenId(registerVo.getWxOpenId());
        memberOpenCardRequestVO.setUnionId(registerVo.getWxUnionId());
        memberOpenCardRequestVO.setBrandId(registerVo.getSysBrandId());
        memberOpenCardRequestVO.setOfflineBrandCode(mbrMembersPo.getOfflineBrandCode());
        memberOpenCardRequestVO.setOpenGuideCode(mbrMembersPo.getOpenCardGuideCode());
        if (mbrMembersPo.getOpenCardStoreId() != null) {
            log.info("\u8865\u5145\u65e5\u5fd7:3");
            SysStorePo sysStorePo = this.centerStageInterfaceService.querySysStoreInfo(mbrMembersPo.getOpenCardStoreId());
            if (sysStorePo == null) {
                throw new BizvaneMembersException("\u67e5\u8be2\u5e97\u94fa\u4e3a\u7a7a");
            }
            memberOpenCardRequestVO.setOpenStoreCode(sysStorePo.getSysStoreOnlineCode());
        }
        return memberOpenCardRequestVO;
    }
}

