/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.unifiedreg.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.bo.BrandConfigsBO;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.vo.SysBrandVo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.couponfacade.interfaces.UtilsServiceFeign;
import com.bizvane.members.facade.enums.BasePropertyEnum;
import com.bizvane.members.facade.enums.ExtendOfflinePropertyEnum;
import com.bizvane.members.facade.enums.ExtendPropTypeEnum;
import com.bizvane.members.facade.enums.GenderEnum;
import com.bizvane.members.facade.enums.OpenCardSceneEnum;
import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.ExtendPropertyModel;
import com.bizvane.members.facade.models.ExtendPropertyValueModel;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.members.facade.models.MemberCardLevelModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.bo.MiniProgramPropertyVipCardShowBo;
import com.bizvane.members.facade.vo.ExtendPropertyValueVO;
import com.bizvane.members.facade.vo.PersonalDataVo;
import com.bizvane.redis.canal.dto.StaffCacheDto;
import com.bizvane.redis.canal.dto.StoreCacheDto;
import com.bizvane.redis.canal.service.IRedisCacheService;
import com.bizvane.unifiedreg.mapper.MbrElectCardPoMapper;
import com.bizvane.unifiedreg.mapper.MbrExtendDefPoMapper;
import com.bizvane.unifiedreg.mapper.MbrExtendPoMapper;
import com.bizvane.unifiedreg.mapper.MbrLevelDefPoMapper;
import com.bizvane.unifiedreg.mapper.MbrLifecycleParameterPoMapper;
import com.bizvane.unifiedreg.model.po.MbrElectCardPo;
import com.bizvane.unifiedreg.model.po.MbrElectCardPoExample;
import com.bizvane.unifiedreg.model.po.MbrLifecycleParameterPo;
import com.bizvane.unifiedreg.model.vo.MbrElectCardVo;
import com.bizvane.unifiedreg.model.vo.MemberCommonVo;
import com.bizvane.unifiedreg.rpc.AppletServiceFeign;
import com.bizvane.unifiedreg.service.copy.mapper.MemberInfoMapper;
import com.bizvane.unifiedreg.tools.ParamValidation;
import com.bizvane.unifiedreg.tools.ResponseUtil;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import io.jsonwebtoken.lang.Collections;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AppletServiceFeignImpl
implements AppletServiceFeign {
    private static final Logger log = LoggerFactory.getLogger(AppletServiceFeignImpl.class);
    @Resource
    private MemberInfoMapper memberInfoMapper;
    @Autowired
    private UtilsServiceFeign utilsServiceFeign;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private IRedisCacheService iRedisCacheService;
    @Resource
    private MbrLevelDefPoMapper mbrLevelDefPoMapper;
    @Resource
    private MbrExtendDefPoMapper mbrExtendDefPoMapper;
    @Resource
    private MbrExtendPoMapper mbrExtendPoMapper;
    @Resource
    private MbrElectCardPoMapper mbrElectCardPoMapper;
    @Resource
    private MbrLifecycleParameterPoMapper mbrLifecycleParameterPoMapper;

    public ResponseData<MemberCardLevelModel> queryMemberCardInfo(String memberCode) {
        String barCode;
        log.info("MemberCardProgramApiServiceImpl#queryMemberCardInfo#memberCode:{}", (Object)memberCode);
        ParamValidation.paramsValidate((Object[])new Object[]{memberCode});
        ResponseData responseData = new ResponseData();
        MemberCardLevelModel memberCardLevelModel = this.memberInfoMapper.queryMemberCardInfo(memberCode);
        if (memberCardLevelModel == null) {
            log.error("MemberCardProgramApiServiceImpl#queryMemberCardInfo#memberCardLevelModel == null#memberCode:{}", (Object)memberCode);
            return ResponseUtil.getFailedData(null);
        }
        if (StringUtils.isEmpty((CharSequence)memberCardLevelModel.getBarCode()) && StringUtils.isNotEmpty((CharSequence)memberCardLevelModel.getCardNo()) && !StringUtils.isBlank((CharSequence)(barCode = (String)this.utilsServiceFeign.getBarcode(memberCardLevelModel.getCardNo()).getData()))) {
            memberCardLevelModel.setBarCode(barCode);
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setBarCode(barCode);
            memberInfoModel.setMemberCode(memberCode);
            this.memberInfoMapper.updateBarCode(memberInfoModel);
        }
        responseData.setData((Object)memberCardLevelModel);
        return responseData;
    }

    public ResponseData<List<MiniProgramPropertyVipCardShowBo>> getMiniProgramPropertyVipCardShow(Long brandId, String memberCode) {
        ParamValidation.paramsValidate((Object[])new Object[]{brandId, memberCode});
        ExtendPropertyModel extendPropertyModel = new ExtendPropertyModel();
        extendPropertyModel.setBrandId(brandId);
        extendPropertyModel.setCardShow(Integer.valueOf(1));
        List propertyModel = this.mbrExtendDefPoMapper.queryPropertyVipCardShow(extendPropertyModel);
        if (propertyModel == null || propertyModel.size() == 0) {
            return ResponseUtil.getSuccessData(null);
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        MemberInfoModel memberInfo = this.memberInfoMapper.findMemberInfoByMemberModel(memberInfoModel);
        if (memberInfo == null) {
            return ResponseUtil.getSuccessData(null);
        }
        ArrayList<MiniProgramPropertyVipCardShowBo> boList = new ArrayList<MiniProgramPropertyVipCardShowBo>();
        for (int i = 0; i < propertyModel.size(); ++i) {
            MiniProgramPropertyVipCardShowBo propertyShow = new MiniProgramPropertyVipCardShowBo();
            ExtendPropertyModel model = (ExtendPropertyModel)propertyModel.get(i);
            propertyShow.setPropertyCode(model.getPropertyCode());
            propertyShow.setPropertyName(model.getPropertyName());
            propertyShow.setPropertyType(model.getPropertyType());
            if (((ExtendPropertyModel)propertyModel.get(i)).getDefType() == 1) {
                ExtendPropertyValueVO extendPropertyValueVO = new ExtendPropertyValueVO();
                extendPropertyValueVO.setPropertyCode(model.getPropertyCode());
                this.setBaseProperty(memberInfo, extendPropertyValueVO);
                propertyShow.setPropertyValue(extendPropertyValueVO.getPropertyValue());
            } else {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("propertyCode", model.getPropertyCode());
                paramMap.put("memberCode", memberCode);
                ExtendPropertyValueModel extendPropertyValueModel = this.mbrExtendPoMapper.findPropertyValue(paramMap);
                if (extendPropertyValueModel != null) {
                    propertyShow.setPropertyValue(extendPropertyValueModel.getPropertyValue());
                } else if (ExtendOfflinePropertyEnum.EUCURRENCY.getCode().equals(model.getOfflinePropertyCode())) {
                    propertyShow.setPropertyValue("0");
                }
            }
            boList.add(propertyShow);
        }
        return ResponseUtil.getSuccessData(boList);
    }

    private void setBaseProperty(MemberInfoModel memberInfo, ExtendPropertyValueVO extendPropertyValueVO) {
        extendPropertyValueVO.setMemberCode(memberInfo.getMemberCode());
        BasePropertyEnum basePropertyEnum = BasePropertyEnum.getBasePropertyEnum((String)extendPropertyValueVO.getPropertyCode());
        if (basePropertyEnum == BasePropertyEnum.NAME) {
            extendPropertyValueVO.setPropertyValue(memberInfo.getName());
            return;
        }
        if (basePropertyEnum == BasePropertyEnum.BIRTHDAY) {
            extendPropertyValueVO.setPropertyValue(DateUtil.format((Date)memberInfo.getBirthday(), (String)"yyyy-MM-dd"));
            return;
        }
        if (basePropertyEnum == BasePropertyEnum.ADDRESSES) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("province", memberInfo.getProvince());
            map.put("city", memberInfo.getCity());
            map.put("county", memberInfo.getCounty());
            map.put("address", memberInfo.getAddress());
            extendPropertyValueVO.setPropertyValue(JacksonUtil.bean2Json(map));
            return;
        }
        if (basePropertyEnum == BasePropertyEnum.GENDER) {
            extendPropertyValueVO.setPropertyValue(memberInfo.getGender());
            ArrayList list = new ArrayList();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", GenderEnum.WOMAN.getMsg());
            list.add(map);
            map = new HashMap();
            map.put("name", GenderEnum.MAN.getMsg());
            list.add(map);
            map = new HashMap();
            map.put("name", GenderEnum.UNKNOWN.getMsg());
            list.add(map);
            extendPropertyValueVO.setPropertyOption(JacksonUtil.bean2Json(list));
            return;
        }
        if (basePropertyEnum == BasePropertyEnum.EMAIL) {
            extendPropertyValueVO.setPropertyValue(memberInfo.getEmail());
            ResponseData brandPoResponseData = this.brandServiceRpc.getBrandConfigsByBrandId(memberInfo.getSysCompanyId(), memberInfo.getBrandId());
            if (brandPoResponseData.getCode() == SysResponseEnum.SUCCESS.getCode() && StringUtil.isNotBlank((String)((SysBrandPo)brandPoResponseData.getData()).getBrandConfigs())) {
                String brandConfigs = ((SysBrandPo)brandPoResponseData.getData()).getBrandConfigs();
                BrandConfigsBO brandConfigsBO = (BrandConfigsBO)JSON.parseObject((String)brandConfigs, BrandConfigsBO.class);
                if (StringUtils.isNotBlank((CharSequence)brandConfigsBO.getEmailName())) {
                    extendPropertyValueVO.setStatus("1");
                    extendPropertyValueVO.setPropertyType("2");
                } else {
                    extendPropertyValueVO.setStatus("0");
                }
            } else {
                extendPropertyValueVO.setStatus("0");
            }
            extendPropertyValueVO.setExtraInfo(memberInfo.getEmailStatus() == null ? null : String.valueOf(memberInfo.getEmailStatus()));
            return;
        }
        if (basePropertyEnum == BasePropertyEnum.PHONE) {
            extendPropertyValueVO.setPropertyValue(memberInfo.getPhone());
            return;
        }
        if (basePropertyEnum == BasePropertyEnum.SERVICE_STORE) {
            if (memberInfo.getServiceStoreId() != null) {
                StoreCacheDto store = this.iRedisCacheService.getOnlineStoreByCompanyId(memberInfo.getSysCompanyId(), memberInfo.getServiceStoreId());
                if (store != null) {
                    log.info("iRedisCacheService_store:" + store.getStoreName());
                    extendPropertyValueVO.setPropertyValue(store.getStoreName());
                }
                extendPropertyValueVO.setExtraInfo(memberInfo.getServiceStoreId().toString());
            }
            return;
        }
        if (basePropertyEnum == BasePropertyEnum.SERVICE_GUIDE) {
            if (memberInfo.getServiceGuideId() != null) {
                StaffCacheDto staff = this.iRedisCacheService.getOnlineStaff(memberInfo.getSysCompanyId(), memberInfo.getServiceGuideId());
                if (staff != null) {
                    log.info("iRedisCacheService_staff:" + staff.getStaffName());
                    extendPropertyValueVO.setPropertyValue(staff.getStaffName());
                }
                extendPropertyValueVO.setExtraInfo(memberInfo.getServiceGuideId().toString());
            }
            return;
        }
        if (basePropertyEnum == BasePropertyEnum.LEVEL) {
            MbrLevelModel mbrLevelModel = this.mbrLevelDefPoMapper.queryLevelBasicInfo(memberInfo.getLevelId());
            if (mbrLevelModel != null) {
                extendPropertyValueVO.setPropertyValue(mbrLevelModel.getLevelName());
            }
            return;
        }
        if (basePropertyEnum == BasePropertyEnum.INTEGRAL) {
            extendPropertyValueVO.setPropertyValue(memberInfo.getCountIntegral() == null ? "0" : memberInfo.getCountIntegral().toString());
            return;
        }
        if (basePropertyEnum == BasePropertyEnum.OPENCARD_STORE) {
            if (memberInfo.getOpenCardScene() != null) {
                StoreCacheDto storeCacheDto;
                if (memberInfo.getOpenCardStoreId() != null && (storeCacheDto = this.iRedisCacheService.getOnlineStoreByCompanyId(memberInfo.getSysCompanyId(), memberInfo.getOpenCardStoreId())) != null) {
                    log.info("iRedisCacheService_store:" + storeCacheDto.getStoreName());
                    extendPropertyValueVO.setPropertyValue(storeCacheDto.getStoreName());
                    extendPropertyValueVO.setExtraInfo(storeCacheDto.getStoreCode());
                }
                if (memberInfo.getOpenCardScene() >= OpenCardSceneEnum.SELF_CHOOSE.getCode()) {
                    extendPropertyValueVO.setStatus("1");
                }
            } else {
                extendPropertyValueVO.setStatus("1");
            }
            return;
        }
        if (basePropertyEnum == BasePropertyEnum.OPENCARDDATE) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            extendPropertyValueVO.setPropertyValue(simpleDateFormat.format(memberInfo.getOpenCardTime()));
            return;
        }
    }

    public ResponseData<MemberInfoModel> getSingleMemberModel(@RequestBody MemberInfoModel memberInfoModel) throws MemberException {
        log.info("enter getSingleMemberModel method param:{}", (Object)JacksonUtil.bean2Json((Object)memberInfoModel));
        MemberInfoModel searchModel = this.memberInfoMapper.findMemberInfoByMemberModel(memberInfoModel);
        return ResponseUtil.getSuccessData((Object)searchModel);
    }

    public ResponseData<Boolean> judgePayLevelCard(Long sysCompanyId, Long brandId) {
        log.info("enter judgePayLevelCard param:sysCompanyId:{},brandId:{}", (Object)sysCompanyId, (Object)brandId);
        MbrLevelModel searchModel = new MbrLevelModel();
        searchModel.setSysCompanyId(sysCompanyId);
        searchModel.setBrandId(brandId);
        searchModel.setPayFlag(Integer.valueOf(1));
        List mbrLevelModels = this.mbrLevelDefPoMapper.queryMbrLevelModelList(searchModel);
        if (!Collections.isEmpty((Collection)mbrLevelModels)) {
            return ResponseUtil.getSuccessData((Object)true);
        }
        return ResponseUtil.getSuccessData((Object)false);
    }

    public ResponseData<String> queryElectCardConfig(Long sysCompanyId, Long sysBrandId) {
        log.info("queryElectCardConfig sysCompanyId:{} sysBrandId:{} ", (Object)sysCompanyId, (Object)sysBrandId);
        MbrElectCardPoExample example = new MbrElectCardPoExample();
        example.createCriteria().andSysCompanyIdEqualTo(sysCompanyId).andSysBrandIdEqualTo(sysBrandId);
        List mbrElectCardPOS = this.mbrElectCardPoMapper.selectByExample(example);
        if (CollectionUtil.isEmpty((Collection)mbrElectCardPOS)) {
            return ResponseUtil.getSuccessData(null);
        }
        MbrElectCardPo mbrElectCardPo = (MbrElectCardPo)mbrElectCardPOS.get(0);
        return ResponseUtil.getSuccessData((Object)mbrElectCardPo.getRemark(), (String)"\u67e5\u8be2\u6210\u529f");
    }

    public ResponseData<MbrElectCardVo> queryElectCardConfigVo(Long sysCompanyId, Long sysBrandId) {
        log.info("queryElectCardConfigVo sysCompanyId:{} sysBrandId:{} ", (Object)sysCompanyId, (Object)sysBrandId);
        MbrElectCardPoExample example = new MbrElectCardPoExample();
        example.createCriteria().andSysCompanyIdEqualTo(sysCompanyId).andSysBrandIdEqualTo(sysBrandId);
        List mbrElectCardPOS = this.mbrElectCardPoMapper.selectByExample(example);
        if (CollectionUtil.isEmpty((Collection)mbrElectCardPOS)) {
            return ResponseUtil.getSuccessData(null);
        }
        MbrElectCardPo mbrElectCardPo = (MbrElectCardPo)mbrElectCardPOS.get(0);
        MbrElectCardVo mbrElectCardVo = new MbrElectCardVo();
        BeanUtils.copyProperties((Object)mbrElectCardPo, (Object)mbrElectCardVo);
        return ResponseUtil.getSuccessData((Object)mbrElectCardVo, (String)"\u67e5\u8be2\u6210\u529f");
    }

    public ResponseData<Boolean> memberIsHaveUnfilledProperty(String memberCode, Long sysBrandId) {
        ParamValidation.paramsValidate((Object[])new Object[]{memberCode, sysBrandId});
        boolean isHaveUnfilledProperty = false;
        if ("undefined".equals(memberCode)) {
            return ResponseUtil.getSuccessData((Object)isHaveUnfilledProperty);
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        memberInfoModel.setBrandId(sysBrandId);
        if ("undefined".equals(memberCode)) {
            return ResponseUtil.getSuccessData((Object)isHaveUnfilledProperty);
        }
        MemberInfoModel memberInfoByMemberCode = this.memberInfoMapper.findMemberInfoByMemberModel(memberInfoModel);
        if (memberInfoByMemberCode == null) {
            return ResponseUtil.getFailedData((Object)false);
        }
        Date openCardTime = memberInfoByMemberCode.getOpenCardTime();
        MbrLifecycleParameterPo lifecycleParameterModel = this.mbrLifecycleParameterPoMapper.selectByBrandId(sysBrandId);
        Date date = lifecycleParameterModel != null && lifecycleParameterModel.getNewMember() != null ? DateUtils.addDays((Date)openCardTime, (int)lifecycleParameterModel.getNewMember()) : DateUtils.addDays((Date)openCardTime, (int)30);
        if (DateUtils.truncatedCompareTo((Date)new Date(), (Date)date, (int)5) >= 0) {
            return ResponseUtil.getSuccessData((Object)isHaveUnfilledProperty);
        }
        ResponseData baseAndExtendPropertyValue = this.getBaseAndExtendPropertyValue(memberInfoModel);
        PersonalDataVo propertyValue = (PersonalDataVo)baseAndExtendPropertyValue.getData();
        log.info("memberIsHaveUnfilledProperty getBaseAndExtendPropertyValue \u51fa\u53c2:{}", (Object)JacksonUtil.bean2Json((Object)propertyValue));
        for (ExtendPropertyValueVO extendPropertyValueVO : propertyValue.getBase()) {
            if (!"2".equals(extendPropertyValueVO.getRequired()) || !StringUtils.isBlank((CharSequence)extendPropertyValueVO.getPropertyValue())) continue;
            isHaveUnfilledProperty = true;
            break;
        }
        for (ExtendPropertyValueVO extendPropertyValueVO : propertyValue.getExtend()) {
            if (!"2".equals(extendPropertyValueVO.getRequired()) || !StringUtils.isBlank((CharSequence)extendPropertyValueVO.getPropertyValue())) continue;
            isHaveUnfilledProperty = true;
            break;
        }
        return ResponseUtil.getSuccessData((Object)isHaveUnfilledProperty);
    }

    public ResponseData<PersonalDataVo> getBaseAndExtendPropertyValue(@RequestBody MemberInfoModel memberInfoModel) throws MemberException {
        log.info("enter getBaseAndExtendPropertyValue method ! param:memberCode:{},brandId:{}", (Object)memberInfoModel.getMemberCode(), (Object)memberInfoModel.getBrandId());
        ParamValidation.paramsValidate((Object[])new Object[]{memberInfoModel.getMemberCode(), memberInfoModel.getBrandId()});
        MemberInfoModel memberInfo = this.memberInfoMapper.findMemberInfoByMemberModel(memberInfoModel);
        if (memberInfo == null) {
            return ResponseUtil.getSuccessData(null);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("brandId", memberInfo.getBrandId());
        map.put("memberCode", memberInfo.getMemberCode());
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        propertyMap.put("brandId", memberInfo.getBrandId());
        propertyMap.put("visible", 2);
        propertyMap.put("wxVisible", 2);
        propertyMap.put("status", "0");
        List base = this.mbrExtendDefPoMapper.queryBasePropertyColumn(propertyMap);
        propertyMap.put("visible", null);
        propertyMap.put("status", 0);
        List extend = this.mbrExtendDefPoMapper.queryExtendPropertyColumn(propertyMap);
        List list = this.mbrExtendPoMapper.findExtendPropertyValueListByExtendIds(map);
        for (Object extendPropertyValueVO : extend) {
            if (ExtendPropTypeEnum.RELATION_TYPE.getCode().equals(extendPropertyValueVO.getPropertyType())) {
                JSONArray jsonArray = JSONArray.parseArray((String)extendPropertyValueVO.getPropertyOption());
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsonObj = jsonArray.getJSONObject(i);
                    String option = jsonObj.getString("option");
                    ExtendPropertyModel searchPropertyModel = new ExtendPropertyModel();
                    searchPropertyModel.setPropertyCode(option);
                    searchPropertyModel.setBrandId(memberInfo.getBrandId());
                    ExtendPropertyValueVO relationPropertyValueVO = this.mbrExtendDefPoMapper.queryExtendPropertyByPropertyCode(searchPropertyModel);
                    jsonObj.remove((Object)"option");
                    if (relationPropertyValueVO == null) continue;
                    HashMap<String, String> paramMap = new HashMap<String, String>();
                    paramMap.put("memberCode", memberInfo.getMemberCode());
                    paramMap.put("propertyCode", option);
                    ExtendPropertyValueModel propertyValueModel = this.mbrExtendPoMapper.findPropertyValue(paramMap);
                    if (propertyValueModel != null) {
                        relationPropertyValueVO.setMemberCode(propertyValueModel.getMemberCode());
                        relationPropertyValueVO.setPropertyValue(propertyValueModel.getPropertyValue());
                    }
                    jsonObj.put("property", (Object)JacksonUtil.bean2Json((Object)relationPropertyValueVO));
                    extendPropertyValueVO.setPropertyOption(jsonArray.toString());
                }
            }
            for (ExtendPropertyValueVO extendPropertyValueVo1 : list) {
                if (!extendPropertyValueVO.getPropertyCode().equals(extendPropertyValueVo1.getPropertyCode())) continue;
                extendPropertyValueVO.setPropertyValue(extendPropertyValueVo1.getPropertyValue());
            }
        }
        PersonalDataVo personalDataVo = new PersonalDataVo();
        for (ExtendPropertyValueVO extendPropertyValueVO : base) {
            this.setBaseProperty(memberInfo, extendPropertyValueVO);
        }
        personalDataVo.setBase(base);
        personalDataVo.setExtend(extend);
        SysBrandVo sysBrandVo = new SysBrandVo();
        sysBrandVo.setSysBrandId(memberInfo.getBrandId());
        String skip = (String)this.brandServiceRpc.getSkipByBrandId(sysBrandVo).getData();
        personalDataVo.setSkip(skip);
        return ResponseUtil.getSuccessData((Object)personalDataVo);
    }

    public ResponseData<MemberCommonVo> queryMemberIncludeCommon(Long sysBrandId, String memberCode) {
        String barCode;
        log.info("MemberCardProgramApiServiceImpl#queryMemberIncludeCommon#sysBrandId:{},memberCode:{}", (Object)sysBrandId, (Object)memberCode);
        ParamValidation.paramsValidate((Object[])new Object[]{sysBrandId, memberCode});
        MemberCommonVo memberCommonVo = this.memberInfoMapper.queryMemberIncludeCommon(sysBrandId, memberCode);
        if (memberCommonVo == null) {
            log.info("memberInfoMapper#queryMemberIncludeCommon result is null, sysBrandId:{},memberCode:{}", (Object)sysBrandId, (Object)memberCode);
            return ResponseUtil.getFailedData(null);
        }
        if (StringUtils.isEmpty((CharSequence)memberCommonVo.getBarCode()) && StringUtils.isNotEmpty((CharSequence)memberCommonVo.getCardNo()) && !StringUtils.isBlank((CharSequence)(barCode = (String)this.utilsServiceFeign.getBarcode(memberCommonVo.getCardNo()).getData()))) {
            memberCommonVo.setBarCode(barCode);
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setBarCode(barCode);
            memberInfoModel.setMemberCode(memberCode);
            this.memberInfoMapper.updateBarCode(memberInfoModel);
        }
        return new ResponseData((Object)memberCommonVo);
    }

    public ResponseData<Integer> getCountIntegralByMemberCodeAndBrandId(Long sysBrandId, String memberCode) {
        log.info("MemberCardProgramApiServiceImpl#getCountIntegralByMemberCodeAndBrandId#sysBrandId:{},memberCode:{}", (Object)sysBrandId, (Object)memberCode);
        Integer countIntegral = this.memberInfoMapper.getCountIntegralByMemberCodeAndBrandId(sysBrandId, memberCode);
        return new ResponseData((Object)countIntegral);
    }
}

