/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.unifiedreg.service.copy.tools;

import com.bizvane.unifiedreg.service.copy.tools.StopWatchTimeAndLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.StopWatch;

public class StopWatchTime {
    private static final Logger log = LoggerFactory.getLogger(StopWatchTime.class);
    private static final ThreadLocal<StopWatchTimeAndLogger> STOP_WATCH_THREAD_LOCAL = new /* Unavailable Anonymous Inner Class!! */;

    public static void init(@Nullable Logger logger) {
        STOP_WATCH_THREAD_LOCAL.set(new StopWatchTimeAndLogger(new StopWatch(), logger));
    }

    public static void start(String taskName) {
        StopWatchTimeAndLogger swt = (StopWatchTimeAndLogger)STOP_WATCH_THREAD_LOCAL.get();
        if (swt == null) {
            log.info("\u4f7f\u7528start\u524d\u8bf7\u5148\u8c03\u7528init");
            return;
        }
        swt.getStopWatch().start(taskName);
        Logger logger = swt.getLog();
        if (logger != null) {
            logger.info("{} start", (Object)taskName);
        }
    }

    public static void stop() {
        StopWatchTimeAndLogger swt = (StopWatchTimeAndLogger)STOP_WATCH_THREAD_LOCAL.get();
        if (swt == null) {
            log.info("\u4f7f\u7528stop\u524d\u8bf7\u5148\u4f7f\u7528init");
            return;
        }
        StopWatch stopWatch = swt.getStopWatch();
        String taskName = stopWatch.currentTaskName();
        stopWatch.stop();
        Logger logger = swt.getLog();
        if (logger != null) {
            logger.info("{} stop", (Object)taskName);
        }
    }

    public static void pretty() {
        StopWatchTimeAndLogger swt = (StopWatchTimeAndLogger)STOP_WATCH_THREAD_LOCAL.get();
        if (swt == null) {
            log.info("\u4f7f\u7528pretty\u524d\u8bf7\u5148\u4f7f\u7528init");
            return;
        }
        StopWatch stopWatch = swt.getStopWatch();
        String taskName = stopWatch.currentTaskName();
        Logger logger = swt.getLog();
        if (logger != null) {
            logger.info("{} ,{}", (Object)taskName, (Object)stopWatch.toString());
        }
    }

    public static void destroy() {
        STOP_WATCH_THREAD_LOCAL.remove();
    }
}

