/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.unifiedreg.service.copy.outer;

import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WeChatInterfaceTransform {
    private static final Logger log = LoggerFactory.getLogger(WeChatInterfaceTransform.class);
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;

    public WxPublicPO getWxPublicPoByAppId(String appId) {
        if (StringUtils.isEmpty((CharSequence)appId)) {
            return null;
        }
        ResponseData responseData = this.wxPublicServiceFeign.getWxPublicPOByAppId(appId);
        if (responseData == null) {
            return null;
        }
        return (WxPublicPO)responseData.getData();
    }

    public WxPublicPO getWxPublicPoByBrandId(Long brandId) {
        if (brandId == null) {
            return null;
        }
        ResponseData responseData = this.wxPublicServiceFeign.getWxPublicBySysBrandId(brandId);
        if (responseData == null) {
            return null;
        }
        return (WxPublicPO)responseData.getData();
    }

    public List<WxPublicPO> getWxPublicPoListByBrandId(Long brandId) {
        if (brandId == null) {
            return null;
        }
        ResponseData responseData = this.wxPublicServiceFeign.getWxPublicListBySysBrandId(brandId);
        if (responseData == null) {
            return null;
        }
        return (List)responseData.getData();
    }
}

