/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.unifiedreg.service.copy.outer;

import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.IntegralAdjustRequestVO;
import com.bizvane.connectorservice.entity.common.IntegralAdjustResponseVO;
import com.bizvane.connectorservice.entity.common.MemberBindToErpRequestVO;
import com.bizvane.connectorservice.entity.common.MemberLoginRequestVO;
import com.bizvane.connectorservice.entity.common.MemberLoginResponseVO;
import com.bizvane.connectorservice.entity.common.MemberOpenCardRequestVO;
import com.bizvane.connectorservice.entity.common.MemberOpenCardResponseVO;
import com.bizvane.connectorservice.entity.common.MemberPhoneUpdateRequestVO;
import com.bizvane.connectorservice.interfaces.rpc.ConnectorServiceFeign;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConnectorInterfaceTransform {
    private static final Logger log = LoggerFactory.getLogger(ConnectorInterfaceTransform.class);
    @Autowired
    private ConnectorServiceFeign connectorServiceFeign;

    public Result<MemberLoginResponseVO> getOfflineLoginResult(MemberLoginRequestVO memberLoginRequestVO) {
        return this.connectorServiceFeign.login(memberLoginRequestVO);
    }

    public Result<MemberOpenCardResponseVO> getOfflineRegisterResult(MemberOpenCardRequestVO memberOpenCardRequestVO) {
        return this.connectorServiceFeign.opencard(memberOpenCardRequestVO);
    }

    public Result getOfflineModifiedPhoneData(MemberPhoneUpdateRequestVO memberPhoneUpdateRequestVO) {
        return this.connectorServiceFeign.modifyphone(memberPhoneUpdateRequestVO);
    }

    public IntegralAdjustResponseVO getOfflineChangeIntegralData(IntegralAdjustRequestVO integralAdjustRequestVO) {
        Result result = this.connectorServiceFeign.adjustIntegral(integralAdjustRequestVO);
        if (result == null) {
            return null;
        }
        return (IntegralAdjustResponseVO)result.getData();
    }

    public Result tmallBindToErp(MemberBindToErpRequestVO vo) {
        return this.connectorServiceFeign.tmallBindToErp(vo);
    }

    public Result<MemberOpenCardResponseVO> loginandopencard(MemberOpenCardRequestVO requestVO) {
        return this.connectorServiceFeign.loginandopencard(requestVO);
    }
}

