/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.unifiedreg.service.copy.mapper;

import com.bizvane.members.facade.models.ExtendPropertyModel;
import com.bizvane.members.facade.models.MemberCardLevelModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.WxMemberInfoInModel;
import com.bizvane.members.facade.models.WxMemberInfoOutModel;
import com.bizvane.members.facade.models.bo.CompanyMemberInfoBo;
import com.bizvane.members.facade.models.bo.GetMemberDeductionInfo;
import com.bizvane.members.facade.models.query.CouponMemberPo;
import com.bizvane.members.facade.models.query.FetchMessagePo;
import com.bizvane.members.facade.service.datafetch.model.MemberCardInfoFetchModel;
import com.bizvane.members.facade.vo.BatchUpdateMemberInfoVo;
import com.bizvane.members.facade.vo.DistributionMemberVo;
import com.bizvane.members.facade.vo.MemberInfoCardVo;
import com.bizvane.members.facade.vo.MemberInfoVo;
import com.bizvane.members.facade.vo.qywx.MemberFriendsKeyQueryVo;
import com.bizvane.unifiedreg.model.vo.MemberCommonVo;
import com.bizvane.unifiedreg.service.copy.base.MapperBase;
import com.bizvane.utils.tenant.QuarantineAnnotation;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

@Mapper
public interface MemberInfoMapper
extends MapperBase<MemberInfoModel> {
    public int insertMemberInfo(MemberInfoModel var1);

    public int updateMemberInfoByMemberCode(MemberInfoModel var1);

    public int updateMemberInfoByBrandAndPhone(MemberInfoModel var1);

    public MemberInfoModel findMemberInfoByMemberModel(MemberInfoModel var1);

    public MemberInfoModel findMemberInfoByMemberCode(@Param(value="memberCode") String var1);

    public List<MemberInfoModel> findMemberInfoByMemberCodeList(@Param(value="memberCodeList") List<String> var1, @Param(value="sysCompanyId") Long var2, @Param(value="sysBrandId") Long var3);

    public List<MemberInfoModel> findAllByConditions(Map var1);

    public MemberInfoModel queryMemberBasicInfo(@Param(value="memberCode") String var1);

    public MemberInfoCardVo queryMemberCard(@Param(value="memberCode") String var1);

    public MemberInfoVo findMemberInfoAndLevelByMemberCode(@Param(value="memberCode") String var1);

    @QuarantineAnnotation
    public List<Map> queryMemberCardChannel(@Param(value="channelIds") String var1);

    @Select(value={"select count(1) from t_mbr_members where valid = 1 and level_id = #{mbrLevelId}"})
    public int findLevelCount(@Param(value="mbrLevelId") Long var1);

    @Select(value={"select member_code as memberCode,label_ids as labelIds from t_mbr_members where member_code = #{memberCode}"})
    public MemberInfoModel findLabelIdsByMemberCode(@Param(value="memberCode") String var1);

    public Map getIntegralByMemberCode(@Param(value="memberCode") String var1);

    public Map getLevelByMemberCode(@Param(value="memberCode") String var1);

    public int batchUpdate(BatchUpdateMemberInfoVo var1);

    public int batchUpdateStoreAndGuide(BatchUpdateMemberInfoVo var1);

    public int updateIntegral(MemberInfoModel var1);

    public int updateLevel(MemberInfoModel var1);

    public MemberCardLevelModel queryMemberCardInfo(@Param(value="memberCode") String var1);

    @Select(value={"select service_store_id from t_mbr_members where member_code = #{memberCode}"})
    public Long getServiceStoreId(@Param(value="memberCode") String var1);

    @Select(value={"select open_card_store_id from t_mbr_members where member_code = #{memberCode}"})
    public Long getOpenCardStoreId(@Param(value="memberCode") String var1);

    @Select(value={"select max(card_no) from t_mbr_members where brand_id = #{brandId}"})
    public String queryMaxCardNo(@Param(value="brandId") Long var1);

    public MemberInfoModel queryMemberCardByErpIdAndOfflineBrandCode(MemberCardInfoFetchModel var1);

    public List<MemberInfoModel> getMemberInfoWithLimitTo(@Param(value="limit") Long var1, @Param(value="to") Long var2);

    public List<ExtendPropertyModel> exportMemberInfoList(@Param(value="memberInfoModel") MemberInfoModel var1, @Param(value="limit") Long var2, @Param(value="to") Long var3);

    public List<MemberInfoModel> getMemberInfoByMembersCode(Map var1);

    @Select(value={"select mbr_member_id as mbrMemberId,level_id as levelId,offline_update_date as offlineUpdateDate, member_code as memberCode,offline_update_integral_date as offlineUpdateIntegralDate,offline_update_balance_date as offlineUpdateBalanceDate,service_store_id as serviceStoreId,open_card_store_id as openCardStoreId,wx_union_id as wxUnionId,sys_company_id as sysCompanyId,brand_id as brandId,first_order_time as firstOrderTime,card_no as cardNo,service_guide_id as serviceGuideId,pet_card as petCard,open_card_store_id as openCardStoreId,open_card_store_code as openCardStoreCode,phone from t_mbr_members where erp_id = #{erpId} and offline_brand_code = #{offlineBrandCode} and offline_company_code=#{offlineCompanyCode} limit 1"})
    public MemberInfoModel queryMemberCodeByErpIdAndBrandCodeAndCompanyCode(@Param(value="erpId") String var1, @Param(value="offlineBrandCode") String var2, @Param(value="offlineCompanyCode") String var3);

    @Select(value={"select member_code as memberCode,sys_company_id as sysCompanyId,brand_id as brandId,first_order_time as firstOrderTime,wx_union_id as wxUnionId, open_card_store_id as openCardStoreId,phone , card_no as cardNo, service_store_id as serviceStoreId, offline_card_no as offlineCardNo,open_card_time as openCardTime from t_mbr_members where erp_id = #{erpId} and brand_id = #{brandId}"})
    public MemberInfoModel queryMemberInfoByErpIdAndBrandId(@Param(value="erpId") String var1, @Param(value="brandId") Long var2);

    public int updateLastEsTime(@Param(value="memberCode") String var1, @Param(value="activeStore") Long var2);

    public Integer getMemberInfoDistributionState(@Param(value="memberCode") String var1, @Param(value="brandId") Long var2);

    public List<MemberInfoModel> findDistributionMemberList(DistributionMemberVo var1);

    public Long countDistributionMemberInfoList(DistributionMemberVo var1);

    public List<MemberInfoModel> exportDistributionMemberList(@Param(value="distributionMemberVo") DistributionMemberVo var1, @Param(value="limit") Long var2, @Param(value="to") Long var3);

    public int updateMemberInfo(@Param(value="memberInfoModel") MemberInfoModel var1, @Param(value="map") Map var2);

    public FetchMessagePo queryMessagePo(String var1);

    @Select(value={"select member_code from t_mbr_members where brand_id = #{brandId} and offline_card_no = #{offlineCardNo} and valid = 1 limit 1"})
    public String queryMemberCodeByCardNo(MemberInfoModel var1);

    public MemberInfoModel queryMemberInfoByCardNo(MemberInfoModel var1);

    public List<MemberInfoModel> getMemberInfoByCodeList(CouponMemberPo var1);

    public List<CompanyMemberInfoBo> getCompanyWxMemberInfo(CouponMemberPo var1);

    @QuarantineAnnotation
    public int updateFriends(MemberInfoModel var1);

    @Update(value={"update t_mbr_members set member_comment = #{memberComment},modified_date = now() where member_code = #{memberCode}"})
    public int updateMemberComment(MemberInfoModel var1);

    @Select(value={"select mbr_member_id as mbrMemberId,member_code as memberCode from t_mbr_members where valid = 1 and brand_id = #{brandId} and wx_union_id = #{wxUnionId}"})
    public MemberInfoModel queryMemberByUnionId(MemberInfoModel var1);

    @Update(value={"update t_mbr_members set bar_code = #{barCode},modified_date = now() where member_code = #{memberCode}"})
    public int updateBarCode(MemberInfoModel var1);

    @Update(value={"update t_mbr_members set service_guide_id = null, mark = 0,modified_date = now() where service_guide_id = #{serviceGuideId} and brand_id = #{brandId}"})
    public int removeServiceGuide(MemberInfoModel var1);

    @Select(value={"select erp_id as erpId from t_mbr_members where mbr_member_id = #{mbrMemberId}"})
    public MemberInfoModel getMemberById(@Param(value="mbrMemberId") Long var1);

    public MemberInfoModel getMemberFriendsWithMultiKeyWord(MemberFriendsKeyQueryVo var1);

    public int queryCountByPhone(MemberInfoModel var1);

    public MemberInfoModel findSimpleMemberInfoWithCardNo(MemberInfoModel var1);

    public int updateMembersWithNullAssignFieldByMemberCode(@Param(value="record") MemberInfoModel var1, @Param(value="fieldmap") Map<String, String> var2);

    public int updateMemberLabel(MemberInfoModel var1);

    public MemberInfoModel findTaoBaoMemberInfoByMemberCode(MemberInfoModel var1);

    public Integer getCountIntegralByMemberCode(String var1);

    @Select(value={"UPDATE t_mbr_members SET integral_exchange_ticket_count = integral_exchange_ticket_count + #{second},modified_date = now() WHERE member_code = #{memberCode}"})
    public Integer addIntegralExchangeTicketCount(@Param(value="memberCode") String var1, @Param(value="second") Integer var2);

    public List<MemberInfoModel> queryMemberByLabelId(@Param(value="mbrLabelDefId") Long var1);

    public List<String> getMemberCodeByStoreCode(@Param(value="brandId") Long var1, @Param(value="companyId") Long var2, @Param(value="storeId") Long var3);

    public int updateMemberLevelByMemberCode(MemberInfoModel var1);

    public int updateMemberBalance(MemberInfoModel var1);

    public MemberInfoModel queryMemberCodeByErpIdAndBrandId(@Param(value="erpId") String var1, @Param(value="brandId") Long var2, @Param(value="sysCompanyId") Long var3);

    public int updateMemberLevelUpTimeByMemberCode(MemberInfoModel var1);

    public int updateBabyBirthdayByMemberCode(MemberInfoModel var1);

    public int updateFirstOrderTimeByMemberCode(MemberInfoModel var1);

    public int queryMemberCountByServiceGuide(@Param(value="brandId") Long var1, @Param(value="serviceGuideId") Long var2);

    @Select(value={"select count_integral from t_mbr_members where member_code = #{memberCode}"})
    public Integer queryMemberIntegral(@Param(value="memberCode") String var1);

    public GetMemberDeductionInfo queryMemberDeductionInfo(@Param(value="memberCode") String var1);

    public int updateMemberBalanceAndIntegral(GetMemberDeductionInfo var1);

    public Integer getBalanceByCardNo(@Param(value="cardNo") String var1, @Param(value="brandId") Long var2);

    public BigDecimal queryMemberBalanceByMemberCode(@Param(value="memberCode") String var1);

    public GetMemberDeductionInfo queryMemberByCardNo(@Param(value="cardNo") String var1, @Param(value="brandId") Long var2);

    public Integer updatePetCardByMemberCode(@Param(value="memberCode") String var1, @Param(value="petCard") String var2);

    public MemberInfoModel getCommonSingleMembersInfo(@Param(value="record") MemberInfoModel var1, @Param(value="wxMembers") Boolean var2);

    public int updateByPrimaryKeySelectiveWithNullAssigned(@Param(value="record") MemberInfoModel var1, @Param(value="fieldmap") Map<String, String> var2);

    public int updatePetCardByErpIdAndBrandId(@Param(value="petCard") String var1, @Param(value="erpId") String var2, @Param(value="brandId") Long var3);

    public MemberInfoModel findSimpleMemberInfoWithCardNoAndWxMembers(@Param(value="record") MemberInfoModel var1, @Param(value="wxMembers") Boolean var2);

    public MemberInfoModel queryUrMemberInfo(MemberInfoModel var1);

    public int updateUrMembersInfo(@Param(value="record") MemberInfoModel var1, @Param(value="fieldmap") Map<String, String> var2);

    public int updateUrMembersPhone(MemberInfoModel var1);

    public MemberInfoModel queryBasicMemberInfo(MemberInfoModel var1);

    public MemberInfoModel queryMemberInfoByMemberCode(@Param(value="memberCode") String var1);

    public WxMemberInfoOutModel queryWxMemberInfo(WxMemberInfoInModel var1);

    public MemberInfoModel queryMemberInfoByPhone(@Param(value="phone") String var1, @Param(value="brandId") Long var2);

    public MemberInfoModel queryChannelInfoByMemberCode(@Param(value="memberCode") String var1, @Param(value="brandId") Long var2);

    public int updateEmailStatusByMemberCode(@Param(value="memberCode") String var1, @Param(value="brandId") Long var2);

    public MemberInfoModel querySingleMemberInfoIgnoreValid(MemberInfoModel var1);

    public MemberInfoModel findMemberInfoByPhone(@Param(value="phone") String var1, @Param(value="sysCompanyId") Long var2, @Param(value="sysBrandId") Long var3);

    public MemberInfoModel findMemberInfoByPhoneCardNoErpid(@Param(value="phone") String var1, @Param(value="cardNo") String var2, @Param(value="erpid") String var3, @Param(value="sysCompanyId") Long var4, @Param(value="sysBrandId") Long var5);

    public int updateMemberInfoByErpIdAndBrandId(MemberInfoModel var1);

    public MemberInfoModel queryMemberByErpIdBrandId(@Param(value="erpId") String var1, @Param(value="brandId") Long var2);

    public MemberInfoModel queryIntegralByErpIdBrandId(@Param(value="erpId") String var1, @Param(value="brandId") Long var2);

    public int updateMemberInfoByMemberCodeNotEmpty(MemberInfoModel var1);

    public MemberInfoModel getEmailByMemberCode(@Param(value="memberCode") String var1, @Param(value="brandId") Long var2);

    public List<MemberInfoModel> queryMembersByErpIdCompanyId(@Param(value="sysCompanyId") Long var1, @Param(value="erpId") String var2);

    public List<MemberInfoModel> queryMembersByErpIdCompanyIdPhoneUnionId(@Param(value="sysCompanyId") Long var1, @Param(value="erpId") String var2, @Param(value="phone") String var3, @Param(value="wxUnionId") String var4);

    public int updateMemberBalanceByErpIdBrandId(MemberInfoModel var1);

    public Map<String, Object> selectFieldMemberInfo(@Param(value="fieldList") Set<String> var1, @Param(value="model") MemberInfoModel var2);

    public List<MemberInfoModel> queryMembersList(MemberInfoModel var1);

    public MemberInfoModel queryMembersListStageProcess(MemberInfoModel var1);

    public int updateMemberServiceStore(MemberInfoModel var1);

    public int updateMemberServiceStoreAllBrands(@Param(value="serviceStoreId") Long var1, @Param(value="serviceStoreCode") String var2, @Param(value="erpId") String var3, @Param(value="companyId") Long var4);

    public int updateServiceStore(MemberInfoModel var1);

    public int updateMembersWithNullAssignField(@Param(value="record") MemberInfoModel var1, @Param(value="fieldmap") Map<String, String> var2);

    public int updateMemberInfoBasion(MemberInfoModel var1);

    public MemberInfoModel findMemberInfoBaison(MemberInfoModel var1);

    public int updateMemberValid(MemberInfoModel var1);

    @Select(value={"select name, mbr_member_id as mbrMemberId, sys_company_id as sysCompanyid, brand_id as brandId, member_code as memberCode,all_channel_ids as allChannelIds,open_card_channel_id as openCardChannelId from t_mbr_members where sys_company_id=#{sysCompanyId}  and phone=#{phone}"})
    public List<MemberInfoModel> getMemberListBySysCompanyIdAndPhone(@Param(value="sysCompanyId") Long var1, @Param(value="phone") String var2);

    public List<MemberInfoModel> selectBrandIdByCardNo(MemberInfoModel var1);

    @Select(value={"select member_code,level_id,offline_level_code,sys_company_id from t_mbr_members where erp_id = #{erpId} and brand_id = #{brandId}"})
    public MemberInfoModel queryMemberByErpIdAndBrandId(@Param(value="erpId") String var1, @Param(value="brandId") Long var2);

    public int batchUpdateAllChannels(List<MemberInfoModel> var1);

    public int updateMbrLevelIdByCode(@Param(value="memberCode") String var1, @Param(value="sysCompanyId") Long var2, @Param(value="brandId") Long var3, @Param(value="levelId") Long var4);

    public List<MemberInfoModel> getAllMember(@Param(value="erpId") String var1, @Param(value="sysCompanyId") Long var2);

    @Update(value={"UPDATE t_mbr_members set first_order_time = null WHERE mbr_member_id = #{mbrMemberId}"})
    public int updateFirstOrderTimeById(@Param(value="mbrMemberId") Long var1);

    public int updateAboutExpireIntegral(MemberInfoModel var1);

    public int batchUpdateAboutExpireIntegral(@Param(value="list") List<String> var1, @Param(value="sysCompanyId") Long var2, @Param(value="brandId") Long var3, @Param(value="aboutExpireIntegral") Integer var4);

    public int updateAboutExpireIntegralByErpId(MemberInfoModel var1);

    public int batchUpdateAboutExpireIntegralByErpId(@Param(value="list") List<String> var1, @Param(value="sysCompanyId") Long var2, @Param(value="brandId") Long var3, @Param(value="aboutExpireIntegral") Integer var4);

    @Update(value={"update t_mbr_members set all_channel_ids = #{allChannelIds},modified_date = now() where member_code = #{memberCode} and sys_company_id = #{sysCompanyId} and brand_id = #{brandId}"})
    public int updateMemberAllChannelIds(MemberInfoModel var1);

    public MemberInfoModel findMemberInfoForInterface(MemberInfoModel var1);

    @Select(value={"select member_code from t_mbr_members where sys_company_id = 3841 limit 100"})
    public List<String> testSelectMembers();

    public int updateBindByMemberCode(MemberInfoModel var1);

    public int deleteByMemberCode(@Param(value="sysCompanyId") Long var1, @Param(value="brandId") Long var2, @Param(value="memberCode") String var3);

    public MemberCommonVo queryMemberIncludeCommon(@Param(value="sysBrandId") Long var1, @Param(value="memberCode") String var2);

    public Integer getCountIntegralByMemberCodeAndBrandId(@Param(value="sysBrandId") Long var1, @Param(value="memberCode") String var2);
}

