/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.unifiedreg.service.copy.inner.impl;

import com.alibaba.fastjson.JSON;
import com.bizvane.centerstageservice.models.po.SysStaffPo;
import com.bizvane.centerstageservice.models.po.SysStoreGroupPo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.models.vo.GetOnlineOrgStoresRequestVo;
import com.bizvane.centerstageservice.models.vo.OnlineOrgStoreInfoRequestVo;
import com.bizvane.centerstageservice.models.vo.OnlineOrgStoreInfoResponseVo;
import com.bizvane.centerstageservice.rpc.StaffServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreGroupServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.centerstageservice.rpc.SysDimSkuServiceRpc;
import com.bizvane.centerstageservice.rpc.SysOnlineOrgServcieRpc;
import com.bizvane.members.facade.enums.CardStatusEnum;
import com.bizvane.members.facade.enums.TaoBaoBindStatusEnum;
import com.bizvane.members.facade.es.pojo.MembersInfoSearchPojo;
import com.bizvane.members.facade.es.vo.MembersInfoSearchVo;
import com.bizvane.members.facade.es.vo.SearchChannelRequest;
import com.bizvane.members.facade.es.vo.SearchExternalRequest;
import com.bizvane.members.facade.es.vo.SearchFriendsRequest;
import com.bizvane.members.facade.es.vo.SearchGroupRequest;
import com.bizvane.members.facade.es.vo.SearchGuideRequest;
import com.bizvane.members.facade.es.vo.SearchOrgRequest;
import com.bizvane.members.facade.es.vo.SearchPhoneBatchRequest;
import com.bizvane.members.facade.es.vo.SearchStoreRequest;
import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MbrGroupModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.MembersSysModel;
import com.bizvane.members.facade.vo.ExtendPropertyValueVO;
import com.bizvane.members.facade.vo.MemberInfoVo;
import com.bizvane.members.facade.vo.PageVo;
import com.bizvane.unifiedreg.service.copy.es.repository.MembersInfoSearchRepository;
import com.bizvane.unifiedreg.service.copy.inner.MemberGroupService;
import com.bizvane.unifiedreg.service.copy.inner.MemberLevelService;
import com.bizvane.unifiedreg.service.copy.inner.MemberScreenService;
import com.bizvane.unifiedreg.service.copy.inner.MembersAdvancedSearchService;
import com.bizvane.unifiedreg.service.copy.mapper.MemberGroupMapper;
import com.bizvane.unifiedreg.service.copy.mapper.MemberInfoMapper;
import com.bizvane.unifiedreg.service.copy.mapper.MemberSysMapper;
import com.bizvane.unifiedreg.service.copy.tools.DateUtil;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.google.common.collect.Lists;
import io.jsonwebtoken.lang.Collections;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.ScriptQueryBuilder;
import org.elasticsearch.script.Script;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MembersAdvancedSearchServiceImpl
implements MembersAdvancedSearchService {
    private static final Logger log = LoggerFactory.getLogger(MembersAdvancedSearchServiceImpl.class);
    public static final String YYYY_MM_DD_T_HH_MM_SS_SSS_0800 = "yyyy-MM-dd'T'HH:mm:ss.SSS+0800";
    public static final String ASIA_SHANGHAI = "Asia/Shanghai";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    @Autowired
    StoreServiceRpc storeServiceRpc;
    @Autowired
    StaffServiceRpc staffServiceRpc;
    @Autowired
    MemberLevelService memberLevelService;
    @Autowired
    StoreGroupServiceRpc storeGroupServiceRpc;
    @Lazy
    @Autowired
    MemberScreenService memberScreenService;
    @Autowired
    private MembersInfoSearchRepository searchRepository;
    @Autowired
    private SysDimSkuServiceRpc sysDimSkuServiceRpc;
    @Autowired
    private MemberInfoMapper memberInfoMapper;
    @Autowired
    private MemberSysMapper memberSysMapper;
    @Autowired
    private MemberGroupMapper memberGroupMapper;
    @Autowired
    private SysOnlineOrgServcieRpc sysOnlineOrgServcieRpc;
    @Autowired
    private MemberGroupService memberGroupService;
    private static Pattern pattern = Pattern.compile("^-?[0-9]+");
    private static String[] number = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24"};

    public ResponseData<PageInfo<MemberInfoVo>> search(MembersInfoSearchVo membersInfoSearchVo, PageVo pageVo) throws MemberException {
        log.info("\u5f00\u59cb\u641c\u7d22 enter search method current start time :{}", (Object)DateUtil.format((Date)new Date(), (String)DateUtil.ymdhmsS));
        ResponseData responseData = new ResponseData();
        PageRequest pageable = PageRequest.of((int)(pageVo.getPageNumber() - 1), (int)pageVo.getPageSize(), (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createDate", "openCardTime", "mbrMemberId"}));
        try {
            PageInfo pageInfo = this.analysisParamForMemberfile(membersInfoSearchVo, (Pageable)pageable);
            responseData.setData((Object)pageInfo);
        }
        catch (MemberException e) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(e.getMessage());
            log.error("advanced search query failed exception info" + (Object)((Object)e));
        }
        log.info("\u5b8c\u6210\u641c\u7d22 search method response current end time :{}", (Object)DateUtil.format((Date)new Date(), (String)DateUtil.ymdhmsS));
        return responseData;
    }

    public PageInfo<MemberInfoVo> analysisParamForMemberfile(MembersInfoSearchVo infoSearchVo, Pageable pageable) throws MemberException {
        Date startDate = new Date();
        log.info("\u5f00\u59cb\u89e3\u6790\u53c2\u6570\u62fc\u63a5ES\u6761\u4ef6 analysisParam method current start time :{}", (Object)DateUtil.format((Date)startDate, (String)DateUtil.ymdhmsS));
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        infoSearchVo.setChildMbrGroupDefIdsStr(this.formatChildMbrGroupIds(infoSearchVo.getChildMbrGroupDefIds()));
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)infoSearchVo.getChildMbrGroupDefIdsStr())) {
            builder.must((QueryBuilder)this.getEsWhere(infoSearchVo, QueryBuilders.boolQuery()));
            BoolQueryBuilder parentBuilder = QueryBuilders.boolQuery();
            List<String> idList = Arrays.asList(infoSearchVo.getChildMbrGroupDefIdsStr().split("\\|"));
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(idList)) {
                for (String str : idList) {
                    BoolQueryBuilder childBuilder = QueryBuilders.boolQuery();
                    List list = this.memberGroupMapper.selectByGroupIdList(str);
                    if (!Collections.isEmpty((Collection)list)) {
                        for (MbrGroupModel model : list) {
                            this.formatEsQueryBulider(infoSearchVo, model, childBuilder);
                        }
                    }
                    if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)childBuilder.must())) continue;
                    parentBuilder.should((QueryBuilder)childBuilder);
                }
            }
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)parentBuilder.should())) {
                builder.must((QueryBuilder)parentBuilder);
            }
        } else {
            builder = this.getEsWhere(infoSearchVo, builder);
        }
        log.info("ES DSL builder{}", (Object)builder);
        Page page = this.searchRepository.search((QueryBuilder)builder, pageable);
        Date endDate = new Date();
        long interval = (endDate.getTime() - startDate.getTime()) / 1000L;
        log.info("\u53d6\u5230ES\u6570\u636e\u540e\uff0c\u8fdb\u884c\u8f6c\u6362\u9700\u8981\u7684\u5bf9\u8c61 start time:{}", (Object)DateUtil.format((Date)endDate, (String)DateUtil.ymdhmsS));
        log.info("es search time:{}", (Object)(interval + "s"));
        List infoVoList = this.convertVoForMemberfile(infoSearchVo.getSysCompanyId(), infoSearchVo.getBrandId(), page.getContent());
        log.info("\u5b8c\u6210\u89e3\u6790\u53c2\u6570\u62fc\u63a5ES\u6761\u4ef6 analysisParam method current end time :{}", (Object)DateUtil.format((Date)new Date(), (String)DateUtil.ymdhmsS));
        return this.getPageInfo(infoVoList, page, pageable);
    }

    public BoolQueryBuilder getEsWhere(MembersInfoSearchVo infoSearchVo, BoolQueryBuilder builder) throws MemberException {
        BoolQueryBuilder membersBuilder;
        ExistsQueryBuilder downGradeBuilder2;
        BoolQueryBuilder boolQueryBuilder;
        SimpleDateFormat yyyyMmDdFormat;
        SimpleDateFormat sd;
        String start;
        Date endDate;
        Date firstDate;
        String nowDate;
        BoolQueryBuilder nullBuilder;
        List newGuideList;
        BoolQueryBuilder labelBuilder;
        BoolQueryBuilder openCardBuilder;
        BoolQueryBuilder nullBuilder2;
        List memberCodeList;
        SearchPhoneBatchRequest search;
        List<Integer> idList;
        List list;
        BoolQueryBuilder channelBuilder;
        List newStoreList;
        builder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"valid", (Object)true));
        if (infoSearchVo.getCardUseStatus() != null) {
            if (infoSearchVo.getCardUseStatus() == 4) {
                builder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"cardUseStatus", (Object)infoSearchVo.getCardUseStatus()));
            } else {
                builder.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"cardUseStatus", (Object)4));
            }
        }
        if (null != infoSearchVo.getSysCompanyId()) {
            builder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"sysCompanyId", (Object)infoSearchVo.getSysCompanyId()));
        }
        if (null != infoSearchVo.getBrandId()) {
            builder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"brandId", (Object)infoSearchVo.getBrandId()));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)infoSearchVo.getName())) {
            builder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"name", (Object)infoSearchVo.getName()));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)infoSearchVo.getPhone())) {
            builder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"phone.keyword", (Object)infoSearchVo.getPhone()));
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getStoreList())) {
            BoolQueryBuilder storeBuilder = QueryBuilders.boolQuery();
            newStoreList = infoSearchVo.getStoreList().stream().filter(store -> store != null).collect(Collectors.toList());
            while (newStoreList != null && newStoreList.size() > 0) {
                if (newStoreList.size() > 1000) {
                    storeBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"serviceStoreId", newStoreList.subList(0, 1000)));
                    newStoreList = newStoreList.subList(1000, newStoreList.size());
                    continue;
                }
                storeBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"serviceStoreId", newStoreList.subList(0, newStoreList.size())));
                newStoreList = null;
            }
            builder.must((QueryBuilder)storeBuilder);
        }
        if (infoSearchVo.getServiceOrg() != null) {
            BoolQueryBuilder serviceOrgBuilder = QueryBuilders.boolQuery();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)infoSearchVo.getServiceOrg().getList())) {
                List orgList = infoSearchVo.getServiceOrg().getList();
                List orgCodesList = orgList.stream().map(SearchOrgRequest::getOnlineOrgCode).collect(Collectors.toList());
                GetOnlineOrgStoresRequestVo requestVo = new GetOnlineOrgStoresRequestVo();
                requestVo.setBrandId(infoSearchVo.getBrandId());
                requestVo.setSysCompanyId(infoSearchVo.getSysCompanyId());
                requestVo.setOnlineOrgCodes(orgCodesList);
                ResponseData storeResp = this.sysOnlineOrgServcieRpc.getStoresByOnlineOrgCodes(requestVo);
                if (storeResp == null || storeResp.getCode() == SysResponseEnum.FAILED.getCode()) {
                    throw new MemberException(SysResponseEnum.FAILED.getMessage());
                }
                List storeIdList = ((List)storeResp.getData()).stream().filter(Objects::nonNull).map(OnlineOrgStoreInfoResponseVo::getSysStoreId).collect(Collectors.toList());
                while (storeIdList != null && storeIdList.size() > 0) {
                    if (storeIdList.size() > 1000) {
                        serviceOrgBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"serviceStoreId", storeIdList.subList(0, 1000)));
                        storeIdList = storeIdList.subList(1000, storeIdList.size());
                        continue;
                    }
                    serviceOrgBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"serviceStoreId", storeIdList.subList(0, storeIdList.size())));
                    storeIdList = null;
                }
            }
            builder.must((QueryBuilder)serviceOrgBuilder);
        }
        if (null != infoSearchVo.getServiceGroup()) {
            BoolQueryBuilder serviceGroupBuilder = QueryBuilders.boolQuery();
            if (!Collections.isEmpty((Collection)infoSearchVo.getServiceGroup().getList())) {
                List requestList = infoSearchVo.getServiceGroup().getList();
                requestList.stream().forEach(storeGroup -> {
                    if (0L == storeGroup.getSysStoreGroupId()) {
                        BoolQueryBuilder nullBuilder = QueryBuilders.boolQuery();
                        nullBuilder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"serviceStoreId"));
                        serviceGroupBuilder.should((QueryBuilder)nullBuilder);
                    }
                });
                List longList = requestList.stream().map(SearchGroupRequest::getSysStoreGroupId).collect(Collectors.toList());
                ResponseData storeList = this.storeGroupServiceRpc.getStoreIdsByGroupIds(longList);
                if (storeList != null && storeList.getData() != null) {
                    List newStoreList2 = ((List)storeList.getData()).stream().filter(store -> store != null).collect(Collectors.toList());
                    while (newStoreList2 != null && newStoreList2.size() > 0) {
                        if (newStoreList2.size() > 1000) {
                            serviceGroupBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"serviceStoreId", newStoreList2.subList(0, 1000)));
                            newStoreList2 = newStoreList2.subList(1000, newStoreList2.size());
                            continue;
                        }
                        serviceGroupBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"serviceStoreId", newStoreList2.subList(0, newStoreList2.size())));
                        newStoreList2 = null;
                    }
                }
            }
            builder.must((QueryBuilder)serviceGroupBuilder);
        }
        if (infoSearchVo.getChannelIds() != null) {
            channelBuilder = QueryBuilders.boolQuery();
            if (!Collections.isEmpty((Collection)infoSearchVo.getChannelIds().getList())) {
                list = infoSearchVo.getChannelIds().getList();
                idList = list.stream().map(SearchChannelRequest::getChannelId).collect(Collectors.toList());
                BoolQueryBuilder boolQueryBuilder2 = QueryBuilders.boolQuery();
                idList.forEach(channel -> {
                    boolQueryBuilder2.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"allChannelIds", (String)("*," + channel + ",*")));
                    boolQueryBuilder2.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"allChannelIds", (String)("*," + channel)));
                });
                channelBuilder.must((QueryBuilder)boolQueryBuilder2);
            }
            builder.filter((QueryBuilder)channelBuilder);
        }
        if (infoSearchVo.getOpenCardChannelIds() != null) {
            channelBuilder = QueryBuilders.boolQuery();
            if (!Collections.isEmpty((Collection)infoSearchVo.getOpenCardChannelIds().getList())) {
                list = infoSearchVo.getOpenCardChannelIds().getList();
                idList = list.stream().map(SearchChannelRequest::getChannelId).collect(Collectors.toList());
                idList.forEach(channel -> channelBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"openCardChannelId", (Object)channel).operator(Operator.OR)));
            }
            builder.filter((QueryBuilder)channelBuilder);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)infoSearchVo.getCardNoBatch())) {
            BoolQueryBuilder cardNoBuilder = QueryBuilders.boolQuery();
            try {
                ResponseData cardNoBatch = this.memberScreenService.importCardNoExcel(infoSearchVo.getCardNoBatch());
                if (cardNoBatch != null && !Collections.isEmpty((Collection)((Collection)cardNoBatch.getData()))) {
                    List cardList = (List)cardNoBatch.getData();
                    while (cardList != null && cardList.size() > 0) {
                        if (cardList.size() > 1000) {
                            cardNoBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"cardNo.keyword", cardList.subList(0, 1000)));
                            cardList = cardList.subList(1000, cardList.size());
                            continue;
                        }
                        cardNoBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"cardNo.keyword", cardList.subList(0, cardList.size())));
                        cardList = null;
                    }
                } else {
                    cardNoBuilder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"cardNo.keyword", (Object)"zero"));
                }
            }
            catch (MemberException e) {
                e.printStackTrace();
                throw new MemberException(e.getMessage());
            }
            builder.filter((QueryBuilder)cardNoBuilder);
        }
        if (infoSearchVo.getPhoneBatch() != null) {
            search = infoSearchVo.getPhoneBatch();
            BoolQueryBuilder phoneBuilder = QueryBuilders.boolQuery();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)search.getUrl())) {
                try {
                    ResponseData phoneBatch = this.memberScreenService.importPhoneExcel(search.getUrl());
                    if (phoneBatch != null && !Collections.isEmpty((Collection)((Collection)phoneBatch.getData()))) {
                        List phoneList = (List)phoneBatch.getData();
                        while (phoneList != null && phoneList.size() > 0) {
                            if (phoneList.size() > 1000) {
                                phoneBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"phone.keyword", phoneList.subList(0, 1000)));
                                phoneList = phoneList.subList(1000, phoneList.size());
                                continue;
                            }
                            phoneBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"phone.keyword", phoneList.subList(0, phoneList.size())));
                            phoneList = null;
                        }
                    } else {
                        phoneBuilder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"phone.keyword", (Object)"zero"));
                    }
                }
                catch (MemberException e) {
                    e.printStackTrace();
                    throw new MemberException(e.getMessage());
                }
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)search.getMobile())) {
                if (!search.getMobile().contains(",")) {
                    phoneBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"phone.keyword", (Object)search.getMobile()).operator(Operator.AND));
                } else {
                    String[] mobiles;
                    for (String mobile : mobiles = search.getMobile().split(",")) {
                        phoneBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"phone.keyword", (Object)mobile).operator(Operator.AND));
                    }
                }
            }
            builder.filter((QueryBuilder)phoneBuilder);
        }
        if (infoSearchVo.getEmailBatch() != null) {
            search = infoSearchVo.getEmailBatch();
            BoolQueryBuilder emailBuilder = QueryBuilders.boolQuery();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)search.getUrl())) {
                try {
                    ResponseData emailBatch = this.memberScreenService.importEmailExcel(search.getUrl());
                    if (emailBatch != null && !Collections.isEmpty((Collection)((Collection)emailBatch.getData()))) {
                        List emailList = (List)emailBatch.getData();
                        while (emailList != null && emailList.size() > 0) {
                            if (emailList.size() > 1000) {
                                emailBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"email.keyword", emailList.subList(0, 1000)));
                                emailList = emailList.subList(1000, emailList.size());
                                continue;
                            }
                            emailBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"email.keyword", emailList.subList(0, emailList.size())));
                            emailList = null;
                        }
                    } else {
                        emailBuilder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"email.keyword", (Object)"zero"));
                    }
                }
                catch (MemberException e) {
                    e.printStackTrace();
                    throw new MemberException(e.getMessage());
                }
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)search.getEmail())) {
                if (!search.getEmail().contains(",")) {
                    emailBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"email.keyword", (Object)search.getEmail()).operator(Operator.AND));
                } else {
                    String[] emails;
                    for (String email : emails = search.getEmail().split(",")) {
                        emailBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"email.keyword", (Object)email).operator(Operator.AND));
                    }
                }
            }
            builder.filter((QueryBuilder)emailBuilder);
            if (search.getType() != null) {
                BoolQueryBuilder emailStatusBuilders;
                BoolQueryBuilder emailStatusBuilder = QueryBuilders.boolQuery();
                if (search.getType() == 3) {
                    emailStatusBuilders = QueryBuilders.boolQuery();
                    emailStatusBuilders.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"email.keyword"));
                    emailStatusBuilder.should((QueryBuilder)emailStatusBuilders);
                    BoolQueryBuilder emailStatusBuilderCard = QueryBuilders.boolQuery();
                    emailStatusBuilderCard.must((QueryBuilder)QueryBuilders.termQuery((String)"email.keyword", (String)""));
                    emailStatusBuilder.should((QueryBuilder)emailStatusBuilderCard);
                } else if (search.getType() == 2) {
                    emailStatusBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"emailStatus", (Object)0));
                    emailStatusBuilders = QueryBuilders.boolQuery();
                    emailStatusBuilders.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"emailStatus"));
                    emailStatusBuilders.must((QueryBuilder)QueryBuilders.existsQuery((String)"email.keyword"));
                    emailStatusBuilders.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"email.keyword", (String)""));
                    emailStatusBuilder.should((QueryBuilder)emailStatusBuilders);
                } else {
                    emailBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"emailStatus", (Object)search.getType()).operator(Operator.AND));
                }
                builder.filter((QueryBuilder)emailStatusBuilder);
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)infoSearchVo.getMemberCodeList())) {
            BoolQueryBuilder memberBuilder = QueryBuilders.boolQuery();
            memberCodeList = infoSearchVo.getMemberCodeList();
            while (memberCodeList != null && memberCodeList.size() > 0) {
                if (memberCodeList.size() > 1000) {
                    memberBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"memberCode", memberCodeList.subList(0, 1000)));
                    memberCodeList = memberCodeList.subList(1000, memberCodeList.size());
                    continue;
                }
                memberBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"memberCode", memberCodeList.subList(0, memberCodeList.size())));
                memberCodeList = null;
            }
            if (!infoSearchVo.isMemberCodeListHas()) {
                builder.filter((QueryBuilder)memberBuilder);
            } else {
                builder.mustNot((QueryBuilder)memberBuilder);
            }
        }
        if (infoSearchVo.getTaobaoBindStatus() != null) {
            if (infoSearchVo.getTaobaoBindStatus() == 1) {
                builder.filter((QueryBuilder)QueryBuilders.termQuery((String)"taobaoBindStatus", (Object)TaoBaoBindStatusEnum.TAOBAO_BIND.getCode()));
            } else if (infoSearchVo.getTaobaoBindStatus() == 2) {
                BoolQueryBuilder taobaoBuilder = QueryBuilders.boolQuery();
                nullBuilder2 = QueryBuilders.boolQuery();
                nullBuilder2.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"taobaoBindStatus"));
                taobaoBuilder.should((QueryBuilder)nullBuilder2);
                taobaoBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"taobaoBindStatus", (Object)TaoBaoBindStatusEnum.UN_TAOBAO_BIND.getCode()));
                builder.filter((QueryBuilder)taobaoBuilder);
            } else if (infoSearchVo.getTaobaoBindStatus() == 3) {
                builder.filter((QueryBuilder)QueryBuilders.termQuery((String)"taobaoBindStatus", (Object)TaoBaoBindStatusEnum.TAOBAO_REMOVE_BIND.getCode()));
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)infoSearchVo.getConditions())) {
            builder.must((QueryBuilder)QueryBuilders.multiMatchQuery((Object)infoSearchVo.getConditions(), (String[])new String[]{"phone.keyword", "name", "cardNo.keyword"}).operator(Operator.AND).type(MultiMatchQueryBuilder.Type.BEST_FIELDS));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)infoSearchVo.getMemberCode())) {
            builder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"memberCode", (Object)infoSearchVo.getMemberCode()));
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getArea())) {
            BoolQueryBuilder areaBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getArea().forEach(area -> {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)area.getCity()) || "\u5168\u90e8".equals(area.getCity())) {
                    areaBuilder.should((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)"province", (Object)area.getProvince()).operator(Operator.AND)));
                } else if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)area.getCounty()) || "\u5168\u90e8".equals(area.getCounty())) {
                    areaBuilder.should((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)"province", (Object)area.getProvince()).operator(Operator.AND)).filter((QueryBuilder)QueryBuilders.matchQuery((String)"city", (Object)area.getCity()).operator(Operator.AND)));
                } else {
                    areaBuilder.should((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)"province", (Object)area.getProvince()).operator(Operator.AND)).filter((QueryBuilder)QueryBuilders.matchQuery((String)"city", (Object)area.getCity()).operator(Operator.AND)).filter((QueryBuilder)QueryBuilders.matchQuery((String)"county", (Object)area.getCounty()).operator(Operator.AND)));
                }
            });
            builder.filter((QueryBuilder)areaBuilder);
        }
        if (null != infoSearchVo.getGender()) {
            builder.filter(MembersAdvancedSearchServiceImpl.termQuery((String)"gender", (String)infoSearchVo.getGender().toString()));
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getBirthdayMD())) {
            BoolQueryBuilder birthdayMdBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getBirthdayMD().stream().forEach(birthdayMd -> birthdayMdBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"birthdayMd.keyword").includeLower(true).includeUpper(true).gte((Object)MembersAdvancedSearchServiceImpl.zeroFill((String)birthdayMd.getMin())).lte((Object)MembersAdvancedSearchServiceImpl.zeroFill((String)birthdayMd.getMax()))));
            builder.must((QueryBuilder)birthdayMdBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getBabyBirthdayMD())) {
            BoolQueryBuilder babyBirthdayMdBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getBabyBirthdayMD().stream().forEach(babyBirthdayMd -> babyBirthdayMdBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"babyBirthdayMd").includeLower(true).includeUpper(true).gte((Object)MembersAdvancedSearchServiceImpl.zeroFill((String)babyBirthdayMd.getMin())).lte((Object)MembersAdvancedSearchServiceImpl.zeroFill((String)babyBirthdayMd.getMax()))));
            builder.must((QueryBuilder)babyBirthdayMdBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getAge())) {
            BoolQueryBuilder ageBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getAge().stream().forEach(age -> ageBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"birthday").includeLower(true).includeUpper(true).timeZone("Asia/Shanghai").gte((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)DateUtil.getAgeLast((Integer)Integer.parseInt(age.getMax())))).lte((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)DateUtil.getAgeFirst((Integer)Integer.parseInt(age.getMin()))))));
            builder.filter((QueryBuilder)ageBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getBalance())) {
            BoolQueryBuilder balanceBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getBalance().stream().forEach(balance -> balanceBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"balance").includeLower(true).includeUpper(true).gte((Object)balance.getMin()).lte((Object)balance.getMax())));
            builder.filter((QueryBuilder)balanceBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getLevelID())) {
            BoolQueryBuilder levelBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getLevelID().forEach(level -> levelBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"levelId", (Object)level)));
            builder.filter((QueryBuilder)levelBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getLabelsID())) {
            BoolQueryBuilder labelsBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getLabelsID().forEach(label -> labelsBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"labelIds", (Object)label)));
            builder.filter((QueryBuilder)labelsBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getIntegral())) {
            BoolQueryBuilder integralBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getIntegral().stream().forEach(integral -> integralBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"countIntegral").includeLower(true).includeUpper(true).gte((Object)integral.getMin()).lte((Object)integral.getMax())));
            builder.filter((QueryBuilder)integralBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getAboutExpireIntegral())) {
            BoolQueryBuilder aboutExpireIntegralBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getAboutExpireIntegral().stream().forEach(aboutExpireIntegral -> aboutExpireIntegralBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"expiringIntegral").includeLower(true).includeUpper(true).gte((Object)aboutExpireIntegral.getMin()).lte((Object)aboutExpireIntegral.getMax())));
            builder.filter((QueryBuilder)aboutExpireIntegralBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getOpenCardTime())) {
            openCardBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getOpenCardTime().stream().forEach(openCard -> openCardBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"openCardTime").includeLower(true).includeUpper(true).timeZone("Asia/Shanghai").from((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)((String)openCard.getRang().get(0)))).to((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)((String)openCard.getRang().get(1))))));
            builder.filter((QueryBuilder)openCardBuilder);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)infoSearchVo.getOpenCardDateFrom()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)infoSearchVo.getOpenCardDateTo())) {
            openCardBuilder = QueryBuilders.boolQuery();
            openCardBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"openCardTime").includeLower(true).includeUpper(true).timeZone("Asia/Shanghai").from((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)infoSearchVo.getOpenCardDateFrom())).to((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)infoSearchVo.getOpenCardDateTo())));
            builder.filter((QueryBuilder)openCardBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getBindCardTime())) {
            builder.must((QueryBuilder)QueryBuilders.matchQuery((String)"cardStatus", (Object)CardStatusEnum.ALREADY_BIND_CARD.getCode()));
            BoolQueryBuilder bindCardBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getBindCardTime().stream().forEach(bindCard -> bindCardBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"bindCardTime").includeLower(true).includeUpper(true).timeZone("Asia/Shanghai").from((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)((String)bindCard.getRang().get(0)))).to((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)((String)bindCard.getRang().get(1))))));
            builder.filter((QueryBuilder)bindCardBuilder);
        }
        if (null != infoSearchVo.getFocus() && 0 != infoSearchVo.getFocus()) {
            if (1 == infoSearchVo.getFocus()) {
                builder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"focus"));
            }
            if (2 == infoSearchVo.getFocus() || 3 == infoSearchVo.getFocus()) {
                builder.must((QueryBuilder)QueryBuilders.matchQuery((String)"focus", (Object)infoSearchVo.getFocus().toString()));
            }
        }
        if (null != infoSearchVo.getFocusPublic() && 0 != infoSearchVo.getFocusPublic()) {
            BoolQueryBuilder publicBuilder = QueryBuilders.boolQuery();
            if (2 == infoSearchVo.getFocusPublic()) {
                builder.must((QueryBuilder)QueryBuilders.matchQuery((String)"focus", (Object)infoSearchVo.getFocusPublic().toString()));
            } else {
                builder.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"focus", (Object)"2"));
            }
            builder.filter((QueryBuilder)publicBuilder);
        }
        if (null != infoSearchVo.getCardStatus() && 0 != infoSearchVo.getCardStatus()) {
            String cardStatus = "";
            if (1 == infoSearchVo.getCardStatus()) {
                cardStatus = "2";
            } else if (2 == infoSearchVo.getCardStatus()) {
                cardStatus = "1";
            }
            builder.must((QueryBuilder)QueryBuilders.matchQuery((String)"cardStatus", (Object)cardStatus));
        }
        if (null != infoSearchVo.getWxMembers() && 0 != infoSearchVo.getWxMembers()) {
            builder.must((QueryBuilder)QueryBuilders.matchQuery((String)"wxMembers", (Object)infoSearchVo.getWxMembers().toString()));
        }
        if (null != infoSearchVo.getNewMember() && 0 != infoSearchVo.getNewMember()) {
            builder.must((QueryBuilder)QueryBuilders.matchQuery((String)"groupNewMember", (Object)infoSearchVo.getNewMember().toString()));
        }
        if (null != infoSearchVo.getMemberLiveness() && 0 != infoSearchVo.getMemberLiveness()) {
            builder.must((QueryBuilder)QueryBuilders.matchQuery((String)"memberLiveness", (Object)infoSearchVo.getMemberLiveness().toString()));
        }
        if (null != infoSearchVo.getLabels()) {
            labelBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getLabels().getList().forEach(outer -> {
                BoolQueryBuilder query = QueryBuilders.boolQuery();
                outer.forEach(inner -> query.must((QueryBuilder)QueryBuilders.matchQuery((String)"labelIds", (Object)inner.getMbrLabelDefId()).operator(Operator.AND)));
                labelBuilder.should((QueryBuilder)query);
            });
            builder.filter((QueryBuilder)labelBuilder);
        }
        if (infoSearchVo.getLabelNames() != null && !Collections.isEmpty((Collection)infoSearchVo.getLabelNames().getList())) {
            labelBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getLabelNames().getList().stream().forEach(label -> labelBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"labelIds", (Object)label.getMbrLabelDefId()).operator(Operator.AND)));
            builder.filter((QueryBuilder)labelBuilder);
        }
        if (infoSearchVo.getQaLabels() != null) {
            BoolQueryBuilder qaLabelBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getQaLabels().getList().forEach(outer -> {
                BoolQueryBuilder query = QueryBuilders.boolQuery();
                query.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"audienceName.keyword", (String)("*|" + outer.getLabelName() + "|*")));
                qaLabelBuilder.should((QueryBuilder)query);
            });
            builder.filter((QueryBuilder)qaLabelBuilder);
        }
        if (null != infoSearchVo.getServiceGuide()) {
            BoolQueryBuilder serviceGuideBuilder = QueryBuilders.boolQuery();
            if (!Collections.isEmpty((Collection)infoSearchVo.getServiceGuide().getList())) {
                if (infoSearchVo.getServiceGuide().getList().stream().anyMatch(guide -> guide.getSysStaffId() == 0L)) {
                    nullBuilder2 = QueryBuilders.boolQuery();
                    nullBuilder2.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"serviceGuideId"));
                    serviceGuideBuilder.should((QueryBuilder)nullBuilder2);
                }
                newGuideList = infoSearchVo.getServiceGuide().getList().stream().filter(guide -> guide != null).map(guide -> guide.getSysStaffId()).collect(Collectors.toList());
                while (newGuideList != null && newGuideList.size() > 0) {
                    if (newGuideList.size() > 1000) {
                        serviceGuideBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"serviceGuideId", newGuideList.subList(0, 1000)));
                        newGuideList = newGuideList.subList(1000, newGuideList.size());
                        continue;
                    }
                    serviceGuideBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"serviceGuideId", newGuideList.subList(0, newGuideList.size())));
                    newGuideList = null;
                }
            }
            if (infoSearchVo.getServiceGuide().getContainDefaultService() != null && infoSearchVo.getServiceGuide().getContainDefaultService().booleanValue()) {
                MembersSysModel searchSysModel = new MembersSysModel();
                searchSysModel.setSysCompanyId(infoSearchVo.getSysCompanyId());
                searchSysModel.setBrandId(infoSearchVo.getBrandId());
                MembersSysModel membersSysModel = this.memberSysMapper.selectMembersSysModel(searchSysModel);
                if (membersSysModel != null && membersSysModel.getOpenCardGuideId() != null) {
                    serviceGuideBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"serviceGuideId", (Object)membersSysModel.getOpenCardGuideId()));
                }
            }
            builder.must((QueryBuilder)serviceGuideBuilder);
        }
        if (null != infoSearchVo.getServiceStore()) {
            BoolQueryBuilder serviceStoreBuilder = QueryBuilders.boolQuery();
            if (!Collections.isEmpty((Collection)infoSearchVo.getServiceStore().getList())) {
                newStoreList = infoSearchVo.getServiceStore().getList().stream().filter(store -> store != null).map(SearchStoreRequest::getSysStoreId).collect(Collectors.toList());
                if (newStoreList.stream().anyMatch(storeId -> storeId == 0L)) {
                    nullBuilder = QueryBuilders.boolQuery();
                    nullBuilder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"serviceStoreId"));
                    serviceStoreBuilder.should((QueryBuilder)nullBuilder);
                }
                while (newStoreList != null && newStoreList.size() > 0) {
                    if (newStoreList.size() > 1000) {
                        serviceStoreBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"serviceStoreId", newStoreList.subList(0, 1000)));
                        newStoreList = newStoreList.subList(1000, newStoreList.size());
                        continue;
                    }
                    serviceStoreBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"serviceStoreId", newStoreList.subList(0, newStoreList.size())));
                    newStoreList = null;
                }
                builder.must((QueryBuilder)serviceStoreBuilder);
            }
        }
        if (null != infoSearchVo.getOpenCardGuide()) {
            BoolQueryBuilder openCardGuideBuilder = QueryBuilders.boolQuery();
            if (!Collections.isEmpty((Collection)infoSearchVo.getOpenCardGuide().getList())) {
                newGuideList = infoSearchVo.getOpenCardGuide().getList().stream().filter(guide -> guide != null).map(SearchGuideRequest::getSysStaffId).collect(Collectors.toList());
                if (newGuideList.stream().anyMatch(guideId -> guideId == 0L)) {
                    nullBuilder = QueryBuilders.boolQuery();
                    nullBuilder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"openCardGuideId"));
                    openCardGuideBuilder.should((QueryBuilder)nullBuilder);
                }
                while (newGuideList != null && newGuideList.size() > 0) {
                    if (newGuideList.size() > 1000) {
                        openCardGuideBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"openCardGuideId", newGuideList.subList(0, 1000)));
                        newGuideList = newGuideList.subList(1000, newGuideList.size());
                        continue;
                    }
                    openCardGuideBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"openCardGuideId", newGuideList.subList(0, newGuideList.size())));
                    newGuideList = null;
                }
                builder.must((QueryBuilder)openCardGuideBuilder);
            }
        }
        if (null != infoSearchVo.getOpenCardStore()) {
            BoolQueryBuilder openCardStoreBuilder = QueryBuilders.boolQuery();
            if (!Collections.isEmpty((Collection)infoSearchVo.getOpenCardStore().getList())) {
                newStoreList = infoSearchVo.getOpenCardStore().getList().stream().filter(store -> store != null).map(SearchStoreRequest::getSysStoreId).collect(Collectors.toList());
                if (newStoreList.stream().anyMatch(storeId -> storeId == 0L)) {
                    nullBuilder = QueryBuilders.boolQuery();
                    nullBuilder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"openCardStoreId"));
                    openCardStoreBuilder.should((QueryBuilder)nullBuilder);
                }
                while (newStoreList != null && newStoreList.size() > 0) {
                    if (newStoreList.size() > 1000) {
                        openCardStoreBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"openCardStoreId", newStoreList.subList(0, 1000)));
                        newStoreList = newStoreList.subList(1000, newStoreList.size());
                        continue;
                    }
                    openCardStoreBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"openCardStoreId", newStoreList.subList(0, newStoreList.size())));
                    newStoreList = null;
                }
                builder.must((QueryBuilder)openCardStoreBuilder);
            }
        }
        if (null != infoSearchVo.getCompanyGuideFriends()) {
            BoolQueryBuilder companyGuideFriendsBuilder = QueryBuilders.boolQuery();
            if (!Collections.isEmpty((Collection)infoSearchVo.getCompanyGuideFriends().getList())) {
                List friends = infoSearchVo.getCompanyGuideFriends().getList().stream().map(SearchFriendsRequest::getGuideId).collect(Collectors.toList());
                while (friends != null && friends.size() > 0) {
                    if (friends.size() > 1000) {
                        companyGuideFriendsBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"companyGuideFriends", friends.subList(0, 1000)));
                        friends = friends.subList(1000, friends.size());
                        continue;
                    }
                    companyGuideFriendsBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"companyGuideFriends", friends.subList(0, friends.size())));
                    friends = null;
                }
                if (infoSearchVo.getCompanyGuideFriends().getHas().booleanValue()) {
                    builder.must((QueryBuilder)companyGuideFriendsBuilder);
                } else {
                    builder.mustNot((QueryBuilder)companyGuideFriendsBuilder);
                }
            } else if (infoSearchVo.getCompanyGuideFriends().getHas().booleanValue()) {
                builder.must((QueryBuilder)QueryBuilders.existsQuery((String)"companyGuideFriends"));
            } else {
                builder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"companyGuideFriends"));
            }
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getFirstBuyTime())) {
            BoolQueryBuilder firstBuyTimeBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getFirstBuyTime().stream().forEach(firstBuyTime -> firstBuyTimeBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"firstBuyTime").includeLower(true).includeUpper(true).timeZone("Asia/Shanghai").from((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)((String)firstBuyTime.getRang().get(0)))).to((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)((String)firstBuyTime.getRang().get(1))))));
            builder.must((QueryBuilder)firstBuyTimeBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getLastBuyTime())) {
            BoolQueryBuilder lastBuyTimeBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getLastBuyTime().stream().forEach(lastBuyTime -> lastBuyTimeBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"lastBuyTime").includeLower(true).includeUpper(true).timeZone("Asia/Shanghai").from((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)((String)lastBuyTime.getRang().get(0)))).to((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)((String)lastBuyTime.getRang().get(1))))));
            builder.must((QueryBuilder)lastBuyTimeBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getConsumeAmount())) {
            BoolQueryBuilder consumeAmountBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getConsumeAmount().stream().forEach(consumeAmount -> consumeAmountBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)MembersAdvancedSearchServiceImpl.getPropertyName((String)"consumeAmount", (String)consumeAmount.getVal())).gte((Object)consumeAmount.getMin()).lte((Object)consumeAmount.getMax()).includeLower(true).includeUpper(true)));
            builder.must((QueryBuilder)consumeAmountBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getConsumeNumber())) {
            BoolQueryBuilder consumeNumberBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getConsumeNumber().stream().forEach(consumeNumber -> consumeNumberBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)MembersAdvancedSearchServiceImpl.getPropertyName((String)"consumeNumber", (String)consumeNumber.getVal())).gte((Object)consumeNumber.getMin()).lte((Object)consumeNumber.getMax()).includeLower(true).includeUpper(true)));
            builder.must((QueryBuilder)consumeNumberBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getRefundNumber())) {
            BoolQueryBuilder refundNumberBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getRefundNumber().stream().forEach(refundNumber -> refundNumberBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)MembersAdvancedSearchServiceImpl.getPropertyName((String)"refundNumber", (String)refundNumber.getVal())).gte((Object)refundNumber.getMin()).lte((Object)refundNumber.getMax()).includeLower(true).includeUpper(true)));
            builder.must((QueryBuilder)refundNumberBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getRefundAmount())) {
            BoolQueryBuilder refundAmountBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getRefundAmount().stream().forEach(refundAmount -> refundAmountBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)MembersAdvancedSearchServiceImpl.getPropertyName((String)"refundAmount", (String)refundAmount.getVal())).gt((Object)refundAmount.getMin()).lt((Object)refundAmount.getMax()).includeLower(true).includeUpper(true)));
            builder.must((QueryBuilder)refundAmountBuilder);
        }
        if (null != infoSearchVo.getPctAmount()) {
            BoolQueryBuilder pctAmountBuilder = QueryBuilders.boolQuery();
            pctAmountBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)MembersAdvancedSearchServiceImpl.getPropertyName((String)"pctAmount", (String)infoSearchVo.getPctAmount().getVal())).gt((Object)infoSearchVo.getPctAmount().getMin()).lt((Object)infoSearchVo.getPctAmount().getMax()).includeLower(true).includeUpper(true));
            builder.must((QueryBuilder)pctAmountBuilder);
        }
        if (null != infoSearchVo.getDiscountRate()) {
            BoolQueryBuilder discountRateBuilder = QueryBuilders.boolQuery();
            discountRateBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)MembersAdvancedSearchServiceImpl.getPropertyName((String)"discountRate", (String)infoSearchVo.getDiscountRate().getVal())).gt((Object)infoSearchVo.getDiscountRate().getMin()).lt((Object)infoSearchVo.getDiscountRate().getMax()).includeLower(true).includeUpper(true));
            builder.must((QueryBuilder)discountRateBuilder);
        }
        if (null != infoSearchVo.getAprNumber()) {
            BoolQueryBuilder aprNumberBuilder = QueryBuilders.boolQuery();
            aprNumberBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)MembersAdvancedSearchServiceImpl.getPropertyName((String)"aprNumber", (String)infoSearchVo.getAprNumber().getVal())).gt((Object)infoSearchVo.getAprNumber().getMin()).lt((Object)infoSearchVo.getAprNumber().getMax()).includeLower(true).includeUpper(true));
            builder.must((QueryBuilder)aprNumberBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getConsumeChannelFrom())) {
            channelBuilder = QueryBuilders.boolQuery();
            BoolQueryBuilder channelInnerBuilder = QueryBuilders.boolQuery();
            IntSummaryStatistics collect = infoSearchVo.getConsumeChannelFrom().stream().collect(Collectors.summarizingInt(channel -> channel));
            ScriptQueryBuilder scriptQuery = QueryBuilders.scriptQuery((Script)new Script("(doc['consumeChannelAllInt'].value & " + collect.getSum() + ") > 0 "));
            channelInnerBuilder.filter((QueryBuilder)scriptQuery);
            channelBuilder.should((QueryBuilder)channelInnerBuilder);
            builder.must((QueryBuilder)channelBuilder);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)infoSearchVo.getMemberScope())) {
            if ("1".equals(infoSearchVo.getMemberScope())) {
                builder.must((QueryBuilder)QueryBuilders.existsQuery((String)"wxUnionId"));
            } else if ("2".equals(infoSearchVo.getMemberScope())) {
                builder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"wxUnionId"));
            } else if ("3".equals(infoSearchVo.getMemberScope())) {
                // empty if block
            }
        }
        if (infoSearchVo.getDataIntegrityPercentage() != null) {
            builder.must((QueryBuilder)QueryBuilders.matchQuery((String)"dataIntegrityPercentage", (Object)infoSearchVo.getDataIntegrityPercentage()));
        }
        if (null != infoSearchVo.getBirthdayLine()) {
            BoolQueryBuilder birthDayBuilder = QueryBuilders.boolQuery();
            if (infoSearchVo.getBirthdayLine() == 0) {
                nowDate = DateUtil.format((Date)new Date(), (String)"MMdd");
                birthDayBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"birthdayMd.keyword").gte((Object)nowDate).lte((Object)nowDate));
            } else {
                firstDate = DateUtil.getStartDayOfMonth((Date)new Date());
                endDate = DateUtil.addDay((Date)new Date(), (int)infoSearchVo.getBirthdayLine());
                start = DateUtil.format((Date)firstDate, (String)"MMdd");
                String end = DateUtil.format((Date)endDate, (String)"MMdd");
                birthDayBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"birthdayMd.keyword").gte((Object)start).lte((Object)end));
            }
            builder.must((QueryBuilder)QueryBuilders.existsQuery((String)"birthdayMd.keyword"));
            builder.must((QueryBuilder)birthDayBuilder);
        }
        if (null != infoSearchVo.getBabyBirthdayLine()) {
            BoolQueryBuilder babyBirthDayBuilder = QueryBuilders.boolQuery();
            if (infoSearchVo.getBabyBirthdayLine() == 0) {
                nowDate = DateUtil.format((Date)new Date(), (String)"MMdd");
                babyBirthDayBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"babyBirthdayMd").gte((Object)nowDate).lte((Object)nowDate));
            } else {
                firstDate = DateUtil.getStartDayOfMonth((Date)new Date());
                endDate = DateUtil.addDay((Date)new Date(), (int)infoSearchVo.getBabyBirthdayLine());
                start = DateUtil.format((Date)firstDate, (String)"MMdd");
                String end = DateUtil.format((Date)endDate, (String)"MMdd");
                babyBirthDayBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"babyBirthdayMd").gte((Object)start).lte((Object)end));
            }
            builder.must((QueryBuilder)QueryBuilders.existsQuery((String)"babyBirthdayMd"));
            builder.must((QueryBuilder)babyBirthDayBuilder);
        }
        if (null != infoSearchVo.getOpenCardTimeLine()) {
            openCardBuilder = QueryBuilders.boolQuery();
            if (infoSearchVo.getOpenCardTimeLine() == 0) {
                nowDate = DateUtil.format((Date)new Date(), (String)"yyyyMMdd");
                openCardBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"openCardTimeMD").gte((Object)nowDate).lte((Object)nowDate));
            } else {
                firstDate = DateUtil.getStartDayOfMonth((Date)new Date());
                endDate = DateUtil.addDay((Date)new Date(), (int)infoSearchVo.getOpenCardTimeLine());
                start = DateUtil.format((Date)firstDate, (String)"yyyyMMdd");
                String end = DateUtil.format((Date)endDate, (String)"yyyyMMdd");
                openCardBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"openCardTimeMD").gte((Object)start).lte((Object)end));
            }
            builder.must((QueryBuilder)QueryBuilders.existsQuery((String)"openCardTimeMD"));
            builder.filter((QueryBuilder)openCardBuilder);
        }
        if (infoSearchVo.getLevelUpTimeNode() != null) {
            sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            BoolQueryBuilder levelUpTimeBuilder = QueryBuilders.boolQuery();
            BoolQueryBuilder existsBuilder = QueryBuilders.boolQuery();
            existsBuilder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"levelUpTime"));
            levelUpTimeBuilder.should((QueryBuilder)existsBuilder);
            levelUpTimeBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"levelUpTime").includeLower(true).includeUpper(true).timeZone("Asia/Shanghai").to((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)sd.format(infoSearchVo.getLevelUpTimeNode()))));
            log.info("levelUpTime fhe:{}", (Object)infoSearchVo.getLevelUpTimeNode());
            builder.filter((QueryBuilder)levelUpTimeBuilder);
        }
        if (infoSearchVo.getCreateTimeNode() != null) {
            sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"createDate").includeLower(true).includeUpper(true).timeZone("Asia/Shanghai").to((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)sd.format(infoSearchVo.getCreateTimeNode()))));
        }
        if (null != infoSearchVo.getDistributionState()) {
            builder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"distributionState", (Object)(infoSearchVo.getDistributionState() == 1 ? 1 : 0)));
        }
        if (null != infoSearchVo.getCreateStartTime() && null != infoSearchVo.getCreateEndTime()) {
            BoolQueryBuilder createTimeBuilder = QueryBuilders.boolQuery();
            createTimeBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"distributionCreateTime").includeLower(true).includeUpper(true).timeZone("Asia/Shanghai").from((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)infoSearchVo.getCreateStartTime())).to((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)infoSearchVo.getCreateEndTime())));
            builder.filter((QueryBuilder)createTimeBuilder);
        }
        if (null != infoSearchVo.getModifiedStartTime() && null != infoSearchVo.getModifiedEndTime()) {
            BoolQueryBuilder modifiedTimeBuilder = QueryBuilders.boolQuery();
            modifiedTimeBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"distributionModifiedTime").includeLower(true).includeUpper(true).timeZone("Asia/Shanghai").from((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)infoSearchVo.getModifiedStartTime())).to((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)infoSearchVo.getModifiedEndTime())));
            builder.filter((QueryBuilder)modifiedTimeBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getExtendValue())) {
            BoolQueryBuilder extendBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getExtendValue().stream().forEach(extend -> {
                if (!Collections.isEmpty((Collection)extend.getVal())) {
                    extend.getVal().stream().forEach(val -> extendBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"textProperty", (String)("*" + extend.getCode() + ":*" + val + "*:" + extend.getCode() + "*"))));
                } else if (!Collections.isEmpty((Collection)extend.getRange())) {
                    infoSearchVo.getExtendValue().stream().forEach(extendDateVal -> extendBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)extend.getCode()).includeLower(true).includeUpper(true).timeZone("Asia/Shanghai").from((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)((String)extendDateVal.getRange().get(0)))).to((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)((String)extendDateVal.getRange().get(1))))));
                }
            });
            builder.filter((QueryBuilder)extendBuilder);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)infoSearchVo.getMemberComment())) {
            builder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"memberComment", (Object)infoSearchVo.getMemberComment()));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)infoSearchVo.getWxNick())) {
            builder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"wxNick", (Object)infoSearchVo.getWxNick()));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)infoSearchVo.getFriendsConditions())) {
            builder.must((QueryBuilder)QueryBuilders.multiMatchQuery((Object)infoSearchVo.getFriendsConditions(), (String[])new String[]{"memberComment", "name", "wxNick", "phone.keyword"}).operator(Operator.AND).type(MultiMatchQueryBuilder.Type.BEST_FIELDS));
        }
        if (infoSearchVo.getGenderList() != null) {
            BoolQueryBuilder genderBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getGenderList().forEach(gender -> genderBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"gender", (Object)gender)));
            builder.filter((QueryBuilder)genderBuilder);
        }
        if (infoSearchVo.getCompanyFriend() != null) {
            if (infoSearchVo.getCompanyFriend() == 1) {
                builder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"companyFriend", (Object)infoSearchVo.getCompanyFriend()));
            } else {
                BoolQueryBuilder companyFriendBuilder = QueryBuilders.boolQuery();
                nullBuilder2 = QueryBuilders.boolQuery();
                nullBuilder2.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"companyFriend"));
                companyFriendBuilder.should((QueryBuilder)nullBuilder2);
                companyFriendBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"companyFriend", (Object)0));
                builder.filter((QueryBuilder)companyFriendBuilder);
            }
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getProductCodeList())) {
            infoSearchVo.getProductCodeList().forEach(products -> {
                ResponseData skuRes = this.sysDimSkuServiceRpc.getSysDimSkuListByPrd(null, null, null, null, infoSearchVo.getProductCode(), infoSearchVo.getSysCompanyId(), infoSearchVo.getBrandId());
                List skuList = (List)skuRes.getData();
                BoolQueryBuilder skuBuilder = QueryBuilders.boolQuery();
                if (skuList != null && skuList.size() > 0) {
                    while (skuList != null && skuList.size() > 0) {
                        if (skuList.size() > 1000) {
                            skuBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"skus", (Collection)skuList.subList(0, 1000).stream().map(x -> x.getSkuId()).collect(Collectors.toList())));
                            skuList = skuList.subList(1000, skuList.size());
                            continue;
                        }
                        skuBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"skus", (Collection)skuList.subList(0, skuList.size()).stream().map(x -> x.getSkuId()).collect(Collectors.toList())));
                        skuList = null;
                    }
                } else {
                    skuBuilder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"memberCode"));
                }
                builder.filter((QueryBuilder)skuBuilder);
            });
        }
        if (infoSearchVo.getCata1PrdList() != null || infoSearchVo.getCata2PrdList() != null || infoSearchVo.getCata3PrdList() != null || infoSearchVo.getSeasonPrdList() != null || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)infoSearchVo.getProductCode())) {
            List cata1PrdList = null;
            List cata2PrdList = null;
            List cata3PrdList = null;
            List seasonPrdList = null;
            if (infoSearchVo.getCata1PrdList() != null) {
                cata1PrdList = infoSearchVo.getCata1PrdList().getList();
            }
            if (infoSearchVo.getCata2PrdList() != null) {
                cata2PrdList = infoSearchVo.getCata2PrdList().getList();
            }
            if (infoSearchVo.getCata3PrdList() != null) {
                cata3PrdList = infoSearchVo.getCata3PrdList().getList();
            }
            if (infoSearchVo.getSeasonPrdList() != null) {
                seasonPrdList = infoSearchVo.getSeasonPrdList().getList();
            }
            ResponseData skuRes = this.sysDimSkuServiceRpc.getSysDimSkuListByPrd(cata1PrdList, cata2PrdList, cata3PrdList, seasonPrdList, infoSearchVo.getProductCode(), infoSearchVo.getSysCompanyId(), infoSearchVo.getBrandId());
            List skuList = (List)skuRes.getData();
            BoolQueryBuilder skuBuilder = QueryBuilders.boolQuery();
            if (skuList != null && skuList.size() > 0) {
                while (skuList != null && skuList.size() > 0) {
                    if (skuList.size() > 1000) {
                        skuBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"skus", (Collection)skuList.subList(0, 1000).stream().map(x -> x.getSkuId()).collect(Collectors.toList())));
                        skuList = skuList.subList(1000, skuList.size());
                        continue;
                    }
                    skuBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"skus", (Collection)skuList.subList(0, skuList.size()).stream().map(x -> x.getSkuId()).collect(Collectors.toList())));
                    skuList = null;
                }
            } else {
                skuBuilder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"memberCode"));
            }
            builder.filter((QueryBuilder)skuBuilder);
        }
        if (null != infoSearchVo.getQrCodeChannel()) {
            BoolQueryBuilder qrCodeChannelBuilder = QueryBuilders.boolQuery();
            if (!Collections.isEmpty((Collection)infoSearchVo.getQrCodeChannel().getList())) {
                infoSearchVo.getQrCodeChannel().getList().stream().forEach(qrCodeChannel -> {
                    if (qrCodeChannel.getChannel() != null) {
                        if (0L != qrCodeChannel.getChannel()) {
                            qrCodeChannelBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"channel", (Object)qrCodeChannel.getChannel()));
                        } else {
                            BoolQueryBuilder nullBuilder = QueryBuilders.boolQuery();
                            nullBuilder.must((QueryBuilder)QueryBuilders.existsQuery((String)"channel"));
                            qrCodeChannelBuilder.should((QueryBuilder)nullBuilder);
                        }
                    }
                });
                builder.must((QueryBuilder)qrCodeChannelBuilder);
            }
        }
        if (infoSearchVo.getOpenCardTimeFrom() != null) {
            sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            BoolQueryBuilder openCardTimeBuilder = QueryBuilders.boolQuery();
            openCardTimeBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"openCardTime").includeLower(true).includeUpper(true).timeZone("Asia/Shanghai").to((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)sd.format(infoSearchVo.getOpenCardTimeFrom()))));
            log.info("openCardTime search:{}", (Object)infoSearchVo.getOpenCardTimeFrom());
            builder.filter((QueryBuilder)openCardTimeBuilder);
            builder.must((QueryBuilder)QueryBuilders.existsQuery((String)"openCardTime"));
        }
        if (infoSearchVo.getBirthdayMdRange() != null) {
            BoolQueryBuilder birthdayMdRangeBuilder = QueryBuilders.boolQuery();
            if (infoSearchVo.getBirthdayMdRange().getType() == 1) {
                infoSearchVo.getBirthdayMdRange().getRange().stream().forEach(birthdayMd -> birthdayMdRangeBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"birthdayMd.keyword").includeLower(true).includeUpper(true).gte((Object)MembersAdvancedSearchServiceImpl.zeroFill((String)birthdayMd.getMin())).lte((Object)MembersAdvancedSearchServiceImpl.zeroFill((String)birthdayMd.getMax()))));
            } else if (infoSearchVo.getBirthdayMdRange().getType() == 2) {
                yyyyMmDdFormat = new SimpleDateFormat("yyyy-MM-dd");
                infoSearchVo.getBirthdayMdRange().getRange().stream().forEach(range -> birthdayMdRangeBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"birthday").includeLower(true).includeUpper(true).timeZone("Asia/Shanghai").from((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)(yyyyMmDdFormat.format(DateUtil.addDay((Date)new Date(), (int)Integer.parseInt(range.getMin()))) + " 00:00:00"))).to((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)(yyyyMmDdFormat.format(DateUtil.addDay((Date)new Date(), (int)Integer.parseInt(range.getMax()))) + " 23:59:59")))));
            }
            builder.must((QueryBuilder)birthdayMdRangeBuilder);
        }
        if (infoSearchVo.getOpenCardTimeRange() != null) {
            BoolQueryBuilder openCardRangeBuilder = QueryBuilders.boolQuery();
            if (infoSearchVo.getOpenCardTimeRange().getType() == 1) {
                infoSearchVo.getOpenCardTimeRange().getData().stream().forEach(openCard -> openCardRangeBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"openCardTime").includeLower(true).includeUpper(true).timeZone("Asia/Shanghai").from((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)((String)openCard.getRang().get(0)))).to((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)((String)openCard.getRang().get(1))))));
            } else if (infoSearchVo.getOpenCardTimeRange().getType() == 2) {
                yyyyMmDdFormat = new SimpleDateFormat("yyyy-MM-dd");
                infoSearchVo.getOpenCardTimeRange().getData().stream().forEach(openCard -> openCardRangeBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"openCardTime").includeLower(true).includeUpper(true).timeZone("Asia/Shanghai").from((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)(yyyyMmDdFormat.format(DateUtil.addDay((Date)new Date(), (int)Integer.parseInt((String)openCard.getRang().get(0)))) + " 00:00:00"))).to((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)(yyyyMmDdFormat.format(DateUtil.addDay((Date)new Date(), (int)Integer.parseInt((String)openCard.getRang().get(1)))) + " 23:59:59")))));
            }
            builder.filter((QueryBuilder)openCardRangeBuilder);
        }
        if (infoSearchVo.getBindCardTimeRange() != null) {
            builder.must((QueryBuilder)QueryBuilders.matchQuery((String)"cardStatus", (Object)CardStatusEnum.ALREADY_BIND_CARD.getCode()));
            BoolQueryBuilder bindCardRangeBuilder = QueryBuilders.boolQuery();
            if (infoSearchVo.getBindCardTimeRange().getType() == 1) {
                infoSearchVo.getBindCardTimeRange().getData().stream().forEach(bindCard -> bindCardRangeBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"bindCardTime").includeLower(true).includeUpper(true).timeZone("Asia/Shanghai").from((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)((String)bindCard.getRang().get(0)))).to((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)((String)bindCard.getRang().get(1))))));
            } else if (infoSearchVo.getBindCardTimeRange().getType() == 2) {
                yyyyMmDdFormat = new SimpleDateFormat("yyyy-MM-dd");
                infoSearchVo.getBindCardTimeRange().getData().stream().forEach(bindCard -> bindCardRangeBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"bindCardTime").includeLower(true).includeUpper(true).timeZone("Asia/Shanghai").from((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)(yyyyMmDdFormat.format(DateUtil.addDay((Date)new Date(), (int)Integer.parseInt((String)bindCard.getRang().get(0)))) + " 00:00:00"))).to((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)(yyyyMmDdFormat.format(DateUtil.addDay((Date)new Date(), (int)Integer.parseInt((String)bindCard.getRang().get(1)))) + " 23:59:59")))));
            }
            builder.filter((QueryBuilder)bindCardRangeBuilder);
        }
        if (infoSearchVo.getFirstBuyTimeRange() != null) {
            BoolQueryBuilder firstBuyRangeBuilder = QueryBuilders.boolQuery();
            if (infoSearchVo.getFirstBuyTimeRange().getType() == 1) {
                infoSearchVo.getFirstBuyTimeRange().getData().stream().forEach(firstBuy -> firstBuyRangeBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"firstBuyTime").includeLower(true).includeUpper(true).timeZone("Asia/Shanghai").from((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)((String)firstBuy.getRang().get(0)))).to((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)((String)firstBuy.getRang().get(1))))));
            } else if (infoSearchVo.getFirstBuyTimeRange().getType() == 2) {
                yyyyMmDdFormat = new SimpleDateFormat("yyyy-MM-dd");
                infoSearchVo.getFirstBuyTimeRange().getData().stream().forEach(firstBuy -> firstBuyRangeBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"firstBuyTime").includeLower(true).includeUpper(true).timeZone("Asia/Shanghai").from((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)(yyyyMmDdFormat.format(DateUtil.addDay((Date)new Date(), (int)Integer.parseInt((String)firstBuy.getRang().get(0)))) + " 00:00:00"))).to((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)(yyyyMmDdFormat.format(DateUtil.addDay((Date)new Date(), (int)Integer.parseInt((String)firstBuy.getRang().get(1)))) + " 23:59:59")))));
            }
            builder.filter((QueryBuilder)firstBuyRangeBuilder);
        }
        if (infoSearchVo.getLastBuyTimeRange() != null) {
            BoolQueryBuilder lastBuyRangeBuilder = QueryBuilders.boolQuery();
            if (infoSearchVo.getLastBuyTimeRange().getType() == 1) {
                infoSearchVo.getLastBuyTimeRange().getData().stream().forEach(lastBuy -> lastBuyRangeBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"lastBuyTime").includeLower(true).includeUpper(true).timeZone("Asia/Shanghai").from((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)((String)lastBuy.getRang().get(0)))).to((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)((String)lastBuy.getRang().get(1))))));
            } else if (infoSearchVo.getLastBuyTimeRange().getType() == 2) {
                yyyyMmDdFormat = new SimpleDateFormat("yyyy-MM-dd");
                infoSearchVo.getLastBuyTimeRange().getData().stream().forEach(lastBuy -> lastBuyRangeBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"lastBuyTime").includeLower(true).includeUpper(true).timeZone("Asia/Shanghai").from((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)(yyyyMmDdFormat.format(DateUtil.addDay((Date)new Date(), (int)Integer.parseInt((String)lastBuy.getRang().get(0)))) + " 00:00:00"))).to((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)(yyyyMmDdFormat.format(DateUtil.addDay((Date)new Date(), (int)Integer.parseInt((String)lastBuy.getRang().get(1)))) + " 23:59:59")))));
            }
            builder.filter((QueryBuilder)lastBuyRangeBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getProductCodes())) {
            BoolQueryBuilder productcodesBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getProductCodes().stream().forEach(productCodes -> {
                if (!Collections.isEmpty((Collection)productCodes)) {
                    BoolQueryBuilder productcodeBuilder = QueryBuilders.boolQuery();
                    productCodes.stream().forEach(productCode -> {
                        ResponseData skuRes = this.sysDimSkuServiceRpc.getSysDimSkuListByPrd(null, null, null, null, productCode, infoSearchVo.getSysCompanyId(), infoSearchVo.getBrandId());
                        List skuList = (List)skuRes.getData();
                        BoolQueryBuilder skuBuilder = QueryBuilders.boolQuery();
                        if (skuList != null && skuList.size() > 0) {
                            while (skuList != null && skuList.size() > 0) {
                                if (skuList.size() > 1000) {
                                    skuBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"skus", (Collection)skuList.subList(0, 1000).stream().map(x -> x.getSkuId()).collect(Collectors.toList())));
                                    skuList = skuList.subList(1000, skuList.size());
                                    continue;
                                }
                                skuBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"skus", (Collection)skuList.subList(0, skuList.size()).stream().map(x -> x.getSkuId()).collect(Collectors.toList())));
                                skuList = null;
                            }
                        } else {
                            skuBuilder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"memberCode"));
                        }
                        productcodeBuilder.must((QueryBuilder)skuBuilder);
                    });
                    productcodesBuilder.should((QueryBuilder)productcodeBuilder);
                }
            });
            builder.must((QueryBuilder)productcodesBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getCategories())) {
            BoolQueryBuilder categoriesBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getCategories().stream().forEach(categories -> {
                if (!Collections.isEmpty((Collection)categories)) {
                    BoolQueryBuilder categoryBuilder = QueryBuilders.boolQuery();
                    categories.stream().forEach(category -> {
                        switch (category.getLevel()) {
                            case 1: {
                                categoryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuCate1s", (String)("*" + category.getName() + "*")));
                                break;
                            }
                            case 2: {
                                categoryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuCate2s", (String)("*" + category.getName() + "*")));
                                break;
                            }
                            case 3: {
                                categoryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuCate3s", (String)("*" + category.getName() + "*")));
                                break;
                            }
                        }
                        categoriesBuilder.should((QueryBuilder)categoryBuilder);
                    });
                }
            });
            builder.must((QueryBuilder)categoriesBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getSpecs())) {
            BoolQueryBuilder specsBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getSpecs().stream().forEach(specs -> {
                if (!Collections.isEmpty((Collection)specs)) {
                    BoolQueryBuilder specBuilder = QueryBuilders.boolQuery();
                    specs.stream().forEach(spec -> specBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuSpces.keyword", (String)("*" + spec.getName() + "*"))));
                    specsBuilder.should((QueryBuilder)specBuilder);
                }
            });
            builder.must((QueryBuilder)specsBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getProperties())) {
            BoolQueryBuilder propertiesBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getProperties().stream().forEach(properties -> {
                if (!Collections.isEmpty((Collection)properties)) {
                    BoolQueryBuilder propertyBuilder = QueryBuilders.boolQuery();
                    properties.stream().forEach(property -> propertyBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuPropertyValues.keyword", (String)("*" + property.getName() + "*"))));
                    propertiesBuilder.should((QueryBuilder)propertyBuilder);
                }
            });
            builder.must((QueryBuilder)propertiesBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getOpenCardTimeSection())) {
            openCardBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getOpenCardTimeSection().stream().forEach(openCardTime -> {
                RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"openCardTime").includeLower(true).includeUpper(false).timeZone("Asia/Shanghai");
                if (openCardTime.getFrom() != null) {
                    rangeQueryBuilder.from((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)DateUtil.format((Date)openCardTime.getFrom(), (String)"yyyy-MM-dd HH:mm:ss")));
                }
                if (openCardTime.getTo() != null) {
                    rangeQueryBuilder.to((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)DateUtil.format((Date)openCardTime.getTo(), (String)"yyyy-MM-dd HH:mm:ss")));
                }
                openCardBuilder.should((QueryBuilder)rangeQueryBuilder);
            });
            builder.filter((QueryBuilder)openCardBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getUpgradeTimeSection())) {
            BoolQueryBuilder upgradeTimeBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getUpgradeTimeSection().stream().forEach(upgradeTime -> {
                RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"upgradeDate").includeLower(true).includeUpper(true).timeZone("Asia/Shanghai");
                if (upgradeTime.getFrom() != null) {
                    rangeQueryBuilder.from((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)DateUtil.format((Date)upgradeTime.getFrom(), (String)"yyyy-MM-dd HH:mm:ss")));
                }
                if (upgradeTime.getTo() != null) {
                    rangeQueryBuilder.to((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)DateUtil.format((Date)upgradeTime.getTo(), (String)"yyyy-MM-dd HH:mm:ss")));
                }
                upgradeTimeBuilder.should((QueryBuilder)rangeQueryBuilder);
            });
            ExistsQueryBuilder upgradeTimeBuilder2 = QueryBuilders.existsQuery((String)"upgradeDate");
            boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.mustNot((QueryBuilder)upgradeTimeBuilder2);
            upgradeTimeBuilder.should((QueryBuilder)boolQueryBuilder);
            builder.filter((QueryBuilder)upgradeTimeBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getLevelUpTimeSection())) {
            BoolQueryBuilder levelUpTimeBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getLevelUpTimeSection().stream().forEach(levelUpTime -> {
                RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"levelUpTime").includeLower(true).includeUpper(true).timeZone("Asia/Shanghai");
                if (levelUpTime.getFrom() != null) {
                    rangeQueryBuilder.from((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)DateUtil.format((Date)levelUpTime.getFrom(), (String)"yyyy-MM-dd HH:mm:ss")));
                }
                if (levelUpTime.getTo() != null) {
                    rangeQueryBuilder.to((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)DateUtil.format((Date)levelUpTime.getTo(), (String)"yyyy-MM-dd HH:mm:ss")));
                }
                levelUpTimeBuilder.should((QueryBuilder)rangeQueryBuilder);
            });
            ExistsQueryBuilder levelUpTimeBuilder2 = QueryBuilders.existsQuery((String)"levelUpTime");
            boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.mustNot((QueryBuilder)levelUpTimeBuilder2);
            levelUpTimeBuilder.should((QueryBuilder)boolQueryBuilder);
            builder.filter((QueryBuilder)levelUpTimeBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getDownGradeTimeSection())) {
            BoolQueryBuilder downGradeBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getOpenCardTimeSection().stream().forEach(downGradeTime -> {
                RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"downgradeDate").includeLower(true).includeUpper(true).timeZone("Asia/Shanghai");
                if (downGradeTime.getFrom() != null) {
                    rangeQueryBuilder.from((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)DateUtil.format((Date)downGradeTime.getFrom(), (String)"yyyy-MM-dd HH:mm:ss")));
                }
                if (downGradeTime.getTo() != null) {
                    rangeQueryBuilder.to((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)DateUtil.format((Date)downGradeTime.getTo(), (String)"yyyy-MM-dd HH:mm:ss")));
                }
                downGradeBuilder.should((QueryBuilder)rangeQueryBuilder);
            });
            downGradeBuilder2 = QueryBuilders.existsQuery((String)"downgradeDate");
            boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.mustNot((QueryBuilder)downGradeBuilder2);
            downGradeBuilder.should((QueryBuilder)boolQueryBuilder);
            builder.filter((QueryBuilder)downGradeBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getLevelDownTimeSection())) {
            BoolQueryBuilder levelDownBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getLevelDownTimeSection().stream().forEach(levelDownTime -> {
                RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"levelDownTime").includeLower(true).includeUpper(true).timeZone("Asia/Shanghai");
                if (levelDownTime.getFrom() != null) {
                    rangeQueryBuilder.from((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)DateUtil.format((Date)levelDownTime.getFrom(), (String)"yyyy-MM-dd HH:mm:ss")));
                }
                if (levelDownTime.getTo() != null) {
                    rangeQueryBuilder.to((Object)MembersAdvancedSearchServiceImpl.dateFormat((String)DateUtil.format((Date)levelDownTime.getTo(), (String)"yyyy-MM-dd HH:mm:ss")));
                }
                levelDownBuilder.should((QueryBuilder)rangeQueryBuilder);
            });
            downGradeBuilder2 = QueryBuilders.existsQuery((String)"levelDownTime");
            boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.mustNot((QueryBuilder)downGradeBuilder2);
            levelDownBuilder.should((QueryBuilder)boolQueryBuilder);
            builder.filter((QueryBuilder)levelDownBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getConsume2LevelCombinationSearches())) {
            BoolQueryBuilder combinationBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getConsume2LevelCombinationSearches().stream().forEach(consumer -> {
                BoolQueryBuilder mustBuilder = QueryBuilders.boolQuery();
                mustBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"levelId", (Object)consumer.getLevelId()));
                switch (consumer.getMonth()) {
                    case 3: {
                        mustBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"consumeAmount3").includeUpper(true).includeLower(true).lt((Object)consumer.getPrice()));
                        break;
                    }
                    case 6: {
                        mustBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"consumeAmount6").includeUpper(true).includeLower(true).lt((Object)consumer.getPrice()));
                        break;
                    }
                    case 9: {
                        mustBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"consumeAmount9").includeUpper(true).includeLower(true).lt((Object)consumer.getPrice()));
                        break;
                    }
                    case 12: {
                        mustBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"consumeAmount12").includeUpper(true).includeLower(true).lt((Object)consumer.getPrice()));
                        break;
                    }
                    case 0: {
                        mustBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"consumeAmountAll").includeUpper(true).includeLower(true).lt((Object)consumer.getPrice()));
                        break;
                    }
                }
                combinationBuilder.should((QueryBuilder)mustBuilder);
            });
            builder.must((QueryBuilder)combinationBuilder);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)infoSearchVo.getOnlineOrgCode())) {
            BoolQueryBuilder onlineOrgBuilder = QueryBuilders.boolQuery();
            OnlineOrgStoreInfoRequestVo requestVo = new OnlineOrgStoreInfoRequestVo();
            requestVo.setSysCompanyId(infoSearchVo.getSysCompanyId());
            requestVo.setBrandId(infoSearchVo.getBrandId());
            requestVo.setOnlineOrgCode(infoSearchVo.getOnlineOrgCode());
            requestVo.setPageSize(Integer.valueOf(1000));
            int pageNum = 1;
            while (true) {
                requestVo.setPageNum(Integer.valueOf(pageNum));
                ResponseData pageInfoResponseData = this.sysOnlineOrgServcieRpc.queryOnlineOrgStoreList(requestVo);
                if (pageInfoResponseData == null || pageInfoResponseData.getCode() != SysResponseEnum.SUCCESS.getCode() || pageInfoResponseData.getData() == null) break;
                PageInfo pageInfo = (PageInfo)pageInfoResponseData.getData();
                List storeList = pageInfo.getList().stream().filter(store -> store.getSysStoreId() != null).map(store -> store.getSysStoreId()).collect(Collectors.toList());
                if (!Collections.isEmpty(storeList)) {
                    onlineOrgBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"serviceStoreId", storeList));
                }
                if (pageNum >= pageInfo.getPages()) break;
                ++pageNum;
            }
            if (onlineOrgBuilder.hasClauses()) {
                builder.filter((QueryBuilder)onlineOrgBuilder);
            }
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getGrowthNum())) {
            BoolQueryBuilder growthBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getGrowthNum().stream().forEach(growth -> growthBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"growthNum").includeLower(true).includeUpper(true).timeZone("Asia/Shanghai").gte((Object)growth.getMin()).lte((Object)growth.getMax())));
            builder.filter((QueryBuilder)growthBuilder);
        }
        if (infoSearchVo.getIntegralSwitch() != null) {
            BoolQueryBuilder integralSwitchBuilder = QueryBuilders.boolQuery();
            integralSwitchBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"integralSwitch", (Object)infoSearchVo.getIntegralSwitch()));
            if (infoSearchVo.getIntegralSwitch().equals(1)) {
                nullBuilder2 = QueryBuilders.boolQuery();
                nullBuilder2.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"integralSwitch"));
                integralSwitchBuilder.should((QueryBuilder)nullBuilder2);
            }
            builder.must((QueryBuilder)integralSwitchBuilder);
        }
        if (infoSearchVo.getGrowthSwitch() != null) {
            BoolQueryBuilder growthSwitchBuilder = QueryBuilders.boolQuery();
            growthSwitchBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"growthSwitch", (Object)infoSearchVo.getGrowthSwitch()));
            if (infoSearchVo.getGrowthSwitch().equals(1)) {
                nullBuilder2 = QueryBuilders.boolQuery();
                nullBuilder2.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"growthSwitch"));
                growthSwitchBuilder.should((QueryBuilder)nullBuilder2);
            }
            builder.must((QueryBuilder)growthSwitchBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getMbrMemberIdRanges())) {
            BoolQueryBuilder rangeBuilder = QueryBuilders.boolQuery();
            infoSearchVo.getMbrMemberIdRanges().stream().forEach(range -> {
                RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"mbrMemberId").includeLower(true).includeUpper(true);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)range.getMax())) {
                    rangeQueryBuilder.lte((Object)range.getMax());
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)range.getMin())) {
                    rangeQueryBuilder.gt((Object)range.getMin());
                }
                rangeBuilder.should((QueryBuilder)rangeQueryBuilder);
            });
            builder.filter((QueryBuilder)rangeBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getPositiveMemberCodes())) {
            membersBuilder = QueryBuilders.boolQuery();
            memberCodeList = infoSearchVo.getPositiveMemberCodes();
            while (memberCodeList != null && !Collections.isEmpty((Collection)memberCodeList)) {
                if (memberCodeList.size() > 1000) {
                    membersBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"memberCode", memberCodeList.subList(0, 1000)));
                    memberCodeList = memberCodeList.subList(1000, memberCodeList.size());
                    continue;
                }
                membersBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"memberCode", memberCodeList.subList(0, memberCodeList.size())));
                memberCodeList = null;
            }
            builder.must((QueryBuilder)membersBuilder);
        }
        if (!Collections.isEmpty((Collection)infoSearchVo.getNegativeMemberCodes())) {
            membersBuilder = QueryBuilders.boolQuery();
            memberCodeList = infoSearchVo.getNegativeMemberCodes();
            while (memberCodeList != null && !Collections.isEmpty((Collection)memberCodeList)) {
                if (memberCodeList.size() > 1000) {
                    membersBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"memberCode", memberCodeList.subList(0, 1000)));
                    memberCodeList = memberCodeList.subList(1000, memberCodeList.size());
                    continue;
                }
                membersBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"memberCode", memberCodeList.subList(0, memberCodeList.size())));
                memberCodeList = null;
            }
            builder.mustNot((QueryBuilder)membersBuilder);
        }
        return builder;
    }

    protected List<MemberInfoVo> convertVoForMemberfile(Long sysCompanyId, Long brandId, List<MembersInfoSearchPojo> pojoList) {
        ArrayList<MemberInfoVo> infoVoList = new ArrayList<MemberInfoVo>();
        if (!Collections.isEmpty(pojoList)) {
            Map level = this.memberLevelService.queryLevelMap(brandId);
            List serviceStoreIds = pojoList.stream().map(pojo -> pojo.getServiceStoreId()).filter(x -> x != null).collect(Collectors.toList());
            List openStoreIds = pojoList.stream().map(pojo -> pojo.getOpenCardStoreId()).filter(x -> x != null).collect(Collectors.toList());
            serviceStoreIds.addAll(openStoreIds);
            Map storeMap = this.getStoreList(sysCompanyId, serviceStoreIds);
            Map staffMap = this.getGuideList(sysCompanyId, pojoList.stream().map(pojo -> pojo.getServiceGuideId()).filter(x -> x != null).collect(Collectors.toList()));
            Map storeCityNameMap = this.getStoreCityNameList(sysCompanyId, pojoList.stream().map(pojo -> pojo.getServiceStoreId()).filter(x -> x != null).collect(Collectors.toList()));
            Map storeAreaNameMap = this.getStoreAreaNameList(sysCompanyId, pojoList.stream().map(pojo -> pojo.getServiceStoreId()).filter(x -> x != null).collect(Collectors.toList()));
            Map storeGroupMap = this.getStoreGroupList(sysCompanyId, pojoList.stream().map(pojo -> pojo.getServiceStoreId()).filter(x -> x != null).collect(Collectors.toList()));
            List memberCodeList = pojoList.stream().map(MembersInfoSearchPojo::getMemberCode).collect(Collectors.toList());
            List memberInfoList = this.memberInfoMapper.findMemberInfoByMemberCodeList(memberCodeList, pojoList.get(0).getSysCompanyId(), pojoList.get(0).getBrandId());
            for (MembersInfoSearchPojo searchPojo : pojoList) {
                MemberInfoModel memberInfo = memberInfoList.stream().filter(memberInfoModel -> memberInfoModel.getMemberCode().equals(searchPojo.getMemberCode())).findAny().orElse(null);
                if (memberInfo == null) continue;
                MemberInfoVo infoVo = new MemberInfoVo();
                BeanUtils.copyProperties((Object)searchPojo, (Object)infoVo);
                log.info("\u83b7\u53d6\u5230\u7684\u95e8\u5e97\uff1a{}", (Object)JSON.toJSONString((Object)storeMap));
                log.info("\u5f53\u524d\u670d\u52a1\u95e8\u5e97id:{}", (Object)memberInfo.getServiceStoreId());
                if (storeMap != null && storeMap.get(memberInfo.getServiceStoreId()) != null) {
                    infoVo.setMemberStoreName(((SysStorePo)storeMap.get(memberInfo.getServiceStoreId())).getStoreName());
                    infoVo.setMemberStoreCode(((SysStorePo)storeMap.get(memberInfo.getServiceStoreId())).getSysStoreOnlineCode());
                }
                if (storeMap != null && storeMap.get(memberInfo.getOpenCardStoreId()) != null) {
                    infoVo.setOpenStoreName(((SysStorePo)storeMap.get(memberInfo.getOpenCardStoreId())).getStoreName());
                    infoVo.setOpenStoreCode(((SysStorePo)storeMap.get(memberInfo.getOpenCardStoreId())).getSysStoreOnlineCode());
                }
                infoVo.setStoreCityName(storeCityNameMap != null ? (String)storeCityNameMap.get(memberInfo.getServiceStoreId()) : null);
                infoVo.setStoreAreaName(storeAreaNameMap != null ? (String)storeAreaNameMap.get(memberInfo.getServiceStoreId()) : null);
                infoVo.setMemberGuideName(staffMap != null ? (String)staffMap.get(memberInfo.getServiceGuideId()) : null);
                infoVo.setMemberStoreGroupCode(storeGroupMap != null ? (storeGroupMap.get(memberInfo.getServiceStoreId()) != null ? ((SysStoreGroupPo)storeGroupMap.get(memberInfo.getServiceStoreId())).getSysStoreGroupCode() : null) : null);
                infoVo.setMemberStoreGroupName(storeGroupMap != null ? (storeGroupMap.get(memberInfo.getServiceStoreId()) != null ? ((SysStoreGroupPo)storeGroupMap.get(memberInfo.getServiceStoreId())).getStoreGroupName() : null) : null);
                infoVo.setCountIntegral(Integer.valueOf(memberInfo.getCountIntegral() == null ? 0 : memberInfo.getCountIntegral()));
                infoVo.setLevelName((String)level.get(searchPojo.getLevelId()));
                infoVo.setLabelIds(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)memberInfo.getLabelIds()) ? memberInfo.getLabelIds().replaceAll("-", ",") : null);
                infoVo.setLabelNames(memberInfo.getLabelNames());
                infoVo.setCardUseStatus(memberInfo.getCardUseStatus());
                this.getExtend(searchPojo, infoVo);
                infoVo.setDistributionState(Integer.valueOf(searchPojo.getDistributionState() != null && searchPojo.getDistributionState() != false ? 1 : 0));
                infoVoList.add(infoVo);
            }
        }
        log.info("\u5b8c\u6210ES\u8f6c\u6362\u9700\u8981\u7684\u5bf9\u8c61 end time:{}", (Object)DateUtil.format((Date)new Date(), (String)DateUtil.ymdhmsS));
        return infoVoList;
    }

    protected List<MemberInfoVo> convertVo(Long sysCompanyId, Long brandId, List<MembersInfoSearchPojo> pojoList) {
        ArrayList<MemberInfoVo> infoVoList = new ArrayList<MemberInfoVo>();
        if (!Collections.isEmpty(pojoList)) {
            ResponseData responseData = this.getListResponseData(sysCompanyId);
            Map level = this.memberLevelService.queryLevelMap(brandId);
            Map store = new HashMap();
            Map guide = new HashMap();
            Map cityName = new HashMap();
            Map areaName = new HashMap();
            Map memberStoreCode = new HashMap();
            Map memberGuideCode = new HashMap();
            if (null != responseData && responseData.getCode() == 0) {
                store = (Map)((List)responseData.getData()).get(0);
                guide = (Map)((List)responseData.getData()).get(1);
                cityName = (Map)((List)responseData.getData()).get(2);
                areaName = (Map)((List)responseData.getData()).get(3);
                memberStoreCode = (Map)((List)responseData.getData()).get(4);
                memberGuideCode = (Map)((List)responseData.getData()).get(5);
            }
            ArrayList storeList = Lists.newArrayList();
            pojoList.stream().forEach(pl -> {
                if (pl.getServiceStoreId() != null) {
                    storeList.add(pl.getServiceStoreId());
                }
            });
            Map storeGroupList = this.getStoreGroupList(sysCompanyId, (List)storeList);
            for (MembersInfoSearchPojo searchPojo : pojoList) {
                MemberInfoVo infoVo = new MemberInfoVo();
                BeanUtils.copyProperties((Object)searchPojo, (Object)infoVo);
                infoVo.setMemberStoreCode((String)memberStoreCode.get(searchPojo.getServiceStoreId() == null ? null : searchPojo.getServiceStoreId().toString()));
                infoVo.setMemberStoreName((String)store.get(searchPojo.getServiceStoreId() == null ? null : searchPojo.getServiceStoreId().toString()));
                infoVo.setMemberGuideCode((String)memberGuideCode.get(searchPojo.getServiceGuideId() == null ? null : searchPojo.getServiceGuideId().toString()));
                infoVo.setMemberGuideName((String)guide.get(searchPojo.getServiceGuideId() == null ? null : searchPojo.getServiceGuideId().toString()));
                infoVo.setMemberStoreGroupCode(storeGroupList != null ? (storeGroupList.get(searchPojo.getServiceStoreId()) != null ? ((SysStoreGroupPo)storeGroupList.get(searchPojo.getServiceStoreId())).getSysStoreGroupCode() : null) : null);
                infoVo.setMemberStoreGroupName(storeGroupList != null ? (storeGroupList.get(searchPojo.getServiceStoreId()) != null ? ((SysStoreGroupPo)storeGroupList.get(searchPojo.getServiceStoreId())).getStoreGroupName() : null) : null);
                infoVo.setStoreCityName((String)cityName.get(searchPojo.getServiceStoreId() == null ? null : searchPojo.getServiceStoreId().toString()));
                infoVo.setStoreAreaName((String)areaName.get(searchPojo.getServiceStoreId() == null ? null : searchPojo.getServiceStoreId().toString()));
                infoVo.setLevelName((String)level.get(searchPojo.getLevelId()));
                infoVo.setOpenStoreCode((String)memberStoreCode.get(searchPojo.getOpenCardStoreId() == null ? null : searchPojo.getOpenCardStoreId().toString()));
                infoVo.setOpenStoreName((String)store.get(searchPojo.getOpenCardStoreId() == null ? null : searchPojo.getOpenCardStoreId().toString()));
                this.getExtend(searchPojo, infoVo);
                infoVo.setDistributionState(Integer.valueOf(searchPojo.getDistributionState() != null && searchPojo.getDistributionState() != false ? 1 : 0));
                infoVoList.add(infoVo);
            }
        }
        log.info("\u5b8c\u6210ES\u8f6c\u6362\u9700\u8981\u7684\u5bf9\u8c61 end time:{}", (Object)DateUtil.format((Date)new Date(), (String)DateUtil.ymdhmsS));
        return infoVoList;
    }

    protected void getExtend(MembersInfoSearchPojo searchPojo, MemberInfoVo infoVo) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)searchPojo.getExtendCode()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)searchPojo.getExtendValue())) {
            ArrayList<ExtendPropertyValueVO> valueVOList = new ArrayList<ExtendPropertyValueVO>();
            String[] codes = org.apache.commons.lang3.StringUtils.split((String)searchPojo.getExtendCode(), (String)",");
            String[] values = org.apache.commons.lang3.StringUtils.split((String)searchPojo.getExtendValue(), (String)"%");
            for (int j = 0; j < values.length; ++j) {
                ExtendPropertyValueVO extendPropertyValueVO = new ExtendPropertyValueVO();
                extendPropertyValueVO.setPropertyCode(codes[j]);
                extendPropertyValueVO.setPropertyValue("$".equals(values[j]) ? null : values[j]);
                valueVOList.add(extendPropertyValueVO);
            }
            infoVo.setExtendPropertyList(valueVOList);
        }
    }

    private ResponseData getListResponseData(Long sysCompanyId) {
        Date startDate = new Date();
        log.info("invoke center stage convert data current start  time:{}", (Object)DateUtil.format((Date)startDate, (String)DateUtil.ymdhmsS));
        ResponseData responseData = this.storeServiceRpc.getStoreStaffNameList(sysCompanyId);
        Date endDate = new Date();
        log.info("invoke center stage convert data current end  time:{}", (Object)DateUtil.format((Date)endDate, (String)DateUtil.ymdhmsS));
        log.info("invoke center stage search time:{}", (Object)((endDate.getTime() - startDate.getTime()) / 1000L + "s"));
        return responseData;
    }

    private Map<Long, SysStorePo> getStoreList(Long sysCompanyId, List<Long> sysStoreIdList) {
        if (Collections.isEmpty(sysStoreIdList)) {
            return null;
        }
        Date startDate = new Date();
        log.info("invoke center stage convert data current start  time:{}", (Object)DateUtil.format((Date)startDate, (String)DateUtil.ymdhmsS));
        ResponseData sysStorePoList = this.storeServiceRpc.getIdStoreLists(sysStoreIdList);
        if (sysStorePoList == null || sysStorePoList.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            log.error("storeServiceRpc.getIdStoreLists\u5931\u8d25");
            return null;
        }
        Date endDate = new Date();
        log.info("invoke center stage convert data current end  time:{}", (Object)DateUtil.format((Date)endDate, (String)DateUtil.ymdhmsS));
        log.info("invoke center stage search time:{}", (Object)((endDate.getTime() - startDate.getTime()) / 1000L + "s"));
        if (sysStorePoList.getData() == null) {
            return null;
        }
        return ((List)sysStorePoList.getData()).stream().collect(Collectors.toMap(SysStorePo::getSysStoreId, Function.identity()));
    }

    private Map<Long, String> getGuideList(Long sysCompanyId, List<Long> sysStaffIdList) {
        if (Collections.isEmpty(sysStaffIdList)) {
            return null;
        }
        Date startDate = new Date();
        log.info("invoke center stage convert data current start  time:{}", (Object)DateUtil.format((Date)startDate, (String)DateUtil.ymdhmsS));
        ResponseData staffIdsResponseData = this.staffServiceRpc.getByStaffIds(sysStaffIdList, sysCompanyId);
        if (staffIdsResponseData == null || staffIdsResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            log.error("staffServiceRpc.getByStaffIds\u5931\u8d25");
            return null;
        }
        Date endDate = new Date();
        log.info("invoke center stage convert data current end  time:{}", (Object)DateUtil.format((Date)endDate, (String)DateUtil.ymdhmsS));
        log.info("invoke center stage search time:{}", (Object)((endDate.getTime() - startDate.getTime()) / 1000L + "s"));
        if (staffIdsResponseData.getData() == null) {
            return null;
        }
        return ((List)staffIdsResponseData.getData()).stream().collect(Collectors.toMap(SysStaffPo::getSysStaffId, SysStaffPo::getStaffName));
    }

    private Map<Long, String> getStoreCityNameList(Long sysCompanyId, List<Long> sysStoreIdList) {
        if (Collections.isEmpty(sysStoreIdList)) {
            return null;
        }
        ResponseData sysStorePoList = this.storeServiceRpc.getIdStoreLists(sysStoreIdList);
        if (sysStorePoList == null || sysStorePoList.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            log.error("storeServiceRpc.getIdStoreLists\u5931\u8d25");
            return null;
        }
        if (sysStorePoList.getData() == null) {
            return null;
        }
        HashMap<Long, String> mapSysStoreCity = new HashMap<Long, String>();
        List newSysCityList = (List)sysStorePoList.getData();
        for (SysStorePo sysStorePo : newSysCityList) {
            mapSysStoreCity.put(sysStorePo.getSysStoreId(), sysStorePo.getCityName() != null ? sysStorePo.getCityName() : "");
        }
        return mapSysStoreCity;
    }

    private Map<Long, String> getStoreAreaNameList(Long sysCompanyId, List<Long> sysStoreIdList) {
        if (Collections.isEmpty(sysStoreIdList)) {
            return null;
        }
        ResponseData sysStorePoList = this.storeServiceRpc.getIdStoreLists(sysStoreIdList);
        if (sysStorePoList == null || sysStorePoList.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            log.error("storeServiceRpc.getIdStoreLists\u5931\u8d25");
            return null;
        }
        if (sysStorePoList.getData() == null) {
            return null;
        }
        HashMap<Long, String> mapSysStoreArea = new HashMap<Long, String>();
        List newSysAreaList = (List)sysStorePoList.getData();
        for (SysStorePo sysStorePo : newSysAreaList) {
            mapSysStoreArea.put(sysStorePo.getSysStoreId(), sysStorePo.getAreaName() != null ? sysStorePo.getAreaName() : "");
        }
        return mapSysStoreArea;
    }

    private Map<Long, SysStoreGroupPo> getStoreGroupList(Long sysCompanyId, List<Long> sysStoreIdList) {
        if (Collections.isEmpty(sysStoreIdList)) {
            return null;
        }
        ResponseData storeGroupLists = this.storeGroupServiceRpc.getStoreGroupLists(sysCompanyId, sysStoreIdList);
        if (storeGroupLists == null || storeGroupLists.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            log.error("storeGroupServiceRpc.getStoreGroupLists\u5931\u8d25");
            return null;
        }
        if (storeGroupLists.getData() == null) {
            return null;
        }
        return (Map)storeGroupLists.getData();
    }

    public static String dateFormat(String str) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return DateUtil.format((Date)DateUtil.parse((String)str, (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS+0800");
    }

    private PageInfo<MemberInfoVo> getPageInfo(List<MemberInfoVo> infoVoList, Page page, Pageable pageable) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setList(infoVoList);
        pageInfo.setSize(pageable.getPageSize());
        pageInfo.setPageSize(pageable.getPageSize());
        pageInfo.setPageNum(pageable.getPageNumber() + 1);
        pageInfo.setTotal(page.getTotalElements());
        int pages = (int)((page.getTotalElements() + (long)pageable.getPageSize() - 1L) / (long)pageable.getPageSize());
        pageInfo.setPages(pages);
        return pageInfo;
    }

    private static String getPropertyName(String propertyName, String month) {
        if ("0".equals(month)) {
            return new StringBuffer(propertyName).append("All").toString();
        }
        for (String s : number) {
            if (!s.equals(month)) continue;
            return new StringBuffer(propertyName).append(month).toString();
        }
        return new StringBuffer(propertyName).append(month).toString();
    }

    private static boolean isNum(String str) {
        return pattern.matcher(str).matches();
    }

    private static String zeroFill(String number) {
        if (MembersAdvancedSearchServiceImpl.isNum((String)number) && number.length() == 1) {
            return new StringBuffer().append("0").append(number).toString();
        }
        return number;
    }

    protected static QueryBuilder termQuery(String key, String value) {
        return QueryBuilders.termQuery((String)key, (String)value);
    }

    protected static QueryBuilder termsQuery() {
        return QueryBuilders.termsQuery((String)"name", (String[])new String[]{"\u846b\u82a6580\u5a03", "\u846b\u82a63812\u5a03"});
    }

    protected static QueryBuilder fuzzyQuery(String key, String value) {
        return QueryBuilders.fuzzyQuery((String)"name", (String)"\u846b\u82a63582");
    }

    protected static QueryBuilder matchQuery() {
        return QueryBuilders.matchQuery((String)"name", (Object)"\u846b\u82a64032\u5a03");
    }

    protected static QueryBuilder prefixQuery() {
        return QueryBuilders.prefixQuery((String)"name", (String)"\u846b\u82a631");
    }

    protected static QueryBuilder rangeQuery() {
        return QueryBuilders.rangeQuery((String)"name").from((Object)"\u846b\u82a61000\u5a03").to((Object)"\u846b\u82a63000\u5a03").includeLower(true).includeUpper(false);
    }

    protected static QueryBuilder wildcardQuery() {
        return QueryBuilders.wildcardQuery((String)"name", (String)"\u846b\u82a6*2\u5a03");
    }

    public void testQueryBuilder2() {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"user", (String)"kimchy")).mustNot((QueryBuilder)QueryBuilders.termQuery((String)"message", (String)"nihao")).should((QueryBuilder)QueryBuilders.termQuery((String)"gender", (String)"male"));
    }

    public void formatEsQueryBulider(MembersInfoSearchVo infoSearchVo, MbrGroupModel model, BoolQueryBuilder childBuilder) {
        BoolQueryBuilder builder = new BoolQueryBuilder();
        MembersInfoSearchVo init = null;
        init = this.initMemberInfoSearch(infoSearchVo, model);
        if (init != null) {
            childBuilder.must((QueryBuilder)this.getEsWhere(init, QueryBuilders.boolQuery()));
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)model.getChildMbrGroupDefIds())) {
                List<String> idList = Arrays.asList(model.getChildMbrGroupDefIds().split("\\|"));
                for (String str : idList) {
                    BoolQueryBuilder child = QueryBuilders.boolQuery();
                    List list = this.memberGroupService.formatConditions(str);
                    for (MbrGroupModel dto : list) {
                        init = this.initMemberInfoSearch(infoSearchVo, dto);
                        if (init == null) continue;
                        child.must((QueryBuilder)this.getEsWhere(init, QueryBuilders.boolQuery()));
                    }
                    builder.should((QueryBuilder)child);
                }
            }
            childBuilder.must((QueryBuilder)builder);
        }
    }

    public MembersInfoSearchVo initMemberInfoSearch(MembersInfoSearchVo infoSearchVo, MbrGroupModel model) {
        MembersInfoSearchVo membersInfoSearchVo = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)model.getConditions()) && !"{}".equals(model.getConditions())) {
            membersInfoSearchVo = (MembersInfoSearchVo)JacksonUtil.json2Objs((String)model.getConditions(), MembersInfoSearchVo.class);
            membersInfoSearchVo.setSysCompanyId(infoSearchVo.getSysCompanyId());
            membersInfoSearchVo.setStoreList(infoSearchVo.getStoreList());
            membersInfoSearchVo.setOnlineOrgCode(infoSearchVo.getOnlineOrgCode());
            membersInfoSearchVo.setBrandId(infoSearchVo.getBrandId());
        }
        return membersInfoSearchVo;
    }

    public String formatChildMbrGroupIds(SearchExternalRequest<List<MbrGroupModel>> request) {
        if (request == null || CollectionUtils.isEmpty((Collection)request.getList())) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (List list : request.getList()) {
            List ids = list.stream().map(MbrGroupModel::getMbrGroupDefId).collect(Collectors.toList());
            result.add(StringUtils.join(ids, (String)","));
        }
        return CollectionUtils.isEmpty(result) ? null : StringUtils.join(result, (String)"|");
    }
}

