/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.unifiedreg.service.copy.inner.impl;

import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.bo.BrandConfigsBO;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.vo.SysStoreVo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.IntegralAdjustRequestVO;
import com.bizvane.connectorservice.entity.common.IntegralAdjustResponseVO;
import com.bizvane.connectorservice.entity.common.MemberInfoQueryRequestVO;
import com.bizvane.connectorservice.entity.common.MemberInfoQueryResponseVO;
import com.bizvane.connectorservice.interfaces.rpc.ConnectorServiceFeign;
import com.bizvane.members.facade.constants.MemberConstant;
import com.bizvane.members.facade.enums.BizvaneBaisonBusinessTypeEnum;
import com.bizvane.members.facade.enums.BizvaneBusinessTypeEnum;
import com.bizvane.members.facade.enums.BusinessTypeEnum;
import com.bizvane.members.facade.enums.IntegralChangeTypeEnum;
import com.bizvane.members.facade.enums.IntegralConsumeTypeEnum;
import com.bizvane.members.facade.es.vo.MembersInfoSearchVo;
import com.bizvane.members.facade.es.vo.SearchRangRequest;
import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.IntegralRecordModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.po.MbrIntegralRecordBusinessTypePOExample;
import com.bizvane.members.facade.models.po.MbrSwitchPO;
import com.bizvane.members.facade.models.po.MbrSwitchPOExample;
import com.bizvane.members.facade.models.po.MbrTaoBaoPO;
import com.bizvane.members.facade.models.po.MbrTaoBaoPOExample;
import com.bizvane.members.facade.models.query.FetchMessagePo;
import com.bizvane.members.facade.service.card.request.IntegralChangeForTmallReqVo;
import com.bizvane.members.facade.service.card.request.IntegralChangeRequestModel;
import com.bizvane.members.facade.service.card.response.IntegralChangeResponseModel;
import com.bizvane.members.facade.service.datafetch.model.IntegralRecordFetchModel;
import com.bizvane.members.facade.vo.IntegralRecordBusinessTypeVo;
import com.bizvane.members.facade.vo.MemberInfoVo;
import com.bizvane.members.facade.vo.PageVo;
import com.bizvane.members.facade.vo.SyncChangeRequestVo;
import com.bizvane.members.facade.vo.SyncIntegralVo;
import com.bizvane.messagefacade.interfaces.WechatIntegralServiceFeign;
import com.bizvane.messagefacade.models.vo.IntegralMessageVO;
import com.bizvane.thirddock.service.rpc.NotifyYouzanRpc;
import com.bizvane.unifiedreg.service.copy.IntegralRecordBusinessTypeService;
import com.bizvane.unifiedreg.service.copy.card.AbstractApiIntegralChangeService;
import com.bizvane.unifiedreg.service.copy.config.SwitchConfig;
import com.bizvane.unifiedreg.service.copy.datafetch.util.FetchUtil;
import com.bizvane.unifiedreg.service.copy.inner.AsyncToRemoteService;
import com.bizvane.unifiedreg.service.copy.inner.IntegralChangeService;
import com.bizvane.unifiedreg.service.copy.inner.MembersAdvancedSearchService;
import com.bizvane.unifiedreg.service.copy.mapper.IntegralRecordMapper;
import com.bizvane.unifiedreg.service.copy.mapper.MbrConsumeBehaviorMapper;
import com.bizvane.unifiedreg.service.copy.mapper.MbrIntegralRecordBusinessTypePOMapper;
import com.bizvane.unifiedreg.service.copy.mapper.MbrSwitchPOMapper;
import com.bizvane.unifiedreg.service.copy.mapper.MbrTaoBaoPOMapper;
import com.bizvane.unifiedreg.service.copy.mapper.MemberInfoMapper;
import com.bizvane.unifiedreg.service.copy.outer.WeChatInterfaceTransform;
import com.bizvane.unifiedreg.service.copy.tools.StopWatchTime;
import com.bizvane.unifiedreg.service.copy.tools.message.StandardMessageUtil;
import com.bizvane.unifiedreg.tools.ResponseUtil;
import com.bizvane.unifiedreg.tools.UUIDUtil;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedissonTemplate;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class IntegralChangeServiceImplApiIntegralChangeServiceImpl
extends AbstractApiIntegralChangeService
implements IntegralChangeService {
    private static final Logger log = LoggerFactory.getLogger(IntegralChangeServiceImplApiIntegralChangeServiceImpl.class);
    @Autowired
    private MemberInfoMapper memberInfoMapper;
    @Autowired
    private IntegralRecordMapper integralRecordMapper;
    @Autowired
    private ConnectorServiceFeign connectorServiceFeign;
    @Autowired
    private WechatIntegralServiceFeign wechatIntegralServiceFeign;
    @Autowired
    private WeChatInterfaceTransform weChatInterfaceTransform;
    @Autowired
    private FetchUtil fetchUtil;
    @Autowired
    private AsyncToRemoteService asyncToRemoteService;
    @Autowired
    private RedissonTemplate redissonTemplate;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private IntegralRecordBusinessTypeService integralRecordBusinessTypeService;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private StandardMessageUtil standardMessageUtil;
    @Autowired
    private MbrTaoBaoPOMapper mbrTaoBaoPoMapper;
    @Autowired
    private SwitchConfig switchConfig;
    @Autowired
    private MbrSwitchPOMapper mbrSwitchPoMapper;
    @Autowired
    private MbrIntegralRecordBusinessTypePOMapper mbrIntegralRecordBusinessTypePoMapper;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private MembersAdvancedSearchService membersAdvancedSearchService;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private NotifyYouzanRpc notifyYouzanRpc;
    @Autowired
    private MbrConsumeBehaviorMapper mbrConsumeBehaviorMapper;
    @Autowired
    private RocketMQTemplate rocketMQTemplate;
    @Value(value="${c361.companyId}")
    private Long c361CompanyId;
    private String prefixIntegralTypeConvertOnLineToOffline = "prefixIntegralTypeConvert";
    private String prefixSwitchTypeConvert = "prefixSwitchTypeConvert";
    private static final String BIZVANE_BUSINESS_CODE_PREFIX = "bizvane-";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntegralChangeResponseModel integralChangeOperate(@RequestBody IntegralChangeRequestModel integralChangeRequestModel) {
        log.info("enter integralChangeOperate method ! param:{}", (Object)JacksonUtil.bean2Json((Object)integralChangeRequestModel));
        IntegralChangeResponseModel integralChangeResponseModel = new IntegralChangeResponseModel();
        IntegralChangeResponseModel reslutResponseModel = new IntegralChangeResponseModel();
        try {
            this.redissonTemplate.getRLock(integralChangeRequestModel.getMemberCode(), 30L, TimeUnit.SECONDS);
            MemberInfoModel memberInfo = this.memberInfoMapper.findMemberInfoByMemberCode(integralChangeRequestModel.getMemberCode());
            integralChangeRequestModel.setPhone(memberInfo.getPhone());
            integralChangeRequestModel.setAllChannelIds(memberInfo.getAllChannelIds());
            StopWatchTime.init((Logger)log);
            if ("1".equals(integralChangeRequestModel.getChangeType())) {
                ResponseData brandInfo = this.brandServiceRpc.getBrandConfigsByBrandId(memberInfo.getSysCompanyId(), memberInfo.getBrandId());
                Boolean negativeIntegral = this.enableNegativeIntegral((SysBrandPo)brandInfo.getData());
                log.info("IntegralChangeServiceImpl#IntegralChangeResponseModel#negativeIntegral:{}", (Object)negativeIntegral);
                if (!BusinessTypeEnum.YOUZAN_API_EXCHANGE.getCode().equals(integralChangeRequestModel.getBusinessType()) || negativeIntegral.equals(false)) {
                    log.info("\u4e0d\u8d85\u6263");
                    MemberInfoQueryRequestVO memberInfoQueryRequestVO = new MemberInfoQueryRequestVO();
                    memberInfoQueryRequestVO.setOfflineCardNo(memberInfo.getOfflineCardNo());
                    memberInfoQueryRequestVO.setBrandId(integralChangeRequestModel.getBrandId());
                    Result integralInfo = this.connectorServiceFeign.queryMemberInfo(memberInfoQueryRequestVO);
                    if (integralInfo.getCode().intValue() == SysResponseEnum.SUCCESS.getCode() && integralInfo.getData() != null) {
                        MemberInfoQueryResponseVO responseVO = (MemberInfoQueryResponseVO)integralInfo.getData();
                        if (responseVO.getCountIntegral() - integralChangeRequestModel.getChangeIntegral() < 0) {
                            integralChangeResponseModel.setCode(Integer.valueOf(100));
                            integralChangeResponseModel.setMessage("\u79ef\u5206\u4f59\u989d\u4e0d\u8db3");
                            integralChangeResponseModel.setErrorStatus(IntegralConsumeTypeEnum.OFFLINE_FAILED_BEFORE.getCode());
                            integralChangeResponseModel.setErrorMessage("\u7ebf\u4e0b\u5224\u65ad\u79ef\u5206\u4f59\u989d\u4e0d\u8db3");
                            IntegralChangeResponseModel integralChangeResponseModel2 = integralChangeResponseModel;
                            return integralChangeResponseModel2;
                        }
                    } else if (memberInfo.getCountIntegral() - integralChangeRequestModel.getChangeIntegral() < 0) {
                        integralChangeResponseModel.setCode(Integer.valueOf(100));
                        integralChangeResponseModel.setMessage("\u79ef\u5206\u4f59\u989d\u4e0d\u8db3");
                        integralChangeResponseModel.setErrorStatus(IntegralConsumeTypeEnum.OFFLINE_FAILED_BEFORE.getCode());
                        integralChangeResponseModel.setErrorMessage("\u7ebf\u4e0a\u5224\u65ad\u79ef\u5206\u4f59\u989d\u4e0d\u8db3");
                        IntegralChangeResponseModel integralChangeResponseModel3 = integralChangeResponseModel;
                        return integralChangeResponseModel3;
                    }
                }
            }
            if ("2".equals(integralChangeRequestModel.getChangeType()) && CollectionUtil.isNotEmpty((Collection)this.switchConfig.getIntegralSwitch()) && this.switchConfig.getIntegralSwitch().contains(memberInfo.getSysCompanyId())) {
                MbrSwitchPO switchPo;
                MbrSwitchPOExample example = new MbrSwitchPOExample();
                example.createCriteria().andSysCompanyIdEqualTo(memberInfo.getSysCompanyId()).andSysBrandIdEqualTo(memberInfo.getBrandId()).andMemberCodeEqualTo(memberInfo.getMemberCode());
                List switchPos = this.mbrSwitchPoMapper.selectByExample(example);
                if (CollectionUtil.isNotEmpty((Collection)switchPos) && (switchPo = (MbrSwitchPO)switchPos.get(0)).getIntegralSwitch() != null && switchPo.getIntegralSwitch().equals(0)) {
                    integralChangeResponseModel.setCode(Integer.valueOf(100));
                    integralChangeResponseModel.setMessage("\u4f1a\u5458\u83b7\u53d6\u79ef\u5206\u5f00\u5173\u5df2\u5f00\u542f\uff0c\u65e0\u6cd5\u83b7\u53d6\u79ef\u5206");
                    integralChangeResponseModel.setErrorStatus(IntegralConsumeTypeEnum.DEFAULT.getCode());
                    integralChangeResponseModel.setErrorMessage("\u4f1a\u5458\u83b7\u53d6\u79ef\u5206\u5f00\u5173\u5df2\u5f00\u542f\uff0c\u65e0\u6cd5\u83b7\u53d6\u79ef\u5206");
                    IntegralChangeResponseModel integralChangeResponseModel4 = integralChangeResponseModel;
                    return integralChangeResponseModel4;
                }
            }
            IntegralChangeResponseModel integralChangeResponseModel5 = reslutResponseModel = this.integralChange(integralChangeRequestModel);
            return integralChangeResponseModel5;
        }
        finally {
            StopWatchTime.pretty();
            StopWatchTime.destroy();
            this.redissonTemplate.getRUnLook(integralChangeRequestModel.getMemberCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntegralChangeResponseModel integralChangeOperateForTmall(@RequestBody IntegralChangeForTmallReqVo vo) {
        log.info("enter integralChangeOperateForTmall method ! param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        IntegralChangeResponseModel responseModel = new IntegralChangeResponseModel();
        MemberInfoModel memberInfoModel = this.memberInfoMapper.queryMemberInfoByPhone(vo.getPhone(), vo.getBrandId());
        if (memberInfoModel != null) {
            if (!BusinessTypeEnum.INTEGER_ADJUST_INCOME.getCode().equals(vo.getBizType()) && "1".equals(vo.getType())) {
                MemberInfoQueryRequestVO memberInfoQueryRequestVO = new MemberInfoQueryRequestVO();
                memberInfoQueryRequestVO.setOfflineCardNo(memberInfoModel.getCardNo());
                memberInfoQueryRequestVO.setBrandId(vo.getBrandId());
                Result integralInfo = this.connectorServiceFeign.queryMemberInfo(memberInfoQueryRequestVO);
                if (integralInfo.getCode().intValue() == SysResponseEnum.SUCCESS.getCode() && integralInfo.getData() != null) {
                    MemberInfoQueryResponseVO responseVO = (MemberInfoQueryResponseVO)integralInfo.getData();
                    if (responseVO.getCountIntegral() - vo.getPoint() < 0) {
                        responseModel.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
                        responseModel.setMessage("deduct-fail:point-no-enough");
                        return responseModel;
                    }
                } else if (memberInfoModel.getCountIntegral() - vo.getPoint() < 0) {
                    responseModel.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
                    responseModel.setMessage("deduct-fail:point-no-enough");
                    return responseModel;
                }
            }
            IntegralChangeRequestModel requestModel = new IntegralChangeRequestModel();
            requestModel.setSysCompanyId(memberInfoModel.getSysCompanyId());
            requestModel.setBusinessType(vo.getBizType());
            requestModel.setChangeIntegral(vo.getPoint());
            requestModel.setMemberCode(memberInfoModel.getMemberCode());
            requestModel.setBrandId(vo.getBrandId());
            requestModel.setChangeBills(vo.getRecordId());
            requestModel.setBusinessType("40");
            requestModel.setChangeDetails(vo.getBizType());
            requestModel.setChangeDate(new Date());
            requestModel.setChangeType(vo.getType());
            requestModel.setPhone(memberInfoModel.getPhone());
            requestModel.setAllChannelIds(memberInfoModel.getAllChannelIds());
            MbrTaoBaoPOExample example = new MbrTaoBaoPOExample();
            example.createCriteria().andSysCompanyIdEqualTo(memberInfoModel.getSysCompanyId()).andBrandIdEqualTo(memberInfoModel.getBrandId()).andMemberCodeEqualTo(memberInfoModel.getMemberCode());
            List mbrTaoBaoPos = this.mbrTaoBaoPoMapper.selectByExample(example);
            if (CollectionUtil.isNotEmpty((Collection)mbrTaoBaoPos)) {
                requestModel.setTaoBaoNick(((MbrTaoBaoPO)mbrTaoBaoPos.get(0)).getTaobaoNick());
            }
            try {
                StopWatchTime.init((Logger)log);
                IntegralChangeResponseModel integralChangeResponseModel = this.integralChange(requestModel);
                return integralChangeResponseModel;
            }
            finally {
                StopWatchTime.pretty();
                StopWatchTime.destroy();
            }
        }
        responseModel.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
        responseModel.setMessage("no-exsit-member");
        return responseModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseData offlineSyncIntegral(@RequestBody SyncIntegralVo vo) {
        MemberInfoModel memberInfoModel;
        log.info("IntegralChangeApiServiceImpl offlineSyncIntegral vo:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        try {
            this.redissonTemplate.getRLock(vo.getErpId() + vo.getBrandCode() + vo.getSerialNumber(), 10L, TimeUnit.SECONDS);
            ResponseData brandInfo = this.brandServiceRpc.getBrand(vo.getSysCompanyId(), vo.getBrandCode());
            if (brandInfo.getCode() == SysResponseEnum.FAILED.getCode() || brandInfo.getData() == null) {
                ResponseData responseData = ResponseUtil.getFailedData(null, (String)"\u4f01\u4e1a\u7f16\u53f7\u4e0d\u5b58\u5728");
                return responseData;
            }
            Long sysBrandId = ((SysBrandPo)brandInfo.getData()).getSysBrandId();
            vo.setSysBrandId(sysBrandId);
            memberInfoModel = this.memberInfoMapper.queryIntegralByErpIdBrandId(vo.getErpId(), vo.getSysBrandId());
            if (memberInfoModel == null) {
                ResponseData responseData = ResponseUtil.getFailedData(null, (String)"\u4f1a\u5458\u4e0d\u5b58\u5728");
                return responseData;
            }
            IntegralRecordFetchModel integralRecordFetchModel = new IntegralRecordFetchModel();
            integralRecordFetchModel.setOfflineCompanyCode(memberInfoModel.getOfflineCompanyCode());
            integralRecordFetchModel.setOfflineBrandCode(memberInfoModel.getOfflineBrandCode());
            integralRecordFetchModel.setOfflineIntegralId(vo.getSerialNumber());
            IntegralRecordModel integralResponse = this.integralRecordMapper.queryCountByOfflineId(integralRecordFetchModel);
            if (integralResponse != null) {
                ResponseData responseData = ResponseUtil.getFailedData(null, (String)"\u6d41\u6c34\u5df2\u5b58\u5728");
                return responseData;
            }
            Integer countIntegral = memberInfoModel.getCountIntegral() + vo.getChangeIntegral();
            if (!this.enableNegativeIntegral((SysBrandPo)brandInfo.getData()) && countIntegral < 0) {
                ResponseData responseData = ResponseUtil.getFailedData(null, (String)"\u7ebf\u4e0a\u79ef\u5206\u4e0d\u8db3");
                return responseData;
            }
            if (vo.getChangeIntegral() > 0) {
                Integer addUpIntegral = memberInfoModel.getAddUpIntegral() + vo.getChangeIntegral();
                memberInfoModel.setAddUpIntegral(addUpIntegral);
            }
            if (vo.getChangeIntegral() < 0 && memberInfoModel.getAboutExpireIntegral() != null) {
                Integer aboutExpireIntegral = memberInfoModel.getAboutExpireIntegral() + vo.getChangeIntegral();
                if (aboutExpireIntegral < 0) {
                    aboutExpireIntegral = 0;
                }
                memberInfoModel.setAboutExpireIntegral(aboutExpireIntegral);
            }
            memberInfoModel.setConsumeIntegral(vo.getChangeIntegral());
            memberInfoModel.setModifiedDate(new Date());
            int count = this.getCount(memberInfoModel);
            log.info("\u4fee\u6539\u79ef\u5206:{}", (Object)JSON.toJSONString((Object)memberInfoModel));
            if (count == 0) {
                ResponseData responseData = ResponseUtil.getFailedData(null, (String)"\u66f4\u65b0\u4f1a\u5458\u79ef\u5206\u5931\u8d25");
                return responseData;
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getBusinessWay())) {
                IntegralRecordBusinessTypeVo integralRecordBusinessTypeVoByCode = this.integralRecordBusinessTypeService.findIntegralRecordBusinessTypeVoByCode(vo.getBusinessWay(), memberInfoModel.getSysCompanyId());
                log.info(" findIntegralRecordBusinessTypeVoByCode businessWay{}, integralRecordBusinessTypeVo{}", (Object)vo.getBusinessWay(), (Object)JSONObject.toJSONString((Object)integralRecordBusinessTypeVoByCode));
                if (integralRecordBusinessTypeVoByCode != null) {
                    vo.setBusinessWay(integralRecordBusinessTypeVoByCode.getBizvaneCode());
                    vo.setBusinessWayOffline(integralRecordBusinessTypeVoByCode.getBusinessCode());
                    vo.setBusinessDescription(integralRecordBusinessTypeVoByCode.getDescription());
                } else {
                    vo.setBusinessWayOffline(BizvaneBusinessTypeEnum.UR_OTHER.getCode());
                    vo.setBusinessDescription(BizvaneBusinessTypeEnum.UR_OTHER.getMsg());
                }
            }
            if (!Arrays.asList(MemberConstant.C_361_BRAND).contains(((SysBrandPo)brandInfo.getData()).getBrandCode())) {
                IntegralRecordModel integralRecordModel = new IntegralRecordModel();
                integralRecordModel.setBrandId(sysBrandId);
                integralRecordModel.setChangeBills(vo.getChangeBills());
                integralRecordModel.setMemberCode(memberInfoModel.getMemberCode());
                integralRecordModel.setSysCompanyId(memberInfoModel.getSysCompanyId());
                integralRecordModel.setOfflineBrandCode(memberInfoModel.getOfflineBrandCode());
                integralRecordModel.setOfflineCompanyCode(memberInfoModel.getOfflineCompanyCode());
                integralRecordModel.setRecordCode(UUIDUtil.getUuid16());
                integralRecordModel.setChangeWay(vo.getChangeIntegral() > 0 ? "2" : "1");
                integralRecordModel.setErpId(memberInfoModel.getErpId());
                integralRecordModel.setChangeDate(vo.getChangeDate() != null ? vo.getChangeDate() : new Date());
                integralRecordModel.setChangeDetails(vo.getChangeDetails());
                integralRecordModel.setCreateDate(new Date());
                integralRecordModel.setBusinessWay(vo.getBusinessWay());
                integralRecordModel.setBusinessWayOffline(vo.getBusinessWayOffline());
                integralRecordModel.setChangeIntegral(vo.getChangeIntegral());
                integralRecordModel.setSource(vo.getSource());
                integralRecordModel.setOfflineIntegralId(vo.getSerialNumber());
                integralRecordModel.setBusinessDescription(vo.getBusinessDescription());
                integralRecordModel.setOnlineStoreCode(vo.getOnlineStoreCode());
                integralRecordModel.setOfflineStoreCode(vo.getOfflineStoreCode());
                integralRecordModel.setMemberCardNo(memberInfoModel.getCardNo());
                integralRecordModel.setMemberName(memberInfoModel.getName());
                this.integralRecordMapper.insertSelective((Object)integralRecordModel);
            }
            SyncChangeRequestVo syncChangeInfo = new SyncChangeRequestVo();
            syncChangeInfo.setBrandId(sysBrandId);
            syncChangeInfo.setMemberCode(memberInfoModel.getMemberCode());
            syncChangeInfo.setSysCompanyId(memberInfoModel.getSysCompanyId());
            syncChangeInfo.setType(Integer.valueOf(1));
            this.asyncToRemoteService.asyncInfoChange(syncChangeInfo);
            IntegralChangeResponseModel model = IntegralChangeResponseModel.builder().brandId(sysBrandId).businessType(BusinessTypeEnum.OFFLINE_HAND_TYPE.getCode()).changeDate(new Date()).changeIntegral(vo.getChangeIntegral()).changeType(vo.getChangeIntegral() > 0 ? "2" : "1").memberCode(memberInfoModel.getMemberCode()).offlineBrandCode(vo.getBrandCode()).integralAdjustId(vo.getSerialNumber()).changeDetails(vo.getChangeDetails()).businessDescription(vo.getBusinessDescription()).build();
            new Thread(() -> this.notifySendMessage(model, memberInfoModel)).start();
        }
        catch (Exception e) {
            log.error("IntegralChangeApiServiceImpl offlineSyncIntegral error:{}", (Object)e.getMessage());
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            ResponseData responseData = ResponseUtil.getFailedData(null);
            return responseData;
        }
        finally {
            this.redissonTemplate.getRUnLook(vo.getErpId() + vo.getBrandCode() + vo.getSerialNumber());
        }
        return ResponseUtil.getSuccessData((Object)memberInfoModel);
    }

    private int getCount(MemberInfoModel memberInfoModel) {
        return this.memberInfoMapper.updateIntegral(memberInfoModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseData offlineSyncIntegralConsume(@RequestBody SyncIntegralVo syncIntegralVo) {
        log.info("IntegralChangeApiServiceImpl offlineSyncIntegral vo:{}", (Object)JacksonUtil.bean2Json((Object)syncIntegralVo));
        try {
            int i;
            IntegralRecordModel integralResponse;
            this.redissonTemplate.getRLock(syncIntegralVo.getErpId() + syncIntegralVo.getSysBrandId(), 30L, TimeUnit.SECONDS);
            ResponseData brandInfo = this.brandServiceRpc.getBrand(syncIntegralVo.getSysCompanyId(), syncIntegralVo.getBrandCode());
            if (brandInfo.getCode() == SysResponseEnum.FAILED.getCode() || brandInfo.getData() == null) {
                ResponseData responseData = ResponseUtil.getFailedData(null, (String)"\u4f01\u4e1a\u7f16\u53f7\u4e0d\u5b58\u5728");
                return responseData;
            }
            Long sysBrandId = ((SysBrandPo)brandInfo.getData()).getSysBrandId();
            syncIntegralVo.setSysBrandId(sysBrandId);
            MemberInfoModel memberInfoModel = this.memberInfoMapper.queryIntegralByErpIdBrandId(syncIntegralVo.getErpId(), syncIntegralVo.getSysBrandId());
            if (memberInfoModel == null) {
                ResponseData responseData = ResponseUtil.getFailedData(null, (String)"\u4f1a\u5458\u4e0d\u5b58\u5728");
                return responseData;
            }
            if (StringUtils.isNotBlank((CharSequence)syncIntegralVo.getSerialNumber())) {
                IntegralRecordFetchModel integralRecordFetchModel = new IntegralRecordFetchModel();
                integralRecordFetchModel.setOfflineCompanyCode(memberInfoModel.getOfflineCompanyCode());
                integralRecordFetchModel.setOfflineBrandCode(memberInfoModel.getOfflineBrandCode());
                integralRecordFetchModel.setOfflineIntegralId(syncIntegralVo.getSerialNumber());
                integralResponse = this.integralRecordMapper.queryCountByOfflineId(integralRecordFetchModel);
                if (integralResponse != null) {
                    ResponseData responseData = ResponseUtil.getFailedData(null, (String)"\u6d41\u6c34\u5df2\u5b58\u5728");
                    return responseData;
                }
            }
            Integer countIntegral = memberInfoModel.getCountIntegral() + syncIntegralVo.getChangeIntegral();
            if (!this.enableNegativeIntegral((SysBrandPo)brandInfo.getData()) && countIntegral < 0) {
                integralResponse = ResponseUtil.getFailedData(null, (String)"\u7ebf\u4e0a\u79ef\u5206\u4e0d\u8db3");
                return integralResponse;
            }
            if (syncIntegralVo.getChangeIntegral() > 0) {
                Integer addUpIntegral = memberInfoModel.getAddUpIntegral() + syncIntegralVo.getChangeIntegral();
                memberInfoModel.setAddUpIntegral(addUpIntegral);
            }
            memberInfoModel.setConsumeIntegral(syncIntegralVo.getChangeIntegral());
            memberInfoModel.setModifiedDate(new Date());
            int count = this.modifyIntegral(memberInfoModel);
            if (count == 0 && (i = this.modifyIntegral(memberInfoModel)) == 0) {
                ResponseData responseData = ResponseUtil.getFailedData(null, (String)"\u66f4\u65b0\u4f1a\u5458\u79ef\u5206\u5931\u8d25");
                return responseData;
            }
            if (StringUtils.isNotBlank((CharSequence)syncIntegralVo.getSerialNumber())) {
                IntegralRecordModel integralRecordModel = new IntegralRecordModel();
                integralRecordModel.setBrandId(sysBrandId);
                integralRecordModel.setChangeBills(syncIntegralVo.getChangeBills());
                integralRecordModel.setMemberCode(memberInfoModel.getMemberCode());
                integralRecordModel.setSysCompanyId(memberInfoModel.getSysCompanyId());
                integralRecordModel.setOfflineBrandCode(memberInfoModel.getOfflineBrandCode());
                integralRecordModel.setOfflineCompanyCode(memberInfoModel.getOfflineCompanyCode());
                integralRecordModel.setRecordCode(UUIDUtil.getUuid16());
                integralRecordModel.setChangeWay(syncIntegralVo.getChangeIntegral() > 0 ? "2" : "1");
                integralRecordModel.setErpId(memberInfoModel.getErpId());
                integralRecordModel.setChangeDate(syncIntegralVo.getChangeDate() != null ? syncIntegralVo.getChangeDate() : new Date());
                integralRecordModel.setChangeDetails(syncIntegralVo.getChangeDetails());
                integralRecordModel.setCreateDate(new Date());
                integralRecordModel.setBusinessWay(syncIntegralVo.getBusinessWay());
                integralRecordModel.setChangeIntegral(syncIntegralVo.getChangeIntegral());
                integralRecordModel.setSource(syncIntegralVo.getSource());
                integralRecordModel.setOfflineIntegralId(syncIntegralVo.getSerialNumber());
                IntegralRecordBusinessTypeVo integralRecordBusinessTypeVo = this.integralRecordBusinessTypeService.findIntegralRecordBusinessTypeVoByCode(syncIntegralVo.getBusinessWay(), memberInfoModel.getSysCompanyId());
                log.info(" findIntegralRecordBusinessTypeVoByCode businessWay{}, integralRecordBusinessTypeVo{}", (Object)syncIntegralVo.getBusinessWay(), (Object)JSONObject.toJSONString((Object)integralRecordBusinessTypeVo));
                if (integralRecordBusinessTypeVo != null) {
                    integralRecordModel.setBusinessWay(integralRecordBusinessTypeVo.getBizvaneCode());
                    integralRecordModel.setBusinessWayOffline(integralRecordBusinessTypeVo.getBusinessCode());
                    integralRecordModel.setBusinessDescription(integralRecordBusinessTypeVo.getDescription());
                } else {
                    integralRecordModel.setBusinessWayOffline(BizvaneBusinessTypeEnum.UR_OTHER.getCode());
                    integralRecordModel.setBusinessDescription(BizvaneBusinessTypeEnum.UR_OTHER.getMsg());
                }
                integralRecordModel.setOnlineStoreCode(syncIntegralVo.getOnlineStoreCode());
                this.integralRecordMapper.insertSelective((Object)integralRecordModel);
            }
            SyncChangeRequestVo syncChangeInfo = new SyncChangeRequestVo();
            syncChangeInfo.setBrandId(sysBrandId);
            syncChangeInfo.setMemberCode(memberInfoModel.getMemberCode());
            syncChangeInfo.setSysCompanyId(memberInfoModel.getSysCompanyId());
            syncChangeInfo.setType(Integer.valueOf(1));
            this.asyncToRemoteService.asyncInfoChange(syncChangeInfo);
            IntegralChangeResponseModel model = IntegralChangeResponseModel.builder().brandId(sysBrandId).businessType(BusinessTypeEnum.OFFLINE_HAND_TYPE.getCode()).changeDate(new Date()).changeIntegral(syncIntegralVo.getChangeIntegral()).changeType(syncIntegralVo.getChangeIntegral() > 0 ? "2" : "1").memberCode(memberInfoModel.getMemberCode()).offlineBrandCode(syncIntegralVo.getBrandCode()).integralAdjustId(syncIntegralVo.getSerialNumber()).changeDetails(syncIntegralVo.getChangeDetails()).build();
            new Thread(() -> this.notifySendMessage(model, memberInfoModel)).start();
        }
        catch (Exception e) {
            log.error("IntegralChangeApiServiceImpl offlineSyncIntegral error:{}", (Object)e.getMessage());
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            ResponseData responseData = ResponseUtil.getFailedData(null);
            return responseData;
        }
        finally {
            this.redissonTemplate.getRUnLook(syncIntegralVo.getErpId() + syncIntegralVo.getSysBrandId());
        }
        return ResponseUtil.getSuccessData(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public ResponseData baisonSyncIntegralRecord(SyncIntegralVo syncIntegralVo) {
        log.info("IntegralChangeApiServiceImpl baisonSyncIntegralRecord vo:{}", (Object)JacksonUtil.bean2Json((Object)syncIntegralVo));
        try {
            int i;
            this.redissonTemplate.getRLock(syncIntegralVo.getErpId() + syncIntegralVo.getBrandCode(), 30L, TimeUnit.SECONDS);
            SysBrandPo sysBrandPo = new SysBrandPo();
            sysBrandPo.setBrandCode(syncIntegralVo.getBrandCode());
            ResponseData brandInfo = this.brandServiceRpc.getBrandIdAndCompanyIdByCode(sysBrandPo);
            if (brandInfo.getCode() == SysResponseEnum.FAILED.getCode() || brandInfo.getData() == null) {
                ResponseData responseData = ResponseUtil.getFailedData(null, (String)"\u4f01\u4e1a\u7f16\u53f7\u4e0d\u5b58\u5728");
                return responseData;
            }
            Long sysBrandId = ((SysBrandPo)brandInfo.getData()).getSysBrandId();
            syncIntegralVo.setSysBrandId(sysBrandId);
            MemberInfoModel memberInfoModel = this.memberInfoMapper.queryIntegralByErpIdBrandId(syncIntegralVo.getErpId(), syncIntegralVo.getSysBrandId());
            if (memberInfoModel == null) {
                ResponseData responseData = ResponseUtil.getFailedData(null, (String)"\u4f1a\u5458\u4e0d\u5b58\u5728");
                return responseData;
            }
            if (StringUtils.isNotBlank((CharSequence)syncIntegralVo.getSerialNumber())) {
                IntegralRecordFetchModel integralRecordFetchModel = new IntegralRecordFetchModel();
                integralRecordFetchModel.setOfflineCompanyCode(memberInfoModel.getOfflineCompanyCode());
                integralRecordFetchModel.setOfflineBrandCode(memberInfoModel.getOfflineBrandCode());
                integralRecordFetchModel.setOfflineIntegralId(syncIntegralVo.getSerialNumber());
                IntegralRecordModel integralResponse = this.integralRecordMapper.queryCountByOfflineId(integralRecordFetchModel);
                if (integralResponse != null) {
                    ResponseData responseData = ResponseUtil.getFailedData(null, (String)"\u6d41\u6c34\u5df2\u5b58\u5728");
                    return responseData;
                }
            }
            if (syncIntegralVo.getChangeIntegral() > 0) {
                Integer addUpIntegral = memberInfoModel.getAddUpIntegral() + syncIntegralVo.getChangeIntegral();
                memberInfoModel.setAddUpIntegral(addUpIntegral);
            }
            memberInfoModel.setConsumeIntegral(syncIntegralVo.getChangeIntegral());
            memberInfoModel.setModifiedDate(new Date());
            int count = this.modifyIntegral(memberInfoModel);
            if (count == 0 && (i = this.modifyIntegral(memberInfoModel)) == 0) {
                ResponseData responseData = ResponseUtil.getFailedData(null, (String)"\u66f4\u65b0\u4f1a\u5458\u79ef\u5206\u5931\u8d25");
                return responseData;
            }
            if (StringUtils.isNotBlank((CharSequence)syncIntegralVo.getSerialNumber())) {
                IntegralRecordModel integralRecordModel = new IntegralRecordModel();
                integralRecordModel.setBrandId(sysBrandId);
                integralRecordModel.setChangeBills(syncIntegralVo.getChangeBills());
                integralRecordModel.setMemberCode(memberInfoModel.getMemberCode());
                integralRecordModel.setSysCompanyId(memberInfoModel.getSysCompanyId());
                integralRecordModel.setOfflineBrandCode(memberInfoModel.getOfflineBrandCode());
                integralRecordModel.setOfflineCompanyCode(memberInfoModel.getOfflineCompanyCode());
                integralRecordModel.setRecordCode(UUIDUtil.getUuid16());
                integralRecordModel.setChangeWay(syncIntegralVo.getChangeIntegral() > 0 ? "2" : "1");
                integralRecordModel.setErpId(memberInfoModel.getErpId());
                integralRecordModel.setChangeDate(new Date());
                integralRecordModel.setChangeDetails(syncIntegralVo.getChangeDetails());
                integralRecordModel.setCreateDate(new Date());
                integralRecordModel.setBusinessWay(syncIntegralVo.getBusinessWay());
                integralRecordModel.setBusinessWayOffline(BizvaneBaisonBusinessTypeEnum.getBizvaneBusinessTypeByBaisonCode((String)syncIntegralVo.getBusinessWay()));
                integralRecordModel.setChangeIntegral(syncIntegralVo.getChangeIntegral());
                integralRecordModel.setSource(syncIntegralVo.getSource());
                integralRecordModel.setOfflineIntegralId(syncIntegralVo.getSerialNumber());
                integralRecordModel.setBusinessDescription(syncIntegralVo.getBusinessDescription());
                integralRecordModel.setOnlineStoreCode(syncIntegralVo.getOnlineStoreCode());
                this.integralRecordMapper.insertSelective((Object)integralRecordModel);
            }
            SyncChangeRequestVo syncChangeInfo = new SyncChangeRequestVo();
            syncChangeInfo.setBrandId(sysBrandId);
            syncChangeInfo.setMemberCode(memberInfoModel.getMemberCode());
            syncChangeInfo.setSysCompanyId(memberInfoModel.getSysCompanyId());
            syncChangeInfo.setType(Integer.valueOf(1));
            this.asyncToRemoteService.asyncInfoChange(syncChangeInfo);
            IntegralChangeResponseModel model = IntegralChangeResponseModel.builder().brandId(sysBrandId).businessType(BusinessTypeEnum.OFFLINE_HAND_TYPE.getCode()).changeDate(new Date()).changeIntegral(syncIntegralVo.getChangeIntegral()).changeType(syncIntegralVo.getChangeIntegral() > 0 ? "2" : "1").memberCode(memberInfoModel.getMemberCode()).offlineBrandCode(syncIntegralVo.getBrandCode()).integralAdjustId(syncIntegralVo.getSerialNumber()).changeDetails(syncIntegralVo.getChangeDetails()).build();
            new Thread(() -> this.notifySendMessage(model, memberInfoModel)).start();
        }
        catch (Exception e) {
            log.error("IntegralChangeApiServiceImpl baisonSyncIntegralRecord error:{}", (Object)e.getMessage());
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            ResponseData responseData = ResponseUtil.getFailedData(null);
            return responseData;
        }
        finally {
            this.redissonTemplate.getRUnLook(syncIntegralVo.getErpId() + syncIntegralVo.getBrandCode());
        }
        return ResponseUtil.getSuccessData(null);
    }

    private int modifyIntegral(MemberInfoModel memberInfoModel) {
        int i = 0;
        try {
            i = this.memberInfoMapper.updateIntegral(memberInfoModel);
        }
        catch (Exception e) {
            log.error("modifyIntegral exception", (Throwable)e);
        }
        return i;
    }

    private boolean enableNegativeIntegral(SysBrandPo sysBrandPo) {
        if (StringUtils.isEmpty((CharSequence)sysBrandPo.getBrandConfigs())) {
            return false;
        }
        BrandConfigsBO brandConfigsBO = (BrandConfigsBO)JSON.parseObject((String)sysBrandPo.getBrandConfigs(), BrandConfigsBO.class);
        if (brandConfigsBO == null) {
            return false;
        }
        Boolean enableNegativeIntegral = brandConfigsBO.getEnableNegativeIntegral();
        if (enableNegativeIntegral == null) {
            return false;
        }
        return enableNegativeIntegral;
    }

    public void validationData(IntegralChangeRequestModel integralChangeRequestModel) {
        if (integralChangeRequestModel.getSysCompanyId() == null) {
            log.error("sysCompanyId \u4e0d\u80fd\u4e3a\u7a7a !");
            throw new MemberException("sysCompanyId \u4e0d\u80fd\u4e3a\u7a7a !");
        }
        if (integralChangeRequestModel.getBrandId() == null) {
            log.error("brandId \u4e0d\u80fd\u4e3a\u7a7a!");
            throw new MemberException("brandId \u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)integralChangeRequestModel.getMemberCode())) {
            log.error("memberCode \u4e0d\u80fd\u4e3a\u7a7a!");
            throw new MemberException("memberCode \u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)integralChangeRequestModel.getChangeBills())) {
            log.error("changeBills \u4e0d\u80fd\u4e3a\u7a7a!");
            throw new MemberException("changeBills \u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (integralChangeRequestModel.getChangeIntegral() == null) {
            log.error("changeIntegral \u4e0d\u80fd\u4e3a\u7a7a!");
            throw new MemberException("changeIntegral \u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)integralChangeRequestModel.getChangeType())) {
            log.error("changeType \u4e0d\u80fd\u4e3a\u7a7a!");
            throw new MemberException("changeType \u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)integralChangeRequestModel.getBusinessType())) {
            log.error("businessType \u4e0d\u80fd\u4e3a\u7a7a!");
            throw new MemberException("businessType \u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    public IntegralChangeResponseModel invokeOfflineChange(IntegralChangeRequestModel integralChangeRequestModel) {
        IntegralChangeResponseModel integralChangeResponseModel = new IntegralChangeResponseModel();
        MemberInfoModel memberInfoModel = this.memberInfoMapper.queryMemberBasicInfo(integralChangeRequestModel.getMemberCode());
        if (null == memberInfoModel) {
            log.error("\u6dfb\u52a0\u79ef\u5206\u6d41\u6c34\u5931\u8d25,\u4f1a\u5458\u4e0d\u5b58\u5728!");
            integralChangeResponseModel.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            integralChangeResponseModel.setMessage("\u6dfb\u52a0\u79ef\u5206\u6d41\u6c34\u5931\u8d25,\u4f1a\u5458\u4e0d\u5b58\u5728!");
            integralChangeResponseModel.setErrorStatus(IntegralConsumeTypeEnum.OFFLINE_FAILED_BEFORE.getCode());
            integralChangeResponseModel.setErrorMessage("\u6dfb\u52a0\u79ef\u5206\u6d41\u6c34\u5931\u8d25,\u4f1a\u5458\u4e0d\u5b58\u5728!");
            return integralChangeResponseModel;
        }
        IntegralAdjustRequestVO integralAdjustRequestVO = new IntegralAdjustRequestVO();
        BeanUtils.copyProperties((Object)integralChangeRequestModel, (Object)integralAdjustRequestVO);
        integralAdjustRequestVO.setOfflineCardNo(memberInfoModel.getOfflineCardNo());
        if (IntegralChangeTypeEnum.getIntegralChangeTypeEnum((String)integralChangeRequestModel.getChangeType()) == IntegralChangeTypeEnum.Expend) {
            integralAdjustRequestVO.setChangeIntegral(Integer.valueOf(-Math.abs(integralChangeRequestModel.getChangeIntegral())));
        }
        integralAdjustRequestVO.setOrderBillNo(integralChangeRequestModel.getChangeBills());
        integralAdjustRequestVO.setChangeType(Integer.valueOf(Integer.parseInt(integralChangeRequestModel.getChangeType())));
        Map standardIntegralRecordBusinessTypeVoMap = this.standardConvertOnLineTypeToOffline();
        if (CollectionUtil.isNotEmpty((Map)standardIntegralRecordBusinessTypeVoMap) && StringUtils.isNotBlank((CharSequence)integralChangeRequestModel.getBusinessType()) && StringUtils.isNotBlank((CharSequence)((CharSequence)standardIntegralRecordBusinessTypeVoMap.get(integralChangeRequestModel.getBusinessType())))) {
            String standardIntegralRecordBusinessTypeVoStr = (String)standardIntegralRecordBusinessTypeVoMap.get(integralChangeRequestModel.getBusinessType());
            IntegralRecordBusinessTypeVo integralRecordBusinessTypeVo = (IntegralRecordBusinessTypeVo)JacksonUtil.json2Obj((String)standardIntegralRecordBusinessTypeVoStr, IntegralRecordBusinessTypeVo.class);
            integralAdjustRequestVO.setBusinessType(integralRecordBusinessTypeVo.getDescription());
        }
        integralAdjustRequestVO.setDetail(integralChangeRequestModel.getChangeDetails());
        integralAdjustRequestVO.setStoreId(integralChangeRequestModel.getStoreId());
        integralAdjustRequestVO.setPointsAmount(integralChangeRequestModel.getPointsAmount() != null ? Double.valueOf(integralChangeRequestModel.getPointsAmount().doubleValue()) : null);
        integralAdjustRequestVO.setSource(integralChangeRequestModel.getSource());
        Map integralRecordBusinessTypeVoMap = this.convertOnLineTypeToOffline(memberInfoModel.getSysCompanyId());
        if (CollectionUtil.isNotEmpty((Map)integralRecordBusinessTypeVoMap) && StringUtils.isNotBlank((CharSequence)((CharSequence)integralRecordBusinessTypeVoMap.get(integralChangeRequestModel.getBusinessType())))) {
            String standardIntegralRecordBusinessTypeVoStr = (String)integralRecordBusinessTypeVoMap.get(integralChangeRequestModel.getBusinessType());
            integralAdjustRequestVO.setCreateType(((IntegralRecordBusinessTypeVo)JacksonUtil.json2Obj((String)standardIntegralRecordBusinessTypeVoStr, IntegralRecordBusinessTypeVo.class)).getBizvaneCode());
        } else {
            integralAdjustRequestVO.setCreateType("1");
        }
        if (StringUtils.isNotBlank((CharSequence)integralChangeRequestModel.getPointsIdUnique())) {
            integralAdjustRequestVO.setPointsIdUnique(integralChangeRequestModel.getPointsIdUnique());
        } else {
            integralAdjustRequestVO.setPointsIdUnique(UUIDUtil.getUuid16());
        }
        integralAdjustRequestVO.setErpId(memberInfoModel.getErpId());
        integralAdjustRequestVO.setTaobaoNick(integralChangeRequestModel.getTaoBaoNick());
        StopWatchTime.start((String)"invokeOfflineChange.connectorServiceFeign.adjustIntegral");
        log.info("\u8c03\u7528\u7ebf\u4e0b\u63a5\u53e3\u53c2\u6570:integralAdjustRequestVO:{}", (Object)JacksonUtil.bean2Json((Object)integralAdjustRequestVO));
        Result result = this.connectorServiceFeign.adjustIntegral(integralAdjustRequestVO);
        StopWatchTime.stop();
        log.info("\u79ef\u5206\u4fee\u6539\u7ebf\u4e0b\u8fd4\u56de\u7ed3\u679c:{}", (Object)JacksonUtil.bean2Json((Object)result));
        if (result == null || result.getCode() == null || result.getCode().intValue() != SysResponseEnum.SUCCESS.getCode()) {
            integralChangeResponseModel.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            integralChangeResponseModel.setMessage(result != null ? result.getMessage() : "\u7ebf\u4e0b\u8c03\u6574\u79ef\u5206\u6d41\u6c34\u5931\u8d25");
            integralChangeResponseModel.setErrorStatus(IntegralConsumeTypeEnum.OFFLINE_FAILED_BEFORE.getCode());
            integralChangeResponseModel.setErrorMessage(result != null ? result.getMessage() : "\u7ebf\u4e0b\u8c03\u6574\u79ef\u5206\u6d41\u6c34\u5931\u8d25");
            return integralChangeResponseModel;
        }
        IntegralAdjustResponseVO integralAdjustResponseVO = (IntegralAdjustResponseVO)result.getData();
        integralChangeResponseModel.setCode(result.getCode());
        integralChangeResponseModel.setMessage(result.getMessage());
        BeanUtils.copyProperties((Object)integralAdjustResponseVO, (Object)integralChangeResponseModel);
        return integralChangeResponseModel;
    }

    private Map<String, String> convertOnLineTypeToOffline(Long sysCompanyId) {
        if (CollectionUtil.isEmpty((Collection)this.switchConfig.getIntegralTypeSwitch()) || !this.switchConfig.getIntegralTypeSwitch().contains(sysCompanyId)) {
            return null;
        }
        String redisKey = this.prefixIntegralTypeConvertOnLineToOffline + ":" + sysCompanyId;
        String integralRecordBusinessTypeVoMapStr = (String)this.stringRedisTemplate.opsForValue().get((Object)redisKey);
        if (StringUtils.isNotBlank((CharSequence)integralRecordBusinessTypeVoMapStr)) {
            return (Map)JacksonUtil.json2Objs((String)integralRecordBusinessTypeVoMapStr, Map.class);
        }
        MbrIntegralRecordBusinessTypePOExample mbrIntegralRecordBusinessTypePOExample = new MbrIntegralRecordBusinessTypePOExample();
        mbrIntegralRecordBusinessTypePOExample.createCriteria().andSysCompanyIdEqualTo(sysCompanyId);
        List mbrIntegralRecordBusinessTypePOS = this.mbrIntegralRecordBusinessTypePoMapper.selectByExample(mbrIntegralRecordBusinessTypePOExample);
        if (CollectionUtil.isEmpty((Collection)mbrIntegralRecordBusinessTypePOS)) {
            return null;
        }
        HashMap<String, String> integralRecordBusinessTypeVoMap = new HashMap<String, String>();
        mbrIntegralRecordBusinessTypePOS.stream().forEach(mbrIntegralRecordBusinessTypePO -> {
            if (StringUtils.isNotBlank((CharSequence)mbrIntegralRecordBusinessTypePO.getBizvaneCode())) {
                String[] bizvaneCodes = StringUtils.split((String)mbrIntegralRecordBusinessTypePO.getBizvaneCode(), (String)",");
                Stream.of(bizvaneCodes).forEach(bizvaneCode -> {
                    IntegralRecordBusinessTypeVo integralRecordBusinessTypeVo = new IntegralRecordBusinessTypeVo();
                    integralRecordBusinessTypeVo.setBizvaneCode(bizvaneCode);
                    integralRecordBusinessTypeVo.setBusinessCode(mbrIntegralRecordBusinessTypePO.getBizvaneCode());
                    integralRecordBusinessTypeVo.setDescription(mbrIntegralRecordBusinessTypePO.getDescription());
                    integralRecordBusinessTypeVoMap.put((String)bizvaneCode, JacksonUtil.bean2Json((Object)integralRecordBusinessTypeVo));
                });
            }
        });
        this.stringRedisTemplate.opsForValue().set((Object)redisKey, (Object)JSONObject.toJSONString(integralRecordBusinessTypeVoMap), 10L, TimeUnit.MINUTES);
        return integralRecordBusinessTypeVoMap;
    }

    private Map<String, String> standardConvertOnLineTypeToOffline() {
        String redisKey = this.prefixIntegralTypeConvertOnLineToOffline + ":0";
        String integralRecordBusinessTypeVoMapStr = (String)this.stringRedisTemplate.opsForValue().get((Object)redisKey);
        if (StringUtils.isNotBlank((CharSequence)integralRecordBusinessTypeVoMapStr)) {
            return (Map)JacksonUtil.json2Objs((String)integralRecordBusinessTypeVoMapStr, Map.class);
        }
        MbrIntegralRecordBusinessTypePOExample mbrIntegralRecordBusinessTypePOExample = new MbrIntegralRecordBusinessTypePOExample();
        mbrIntegralRecordBusinessTypePOExample.createCriteria().andSysCompanyIdEqualTo(Long.valueOf(0L));
        List mbrIntegralRecordBusinessTypePOList = this.mbrIntegralRecordBusinessTypePoMapper.selectByExample(mbrIntegralRecordBusinessTypePOExample);
        if (CollectionUtils.isEmpty((Collection)mbrIntegralRecordBusinessTypePOList)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> integralRecordBusinessTypeVoMap = new HashMap<String, String>();
        mbrIntegralRecordBusinessTypePOList.stream().forEach(mbrIntegralRecordBusinessTypePO -> {
            IntegralRecordBusinessTypeVo integralRecordBusinessTypeVo = new IntegralRecordBusinessTypeVo();
            integralRecordBusinessTypeVo.setBizvaneCode(mbrIntegralRecordBusinessTypePO.getBizvaneCode());
            integralRecordBusinessTypeVo.setBusinessCode(mbrIntegralRecordBusinessTypePO.getBusinessCode());
            integralRecordBusinessTypeVo.setDescription(mbrIntegralRecordBusinessTypePO.getDescription());
            integralRecordBusinessTypeVoMap.put(mbrIntegralRecordBusinessTypePO.getBizvaneCode(), JacksonUtil.bean2Json((Object)integralRecordBusinessTypeVo));
        });
        this.stringRedisTemplate.opsForValue().set((Object)redisKey, (Object)JSONObject.toJSONString(integralRecordBusinessTypeVoMap), 10L, TimeUnit.MINUTES);
        return integralRecordBusinessTypeVoMap;
    }

    private Map<String, String> convertTypeToOffline(MemberInfoModel memberInfoModel) {
        if (CollectionUtil.isEmpty((Collection)this.switchConfig.getIntegralTypeSwitch()) || !this.switchConfig.getIntegralTypeSwitch().contains(memberInfoModel.getSysCompanyId())) {
            return null;
        }
        String key = this.prefixSwitchTypeConvert + "_" + memberInfoModel.getSysCompanyId();
        String convertBusinessValue = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (StringUtils.isNotBlank((CharSequence)convertBusinessValue)) {
            return (Map)JacksonUtil.json2Objs((String)convertBusinessValue, Map.class);
        }
        MbrIntegralRecordBusinessTypePOExample example = new MbrIntegralRecordBusinessTypePOExample();
        example.createCriteria().andSysCompanyIdEqualTo(memberInfoModel.getSysCompanyId());
        List integralRecordBusinessTypePos = this.mbrIntegralRecordBusinessTypePoMapper.selectByExample(example);
        if (CollectionUtil.isEmpty((Collection)integralRecordBusinessTypePos)) {
            return null;
        }
        HashMap<String, String> businessMap = new HashMap<String, String>();
        integralRecordBusinessTypePos.stream().forEach(business -> {
            if (StringUtils.isNotBlank((CharSequence)business.getBizvaneCode())) {
                String[] bizvaneCodes = org.springframework.util.StringUtils.commaDelimitedListToStringArray((String)business.getBizvaneCode());
                Stream.of(bizvaneCodes).forEach(bizvaneCode -> businessMap.put((String)bizvaneCode, business.getBusinessCode()));
            }
        });
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)JSONObject.toJSONString(businessMap), 10L, TimeUnit.MINUTES);
        return businessMap;
    }

    public IntegralChangeResponseModel invokeOnlineSyncData(IntegralChangeRequestModel integralChangeRequestModel, IntegralChangeResponseModel integralChangeResponseModel, MemberInfoModel memberInfoModel) {
        IntegralRecordModel integralRecordModel = new IntegralRecordModel();
        BeanUtils.copyProperties((Object)integralChangeRequestModel, (Object)integralRecordModel);
        integralRecordModel.setOfflineIntegralId(integralChangeResponseModel.getIntegralAdjustId());
        integralRecordModel.setChangeWay(integralChangeRequestModel.getChangeType());
        integralRecordModel.setBusinessWay(integralChangeRequestModel.getBusinessType());
        integralRecordModel.setCreateUserId(integralChangeRequestModel.getOperateUserId());
        integralRecordModel.setCreateUserName(integralChangeRequestModel.getOperateUserName());
        integralRecordModel.setModifiedUserId(integralChangeRequestModel.getOperateUserId());
        integralRecordModel.setModifiedUserName(integralChangeRequestModel.getOperateUserName());
        integralRecordModel.setOfflineBrandCode(integralChangeResponseModel.getOfflineBrandCode());
        String businessType = integralChangeRequestModel.getBusinessType();
        if (businessType.startsWith(BIZVANE_BUSINESS_CODE_PREFIX)) {
            businessType = StringUtils.substringAfter((String)businessType, (String)BIZVANE_BUSINESS_CODE_PREFIX);
        }
        integralRecordModel.setBusinessWay(businessType);
        Map integralRecordBusinessTypeVoMap = this.convertOnLineTypeToOffline(memberInfoModel.getSysCompanyId());
        if (CollectionUtil.isNotEmpty((Map)integralRecordBusinessTypeVoMap) && integralRecordBusinessTypeVoMap.get(businessType) != null) {
            IntegralRecordBusinessTypeVo integralRecordBusinessTypeVo = (IntegralRecordBusinessTypeVo)JacksonUtil.json2Obj((String)((String)integralRecordBusinessTypeVoMap.get(businessType)), IntegralRecordBusinessTypeVo.class);
            integralRecordModel.setBusinessWayOffline(integralRecordBusinessTypeVo.getBusinessCode());
            integralRecordModel.setBusinessDescription(integralRecordBusinessTypeVo.getDescription());
        } else if (CollectionUtil.isNotEmpty((Map)integralRecordBusinessTypeVoMap)) {
            integralRecordModel.setBusinessWayOffline("1");
            integralRecordModel.setBusinessDescription("\u8c03\u6574");
        } else {
            Map standardIntegralRecordBusinessTypeVoMap = this.standardConvertOnLineTypeToOffline();
            if (CollectionUtil.isNotEmpty((Map)standardIntegralRecordBusinessTypeVoMap) && StringUtils.isNotBlank((CharSequence)((CharSequence)standardIntegralRecordBusinessTypeVoMap.get(businessType)))) {
                String standardIntegralRecordBusinessTypeVoStr = (String)standardIntegralRecordBusinessTypeVoMap.get(integralChangeRequestModel.getBusinessType());
                IntegralRecordBusinessTypeVo integralRecordBusinessTypeVo = (IntegralRecordBusinessTypeVo)JacksonUtil.json2Obj((String)standardIntegralRecordBusinessTypeVoStr, IntegralRecordBusinessTypeVo.class);
                integralRecordModel.setBusinessWayOffline(integralRecordBusinessTypeVo.getBusinessCode());
                integralRecordModel.setBusinessDescription(integralRecordBusinessTypeVo.getDescription());
            } else {
                integralRecordModel.setBusinessWayOffline(BIZVANE_BUSINESS_CODE_PREFIX + businessType);
            }
        }
        integralRecordModel.setChangeDetails(integralChangeRequestModel.getChangeDetails());
        integralRecordModel.setPointsAmount(integralChangeRequestModel.getPointsAmount());
        integralRecordModel.setStoreId(integralChangeRequestModel.getStoreId());
        integralRecordModel.setSource(integralChangeRequestModel.getSource());
        StopWatchTime.start((String)"invokeOnlineSyncData.findMemberInfoByMemberCode");
        MemberInfoModel model = this.memberInfoMapper.findMemberInfoByMemberCode(integralChangeRequestModel.getMemberCode());
        StopWatchTime.stop();
        if (model != null) {
            BeanUtils.copyProperties((Object)model, (Object)memberInfoModel);
            integralRecordModel.setMemberName(model.getName());
            integralRecordModel.setMemberCardNo(model.getCardNo());
            integralRecordModel.setOfflineCompanyCode(model.getOfflineCompanyCode());
            integralRecordModel.setErpId(model.getErpId());
            Long serviceStoreId = memberInfoModel.getServiceStoreId();
            if (serviceStoreId != null) {
                try {
                    String sysStoreOfflineCode = ((SysStoreVo)this.storeServiceRpc.getSysStoreById(serviceStoreId).getData()).getSysStoreOfflineCode();
                    integralRecordModel.setOfflineStoreCode(sysStoreOfflineCode);
                }
                catch (Exception e) {
                    log.info("\u65e0\u6cd5\u83b7\u53d6serviceStoreId");
                }
            }
            try {
                this.changeMemberIntegral(integralRecordModel);
            }
            catch (Exception e) {
                log.error("changeMemberIntegral", (Throwable)e);
                SyncIntegralVo syncIntegralVo = new SyncIntegralVo();
                syncIntegralVo.setSysCompanyId(integralChangeRequestModel.getSysCompanyId());
                syncIntegralVo.setSysBrandId(integralChangeRequestModel.getBrandId());
                syncIntegralVo.setBrandCode(model.getOfflineBrandCode());
                syncIntegralVo.setErpId(model.getErpId());
                syncIntegralVo.setChangeBills(integralRecordModel.getChangeBills());
                syncIntegralVo.setChangeIntegral(integralRecordModel.getChangeIntegral());
                syncIntegralVo.setSource(integralRecordModel.getSource());
                syncIntegralVo.setSerialNumber(integralRecordModel.getOfflineIntegralId());
                syncIntegralVo.setBusinessWay(integralRecordModel.getBusinessWay());
                syncIntegralVo.setBusinessWayOffline(integralRecordModel.getBusinessWayOffline());
                syncIntegralVo.setBusinessDescription(integralRecordModel.getBusinessDescription());
                syncIntegralVo.setOnlineStoreCode(integralRecordModel.getOnlineStoreCode());
                syncIntegralVo.setChangeDetails(integralRecordModel.getChangeDetails());
                integralChangeResponseModel.setErrorBody(JacksonUtil.bean2Json((Object)syncIntegralVo));
                integralChangeResponseModel.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
                integralChangeResponseModel.setMessage("\u7ebf\u4e0a\u5199\u5165\u79ef\u5206\u5931\u8d25");
                integralChangeResponseModel.setErrorStatus(IntegralConsumeTypeEnum.ONLINE_FAILED_AFTER_OFFLINE.getCode());
                integralChangeResponseModel.setErrorMessage("\u7ebf\u4e0a\u5199\u5165\u79ef\u5206\u5931\u8d25");
                return integralChangeResponseModel;
            }
            SyncChangeRequestVo syncChangeInfo = new SyncChangeRequestVo();
            syncChangeInfo.setBrandId(model.getBrandId());
            syncChangeInfo.setMemberCode(integralChangeRequestModel.getMemberCode());
            syncChangeInfo.setSysCompanyId(model.getSysCompanyId());
            syncChangeInfo.setType(Integer.valueOf(1));
            syncChangeInfo.setIntegralChangeRequestModel(integralChangeRequestModel);
            this.asyncToRemoteService.asyncInfoChange(syncChangeInfo);
        }
        BeanUtils.copyProperties((Object)integralChangeRequestModel, (Object)integralChangeResponseModel);
        integralChangeResponseModel.setCode(Integer.valueOf(0));
        integralChangeResponseModel.setMessage("\u64cd\u4f5c\u6210\u529f");
        return integralChangeResponseModel;
    }

    protected void notifySendMessage(IntegralChangeResponseModel instance, MemberInfoModel memberInfoModel) throws MemberException {
        WxPublicPO wxPublicPo;
        IntegralMessageVO integralMessageVO = new IntegralMessageVO();
        FetchMessagePo messagePo = this.fetchUtil.queryMessagePo(instance.getMemberCode());
        if (messagePo == null) {
            return;
        }
        BeanUtils.copyProperties((Object)messagePo, (Object)integralMessageVO);
        if (StringUtils.isBlank((CharSequence)instance.getBusinessDescription())) {
            IntegralRecordBusinessTypeVo integralRecordBusinessTypeVo = this.integralRecordBusinessTypeService.findIntegralRecordBusinessTypeVoByCode(BIZVANE_BUSINESS_CODE_PREFIX + instance.getBusinessType(), memberInfoModel.getSysCompanyId());
            log.info(" findIntegralRecordBusinessTypeVoByCode businessType{}, integralRecordBusinessTypeVo{}", (Object)(BIZVANE_BUSINESS_CODE_PREFIX + instance.getBusinessType()), (Object)JSONObject.toJSONString((Object)integralRecordBusinessTypeVo));
            if (integralRecordBusinessTypeVo != null) {
                integralMessageVO.setBusinessDescription(integralRecordBusinessTypeVo.getDescription());
            } else {
                integralMessageVO.setBusinessDescription(BizvaneBusinessTypeEnum.UR_OTHER.getMsg());
            }
        } else {
            integralMessageVO.setBusinessDescription(instance.getBusinessDescription());
        }
        integralMessageVO.setCardnumber(messagePo.getCardNumber());
        integralMessageVO.setSysBrandId(instance.getBrandId());
        integralMessageVO.setChangeDate(instance.getChangeDate());
        if (integralMessageVO.getChangeDate() == null) {
            integralMessageVO.setChangeDate(new Date());
        }
        if ((wxPublicPo = this.weChatInterfaceTransform.getWxPublicPoByBrandId(instance.getBrandId())) != null) {
            integralMessageVO.setNickName(wxPublicPo.getNickName());
        }
        integralMessageVO.setNowIntegral(memberInfoModel.getCountIntegral() != null ? memberInfoModel.getCountIntegral().toString() : "0");
        integralMessageVO.setChangeDate(new Date());
        integralMessageVO.setChangeDetails(instance.getChangeDetails());
        integralMessageVO.setServiceStoreId(messagePo.getServiceStoreId());
        if (IntegralChangeTypeEnum.getIntegralChangeTypeEnum((String)instance.getChangeType()) == IntegralChangeTypeEnum.Expend) {
            String nowIntegral;
            String changeIntegral = instance.getChangeIntegral().toString();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{changeIntegral})) {
                integralMessageVO.setUseIntegral(changeIntegral.replace("-", ""));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{nowIntegral = integralMessageVO.getNowIntegral()})) {
                integralMessageVO.setNowIntegral(nowIntegral.replace("-", ""));
            }
            this.wechatIntegralServiceFeign.integralUse(integralMessageVO);
            log.info("\u8c03\u7528standardMessageUtil.useIntegralMessage:{}", (Object)JSON.toJSONString((Object)integralMessageVO));
            this.standardMessageUtil.useIntegralMessage(integralMessageVO);
            return;
        }
        if (IntegralChangeTypeEnum.getIntegralChangeTypeEnum((String)instance.getChangeType()) == IntegralChangeTypeEnum.INCOME) {
            integralMessageVO.setChangeIntegral(instance.getChangeIntegral().toString());
            this.wechatIntegralServiceFeign.integralAdd(integralMessageVO);
            log.info("\u8c03\u7528standardMessageUtil.addIntegralMessage:{}", (Object)JSON.toJSONString((Object)integralMessageVO));
            this.standardMessageUtil.addIntegralMessage(integralMessageVO);
            return;
        }
        integralMessageVO.setExpireIntegral(instance.getChangeIntegral().toString());
        this.wechatIntegralServiceFeign.integralExpire(integralMessageVO);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public ResponseData<Integer> changeMemberIntegral(IntegralRecordModel integralRecordModel) throws MemberException {
        log.info("enter changeMemberIntegral method param:{}!", (Object)JacksonUtil.bean2Json((Object)integralRecordModel));
        StopWatchTime.start((String)"changeMemberIntegral.adjustMemberIntegral");
        int result1 = this.adjustMemberIntegral(integralRecordModel);
        StopWatchTime.stop();
        if (result1 < 1) {
            throw new MemberException("\u8c03\u6574\u4f1a\u5458\u79ef\u5206\u5931\u8d25");
        }
        StopWatchTime.start((String)"changeMemberIntegral.insertIntegralRecord");
        if (StringUtils.isNotBlank((CharSequence)integralRecordModel.getOfflineIntegralId())) {
            int result2;
            SysBrandPo brandInfo = this.getMasterCardBrand(integralRecordModel);
            if (!Arrays.asList(MemberConstant.C_361_BRAND).contains(brandInfo.getBrandCode()) && (result2 = this.insertIntegralRecord(integralRecordModel)) < 1) {
                throw new MemberException("\u63d2\u5165\u79ef\u5206\u6d41\u6c34\u5931\u8d25");
            }
        }
        StopWatchTime.stop();
        return ResponseUtil.getSuccessData((Object)1);
    }

    private SysBrandPo getMasterCardBrand(IntegralRecordModel integralRecordModel) {
        Long sysCompanyId = integralRecordModel.getSysCompanyId();
        Long brandId = integralRecordModel.getBrandId();
        ResponseData brandListByCompanyIdResult = this.brandServiceRpc.getBrandListByCompanyId(sysCompanyId);
        List allsysBrandPoList = (List)brandListByCompanyIdResult.getData();
        List collectMaster = allsysBrandPoList.stream().filter(param -> param.getSysBrandId().equals(brandId)).collect(Collectors.toList());
        return (SysBrandPo)collectMaster.get(0);
    }

    private int adjustMemberIntegral(IntegralRecordModel integralRecordModel) {
        MemberInfoModel memberInfoModel = this.getMemberInfoModel(integralRecordModel.getMemberCode());
        IntegralChangeTypeEnum integralChangeTypeEnum = IntegralChangeTypeEnum.getIntegralChangeTypeEnum((String)integralRecordModel.getChangeWay());
        if (integralChangeTypeEnum == null) {
            throw new MemberException("\u672a\u77e5\u7684\u53d8\u66f4\u7c7b\u578b");
        }
        IntegralRecordBusinessTypeVo integralRecordBusinessTypeVo = this.integralRecordBusinessTypeService.findIntegralRecordBusinessTypeVoByCode(BIZVANE_BUSINESS_CODE_PREFIX + integralRecordModel.getBusinessWay(), integralRecordModel.getSysCompanyId());
        if (integralRecordBusinessTypeVo == null) {
            throw new MemberException("\u672a\u77e5\u7684\u4e1a\u52a1\u7c7b\u578b");
        }
        if (BusinessTypeEnum.INTEGER_REST.getCode().equals(integralRecordModel.getBusinessWay())) {
            this.mbrConsumeBehaviorMapper.updateExpiringIntegralByMemberCode(integralRecordModel.getMemberCode(), integralRecordModel.getSysCompanyId(), integralRecordModel.getBrandId(), Integer.valueOf(0), integralRecordModel.getChangeDate());
        }
        Integer countIntegral = memberInfoModel.getCountIntegral();
        Integer addUpIntegral = memberInfoModel.getAddUpIntegral();
        Integer changeIntegral = 0;
        if (integralChangeTypeEnum == IntegralChangeTypeEnum.Expend) {
            changeIntegral = -Math.abs(integralRecordModel.getChangeIntegral());
            if (!BusinessTypeEnum.INTEGER_REST.getCode().equals(integralRecordModel.getBusinessWay())) {
                MembersInfoSearchVo membersInfoSearchVo = new MembersInfoSearchVo();
                membersInfoSearchVo.setMemberCode(integralRecordModel.getMemberCode());
                membersInfoSearchVo.setSysCompanyId(integralRecordModel.getSysCompanyId());
                membersInfoSearchVo.setBrandId(integralRecordModel.getBrandId());
                ArrayList<SearchRangRequest> expireIntegralRanges = new ArrayList<SearchRangRequest>();
                SearchRangRequest aboutExpireIntgralRang = new SearchRangRequest();
                aboutExpireIntgralRang.setMin("1");
                expireIntegralRanges.add(aboutExpireIntgralRang);
                membersInfoSearchVo.setAboutExpireIntegral(expireIntegralRanges);
                PageVo pageVo = new PageVo();
                pageVo.setPageNum(1);
                pageVo.setPageSize(1);
                ResponseData search = this.membersAdvancedSearchService.search(membersInfoSearchVo, pageVo);
                if (search.getData() != null && CollectionUtil.isNotEmpty((Collection)((PageInfo)search.getData()).getList())) {
                    MemberInfoVo memberInfoVo = (MemberInfoVo)((PageInfo)search.getData()).getList().get(0);
                    int expiringIntegral = memberInfoVo.getExpiringIntegral() - integralRecordModel.getChangeIntegral();
                    if (expiringIntegral < 0) {
                        expiringIntegral = 0;
                    }
                    this.mbrConsumeBehaviorMapper.updateExpiringIntegralByMemberCode(integralRecordModel.getMemberCode(), integralRecordModel.getSysCompanyId(), integralRecordModel.getBrandId(), Integer.valueOf(expiringIntegral), null);
                }
            }
        }
        if (integralChangeTypeEnum == IntegralChangeTypeEnum.INCOME) {
            addUpIntegral = addUpIntegral + Math.abs(integralRecordModel.getChangeIntegral());
            changeIntegral = Math.abs(integralRecordModel.getChangeIntegral());
        }
        memberInfoModel.setCountIntegral(countIntegral);
        memberInfoModel.setAddUpIntegral(addUpIntegral);
        memberInfoModel.setConsumeIntegral(changeIntegral);
        memberInfoModel.setModifiedUserId(integralRecordModel.getModifiedUserId());
        memberInfoModel.setModifiedUserName(integralRecordModel.getModifiedUserName());
        memberInfoModel.setModifiedDate(new Date());
        return this.memberInfoMapper.updateIntegral(memberInfoModel);
    }

    private MemberInfoModel getMemberInfoModel(String memberCode) {
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        memberInfoModel = this.memberInfoMapper.findMemberInfoByMemberModel(memberInfoModel);
        return memberInfoModel;
    }

    private int insertIntegralRecord(IntegralRecordModel integralRecordModel) {
        log.info("\u63d2\u5165\u79ef\u5206\u6d41\u6c34\u7684params :{}", (Object)integralRecordModel);
        IntegralChangeTypeEnum integralChangeTypeEnum = IntegralChangeTypeEnum.getIntegralChangeTypeEnum((String)integralRecordModel.getChangeWay());
        Integer changeIntegral = integralRecordModel.getChangeIntegral();
        integralRecordModel.setRecordCode(UUIDUtil.getUuid16());
        if (integralChangeTypeEnum == IntegralChangeTypeEnum.Expend) {
            integralRecordModel.setChangeIntegral(Integer.valueOf(-Math.abs(changeIntegral)));
        }
        if (integralChangeTypeEnum == IntegralChangeTypeEnum.INCOME) {
            integralRecordModel.setChangeIntegral(Integer.valueOf(Math.abs(changeIntegral)));
        }
        Date date = new Date();
        integralRecordModel.setChangeDate(date);
        integralRecordModel.setCreateDate(date);
        integralRecordModel.setModifiedDate(date);
        String onlineStoreCode = integralRecordModel.getOnlineStoreCode();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{onlineStoreCode})) {
            String[] split = onlineStoreCode.split("-");
            integralRecordModel.setOnlineStoreCode(split[0]);
        }
        integralRecordModel.setPointsAmount(this.getMemberInfoModel(integralRecordModel.getMemberCode()).getCountIntegral());
        return this.integralRecordMapper.insertSelective((Object)integralRecordModel);
    }
}

