/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.unifiedreg.service.copy.inner.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.bizvane.appletservice.models.bo.UpdateMemberInfo;
import com.bizvane.appletservice.rpc.CreateMembersCardServiceRpc;
import com.bizvane.channelsservice.models.bo.MemberInfoBo;
import com.bizvane.channelsservice.rpc.TmallServiceFeign;
import com.bizvane.members.facade.enums.BusinessTypeEnum;
import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.po.MbrElectCardMembersPO;
import com.bizvane.members.facade.models.po.MbrElectCardMembersPOExample;
import com.bizvane.members.facade.models.po.MbrElectCardPO;
import com.bizvane.members.facade.models.po.MbrElectCardPOExample;
import com.bizvane.members.facade.models.po.MbrTaoBaoPO;
import com.bizvane.members.facade.models.po.MbrTaoBaoPOExample;
import com.bizvane.members.facade.models.po.MbrUniversalBindChannelExample;
import com.bizvane.members.facade.service.card.request.IntegralChangeRequestModel;
import com.bizvane.members.facade.vo.SyncChangeRequestVo;
import com.bizvane.thirddock.model.vo.CommonWmMemberPerfectVo;
import com.bizvane.thirddock.model.vo.NotifyYouzanIntegralOperateVo;
import com.bizvane.thirddock.model.vo.NotifyYouzanLevelVo;
import com.bizvane.thirddock.service.rpc.CommonWmRpc;
import com.bizvane.thirddock.service.rpc.NotifyYouzanRpc;
import com.bizvane.unifiedreg.service.copy.inner.AsyncToRemoteService;
import com.bizvane.unifiedreg.service.copy.mapper.MbrElectCardMembersPOMapper;
import com.bizvane.unifiedreg.service.copy.mapper.MbrElectCardPOMapper;
import com.bizvane.unifiedreg.service.copy.mapper.MbrTaoBaoPOMapper;
import com.bizvane.unifiedreg.service.copy.mapper.MbrUniversalBindChannelMapper;
import com.bizvane.unifiedreg.service.copy.mapper.MemberInfoMapper;
import com.bizvane.unifiedreg.service.copy.mapper.MemberLevelMapper;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import io.jsonwebtoken.lang.Collections;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AsyncToRemoteServiceImpl
implements AsyncToRemoteService {
    private static final Logger log = LoggerFactory.getLogger(AsyncToRemoteServiceImpl.class);
    @Autowired
    private MemberInfoMapper memberInfoMapper;
    @Autowired
    private MemberLevelMapper memberLevelMapper;
    @Autowired
    private CreateMembersCardServiceRpc createMembersCardServiceRpc;
    @Autowired
    private MbrElectCardPOMapper mbrElectCardPoMapper;
    @Autowired
    private TmallServiceFeign tmallServiceFeign;
    @Autowired
    private MbrTaoBaoPOMapper mbrTaoBaoPoMapper;
    @Autowired
    private MbrElectCardMembersPOMapper mbrElectCardMembersPoMapper;
    @Autowired
    private MbrUniversalBindChannelMapper mbrUniversalBindChannelMapper;
    @Autowired
    NotifyYouzanRpc notifyYouzanRpc;
    @Autowired
    private CommonWmRpc commonWmRpc;
    private final String offlineCompanyCodeHqt = "P40033";
    private final String YZ_INTEGRAL_DEFAULT_CHANGE_DETAILS = "CRM\u53d8\u52a8";

    @Async
    @Transactional
    public void asyncInfoChange(SyncChangeRequestVo integralChangeRequestVo) throws MemberException {
        log.info("enter asyncInfoChange param:{}", (Object)JacksonUtil.bean2Json((Object)integralChangeRequestVo));
        this.syncInfo(integralChangeRequestVo);
    }

    private void syncInfo(SyncChangeRequestVo integralChangeRequestVo) {
        MemberInfoModel searchModel = new MemberInfoModel();
        searchModel.setMemberCode(integralChangeRequestVo.getMemberCode());
        MemberInfoModel memberInfoModel = this.memberInfoMapper.findMemberInfoByMemberModel(searchModel);
        if (memberInfoModel == null) {
            log.error("\u672a\u67e5\u8be2\u5230\u4f1a\u5458\u4fe1\u606f");
            return;
        }
        log.info("\u67e5\u8be2\u5230\u7684\u4f1a\u5458\u4fe1\u606f:{}", (Object)JacksonUtil.bean2Json((Object)memberInfoModel));
        MbrLevelModel levelModel = (MbrLevelModel)this.memberLevelMapper.selectByPrimaryKey((Object)memberInfoModel.getLevelId());
        try {
            this.taobaoSync(memberInfoModel, levelModel);
        }
        catch (Exception e) {
            log.error("taobaoSync", (Throwable)e);
        }
        try {
            this.electCardSync(memberInfoModel, levelModel, integralChangeRequestVo);
        }
        catch (Exception e) {
            log.error("electCardSync", (Throwable)e);
        }
        try {
            this.youzanSync(memberInfoModel, levelModel, integralChangeRequestVo);
        }
        catch (Exception e) {
            log.error("youzanSync", (Throwable)e);
        }
        try {
            this.wmSync(memberInfoModel, levelModel, integralChangeRequestVo);
        }
        catch (Exception e) {
            log.error("wmSync", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private void youzanSync(MemberInfoModel memberInfoModel, MbrLevelModel levelModel, SyncChangeRequestVo integralChangeRequestVo) {
        Integer integralType;
        MbrUniversalBindChannelExample example = new MbrUniversalBindChannelExample();
        example.createCriteria().andChannelTypeEqualTo(Integer.valueOf(3)).andMemberCodeEqualTo(memberInfoModel.getMemberCode()).andBrandIdEqualTo(memberInfoModel.getBrandId()).andSysCompanyIdEqualTo(memberInfoModel.getSysCompanyId());
        List youzanMemberList = this.mbrUniversalBindChannelMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)youzanMemberList)) {
            log.info("\u672a\u67e5\u8be2\u5230\u6709\u8d5e\u4f1a\u5458\u4fe1\u606f,brandId:{},phone:{}", (Object)memberInfoModel.getBrandId(), (Object)memberInfoModel.getPhone());
            return;
        }
        Integer memberLevelType = 2;
        if (memberLevelType.equals(integralChangeRequestVo.getType())) {
            NotifyYouzanLevelVo levelVo = NotifyYouzanLevelVo.builder().phone(memberInfoModel.getPhone()).levelName(levelModel.getLevelName()).sysBrandId(memberInfoModel.getBrandId()).build();
            log.info("\u540c\u6b65\u5230\u6709\u8d5e\u7b49\u7ea7\u4fe1\u606f:{}", (Object)JacksonUtil.bean2Json((Object)levelVo));
            this.notifyYouzanRpc.notifyLevel(levelVo);
        }
        if ((integralType = Integer.valueOf(1)).equals(integralChangeRequestVo.getType())) {
            IntegralChangeRequestModel integralChangeRequestModel = integralChangeRequestVo.getIntegralChangeRequestModel();
            if (!BusinessTypeEnum.YOUZAN_API_EXCHANGE.getCode().equals(integralChangeRequestModel.getBusinessType())) {
                this.asyncYouzanIntegralOperate(integralChangeRequestModel);
            }
        }
    }

    public void asyncYouzanIntegralOperate(IntegralChangeRequestModel integralChangeRequestModel) {
        log.info("AsyncToRemoteServiceImpl#asyncYouzanIntegralOperate180  integralChangeRequestModel:{}", (Object)JSON.toJSONString((Object)integralChangeRequestModel));
        MemberInfoModel memberInfo = this.memberInfoMapper.findMemberInfoByMemberCode(integralChangeRequestModel.getMemberCode());
        NotifyYouzanIntegralOperateVo notifyYouzanIntegralOperateVo = new NotifyYouzanIntegralOperateVo();
        BeanUtils.copyProperties((Object)integralChangeRequestModel, (Object)notifyYouzanIntegralOperateVo);
        notifyYouzanIntegralOperateVo.setChangeIntegral(memberInfo.getCountIntegral());
        if (StringUtils.isBlank((CharSequence)notifyYouzanIntegralOperateVo.getChangeDetails())) {
            BusinessTypeEnum businessTypeEnum = BusinessTypeEnum.getBusinessTypeEnum((String)integralChangeRequestModel.getBusinessType());
            String changeDetails = Optional.ofNullable(businessTypeEnum).map(BusinessTypeEnum::getMsg).orElse("CRM\u53d8\u52a8");
            notifyYouzanIntegralOperateVo.setChangeDetails(changeDetails);
        }
        ResponseData responseData = this.notifyYouzanRpc.notifyIntegral(notifyYouzanIntegralOperateVo);
        log.info("AsyncToRemoteServiceImpl#asyncYouzanIntegralOperate187 responseData:{}", (Object)responseData);
    }

    private void taobaoSync(MemberInfoModel memberInfoModel, MbrLevelModel levelModel) throws MemberException {
        MbrTaoBaoPOExample example = new MbrTaoBaoPOExample();
        MbrTaoBaoPOExample.Criteria criteria = example.createCriteria();
        criteria.andTaobaoMobileEqualTo(memberInfoModel.getPhone());
        criteria.andBrandIdEqualTo(memberInfoModel.getBrandId());
        List taoBaoMemberList = this.mbrTaoBaoPoMapper.selectByExample(example);
        if (taoBaoMemberList == null || taoBaoMemberList.size() == 0) {
            log.info("\u672a\u67e5\u8be2\u5230\u667a\u6167\u95e8\u5e97\u4f1a\u5458\u4fe1\u606f,brandId:{},phone:{}", (Object)memberInfoModel.getBrandId(), (Object)memberInfoModel.getPhone());
            return;
        }
        MbrTaoBaoPO mbrTaoBaoPo = (MbrTaoBaoPO)taoBaoMemberList.get(0);
        try {
            Long.parseLong(levelModel.getTaobaoLevelCode());
            if (memberInfoModel.getCountIntegral() == null) {
                throw new Exception("\u667a\u6167\u95e8\u5e97\u4f1a\u5458\u4fe1\u606f\u540c\u6b65\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.info("\u667a\u6167\u95e8\u5e97\u4f1a\u5458\u4fe1\u606f\u540c\u6b65\u5931\u8d25:{}", (Object)JacksonUtil.bean2Json((Object)mbrTaoBaoPo));
            return;
        }
        log.info("\u540c\u6b65\u6d88\u606f\u5230\u667a\u6167\u95e8\u5e97\uff1a{}", (Object)JacksonUtil.bean2Json((Object)mbrTaoBaoPo));
        MemberInfoBo memberInfoBo = new MemberInfoBo();
        memberInfoBo.setBrandId(memberInfoModel.getBrandId());
        memberInfoBo.setLevel(Long.valueOf(Long.parseLong(levelModel.getTaobaoLevelCode())));
        memberInfoBo.setMobile(mbrTaoBaoPo.getTaobaoMobile());
        memberInfoBo.setNick(mbrTaoBaoPo.getTaobaoNick());
        memberInfoBo.setPoint(Long.valueOf(memberInfoModel.getCountIntegral().longValue()));
        memberInfoBo.setVersion(String.valueOf(System.currentTimeMillis()));
        this.tmallServiceFeign.tmallMemberSync(memberInfoBo);
    }

    private void electCardSync(MemberInfoModel memberInfoModel, MbrLevelModel levelModel, SyncChangeRequestVo integralChangeRequestVo) throws MemberException {
        MbrElectCardPOExample example = new MbrElectCardPOExample();
        MbrElectCardPOExample.Criteria criteria = example.createCriteria();
        criteria.andSysBrandIdEqualTo(memberInfoModel.getBrandId());
        List mbrElectCardList = this.mbrElectCardPoMapper.selectByExample(example);
        if (Collections.isEmpty((Collection)mbrElectCardList)) {
            log.info("\u672a\u67e5\u8be2\u5230\u7535\u5b50\u4f1a\u5458\u5361\u5361\u5957\u4fe1\u606f:brandId:{}", (Object)memberInfoModel.getBrandId());
            return;
        }
        MbrElectCardPO electCardPo = (MbrElectCardPO)mbrElectCardList.get(0);
        String[] displays = electCardPo.getDisplayEquity().split(",");
        List<String> displaysList = Arrays.asList(displays);
        UpdateMemberInfo updateMemberInfo = new UpdateMemberInfo();
        MbrElectCardMembersPOExample electCardExample = new MbrElectCardMembersPOExample();
        MbrElectCardMembersPOExample.Criteria electCardCriteria = electCardExample.createCriteria();
        electCardCriteria.andMemberCodeEqualTo(memberInfoModel.getMemberCode());
        List electCardMemberList = this.mbrElectCardMembersPoMapper.selectByExample(electCardExample);
        if (Collections.isEmpty((Collection)electCardMemberList)) {
            log.info("\u672a\u67e5\u8be2\u5230\u4f1a\u5458\u7684\u7535\u5b50\u4f1a\u5458\u5361\u4fe1\u606f:memberCode:{}", (Object)memberInfoModel.getMemberCode());
            return;
        }
        MbrElectCardMembersPO mbrElectCardMembersPo = (MbrElectCardMembersPO)electCardMemberList.get(0);
        updateMemberInfo.setCode(mbrElectCardMembersPo.getWechatElectronicCardCode());
        updateMemberInfo.setSysBrandId(memberInfoModel.getBrandId());
        updateMemberInfo.setCard_id(electCardPo.getCardId());
        int type = integralChangeRequestVo.getType() == null ? 0 : integralChangeRequestVo.getType();
        switch (type) {
            case 1: {
                this.electCardIntegralChange(memberInfoModel, displaysList, updateMemberInfo);
                break;
            }
            case 2: {
                this.electCardLevelChange(levelModel, displaysList, updateMemberInfo);
                break;
            }
            default: {
                this.electCardIntegralChange(memberInfoModel, displaysList, updateMemberInfo);
                this.electCardLevelChange(levelModel, displaysList, updateMemberInfo);
            }
        }
        log.info("\u540c\u6b65\u6d88\u606f\u5230\u7535\u5b50\u4f1a\u5458\u5361:updateMemberInfo:{}", (Object)JacksonUtil.bean2Json((Object)updateMemberInfo));
        this.createMembersCardServiceRpc.updateMemberIntegral(updateMemberInfo);
    }

    private void electCardIntegralChange(MemberInfoModel memberInfoModel, List<String> displaysList, UpdateMemberInfo updateMemberInfo) {
        int integralIndex = displaysList.indexOf("\u79ef\u5206");
        String offlineCompanyCode = memberInfoModel.getOfflineCompanyCode() != null ? memberInfoModel.getOfflineCompanyCode() : "";
        UpdateMemberInfo.NotifyOptional notifyOptional = new UpdateMemberInfo.NotifyOptional();
        String countIntegral = memberInfoModel.getCountIntegral() != null ? memberInfoModel.getCountIntegral().toString() : "0";
        switch (integralIndex) {
            case 0: {
                if ("P40033".equals(offlineCompanyCode)) {
                    notifyOptional.setIs_notify_custom_field1(Boolean.valueOf(true));
                    updateMemberInfo.setNotify_optional(notifyOptional);
                }
                updateMemberInfo.setCustom_field_value1(countIntegral);
                break;
            }
            case 1: {
                if ("P40033".equals(offlineCompanyCode)) {
                    notifyOptional.setIs_notify_custom_field2(Boolean.valueOf(true));
                    updateMemberInfo.setNotify_optional(notifyOptional);
                }
                updateMemberInfo.setCustom_field_value2(countIntegral);
                break;
            }
            case 3: {
                if ("P40033".equals(offlineCompanyCode)) {
                    notifyOptional.setIs_notify_custom_field2(Boolean.valueOf(true));
                    updateMemberInfo.setNotify_optional(notifyOptional);
                }
                updateMemberInfo.setCustom_field_value2(countIntegral);
                break;
            }
        }
    }

    private void electCardLevelChange(MbrLevelModel levelModel, List<String> displaysList, UpdateMemberInfo updateMemberInfo) {
        int levelIndex = displaysList.indexOf("\u7b49\u7ea7");
        switch (levelIndex) {
            case 0: {
                updateMemberInfo.setCustom_field_value1(levelModel.getLevelName());
                break;
            }
            case 1: {
                updateMemberInfo.setCustom_field_value2(levelModel.getLevelName());
                break;
            }
            case 3: {
                updateMemberInfo.setCustom_field_value2(levelModel.getLevelName());
                break;
            }
        }
    }

    public void syncInfoChange(SyncChangeRequestVo integralChangeRequestVo) throws MemberException {
        log.info("enter asyncInfoChange param:{}", (Object)JacksonUtil.bean2Json((Object)integralChangeRequestVo));
        this.syncInfo(integralChangeRequestVo);
    }

    private void wmSync(MemberInfoModel memberInfoModel, MbrLevelModel levelModel, SyncChangeRequestVo integralChangeRequestVo) {
        MbrUniversalBindChannelExample example = new MbrUniversalBindChannelExample();
        example.createCriteria().andChannelTypeEqualTo(Integer.valueOf(2)).andMemberCodeEqualTo(memberInfoModel.getMemberCode()).andBrandIdEqualTo(memberInfoModel.getBrandId()).andSysCompanyIdEqualTo(memberInfoModel.getSysCompanyId());
        List wmMemberList = this.mbrUniversalBindChannelMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)wmMemberList)) {
            log.info("\u672a\u67e5\u8be2\u5230\u5fae\u76df\u4f1a\u5458\u4fe1\u606f,brandId:{},phone:{}", (Object)memberInfoModel.getBrandId(), (Object)memberInfoModel.getPhone());
            return;
        }
        Integer memberPerfectType = 4;
        if (memberPerfectType.equals(integralChangeRequestVo.getType())) {
            CommonWmMemberPerfectVo perfectVo = CommonWmMemberPerfectVo.builder().sysBrandId(memberInfoModel.getBrandId()).phone(memberInfoModel.getPhone()).gender(Integer.valueOf(memberInfoModel.getGender())).name(memberInfoModel.getName()).birthday(DateUtil.format((Date)memberInfoModel.getBirthday(), (String)"yyyy-MM-dd")).build();
            log.info("\u540c\u6b65\u5230\u5fae\u76df\u4f1a\u5458\u4fe1\u606f:{}", (Object)JacksonUtil.bean2Json((Object)perfectVo));
            this.commonWmRpc.notifyMemberPerfect(perfectVo);
        }
    }
}

