/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.unifiedreg.service.copy.impl;

import cn.hutool.core.date.DateUtil;
import com.bizvane.appletservice.rpc.ClearRedisCacheServiceRpc;
import com.bizvane.centerstageservice.models.po.SysStaffPo;
import com.bizvane.centerstageservice.models.vo.SysStoreVo;
import com.bizvane.centerstageservice.rpc.StaffServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.MemberInfoUpdateRequestVO;
import com.bizvane.connectorservice.entity.common.MemberLoginRequestVO;
import com.bizvane.connectorservice.entity.common.MemberLoginResponseVO;
import com.bizvane.connectorservice.entity.common.MemberOpenCardRequestVO;
import com.bizvane.connectorservice.entity.common.MemberOpenCardResponseVO;
import com.bizvane.members.facade.constants.MemberConstant;
import com.bizvane.members.facade.enums.CardStatusEnum;
import com.bizvane.members.facade.enums.FirstLandEnum;
import com.bizvane.members.facade.enums.GeneralizeChannelEnum;
import com.bizvane.members.facade.enums.MemberFromEnum;
import com.bizvane.members.facade.enums.OpenCardChannelEnum;
import com.bizvane.members.facade.enums.OpenCardSceneEnum;
import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.members.facade.models.MbrWxChannelModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.MembersSysModel;
import com.bizvane.members.facade.service.card.response.PushMbrModel;
import com.bizvane.members.facade.ur.vo.UrMemberCardRequestVo;
import com.bizvane.members.facade.ur.vo.UrMemberCardResponseVo;
import com.bizvane.members.facade.ur.vo.UrMemberQueryRequestVo;
import com.bizvane.members.facade.ur.vo.UrMemberQueryResponseVo;
import com.bizvane.members.facade.ur.vo.UrMemberUnbindRequestVo;
import com.bizvane.members.facade.ur.vo.UrMemberUpdateInfoRequestVo;
import com.bizvane.members.facade.ur.vo.UrMemberUpdateInfoResponseVo;
import com.bizvane.members.facade.ur.vo.UrMemberUpdatePhoneRequestVo;
import com.bizvane.members.facade.ur.vo.UrMemberUpdatePhoneResponseVo;
import com.bizvane.messagefacade.models.vo.MemberMessageVO;
import com.bizvane.unifiedreg.rpc.UrOpenCardApiService;
import com.bizvane.unifiedreg.service.copy.MemberCommonMqUtilService;
import com.bizvane.unifiedreg.service.copy.MqAsyncSendDataToOfflineService;
import com.bizvane.unifiedreg.service.copy.mapper.MbrWxChannelMapper;
import com.bizvane.unifiedreg.service.copy.mapper.MemberInfoMapper;
import com.bizvane.unifiedreg.service.copy.mapper.MemberLevelMapper;
import com.bizvane.unifiedreg.service.copy.mapper.MemberSysMapper;
import com.bizvane.unifiedreg.service.copy.outer.ConnectorInterfaceTransform;
import com.bizvane.unifiedreg.service.copy.outer.MessageInterfaceTransform;
import com.bizvane.unifiedreg.tools.CollectionUtil;
import com.bizvane.unifiedreg.tools.ParamValidation;
import com.bizvane.unifiedreg.tools.ResponseUtil;
import com.bizvane.unifiedreg.tools.UUIDUtil;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UrOpenCardApiServiceImpl
implements UrOpenCardApiService {
    private static final Logger log = LoggerFactory.getLogger(UrOpenCardApiServiceImpl.class);
    @Autowired
    private MemberInfoMapper memberInfoMapper;
    @Autowired
    private MemberLevelMapper memberLevelMapper;
    @Autowired
    private MemberSysMapper memberSysMapper;
    @Autowired
    private StaffServiceRpc staffServiceRpc;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private ConnectorInterfaceTransform connectorInterfaceTransform;
    @Autowired
    private MessageInterfaceTransform messageInterfaceTransform;
    @Autowired
    private MqAsyncSendDataToOfflineService mqAsyncSendDataToOfflineService;
    @Autowired
    private MbrWxChannelMapper mbrWxChannelMapper;
    @Autowired
    private MemberCommonMqUtilService memberCommonMqUtilService;
    @Autowired
    private ClearRedisCacheServiceRpc clearRedisCacheServiceRpc;

    public ResponseData<UrMemberCardResponseVo> memberRegister(@RequestBody @Valid UrMemberCardRequestVo urMemberCardRequestVo) {
        log.info("enter ur memberRegister param:{}", (Object)JacksonUtil.bean2Json((Object)urMemberCardRequestVo));
        ParamValidation.paramsValidate((Object[])new Object[]{urMemberCardRequestVo.getMobileTel()});
        MemberInfoModel searchMemberInfoModel = new MemberInfoModel();
        searchMemberInfoModel.setPhone(urMemberCardRequestVo.getMobileTel());
        searchMemberInfoModel.setBrandId(urMemberCardRequestVo.getBrandId());
        MemberInfoModel memberInfoModel = this.memberInfoMapper.findMemberInfoByMemberModel(searchMemberInfoModel);
        if (memberInfoModel != null) {
            log.info("\u624b\u673a\u53f7\u5df2\u6ce8\u518c:{}", (Object)JacksonUtil.bean2Json((Object)memberInfoModel));
            return ResponseUtil.getFailedData(null, (String)"\u624b\u673a\u53f7\u5df2\u6ce8\u518c");
        }
        MembersSysModel membersSysModel = this.memberSysMapper.selectByBrandId(urMemberCardRequestVo.getBrandId().longValue());
        if (membersSysModel == null) {
            log.error("\u4f1a\u5458\u5361\u5236\u5ea6\u672a\u914d\u7f6e");
            return ResponseUtil.getFailedData(null, (String)"\u4f1a\u5458\u5361\u5236\u5ea6\u672a\u914d\u7f6e");
        }
        ResponseData memberInfoModelResponseData = this.mapperUrMemberCardRequestVoToMemberInfo(urMemberCardRequestVo, membersSysModel);
        if (memberInfoModelResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            return ResponseUtil.getFailedData(null, (String)memberInfoModelResponseData.getMessage());
        }
        memberInfoModel = (MemberInfoModel)memberInfoModelResponseData.getData();
        log.info("\u7ebf\u4e0b\u767b\u5f55\u67e5\u8be2\u4f1a\u5458\u662f\u5426\u5b58\u5728");
        Result result = this.offlineLoginResult(urMemberCardRequestVo.getBrandId(), urMemberCardRequestVo.getMobileTel());
        if (result == null) {
            log.error("\u8c03\u7528\u7ebf\u4e0b\u767b\u5f55\u63a5\u53e3\u5f02\u5e38\uff0c\u7ebf\u4e0b\u8fd4\u56denull");
            return ResponseUtil.getFailedData(null, (String)"\u8c03\u7528\u7ebf\u4e0b\u767b\u5f55\u63a5\u53e3\u5f02\u5e38\uff0c\u7ebf\u4e0b\u8fd4\u56denull");
        }
        if (result.getCode().intValue() == SysResponseEnum.SUCCESS.getCode()) {
            MemberLoginResponseVO memberLoginResponseVO = (MemberLoginResponseVO)result.getData();
            ResponseData modelResponseData = this.offlineExist(memberInfoModel, memberLoginResponseVO);
            if (modelResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
                return ResponseUtil.getFailedData(null, (String)modelResponseData.getMessage());
            }
            return ResponseUtil.getSuccessData(null);
        }
        if (MemberConstant.REGISTER_CARD.intValue() != result.getCode().intValue()) {
            log.error("\u7ebf\u4e0b\u767b\u5f55\u5f02\u5e38");
            return ResponseUtil.getFailedData(null, (String)"\u7ebf\u4e0b\u767b\u5f55\u5f02\u5e38");
        }
        log.info("\u7ebf\u4e0b\u4e0d\u5b58\u5728\u7ee7\u7eed\u5f00\u5361");
        log.info("\u7ebf\u4e0b\u6ce8\u518c\u4f1a\u5458");
        ResponseData memberOpenCardResponseVoResponseData = this.registerToOffline(memberInfoModel, urMemberCardRequestVo);
        if (memberOpenCardResponseVoResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            log.error("\u8c03\u7528\u7ebf\u4e0b\u767b\u5f55\u63a5\u53e3\u5f02\u5e38\uff0c\u7ebf\u4e0b\u8fd4\u56denull");
            return ResponseUtil.getFailedData(null, (String)"\u8c03\u7528\u7ebf\u4e0b\u767b\u5f55\u63a5\u53e3\u5f02\u5e38\uff0c\u7ebf\u4e0b\u8fd4\u56denull");
        }
        MemberOpenCardResponseVO memberOpenCardResponseVO = (MemberOpenCardResponseVO)memberOpenCardResponseVoResponseData.getData();
        this.onlineAfterRegister(memberOpenCardResponseVO, memberInfoModel);
        this.sendMemberRegisterMsg(memberInfoModel);
        return ResponseUtil.getSuccessData(null);
    }

    protected ResponseData<MemberInfoModel> mapperUrMemberCardRequestVoToMemberInfo(UrMemberCardRequestVo urMemberCardRequestVo, MembersSysModel membersSysModel) {
        Long openCardStoreId;
        ResponseData responseData;
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        Long brandId = urMemberCardRequestVo.getBrandId();
        Long sysCompanyId = urMemberCardRequestVo.getSysCompanyId();
        memberInfoModel.setOfflineCompanyCode(urMemberCardRequestVo.getOfflineCompanyCode());
        memberInfoModel.setOfflineBrandCode(urMemberCardRequestVo.getOfflineBrandCode());
        memberInfoModel.setSysCompanyId(sysCompanyId);
        memberInfoModel.setBrandId(brandId);
        memberInfoModel.setPhone(urMemberCardRequestVo.getMobileTel());
        memberInfoModel.setName(urMemberCardRequestVo.getCustomerName());
        memberInfoModel.setRegisterType(urMemberCardRequestVo.getRegisterType());
        if (urMemberCardRequestVo.getSex() == null) {
            memberInfoModel.setGender("3");
        } else {
            switch (urMemberCardRequestVo.getSex()) {
                case 1: {
                    memberInfoModel.setGender("1");
                    break;
                }
                case 0: {
                    memberInfoModel.setGender("2");
                    break;
                }
                default: {
                    memberInfoModel.setGender("3");
                }
            }
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        if (StringUtils.isNotBlank((CharSequence)urMemberCardRequestVo.getBirthday())) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMdd");
            try {
                memberInfoModel.setBirthday(sd.parse(urMemberCardRequestVo.getBirthday()));
                memberInfoModel.setBirthdayMd(simpleDateFormat.format(memberInfoModel.getBirthday()));
            }
            catch (Exception e) {
                log.error("\u751f\u65e5\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                return ResponseUtil.getFailedData(null, (String)"\u751f\u65e5\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38");
            }
        }
        memberInfoModel.setWxOpenId(urMemberCardRequestVo.getWxOpenId());
        memberInfoModel.setOpenCardStoreCode(urMemberCardRequestVo.getShopId());
        memberInfoModel.setServiceStoreCode(urMemberCardRequestVo.getStoreId());
        if (urMemberCardRequestVo.getShopId() != null) {
            responseData = this.storeServiceRpc.getStoreIdByCodeAndBrandId(urMemberCardRequestVo.getShopId(), urMemberCardRequestVo.getBrandId());
            if (responseData == null || SysResponseEnum.SUCCESS.getCode() != responseData.getCode()) {
                log.error("\u4e2d\u53f0\u63a5\u53e3\u67e5\u5e97\u94fa\u51fa\u95ee\u9898");
                return ResponseUtil.getFailedData(null, (String)"\u4e2d\u53f0\u63a5\u53e3\u67e5\u5e97\u94fa\u5931\u8d25");
            }
            openCardStoreId = (Long)responseData.getData();
            if (openCardStoreId == null) {
                log.error("\u7ebf\u4e0a\u95e8\u5e97\u672a\u914d\u7f6ecode:{}", (Object)urMemberCardRequestVo.getShopId());
                return ResponseUtil.getFailedData(null, (String)"\u7ebf\u4e0a\u95e8\u5e97\u672a\u914d\u7f6e\u8be5code");
            }
        } else {
            log.info("\u4f7f\u7528\u9ed8\u8ba4\u5f00\u5361\u95e8\u5e97:{}", (Object)membersSysModel.getOpenCardStoreId());
            openCardStoreId = membersSysModel.getOpenCardStoreId();
        }
        memberInfoModel.setOpenCardStoreId(openCardStoreId);
        if (urMemberCardRequestVo.getStoreId() != null) {
            responseData = this.storeServiceRpc.getStoreIdByCodeAndBrandId(urMemberCardRequestVo.getStoreId(), urMemberCardRequestVo.getBrandId());
            if (responseData == null || SysResponseEnum.SUCCESS.getCode() != responseData.getCode()) {
                log.error("\u4e2d\u53f0\u63a5\u53e3\u67e5\u5e97\u94fa\u51fa\u95ee\u9898");
                return ResponseUtil.getFailedData(null, (String)"\u4e2d\u53f0\u63a5\u53e3\u67e5\u5e97\u94fa\u5931\u8d25");
            }
            if (responseData.getData() != null) {
                memberInfoModel.setServiceStoreId((Long)responseData.getData());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)urMemberCardRequestVo.getCardTypeId())) {
            Long levelId = this.memberLevelMapper.queryLevelIdByOfflineCode(urMemberCardRequestVo.getCardTypeId(), brandId);
            memberInfoModel.setLevelId(levelId);
            memberInfoModel.setOfflineLevelCode(urMemberCardRequestVo.getCardTypeId());
        } else {
            memberInfoModel.setLevelId(membersSysModel.getNewLevelId());
            if (membersSysModel.getNewLevelId() != null) {
                MbrLevelModel mbrLevelModel = this.memberLevelMapper.queryLevelBasicInfo(membersSysModel.getNewLevelId());
                memberInfoModel.setOfflineLevelCode(mbrLevelModel.getOfflineLevelCode());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)urMemberCardRequestVo.getOpenStatus())) {
            memberInfoModel.setValid(Integer.valueOf(Integer.parseInt(urMemberCardRequestVo.getOpenStatus())));
        }
        if (StringUtils.isNotBlank((CharSequence)urMemberCardRequestVo.getEffectiveTime())) {
            try {
                memberInfoModel.setEffectiveTime(sd.parse(urMemberCardRequestVo.getEffectiveTime()));
            }
            catch (Exception e) {
                log.error("\u6709\u6548\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                return ResponseUtil.getFailedData(null, (String)"\u6709\u6548\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38");
            }
        }
        memberInfoModel.setCountIntegral(urMemberCardRequestVo.getPoints());
        memberInfoModel.setMemberSysId(membersSysModel.getMemberSysDefId());
        memberInfoModel.setGeneralizeChannel(GeneralizeChannelEnum.NO.getMsg());
        log.info("mapperUrMemberCardRequestVoToMemberInfo :{}", (Object)JacksonUtil.bean2Json((Object)memberInfoModel));
        return ResponseUtil.getSuccessData((Object)memberInfoModel);
    }

    protected Result<MemberLoginResponseVO> offlineLoginResult(Long brandId, String phone) {
        MemberLoginRequestVO memberLoginRequestVO = new MemberLoginRequestVO();
        memberLoginRequestVO.setBrandId(brandId);
        memberLoginRequestVO.setPhone(phone);
        Result result = this.connectorInterfaceTransform.getOfflineLoginResult(memberLoginRequestVO);
        log.info("\u8c03\u7528\u7ebf\u4e0b\u767b\u5f55\u63a5\u53e3\u53c2\u6570:{}\uff0c\u8fd4\u56de\u7ed3\u679c:{}", (Object)JacksonUtil.bean2Json((Object)memberLoginRequestVO), (Object)JacksonUtil.bean2Json((Object)result));
        return result;
    }

    private ResponseData<MemberInfoModel> offlineExist(MemberInfoModel memberInfoModel, MemberLoginResponseVO memberLoginResponseVO) {
        memberInfoModel.setMemberCode(UUIDUtil.getUuid16());
        memberInfoModel.setGeneralizeChannel(GeneralizeChannelEnum.NO.getMsg());
        memberInfoModel.setCardNo(memberLoginResponseVO.getOfflineCardNo());
        memberInfoModel.setOfflineCardNo(memberLoginResponseVO.getOfflineCardNo());
        memberInfoModel.setProvince(memberLoginResponseVO.getProvince());
        memberInfoModel.setCity(memberLoginResponseVO.getCity());
        memberInfoModel.setCounty(memberLoginResponseVO.getCounty());
        memberInfoModel.setAddress(memberLoginResponseVO.getAddress());
        memberInfoModel.setErpId(memberLoginResponseVO.getErpId());
        memberInfoModel.setOpenCardChannelId(OpenCardChannelEnum.OFFLINE_CHANNEL.getCode());
        ArrayList list = new ArrayList();
        Collections.addAll(list, OpenCardChannelEnum.OFFLINE_CHANNEL.getCode().toString());
        String allChannelIds = CollectionUtil.convertListToString(list, (String)",");
        memberInfoModel.setAllChannelIds(allChannelIds);
        memberInfoModel.setFirstLandingCheck(FirstLandEnum.FIRST_LAND.getCode());
        Date date = new Date();
        memberInfoModel.setCreateDate(date);
        memberInfoModel.setModifiedDate(date);
        memberInfoModel.setCardStatus(CardStatusEnum.NOT_BIND_CARD.getCode());
        memberInfoModel.setOpenCardTime(date);
        if (memberInfoModel.getServiceGuideId() != null) {
            memberInfoModel.setMembersFrom(MemberFromEnum.MEMBER_FROM_OFFLINE.getMsg());
            memberInfoModel.setDateFrom(date);
        }
        log.info("\u63d2\u5165\u5230\u4f1a\u5458\u8868\u4e2d\u7684\u4fe1\u606f\uff1amemberInfoModel:{}", (Object)memberInfoModel);
        memberInfoModel.setOpenCardScene(OpenCardSceneEnum.BIND_CARD.getCode());
        int result = this.memberInfoMapper.insertMemberInfo(memberInfoModel);
        if (result < 1) {
            log.error("\u63d2\u5165\u7ebf\u4e0a\u4f1a\u5458\u6570\u636e\u5931\u8d25");
            return ResponseUtil.getFailedData(null, (String)"\u5199\u5165\u63d2\u5165\u7ebf\u4e0a\u4f1a\u5458\u6570\u636e\u5931\u8d25");
        }
        return ResponseUtil.getSuccessData((Object)memberInfoModel);
    }

    private void sendMemberRegisterMsg(MemberInfoModel memberInfoModel) {
        SysStoreVo storeVo;
        log.info("enter sendMemberRegisterMsg param:{}", (Object)JacksonUtil.bean2Json((Object)memberInfoModel));
        MemberMessageVO memberMessageVo = new MemberMessageVO();
        memberMessageVo.setMemberCode(memberInfoModel.getMemberCode());
        memberMessageVo.setOpenId(null);
        memberMessageVo.setLevelName(memberInfoModel.getLevelName());
        memberMessageVo.setOriginLevelName(memberInfoModel.getLevelName());
        memberMessageVo.setChannelName(OpenCardChannelEnum.OTHER_CHANNEL.getMsg());
        memberMessageVo.setDate(new Date());
        memberMessageVo.setBrandName("UR");
        memberMessageVo.setMemberName(memberInfoModel.getName());
        memberMessageVo.setNowLevelMember(memberInfoModel.getLevelName());
        memberMessageVo.setPubNum("");
        memberMessageVo.setMemberPhone(memberInfoModel.getPhone());
        memberMessageVo.setSysBrandId(memberInfoModel.getBrandId());
        memberMessageVo.setSendWxmember("1");
        if (memberInfoModel.getServiceStoreId() != null && (storeVo = (SysStoreVo)this.storeServiceRpc.getSysStoreById(memberInfoModel.getServiceStoreId()).getData()) != null) {
            memberMessageVo.setStoresName(storeVo.getStoreName());
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        memberMessageVo.setInviteRegisterTime(sd.format(new Date()));
        memberMessageVo.setIntegral(memberInfoModel.getCountIntegral() != null ? memberInfoModel.getCountIntegral().toString() : null);
        memberMessageVo.setSysCompanyId(memberInfoModel.getSysCompanyId());
        memberMessageVo.setCardNumber(memberInfoModel.getCardNo());
        log.info("sendRegisterMessage param:{}", (Object)JacksonUtil.bean2Json((Object)memberMessageVo));
        String returnStr = this.messageInterfaceTransform.sendRegisterMessage(memberMessageVo);
        log.info("sendRegisterMessage result:{}", (Object)JacksonUtil.bean2Json((Object)returnStr));
    }

    private ResponseData<MemberOpenCardResponseVO> registerToOffline(MemberInfoModel memberInfoModel, UrMemberCardRequestVo urMemberCardRequestVo) {
        MemberOpenCardRequestVO memberOpenCardRequestVO = new MemberOpenCardRequestVO();
        memberOpenCardRequestVO.setRegisterType(urMemberCardRequestVo.getRegisterType() != null ? urMemberCardRequestVo.getRegisterType().toString() : null);
        memberOpenCardRequestVO.setAddress(memberInfoModel.getAddress());
        memberOpenCardRequestVO.setCity(memberInfoModel.getCity());
        memberOpenCardRequestVO.setCounty(memberInfoModel.getCounty());
        memberOpenCardRequestVO.setGender(urMemberCardRequestVo.getSex());
        SimpleDateFormat sd = new SimpleDateFormat("yyyyMMdd");
        if (memberInfoModel.getBirthday() != null) {
            memberOpenCardRequestVO.setBirthday(sd.format(memberInfoModel.getBirthday()));
        }
        if (memberInfoModel.getEffectiveTime() != null) {
            memberOpenCardRequestVO.setEffectiveTime(sd.format(memberInfoModel.getEffectiveTime()));
        }
        memberOpenCardRequestVO.setLevelCode(memberInfoModel.getOfflineLevelCode());
        memberOpenCardRequestVO.setName(memberInfoModel.getName());
        memberOpenCardRequestVO.setOpenId(memberInfoModel.getWxOpenId());
        memberOpenCardRequestVO.setPhone(memberInfoModel.getPhone());
        memberOpenCardRequestVO.setProvince(memberInfoModel.getProvince());
        memberOpenCardRequestVO.setUnionId(memberInfoModel.getWxUnionId());
        memberOpenCardRequestVO.setBrandId(memberInfoModel.getBrandId());
        memberOpenCardRequestVO.setOfflineBrandCode(memberInfoModel.getOfflineBrandCode());
        memberOpenCardRequestVO.setOpenGuideCode(memberInfoModel.getOpenCardGuideCode());
        memberOpenCardRequestVO.setOpenStoreCode(memberInfoModel.getOpenCardStoreCode());
        memberOpenCardRequestVO.setServiceStoreCode(memberInfoModel.getServiceStoreCode());
        Result result = this.connectorInterfaceTransform.getOfflineRegisterResult(memberOpenCardRequestVO);
        log.info("\u8c03\u7528\u7ebf\u4e0b\u6ce8\u518c\u63a5\u53e3\u53c2\u6570:{}\uff0c\u8fd4\u56de\u7ed3\u679c:{}", (Object)JacksonUtil.bean2Json((Object)memberOpenCardRequestVO), (Object)JacksonUtil.bean2Json((Object)result));
        if (result == null) {
            log.error("\u8c03\u7528\u7ebf\u4e0b\u6ce8\u518c\u63a5\u53e3\u5931\u8d25\uff0c\u8fd4\u56de\u503c\u4e3a\u7a7a");
            return ResponseUtil.getFailedData(null, (String)"\u8c03\u7528\u7ebf\u4e0b\u6ce8\u518c\u63a5\u53e3\u5931\u8d25\uff0c\u8fd4\u56de\u503c\u4e3a\u7a7a");
        }
        if (result.getCode().intValue() != SysResponseEnum.SUCCESS.getCode()) {
            log.error("\u8c03\u7528\u8fde\u63a5\u5668\u6ce8\u518c\u63a5\u53e3\u5931\u8d25,\u8bf7\u6c42\u53c2\u6570\uff1a" + JacksonUtil.bean2Json((Object)memberOpenCardRequestVO) + "\uff0c\u8fde\u63a5\u5668\u8fd4\u56de:" + JacksonUtil.bean2Json((Object)result));
            return ResponseUtil.getFailedData(null, (String)("\u8c03\u7528\u8fde\u63a5\u5668\u6ce8\u518c\u63a5\u53e3\u5931\u8d25,\u8bf7\u6c42\u53c2\u6570\uff1a" + JacksonUtil.bean2Json((Object)memberOpenCardRequestVO) + "\uff0c\u8fde\u63a5\u5668\u8fd4\u56de:" + JacksonUtil.bean2Json((Object)result)));
        }
        return ResponseUtil.getSuccessData((Object)result.getData());
    }

    private void onlineAfterRegister(MemberOpenCardResponseVO memberOpenCardResponseVO, MemberInfoModel memberInfoModel) {
        memberInfoModel.setErpId(memberOpenCardResponseVO.getErpId());
        memberInfoModel.setCardNo(memberOpenCardResponseVO.getOfflineCardNo());
        memberInfoModel.setOfflineCardNo(memberOpenCardResponseVO.getOfflineCardNo());
        memberInfoModel.setAddress(memberOpenCardResponseVO.getAddress());
        memberInfoModel.setCity(memberOpenCardResponseVO.getCity());
        memberInfoModel.setProvince(memberOpenCardResponseVO.getProvince());
        memberInfoModel.setCounty(memberOpenCardResponseVO.getCounty());
        memberInfoModel.setMemberCode(UUIDUtil.getUuid16());
        memberInfoModel.setOpenCardScene(OpenCardSceneEnum.DEFAULT.getCode());
        Date date = new Date();
        memberInfoModel.setOpenCardTime(date);
        memberInfoModel.setCreateDate(date);
        memberInfoModel.setModifiedDate(date);
        memberInfoModel.setOpenCardChannelId(OpenCardChannelEnum.OFFLINE_CHANNEL.getCode());
        ArrayList list = new ArrayList();
        Collections.addAll(list, OpenCardChannelEnum.OFFLINE_CHANNEL.getCode().toString());
        String allChannelIds = CollectionUtil.convertListToString(list, (String)",");
        memberInfoModel.setAllChannelIds(allChannelIds);
        memberInfoModel.setCardStatus(CardStatusEnum.NOT_BIND_CARD.getCode());
        memberInfoModel.setFirstLandingCheck(FirstLandEnum.FIRST_LAND.getCode());
        log.info("\u63d2\u5165\u5230\u4f1a\u5458\u8868\u4e2d\u7684\u4fe1\u606f\uff1amemberInfoModel:{}", (Object)memberInfoModel);
        int result = this.memberInfoMapper.insertMemberInfo(memberInfoModel);
        if (result < 1) {
            throw new MemberException("\u63d2\u5165\u7ebf\u4e0a\u4f1a\u5458\u6570\u636e\u5931\u8d25");
        }
    }

    public ResponseData<UrMemberQueryResponseVo> memberQuery(@RequestBody @Valid UrMemberQueryRequestVo urMemberQueryRequestVo) throws Exception {
        MbrWxChannelModel wxChannelModel;
        ResponseData res;
        log.info("enter memberQuery param:{}", (Object)JacksonUtil.bean2Json((Object)urMemberQueryRequestVo));
        if (StringUtils.isBlank((CharSequence)urMemberQueryRequestVo.getCardCode()) && StringUtils.isBlank((CharSequence)urMemberQueryRequestVo.getMobileTel()) && StringUtils.isBlank((CharSequence)urMemberQueryRequestVo.getWxOpenID()) && StringUtils.isBlank((CharSequence)urMemberQueryRequestVo.getUnionid())) {
            return ResponseUtil.getSuccessData(null, (String)"\u4f1a\u5458\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isBlank((CharSequence)urMemberQueryRequestVo.getCardCode())) {
            urMemberQueryRequestVo.setCardCode(null);
        }
        if (StringUtils.isBlank((CharSequence)urMemberQueryRequestVo.getMobileTel())) {
            urMemberQueryRequestVo.setMobileTel(null);
        }
        MemberInfoModel searchModel = new MemberInfoModel();
        searchModel.setSysCompanyId(urMemberQueryRequestVo.getSysCompanyId());
        searchModel.setBrandId(urMemberQueryRequestVo.getBrandId());
        searchModel.setPhone(urMemberQueryRequestVo.getMobileTel());
        searchModel.setCardNo(urMemberQueryRequestVo.getCardCode());
        searchModel.setWxOpenId(urMemberQueryRequestVo.getWxOpenID());
        searchModel.setWxUnionId(urMemberQueryRequestVo.getUnionid());
        MemberInfoModel memberInfoModel = this.memberInfoMapper.queryUrMemberInfo(searchModel);
        if (memberInfoModel == null) {
            log.info("\u4f1a\u5458\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return ResponseUtil.getSuccessData(null, (String)"\u4f1a\u5458\u4e0d\u5b58\u5728");
        }
        UrMemberQueryResponseVo responseVo = new UrMemberQueryResponseVo();
        responseVo.setId(memberInfoModel.getMbrMemberId());
        responseVo.setVipId(memberInfoModel.getErpId());
        responseVo.setNameVip(memberInfoModel.getName());
        responseVo.setRegisterType(memberInfoModel.getRegisterType());
        switch (memberInfoModel.getGender()) {
            case "1": {
                responseVo.setSexVip("1");
                break;
            }
            case "2": {
                responseVo.setSexVip("0");
                break;
            }
            default: {
                responseVo.setSexVip("2");
            }
        }
        responseVo.setMobileVip(memberInfoModel.getPhone());
        if (memberInfoModel.getServiceGuideId() != null) {
            res = this.staffServiceRpc.getStaffById(memberInfoModel.getServiceGuideId());
            if (res == null || res.getData() == null || res.getCode() != SysResponseEnum.SUCCESS.getCode()) {
                log.error("\u67e5\u8be2\u670d\u52a1\u5bfc\u8d2d\u5931\u8d25");
                return ResponseUtil.getFailedData(null, (String)"\u67e5\u8be2\u670d\u52a1\u5bfc\u8d2d\u5931\u8d25");
            }
            responseVo.setEmpId(((SysStaffPo)res.getData()).getStaffCode());
        }
        if (memberInfoModel.getServiceStoreId() != null) {
            res = this.storeServiceRpc.getStoreCodeById(memberInfoModel.getServiceStoreId());
            if (res == null || res.getData() == null || res.getCode() != SysResponseEnum.SUCCESS.getCode()) {
                log.error("\u67e5\u8be2\u670d\u52a1\u95e8\u5e97\u5931\u8d25");
                return ResponseUtil.getFailedData(null, (String)"\u67e5\u8be2\u670d\u52a1\u95e8\u5e97\u5931\u8d25");
            }
            responseVo.setStoreId((String)res.getData());
        }
        if (memberInfoModel.getLevelId() != null) {
            MbrLevelModel mbrLevelModel = this.memberLevelMapper.queryLevelBasicInfo(memberInfoModel.getLevelId());
            if (mbrLevelModel == null) {
                log.error("\u67e5\u8be2\u7b49\u7ea7\u5931\u8d25");
                return ResponseUtil.getFailedData(null, (String)"\u67e5\u8be2\u7b49\u7ea7\u5931\u8d25");
            }
            responseVo.setCardTypeId(mbrLevelModel.getOfflineLevelCode());
            responseVo.setVipTypeId(mbrLevelModel.getOfflineLevelCode());
            responseVo.setVipTypeCode(mbrLevelModel.getOfflineLevelCode());
        }
        if ((wxChannelModel = this.mbrWxChannelMapper.queryWxPublic(memberInfoModel.getMemberCode(), memberInfoModel.getBrandId())) != null) {
            responseVo.setOpenId(wxChannelModel.getOpenId());
            responseVo.setUnionId(wxChannelModel.getUnionId());
        }
        responseVo.setCardNoVip(memberInfoModel.getCardNo());
        responseVo.setOpenStatus(memberInfoModel.getCardStatus() != null ? memberInfoModel.getCardStatus().toString() : null);
        responseVo.setPoints(memberInfoModel.getCountIntegral());
        responseVo.setTVb(memberInfoModel.getBirthday());
        responseVo.setTD1(memberInfoModel.getEffectiveTime());
        responseVo.setFrActive(memberInfoModel.getValid() != null ? memberInfoModel.getValid().toString() : null);
        responseVo.setTBizcr(memberInfoModel.getModifiedDate());
        responseVo.setTBizmd(memberInfoModel.getModifiedDate());
        responseVo.setTCr(memberInfoModel.getCreateDate());
        responseVo.setTMd(memberInfoModel.getModifiedDate());
        responseVo.setTIn(memberInfoModel.getModifiedDate());
        responseVo.setProvince(memberInfoModel.getProvince());
        responseVo.setCity(memberInfoModel.getCity());
        responseVo.setDistrict(memberInfoModel.getCounty());
        responseVo.setEmail(memberInfoModel.getEmail());
        responseVo.setUnionId(memberInfoModel.getWxUnionId());
        return ResponseUtil.getSuccessData((Object)responseVo);
    }

    public ResponseData<UrMemberUpdateInfoResponseVo> memberUpdateInfo(@RequestBody @Valid UrMemberUpdateInfoRequestVo urMemberUpdateInfoRequestVo) {
        log.info("enter memberUpdateInfo param:{}", (Object)JacksonUtil.bean2Json((Object)urMemberUpdateInfoRequestVo));
        if (StringUtils.isBlank((CharSequence)urMemberUpdateInfoRequestVo.getCardCode())) {
            urMemberUpdateInfoRequestVo.setCardCode(null);
        }
        if (StringUtils.isBlank((CharSequence)urMemberUpdateInfoRequestVo.getMobileTel())) {
            urMemberUpdateInfoRequestVo.setMobileTel(null);
        }
        MemberInfoModel searchModel = new MemberInfoModel();
        searchModel.setSysCompanyId(urMemberUpdateInfoRequestVo.getSysCompanyId());
        searchModel.setBrandId(urMemberUpdateInfoRequestVo.getBrandId());
        searchModel.setCardNo(urMemberUpdateInfoRequestVo.getCardCode());
        searchModel.setPhone(urMemberUpdateInfoRequestVo.getMobileTel());
        searchModel.setWxOpenId(urMemberUpdateInfoRequestVo.getWxOpenId());
        MemberInfoModel memberInfoModel = this.memberInfoMapper.queryUrMemberInfo(searchModel);
        if (memberInfoModel == null) {
            log.info("\u67e5\u4e0d\u5230\u5f53\u524d\u4f1a\u5458");
            return ResponseUtil.getFailedData(null, (String)"\u67e5\u4e0d\u5230\u5f53\u524d\u4f1a\u5458");
        }
        MemberInfoModel record = new MemberInfoModel();
        record.setSysCompanyId(urMemberUpdateInfoRequestVo.getSysCompanyId());
        record.setBrandId(urMemberUpdateInfoRequestVo.getBrandId());
        record.setErpId(memberInfoModel.getErpId());
        record.setPhone(StringUtils.isNotBlank((CharSequence)urMemberUpdateInfoRequestVo.getMobileTel()) ? urMemberUpdateInfoRequestVo.getMobileTel() : memberInfoModel.getPhone());
        record.setCardNo(memberInfoModel.getCardNo());
        record.setName(urMemberUpdateInfoRequestVo.getCustomerName());
        switch (urMemberUpdateInfoRequestVo.getSex()) {
            case "1": {
                record.setGender("1");
                break;
            }
            case "0": {
                record.setGender("2");
                break;
            }
            default: {
                record.setGender("3");
            }
        }
        record.setWxOpenId(urMemberUpdateInfoRequestVo.getWxOpenId());
        record.setProvince(urMemberUpdateInfoRequestVo.getProvince());
        record.setCity(urMemberUpdateInfoRequestVo.getCity());
        record.setCounty(urMemberUpdateInfoRequestVo.getDistrict());
        record.setEmail(urMemberUpdateInfoRequestVo.getEmail());
        if (urMemberUpdateInfoRequestVo.getBirthday() != null) {
            SimpleDateFormat sd = new SimpleDateFormat("MMdd");
            record.setBirthday(urMemberUpdateInfoRequestVo.getBirthday());
            record.setBirthdayMd(sd.format(urMemberUpdateInfoRequestVo.getBirthday()));
        }
        this.writeToOffline(record);
        log.info("update MemberInfo:{}", (Object)JacksonUtil.bean2Json((Object)record));
        this.memberInfoMapper.updateUrMembersInfo(record, new HashMap());
        if (record.getBirthday() != null) {
            PushMbrModel pushMbrModel = PushMbrModel.builder().sysCompanyId(record.getSysCompanyId()).brandId(record.getBrandId()).memberCode(record.getMemberCode()).build();
            this.memberCommonMqUtilService.pushBirthdayActivityMsg(pushMbrModel);
        }
        return ResponseUtil.getSuccessData(null);
    }

    protected void writeToOffline(MemberInfoModel memberInfoModel) {
        log.info("\u6839\u636e\u4f1a\u5458\u7f16\u7801\u5f97\u5230\u7684\u4f1a\u5458\u4fe1\u606fmemberInfoModel" + JacksonUtil.bean2Json((Object)memberInfoModel));
        MemberInfoUpdateRequestVO memberInfoUpdateRequestVO = new MemberInfoUpdateRequestVO();
        memberInfoUpdateRequestVO.setErpId(memberInfoModel.getErpId());
        memberInfoUpdateRequestVO.setOfflineCardNo(memberInfoModel.getCardNo());
        memberInfoUpdateRequestVO.setBrandId(memberInfoModel.getBrandId());
        memberInfoUpdateRequestVO.setPhone(memberInfoModel.getPhone());
        memberInfoUpdateRequestVO.setName(memberInfoModel.getName());
        if ("1".equals(memberInfoModel.getGender())) {
            memberInfoUpdateRequestVO.setGender("0");
        } else if ("2".equals(memberInfoModel.getGender())) {
            memberInfoUpdateRequestVO.setGender("1");
        } else {
            memberInfoUpdateRequestVO.setGender("2");
        }
        if (memberInfoModel.getBirthday() != null) {
            memberInfoUpdateRequestVO.setBirthday(DateUtil.format((Date)memberInfoModel.getBirthday(), (String)"yyyyMMdd"));
        }
        memberInfoUpdateRequestVO.setEmail(memberInfoModel.getEmail());
        memberInfoUpdateRequestVO.setAddress(memberInfoModel.getAddress());
        memberInfoUpdateRequestVO.setProvince(memberInfoModel.getProvince());
        memberInfoUpdateRequestVO.setCity(memberInfoModel.getCity());
        memberInfoUpdateRequestVO.setCounty(memberInfoModel.getCounty());
        log.info("\u8c03\u7528\u540c\u6b65\u7ebf\u4e0b\u63a5\u53e3asyncSendDataToOffline\u53c2\u6570\u5b9e\u4f53\u7c7b:" + JacksonUtil.bean2Json((Object)memberInfoUpdateRequestVO));
        this.mqAsyncSendDataToOfflineService.asyncSendDataToOffline(memberInfoUpdateRequestVO);
    }

    public ResponseData<UrMemberUpdatePhoneResponseVo> memberUpdatePhone(@RequestBody @Valid UrMemberUpdatePhoneRequestVo urMemberUpdatePhoneRequestVo) {
        log.info("enter memberUpdatePhone param:{}", (Object)JacksonUtil.bean2Json((Object)urMemberUpdatePhoneRequestVo));
        if (StringUtils.isBlank((CharSequence)urMemberUpdatePhoneRequestVo.getCardCode())) {
            urMemberUpdatePhoneRequestVo.setCardCode(null);
        }
        if (StringUtils.isBlank((CharSequence)urMemberUpdatePhoneRequestVo.getMobileTel())) {
            urMemberUpdatePhoneRequestVo.setMobileTel(null);
        }
        MemberInfoModel searchPhoneModel = new MemberInfoModel();
        searchPhoneModel.setPhone(urMemberUpdatePhoneRequestVo.getNewMobileTel());
        searchPhoneModel.setBrandId(urMemberUpdatePhoneRequestVo.getBrandId());
        int count = this.memberInfoMapper.queryCountByPhone(searchPhoneModel);
        if (count > 0) {
            log.info("\u8be5\u624b\u673a\u53f7\u5df2\u6ce8\u518c!");
            return ResponseUtil.getFailedData(null);
        }
        MemberInfoModel searchModel = new MemberInfoModel();
        searchModel.setSysCompanyId(urMemberUpdatePhoneRequestVo.getSysCompanyId());
        searchModel.setBrandId(urMemberUpdatePhoneRequestVo.getBrandId());
        searchModel.setCardNo(urMemberUpdatePhoneRequestVo.getCardCode());
        searchModel.setPhone(urMemberUpdatePhoneRequestVo.getMobileTel());
        MemberInfoModel memberInfoModel = this.memberInfoMapper.queryUrMemberInfo(searchModel);
        if (memberInfoModel == null) {
            log.info("\u67e5\u4e0d\u5230\u5f53\u524d\u4f1a\u5458");
            return ResponseUtil.getFailedData(null, (String)"\u67e5\u4e0d\u5230\u5f53\u524d\u4f1a\u5458");
        }
        if (urMemberUpdatePhoneRequestVo.getNewMobileTel().equals(memberInfoModel.getPhone())) {
            log.info("\u73b0\u5728\u624b\u673a\u53f7\u4e0e\u539f\u624b\u673a\u53f7\u4e00\u81f4\u4e0d\u80fd\u4fee\u6539");
            return ResponseUtil.getFailedData(null);
        }
        MemberInfoModel origin = new MemberInfoModel();
        origin.setSysCompanyId(urMemberUpdatePhoneRequestVo.getSysCompanyId());
        origin.setBrandId(urMemberUpdatePhoneRequestVo.getBrandId());
        origin.setCardNo(memberInfoModel.getCardNo());
        origin.setPhone(urMemberUpdatePhoneRequestVo.getNewMobileTel());
        origin.setErpId(memberInfoModel.getErpId());
        this.writeToOffline(origin);
        this.memberInfoMapper.updateUrMembersPhone(origin);
        return ResponseUtil.getSuccessData(null);
    }

    public ResponseData memberUnbind(@RequestBody @Valid UrMemberUnbindRequestVo vo) {
        log.info("enter memberUnbind param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        ResponseData responseData = new ResponseData();
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setSysCompanyId(vo.getSysCompanyId());
        memberInfoModel.setBrandId(vo.getBrandId());
        memberInfoModel.setCardNo(vo.getCardCode());
        memberInfoModel.setPhone(vo.getMobileTel());
        memberInfoModel.setErpId(vo.getErpId());
        MemberInfoModel memberInfo = this.memberInfoMapper.querySingleMemberInfoIgnoreValid(memberInfoModel);
        if (memberInfo == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u6ca1\u6709\u67e5\u5230\u76f8\u5173\u4f1a\u5458");
            return responseData;
        }
        MbrWxChannelModel wxChannelModel = this.mbrWxChannelMapper.queryWxByMemberCode(memberInfo.getMemberCode(), memberInfo.getBrandId());
        if (wxChannelModel != null) {
            log.info("\u4fee\u6539\u5fae\u4fe1\u6e20\u9053\u8868\u4f1a\u5458\u4fe1\u606f memberCode:{}", (Object)memberInfo.getMemberCode());
            this.mbrWxChannelMapper.updateWxByMemberCode(memberInfo.getMemberCode(), memberInfo.getBrandId(), vo.getSysCompanyId());
        }
        log.info("\u4fee\u6539\u4f1a\u5458\u8868\u5fae\u4fe1\u4fe1\u606f memberCode:{},unionId:{},openId:{}", new Object[]{memberInfo.getMemberCode(), memberInfo.getWxUnionId(), memberInfo.getWxOpenId()});
        this.memberInfoMapper.updateBindByMemberCode(memberInfo);
        this.clearRedisCacheServiceRpc.clearSessionCache(memberInfo.getMemberCode());
        return responseData;
    }
}

