/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.unifiedreg.service.copy.impl;

import com.bizvane.members.facade.enums.BusinessTypeEnum;
import com.bizvane.members.facade.models.IntegralRecordModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.card.request.IntegralChangeRequestModel;
import com.bizvane.members.facade.service.card.response.IntegralChangeResponseModel;
import com.bizvane.members.facade.ur.vo.UrIntegralQueryRequestVo;
import com.bizvane.members.facade.ur.vo.UrIntegralQueryResponseVo;
import com.bizvane.members.facade.ur.vo.UrIntegralRequestVo;
import com.bizvane.members.facade.ur.vo.UrIntegralResponseVo;
import com.bizvane.members.facade.ur.vo.UrIntegralSaveRequestVo;
import com.bizvane.members.facade.vo.IntegralRecordBusinessTypeVo;
import com.bizvane.unifiedreg.rpc.IntegralChangeApiService;
import com.bizvane.unifiedreg.rpc.UrIntegralApiService;
import com.bizvane.unifiedreg.service.copy.IntegralRecordBusinessTypeService;
import com.bizvane.unifiedreg.service.copy.mapper.IntegralRecordMapper;
import com.bizvane.unifiedreg.service.copy.mapper.MemberInfoMapper;
import com.bizvane.unifiedreg.tools.ParamValidation;
import com.bizvane.unifiedreg.tools.ResponseUtil;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UrIntegralApiServiceImpl
implements UrIntegralApiService {
    private static final Logger log = LoggerFactory.getLogger(UrIntegralApiServiceImpl.class);
    @Autowired
    private IntegralRecordMapper integralRecordMapper;
    @Autowired
    private IntegralChangeApiService integralChangeApiService;
    @Autowired
    private MemberInfoMapper memberInfoMapper;
    @Autowired
    private IntegralRecordBusinessTypeService integralRecordBusinessTypeService;

    public ResponseData<PageInfo<UrIntegralResponseVo>> getUrIntegralRecord(@RequestBody @Valid UrIntegralRequestVo urIntegralRequestVo) {
        log.info("enter getUrIntegralRecord param:{}", (Object)JacksonUtil.bean2Json((Object)urIntegralRequestVo));
        IntegralRecordModel searchIntegralRecordModel = new IntegralRecordModel();
        searchIntegralRecordModel.setSysCompanyId(urIntegralRequestVo.getSysCompanyId());
        searchIntegralRecordModel.setBrandId(urIntegralRequestVo.getBrandId());
        searchIntegralRecordModel.setMemberCode(urIntegralRequestVo.getMemberCode());
        searchIntegralRecordModel.setChangeWay(urIntegralRequestVo.getIntegralType() != null ? urIntegralRequestVo.getIntegralType().toString() : null);
        Page page = PageHelper.startPage((int)urIntegralRequestVo.getPageNum(), (int)urIntegralRequestVo.getPageSize()).doSelectPage(() -> this.integralRecordMapper.getUrIntegralRecordList(searchIntegralRecordModel));
        PageInfo originPageInfo = new PageInfo((List)page);
        if (originPageInfo.getList() == null) {
            return ResponseUtil.getSuccessData((Object)originPageInfo);
        }
        ArrayList responseVoList = new ArrayList();
        if (originPageInfo.getList() != null) {
            originPageInfo.getList().stream().forEach(x -> {
                UrIntegralResponseVo responseVo = new UrIntegralResponseVo();
                responseVo.setBusinessWay(x.getBusinessWay());
                responseVo.setChangeBills(x.getChangeBills());
                responseVo.setChangeDate(x.getChangeDate());
                responseVo.setChangeIntegral(x.getChangeIntegral());
                IntegralRecordBusinessTypeVo integralRecordBusinessTypeVo = this.integralRecordBusinessTypeService.findIntegralRecordBusinessTypeVoByCode(x.getBusinessWay(), x.getSysCompanyId());
                if (integralRecordBusinessTypeVo != null) {
                    responseVo.setBusinessWayName(integralRecordBusinessTypeVo.getDescription());
                }
                responseVoList.add(responseVo);
            });
        }
        PageInfo pageInfo = new PageInfo();
        pageInfo.setList(responseVoList);
        pageInfo.setSize(originPageInfo.getSize());
        pageInfo.setPageSize(originPageInfo.getPageSize());
        pageInfo.setPageNum(originPageInfo.getPageNum());
        pageInfo.setTotal(originPageInfo.getTotal());
        pageInfo.setPages(originPageInfo.getPages());
        return ResponseUtil.getSuccessData((Object)pageInfo);
    }

    public ResponseData<String> integralAdjust(@RequestBody @Valid UrIntegralSaveRequestVo urIntegralSaveRequestVo) {
        log.info("enter integralAdjust param:{}", (Object)JacksonUtil.bean2Json((Object)urIntegralSaveRequestVo));
        ParamValidation.paramsValidate((Object[])new Object[]{urIntegralSaveRequestVo.getCardNoVip()});
        if (urIntegralSaveRequestVo.getDocdate() == null) {
            urIntegralSaveRequestVo.setDocdate(new Date());
        }
        MemberInfoModel searchMemberInfoModel = new MemberInfoModel();
        searchMemberInfoModel.setCardNo(urIntegralSaveRequestVo.getCardNoVip());
        searchMemberInfoModel.setBrandId(urIntegralSaveRequestVo.getBrandId());
        MemberInfoModel memberInfoModel = this.memberInfoMapper.queryUrMemberInfo(searchMemberInfoModel);
        if (memberInfoModel == null) {
            log.error("\u4f1a\u5458\u4e0d\u5b58\u5728");
            return ResponseUtil.getFailedData(null, (String)"\u4f1a\u5458\u4e0d\u5b58\u5728");
        }
        IntegralChangeRequestModel integralChangeRequestModel = new IntegralChangeRequestModel();
        integralChangeRequestModel.setSysCompanyId(urIntegralSaveRequestVo.getSysCompanyId());
        integralChangeRequestModel.setBrandId(urIntegralSaveRequestVo.getBrandId());
        integralChangeRequestModel.setMemberCode(memberInfoModel.getMemberCode());
        integralChangeRequestModel.setChangeBills(urIntegralSaveRequestVo.getDocNo());
        integralChangeRequestModel.setOfflineCardNo(memberInfoModel.getOfflineCardNo());
        integralChangeRequestModel.setChangeDate(urIntegralSaveRequestVo.getDocdate());
        integralChangeRequestModel.setPointsAmount(urIntegralSaveRequestVo.getPointsAmount());
        integralChangeRequestModel.setStoreId(urIntegralSaveRequestVo.getStoreId());
        integralChangeRequestModel.setSource(urIntegralSaveRequestVo.getSource());
        this.convertBusinessVoToModel(urIntegralSaveRequestVo, integralChangeRequestModel);
        if (urIntegralSaveRequestVo.getPoints() > 0) {
            integralChangeRequestModel.setChangeType("2");
        } else {
            integralChangeRequestModel.setChangeType("1");
        }
        integralChangeRequestModel.setChangeIntegral(Integer.valueOf(Math.abs(urIntegralSaveRequestVo.getPoints())));
        integralChangeRequestModel.setPointsIdUnique(urIntegralSaveRequestVo.getPointsIdUnique());
        IntegralChangeResponseModel integralChangeResponseModel = this.integralChangeApiService.integralChangeOperate(integralChangeRequestModel);
        if (integralChangeResponseModel == null) {
            return ResponseUtil.getFailedData(null, (String)"\u79ef\u5206\u6d41\u6c34\u8c03\u6574\u5931\u8d25");
        }
        if (integralChangeResponseModel.getCode().intValue() != SysResponseEnum.SUCCESS.getCode()) {
            return ResponseUtil.getFailedData(null, (String)integralChangeResponseModel.getMessage());
        }
        return ResponseUtil.getSuccessData((Object)"success");
    }

    protected void convertBusinessVoToModel(@RequestBody @Valid UrIntegralSaveRequestVo urIntegralSaveRequestVo, IntegralChangeRequestModel integralChangeRequestModel) {
        switch (urIntegralSaveRequestVo.getIntegralType()) {
            case "1": {
                integralChangeRequestModel.setBusinessType(BusinessTypeEnum.UR_GIVE_AWAY.getCode());
                break;
            }
            case "2": {
                integralChangeRequestModel.setBusinessType(BusinessTypeEnum.UR_CONSUME.getCode());
                break;
            }
            case "3": {
                integralChangeRequestModel.setBusinessType(BusinessTypeEnum.UR_SALES_RETURN.getCode());
                break;
            }
            case "4": {
                integralChangeRequestModel.setBusinessType(BusinessTypeEnum.UR_ADJUST_DECREASE.getCode());
                break;
            }
            case "5": {
                integralChangeRequestModel.setBusinessType(BusinessTypeEnum.UR_ADJUST_INCREASE.getCode());
                break;
            }
            case "6": {
                integralChangeRequestModel.setBusinessType(BusinessTypeEnum.UR_EXCHANGE.getCode());
                break;
            }
            case "7": {
                integralChangeRequestModel.setBusinessType(BusinessTypeEnum.UR_CASH.getCode());
                break;
            }
            case "8": {
                integralChangeRequestModel.setBusinessType(BusinessTypeEnum.UR_CASH_RETURN.getCode());
                break;
            }
            case "9": {
                integralChangeRequestModel.setBusinessType(BusinessTypeEnum.UR_ZERO.getCode());
                break;
            }
            case "10": {
                integralChangeRequestModel.setBusinessType(BusinessTypeEnum.UR_RETURN.getCode());
                break;
            }
            default: {
                integralChangeRequestModel.setBusinessType(BusinessTypeEnum.UR_OTHER.getCode());
            }
        }
    }

    public ResponseData<List<UrIntegralQueryResponseVo>> queryIntegralRecord(@RequestBody @Valid UrIntegralQueryRequestVo urIntegralQueryRequestVo) {
        log.info("enter queryIntegralRecord param:{}", (Object)JacksonUtil.bean2Json((Object)urIntegralQueryRequestVo));
        MemberInfoModel searchMemberInfoModel = new MemberInfoModel();
        searchMemberInfoModel.setCardNo(urIntegralQueryRequestVo.getCardNoVip());
        searchMemberInfoModel.setBrandId(urIntegralQueryRequestVo.getBrandId());
        MemberInfoModel memberInfoModel = this.memberInfoMapper.queryUrMemberInfo(searchMemberInfoModel);
        if (memberInfoModel == null) {
            log.error("\u4f1a\u5458\u4e0d\u5b58\u5728");
            return ResponseUtil.getFailedData(null, (String)"\u4f1a\u5458\u4e0d\u5b58\u5728");
        }
        IntegralRecordModel searchRecordModel = new IntegralRecordModel();
        searchRecordModel.setSysCompanyId(urIntegralQueryRequestVo.getSysCompanyId());
        searchRecordModel.setBrandId(urIntegralQueryRequestVo.getBrandId());
        searchRecordModel.setMemberCode(memberInfoModel.getMemberCode());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (StringUtils.isNotBlank((CharSequence)urIntegralQueryRequestVo.getEndTime())) {
            try {
                searchRecordModel.setChangeDateMax(simpleDateFormat.parse(urIntegralQueryRequestVo.getEndTime()));
            }
            catch (Exception e) {
                log.error("\u7ed3\u675f\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38");
                return ResponseUtil.getFailedData(null, (String)"\u7ed3\u675f\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)urIntegralQueryRequestVo.getStartTime())) {
            try {
                searchRecordModel.setChangeDateMin(simpleDateFormat.parse(urIntegralQueryRequestVo.getStartTime()));
            }
            catch (Exception e) {
                log.error("\u5f00\u59cb\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38");
                return ResponseUtil.getFailedData(null, (String)"\u5f00\u59cb\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38");
            }
        }
        List integralRecordModelList = this.integralRecordMapper.getUrIntegralRecordList(searchRecordModel);
        ArrayList urIntegralQueryResponseVoList = new ArrayList();
        integralRecordModelList.forEach(x -> {
            UrIntegralQueryResponseVo responseVo = new UrIntegralQueryResponseVo();
            responseVo.setDocDate(x.getChangeDate());
            responseVo.setDocNo(x.getChangeBills());
            this.convertBusinessModelToVo(responseVo, x);
            responseVo.setPoints(x.getChangeIntegral());
            responseVo.setStoreId(x.getStoreId());
            responseVo.setPointsAmount(x.getPointsAmount());
            urIntegralQueryResponseVoList.add(responseVo);
        });
        return ResponseUtil.getSuccessData(urIntegralQueryResponseVoList);
    }

    protected void convertBusinessModelToVo(@RequestBody @Valid UrIntegralQueryResponseVo urIntegralQueryResponseVo, IntegralRecordModel integralRecordModel) {
        if (BusinessTypeEnum.UR_GIVE_AWAY.getCode().equals(integralRecordModel.getBusinessWay())) {
            urIntegralQueryResponseVo.setIntegralType(Integer.valueOf(1));
            urIntegralQueryResponseVo.setIntegralTypeName(BusinessTypeEnum.UR_GIVE_AWAY.getMsg());
        } else if (BusinessTypeEnum.UR_CONSUME.getCode().equals(integralRecordModel.getBusinessWay())) {
            urIntegralQueryResponseVo.setIntegralType(Integer.valueOf(2));
            urIntegralQueryResponseVo.setIntegralTypeName(BusinessTypeEnum.UR_CONSUME.getMsg());
        } else if (BusinessTypeEnum.UR_SALES_RETURN.getCode().equals(integralRecordModel.getBusinessWay())) {
            urIntegralQueryResponseVo.setIntegralType(Integer.valueOf(3));
            urIntegralQueryResponseVo.setIntegralTypeName(BusinessTypeEnum.UR_SALES_RETURN.getMsg());
        } else if (BusinessTypeEnum.UR_ADJUST_DECREASE.getCode().equals(integralRecordModel.getBusinessWay())) {
            urIntegralQueryResponseVo.setIntegralType(Integer.valueOf(4));
            urIntegralQueryResponseVo.setIntegralTypeName(BusinessTypeEnum.UR_ADJUST_DECREASE.getMsg());
        } else if (BusinessTypeEnum.UR_ADJUST_INCREASE.getCode().equals(integralRecordModel.getBusinessWay())) {
            urIntegralQueryResponseVo.setIntegralType(Integer.valueOf(5));
            urIntegralQueryResponseVo.setIntegralTypeName(BusinessTypeEnum.UR_ADJUST_INCREASE.getMsg());
        } else if (BusinessTypeEnum.UR_EXCHANGE.getCode().equals(integralRecordModel.getBusinessWay())) {
            urIntegralQueryResponseVo.setIntegralType(Integer.valueOf(6));
            urIntegralQueryResponseVo.setIntegralTypeName(BusinessTypeEnum.UR_EXCHANGE.getMsg());
        } else if (BusinessTypeEnum.UR_CASH.getCode().equals(integralRecordModel.getBusinessWay())) {
            urIntegralQueryResponseVo.setIntegralType(Integer.valueOf(7));
            urIntegralQueryResponseVo.setIntegralTypeName(BusinessTypeEnum.UR_CASH.getMsg());
        } else if (BusinessTypeEnum.UR_CASH_RETURN.getCode().equals(integralRecordModel.getBusinessWay())) {
            urIntegralQueryResponseVo.setIntegralType(Integer.valueOf(8));
            urIntegralQueryResponseVo.setIntegralTypeName(BusinessTypeEnum.UR_CASH_RETURN.getMsg());
        } else if (BusinessTypeEnum.UR_ZERO.getCode().equals(integralRecordModel.getBusinessWay())) {
            urIntegralQueryResponseVo.setIntegralType(Integer.valueOf(9));
            urIntegralQueryResponseVo.setIntegralTypeName(BusinessTypeEnum.UR_ZERO.getMsg());
        } else if (BusinessTypeEnum.UR_RETURN.getCode().equals(integralRecordModel.getBusinessWay())) {
            urIntegralQueryResponseVo.setIntegralType(Integer.valueOf(10));
            urIntegralQueryResponseVo.setIntegralTypeName(BusinessTypeEnum.UR_RETURN.getMsg());
        }
    }
}

