/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.unifiedreg.service.copy.impl;

import com.aliyun.openservices.ons.api.SendResult;
import com.bizvane.connectorservice.entity.common.MemberInfoUpdateRequestVO;
import com.bizvane.members.facade.enums.MQStateEnum;
import com.bizvane.members.facade.models.MQRecordModel;
import com.bizvane.members.facade.service.card.response.PerfectMemberDataResponseModel;
import com.bizvane.unifiedreg.service.copy.MqAsyncSendDataToOfflineService;
import com.bizvane.unifiedreg.service.copy.config.RocketMQConfig;
import com.bizvane.unifiedreg.service.copy.mapper.MQRecordModelMapper;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.rocketutils.RocketMQClient;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MqAsyncSendToOfflineServiceImpl
implements MqAsyncSendDataToOfflineService {
    private static final Logger log = LoggerFactory.getLogger(MqAsyncSendToOfflineServiceImpl.class);
    @Autowired
    private RocketMQClient rocketMqClient;
    @Autowired
    private RocketMQConfig rocketMqConfig;
    @Autowired
    private MQRecordModelMapper mqRecordModelMapper;

    public PerfectMemberDataResponseModel asyncSendDataToOffline(MemberInfoUpdateRequestVO memberInfoUpdateRequestVO) {
        PerfectMemberDataResponseModel perfectMemberDataResponseModel = new PerfectMemberDataResponseModel();
        String messageBody = JacksonUtil.bean2Json((Object)memberInfoUpdateRequestVO);
        log.info("mq\u5165\u53c2\u4f1a\u5458\u6570\u636e:{}", (Object)messageBody);
        SendResult sendResult = this.rocketMqClient.sendMessage(messageBody, this.rocketMqConfig.memberPerfectTopic, "memberInfoRequestTag");
        log.info(JacksonUtil.bean2Json((Object)sendResult));
        MQRecordModel mqRecordModel = new MQRecordModel();
        mqRecordModel.setBusinessBill(memberInfoUpdateRequestVO.getMemberUUID());
        mqRecordModel.setRequestTopic(this.rocketMqConfig.memberPerfectTopic);
        mqRecordModel.setRequestTag("memberInfoRequestTag");
        mqRecordModel.setRequestMessageBody(messageBody);
        mqRecordModel.setRequestTime(new Date());
        if (sendResult == null) {
            perfectMemberDataResponseModel.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            perfectMemberDataResponseModel.setMessage("\u6d88\u606f\u53d1\u9001\u5931\u8d25");
            mqRecordModel.setState(MQStateEnum.REQUEST_FAILED.getCode());
            this.mqRecordModelMapper.insert(mqRecordModel);
            return perfectMemberDataResponseModel;
        }
        mqRecordModel.setState(MQStateEnum.REQUEST_SUCCESS.getCode());
        this.mqRecordModelMapper.insert(mqRecordModel);
        perfectMemberDataResponseModel.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
        perfectMemberDataResponseModel.setMessage("\u6d88\u606f\u53d1\u9001\u6210\u529f");
        return perfectMemberDataResponseModel;
    }
}

