/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.unifiedreg.service.copy.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.bizvane.members.facade.models.po.MbrIntegralRecordBusinessTypePO;
import com.bizvane.members.facade.models.po.MbrIntegralRecordBusinessTypePOExample;
import com.bizvane.members.facade.vo.IntegralRecordBusinessTypeVo;
import com.bizvane.unifiedreg.service.copy.IntegralRecordBusinessTypeService;
import com.bizvane.unifiedreg.service.copy.config.SwitchConfig;
import com.bizvane.unifiedreg.service.copy.mapper.MbrIntegralRecordBusinessTypePOMapper;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class IntegralRecordBusinessTypeServiceImpl
implements IntegralRecordBusinessTypeService {
    @Autowired
    private SwitchConfig switchConfig;
    @Autowired
    private MbrIntegralRecordBusinessTypePOMapper mbrIntegralRecordBusinessTypePoMapper;
    private static final String BIZVANE_BUSINESS_CODE_PREFIX = "bizvane-";
    private static final String CACHE_KEY_TEMP = "member-IntegralRecordBusinessTypeServiceImpl-findByCode-%s-%S";
    private String prefixIntegralTypeConvertOnLineToOffline = "prefixIntegralTypeConvert";
    private String prefixIntegralTypeConvertOnLineToOfflineFindByCode = "prefixIntegralTypeConvertfindByCode";
    @Autowired
    private StringRedisTemplate redisTemplate;

    public String findByBizvaneCode(String bizvaneBusinessCode) {
        return this.findByCodeImpl(bizvaneBusinessCode, Long.valueOf(0L));
    }

    public String findByCode(String businessCode, Long sysCompanyId) {
        if (businessCode.startsWith(BIZVANE_BUSINESS_CODE_PREFIX)) {
            return this.findByCodeImpl(businessCode, Long.valueOf(0L));
        }
        return this.findByCodeImpl(businessCode, sysCompanyId);
    }

    public IntegralRecordBusinessTypeVo findIntegralRecordBusinessTypeVoByCode(String businessCode, Long sysCompanyId) {
        if (businessCode.startsWith(BIZVANE_BUSINESS_CODE_PREFIX)) {
            return this.findIntegralRecordBusinessTypeVoByCodeImpl(businessCode, Long.valueOf(0L));
        }
        return this.findIntegralRecordBusinessTypeVoByCodeImpl(businessCode, sysCompanyId);
    }

    public Map<String, String> convertOnLineTypeToOffline(Long sysCompanyId) {
        if (CollectionUtil.isEmpty((Collection)this.switchConfig.getIntegralTypeSwitch()) || !this.switchConfig.getIntegralTypeSwitch().contains(sysCompanyId)) {
            return null;
        }
        String redisKey = this.prefixIntegralTypeConvertOnLineToOffline + ":" + sysCompanyId;
        String integralRecordBusinessTypeVoMapStr = (String)this.redisTemplate.opsForValue().get((Object)redisKey);
        if (StringUtils.isNotBlank((CharSequence)integralRecordBusinessTypeVoMapStr)) {
            return (Map)JacksonUtil.json2Objs((String)integralRecordBusinessTypeVoMapStr, Map.class);
        }
        MbrIntegralRecordBusinessTypePOExample mbrIntegralRecordBusinessTypePOExample = new MbrIntegralRecordBusinessTypePOExample();
        mbrIntegralRecordBusinessTypePOExample.createCriteria().andSysCompanyIdEqualTo(sysCompanyId);
        List mbrIntegralRecordBusinessTypePOS = this.mbrIntegralRecordBusinessTypePoMapper.selectByExample(mbrIntegralRecordBusinessTypePOExample);
        if (CollectionUtil.isEmpty((Collection)mbrIntegralRecordBusinessTypePOS)) {
            return null;
        }
        HashMap<String, String> integralRecordBusinessTypeVoMap = new HashMap<String, String>();
        mbrIntegralRecordBusinessTypePOS.stream().forEach(mbrIntegralRecordBusinessTypePO -> {
            if (StringUtils.isNotBlank((CharSequence)mbrIntegralRecordBusinessTypePO.getBizvaneCode())) {
                String[] bizvaneCodes = StringUtils.split((String)mbrIntegralRecordBusinessTypePO.getBizvaneCode(), (String)",");
                Stream.of(bizvaneCodes).forEach(bizvaneCode -> {
                    IntegralRecordBusinessTypeVo integralRecordBusinessTypeVo = new IntegralRecordBusinessTypeVo();
                    integralRecordBusinessTypeVo.setBizvaneCode(bizvaneCode);
                    integralRecordBusinessTypeVo.setBusinessCode(mbrIntegralRecordBusinessTypePO.getBizvaneCode());
                    integralRecordBusinessTypeVo.setDescription(mbrIntegralRecordBusinessTypePO.getDescription());
                    integralRecordBusinessTypeVoMap.put((String)bizvaneCode, JacksonUtil.bean2Json((Object)integralRecordBusinessTypeVo));
                });
            }
        });
        this.redisTemplate.opsForValue().set((Object)redisKey, (Object)JacksonUtil.bean2Json(integralRecordBusinessTypeVoMap), 10L, TimeUnit.MINUTES);
        return integralRecordBusinessTypeVoMap;
    }

    public Map<String, String> standardConvertOnLineTypeToOffline() {
        String redisKey = this.prefixIntegralTypeConvertOnLineToOffline + ":0";
        String integralRecordBusinessTypeVoMapStr = (String)this.redisTemplate.opsForValue().get((Object)redisKey);
        if (StringUtils.isNotBlank((CharSequence)integralRecordBusinessTypeVoMapStr)) {
            return (Map)JacksonUtil.json2Objs((String)integralRecordBusinessTypeVoMapStr, Map.class);
        }
        MbrIntegralRecordBusinessTypePOExample mbrIntegralRecordBusinessTypePOExample = new MbrIntegralRecordBusinessTypePOExample();
        mbrIntegralRecordBusinessTypePOExample.createCriteria().andSysCompanyIdEqualTo(Long.valueOf(0L));
        List mbrIntegralRecordBusinessTypePOList = this.mbrIntegralRecordBusinessTypePoMapper.selectByExample(mbrIntegralRecordBusinessTypePOExample);
        if (CollectionUtils.isEmpty((Collection)mbrIntegralRecordBusinessTypePOList)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> integralRecordBusinessTypeVoMap = new HashMap<String, String>();
        mbrIntegralRecordBusinessTypePOList.stream().forEach(mbrIntegralRecordBusinessTypePO -> {
            IntegralRecordBusinessTypeVo integralRecordBusinessTypeVo = new IntegralRecordBusinessTypeVo();
            integralRecordBusinessTypeVo.setBizvaneCode(mbrIntegralRecordBusinessTypePO.getBizvaneCode());
            integralRecordBusinessTypeVo.setBusinessCode(mbrIntegralRecordBusinessTypePO.getBusinessCode());
            integralRecordBusinessTypeVo.setDescription(mbrIntegralRecordBusinessTypePO.getDescription());
            integralRecordBusinessTypeVoMap.put(mbrIntegralRecordBusinessTypePO.getBizvaneCode(), JacksonUtil.bean2Json((Object)integralRecordBusinessTypeVo));
        });
        this.redisTemplate.opsForValue().set((Object)redisKey, (Object)JacksonUtil.bean2Json(integralRecordBusinessTypeVoMap), 10L, TimeUnit.MINUTES);
        return integralRecordBusinessTypeVoMap;
    }

    private String findByCodeImpl(String businessCode, Long sysCompanyId) {
        String description = (String)this.redisTemplate.opsForValue().get((Object)this.cacheKey(businessCode, sysCompanyId));
        if (StringUtils.isNotEmpty((CharSequence)description)) {
            return description;
        }
        MbrIntegralRecordBusinessTypePOExample example = new MbrIntegralRecordBusinessTypePOExample();
        example.createCriteria().andBusinessCodeEqualTo(businessCode).andSysCompanyIdEqualTo(sysCompanyId);
        List list = this.mbrIntegralRecordBusinessTypePoMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        description = ((MbrIntegralRecordBusinessTypePO)list.get(0)).getDescription();
        this.redisTemplate.opsForValue().set((Object)this.cacheKey(businessCode, sysCompanyId), (Object)description, 5L, TimeUnit.MINUTES);
        return description;
    }

    private IntegralRecordBusinessTypeVo findIntegralRecordBusinessTypeVoByCodeImpl(String businessCode, Long sysCompanyId) {
        String redisKey = this.prefixIntegralTypeConvertOnLineToOfflineFindByCode + ":" + sysCompanyId + ":" + businessCode;
        String integralRecordBusinessTypeVoStr = (String)this.redisTemplate.opsForValue().get((Object)redisKey);
        if (StringUtils.isNotEmpty((CharSequence)integralRecordBusinessTypeVoStr)) {
            return (IntegralRecordBusinessTypeVo)JacksonUtil.json2Objs((String)integralRecordBusinessTypeVoStr, IntegralRecordBusinessTypeVo.class);
        }
        MbrIntegralRecordBusinessTypePOExample example = new MbrIntegralRecordBusinessTypePOExample();
        example.createCriteria().andBusinessCodeEqualTo(businessCode).andSysCompanyIdEqualTo(sysCompanyId);
        List list = this.mbrIntegralRecordBusinessTypePoMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new IntegralRecordBusinessTypeVo();
        }
        MbrIntegralRecordBusinessTypePO mbrIntegralRecordBusinessTypePO = (MbrIntegralRecordBusinessTypePO)list.get(0);
        IntegralRecordBusinessTypeVo integralRecordBusinessTypeVo = new IntegralRecordBusinessTypeVo();
        integralRecordBusinessTypeVo.setBusinessCode(mbrIntegralRecordBusinessTypePO.getBusinessCode());
        integralRecordBusinessTypeVo.setBizvaneCode(Long.valueOf(0L).equals(sysCompanyId) ? mbrIntegralRecordBusinessTypePO.getBizvaneCode() : null);
        integralRecordBusinessTypeVo.setDescription(mbrIntegralRecordBusinessTypePO.getDescription());
        this.redisTemplate.opsForValue().set((Object)redisKey, (Object)JacksonUtil.bean2Json((Object)integralRecordBusinessTypeVo), 5L, TimeUnit.MINUTES);
        return integralRecordBusinessTypeVo;
    }

    public String findByCodeCompatibility(String businessCode, Long sysCompanyId) {
        String description = (String)this.redisTemplate.opsForValue().get((Object)this.cacheKey(businessCode, sysCompanyId));
        if (StringUtils.isNotEmpty((CharSequence)description)) {
            return description;
        }
        MbrIntegralRecordBusinessTypePOExample example = new MbrIntegralRecordBusinessTypePOExample();
        MbrIntegralRecordBusinessTypePOExample.Criteria criteria = example.createCriteria();
        if (businessCode.startsWith(BIZVANE_BUSINESS_CODE_PREFIX)) {
            criteria.andBusinessCodeEqualTo(businessCode);
        } else {
            criteria.andBusinessCodeIn(Arrays.asList(businessCode, BIZVANE_BUSINESS_CODE_PREFIX + businessCode));
        }
        criteria.andSysCompanyIdIn(Arrays.asList(sysCompanyId, 0L));
        List list = this.mbrIntegralRecordBusinessTypePoMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        if (list.size() == 1) {
            description = ((MbrIntegralRecordBusinessTypePO)list.get(0)).getDescription();
            this.redisTemplate.opsForValue().set((Object)this.cacheKey(businessCode, sysCompanyId), (Object)description, 5L, TimeUnit.MINUTES);
        } else {
            Map map = list.stream().collect(Collectors.toMap(MbrIntegralRecordBusinessTypePO::getSysCompanyId, Function.identity()));
            MbrIntegralRecordBusinessTypePO po1 = (MbrIntegralRecordBusinessTypePO)map.get(sysCompanyId);
            if (po1 != null) {
                description = po1.getDescription();
                this.redisTemplate.opsForValue().set((Object)this.cacheKey(businessCode, sysCompanyId), (Object)description, 5L, TimeUnit.MINUTES);
            } else {
                MbrIntegralRecordBusinessTypePO po2 = (MbrIntegralRecordBusinessTypePO)map.get(0L);
                description = po2.getDescription();
                this.redisTemplate.opsForValue().set((Object)this.cacheKey(businessCode, sysCompanyId), (Object)description, 5L, TimeUnit.MINUTES);
            }
        }
        return description;
    }

    private String cacheKey(String businessCode, Long sysCompanyId) {
        return String.format(CACHE_KEY_TEMP, String.valueOf(sysCompanyId), businessCode);
    }
}

