/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.unifiedreg.service.copy.es.EsUtils;

import com.bizvane.unifiedreg.service.copy.es.EsUtils.ESClientSpringFactory;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Scope;

@Configuration
@ComponentScan(basePackageClasses={ESClientSpringFactory.class})
public class ESConfig {
    private static final Logger log = LoggerFactory.getLogger(ESConfig.class);
    @Value(value="${elasticSearch.host}")
    private String host;
    @Value(value="${elasticSearch.port}")
    private int port;
    @Value(value="${elasticSearch.client.connectNum}")
    private Integer connectNum;
    @Value(value="${elasticSearch.client.connectPerRoute}")
    private Integer connectPerRoute;

    public ESConfig() {
        log.info("\u6267\u884c\u5230ESConfig\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
    }

    @Bean
    @DependsOn(value={"elasticsearchTemplate"})
    public HttpHost httpHost() {
        return new HttpHost(this.host, this.port, "http");
    }

    @Bean(initMethod="init", destroyMethod="close")
    @DependsOn(value={"elasticsearchTemplate"})
    public ESClientSpringFactory getFactory() {
        return ESClientSpringFactory.build((HttpHost)this.httpHost(), (Integer)this.connectNum, (Integer)this.connectPerRoute);
    }

    @Bean
    @Scope(value="singleton")
    @DependsOn(value={"elasticsearchTemplate"})
    public RestClient getRestClient() {
        return this.getFactory().getClient();
    }

    @Bean
    @Scope(value="singleton")
    @DependsOn(value={"elasticsearchTemplate"})
    public RestHighLevelClient getRhlClient() {
        return this.getFactory().getRhlClient();
    }
}

