/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.unifiedreg.service.copy.es.EsUtils;

import java.io.IOException;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class ESClientSpringFactory {
    private static final Logger log = LoggerFactory.getLogger(ESClientSpringFactory.class);
    @Value(value="${elasticSearch.username}")
    private String username;
    @Value(value="${elasticSearch.password}")
    private String password;
    public static int CONNECT_TIMEOUT_MILLIS = 1000;
    public static int SOCKET_TIMEOUT_MILLIS = 30000;
    public static int CONNECTION_REQUEST_TIMEOUT_MILLIS = 500;
    public static int MAX_CONN_PER_ROUTE = 10;
    public static int MAX_CONN_TOTAL = 30;
    private static HttpHost HTTP_HOST;
    private RestClientBuilder builder;
    private RestClient restClient;
    private RestHighLevelClient restHighLevelClient;
    private static ESClientSpringFactory esClientSpringFactory;

    private ESClientSpringFactory() {
    }

    public static ESClientSpringFactory build(HttpHost httpHost, Integer maxConnectNum, Integer maxConnectPerRoute) {
        HTTP_HOST = httpHost;
        MAX_CONN_TOTAL = maxConnectNum;
        MAX_CONN_PER_ROUTE = maxConnectPerRoute;
        return esClientSpringFactory;
    }

    public static ESClientSpringFactory build(HttpHost httpHost, Integer connectTimeOut, Integer socketTimeOut, Integer connectionRequestTime, Integer maxConnectNum, Integer maxConnectPerRoute) {
        HTTP_HOST = httpHost;
        CONNECT_TIMEOUT_MILLIS = connectTimeOut;
        SOCKET_TIMEOUT_MILLIS = socketTimeOut;
        CONNECTION_REQUEST_TIMEOUT_MILLIS = connectionRequestTime;
        MAX_CONN_TOTAL = maxConnectNum;
        MAX_CONN_PER_ROUTE = maxConnectPerRoute;
        return esClientSpringFactory;
    }

    public void init() {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
        this.builder = RestClient.builder((HttpHost[])new HttpHost[]{HTTP_HOST}).setHttpClientConfigCallback((RestClientBuilder.HttpClientConfigCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.restClient = this.builder.build();
        this.restHighLevelClient = new RestHighLevelClient(this.restClient);
        log.info("init factory");
    }

    public void setConnectTimeOutConfig() {
        this.builder.setRequestConfigCallback(requestConfigBuilder -> {
            requestConfigBuilder.setConnectTimeout(CONNECT_TIMEOUT_MILLIS);
            requestConfigBuilder.setSocketTimeout(SOCKET_TIMEOUT_MILLIS);
            requestConfigBuilder.setConnectionRequestTimeout(CONNECTION_REQUEST_TIMEOUT_MILLIS);
            return requestConfigBuilder;
        });
    }

    public void setMutiConnectConfig() {
        this.builder.setHttpClientConfigCallback(httpClientBuilder -> {
            httpClientBuilder.setMaxConnTotal(MAX_CONN_TOTAL);
            httpClientBuilder.setMaxConnPerRoute(MAX_CONN_PER_ROUTE);
            return httpClientBuilder;
        });
    }

    public RestClient getClient() {
        return this.restClient;
    }

    public RestHighLevelClient getRhlClient() {
        return this.restHighLevelClient;
    }

    public void close() {
        if (this.restClient != null) {
            try {
                this.restClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        log.info("close client");
    }

    static {
        esClientSpringFactory = new ESClientSpringFactory();
    }
}

