/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.unifiedreg.service.copy.datafetch.util;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.etlservice.interfaces.ErrorRecordProviderRpc;
import com.bizvane.members.facade.enums.FetchErrorType;
import com.bizvane.members.facade.enums.FocusStatusEnum;
import com.bizvane.members.facade.models.IntegralRecordModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.OrderDetailModel;
import com.bizvane.members.facade.models.OrderModel;
import com.bizvane.members.facade.models.po.MbrEuCurrencyRecordPO;
import com.bizvane.members.facade.models.query.FetchMessagePo;
import com.bizvane.members.facade.service.datafetch.model.BaseFetchModel;
import com.bizvane.members.facade.service.datafetch.model.CodeToId;
import com.bizvane.members.facade.service.datafetch.model.EuCurrencyFetchModel;
import com.bizvane.members.facade.service.datafetch.model.IntegralRecordFetchModel;
import com.bizvane.members.facade.service.datafetch.model.MemberBalanceModel;
import com.bizvane.members.facade.service.datafetch.model.MemberCardInfoFetchModel;
import com.bizvane.members.facade.service.datafetch.model.MemberIntegralFetchModel;
import com.bizvane.members.facade.service.datafetch.model.MemberOrderDetailFetchModel;
import com.bizvane.members.facade.service.datafetch.model.MemberOrderFetchModel;
import com.bizvane.members.facade.service.datafetch.model.MemberRelationFetchModel;
import com.bizvane.redis.canal.dto.BrandCacheDto;
import com.bizvane.redis.canal.dto.CompanyCacheDto;
import com.bizvane.redis.canal.dto.LevelCacheDto;
import com.bizvane.redis.canal.dto.StaffCacheDto;
import com.bizvane.redis.canal.dto.StoreCacheDto;
import com.bizvane.redis.canal.service.IRedisCacheService;
import com.bizvane.unifiedreg.service.copy.mapper.MemberInfoMapper;
import com.bizvane.unifiedreg.tools.ParamValidation;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import tk.mybatis.mapper.util.StringUtil;

@Component
public class FetchUtil {
    private static final Logger log = LoggerFactory.getLogger(FetchUtil.class);
    @Resource
    private ErrorRecordProviderRpc errorRecordProviderRpc;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private MemberInfoMapper memberInfoMapper;
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;
    @Autowired
    private IRedisCacheService iRedisCacheService;
    private ExecutorService executorService = new ThreadPoolExecutor(10, 10, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(Integer.MAX_VALUE), new ThreadPoolExecutor.CallerRunsPolicy());

    public <T extends BaseFetchModel> ResponseData verifyMessage(T t, String topic, String topicType, String businessWay) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        if (t == null) {
            return responseData;
        }
        if (StringUtils.isEmpty((CharSequence)t.getBusinessId())) {
            responseData.setMessage("businessid\u4e3a\u7a7a");
            return responseData;
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public <T extends BaseFetchModel> ResponseData baseParamValidation(T t, String topic, String topicType, String businessWay) {
        ResponseData responseData = new ResponseData();
        if (ParamValidation.isNull((Object)t.getOfflineBrandCode())) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u7ebf\u4e0bbrandCode\u4e3a\u7a7a");
            return responseData;
        }
        if (ParamValidation.isNull((Object)t.getOfflineCompanyCode())) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u7ebf\u4e0bcompanyCode\u4e3a\u7a7a");
            return responseData;
        }
        if (ParamValidation.isNull((Object)t.getErpId())) {
            responseData.setCode(SysResponseEnum.OPERATE_FAILED_ADD_ERROR.getCode());
            responseData.setMessage("\u7ebf\u4e0berpId\u4e3a\u7a7a");
            return responseData;
        }
        if (ParamValidation.isNull((Object)t.getOfflineUpdateDate())) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("offlineUpdateDate\u4e3a\u7a7a");
            return responseData;
        }
        return responseData;
    }

    public <T extends BaseFetchModel> void errorRecord(T t, String businessWay, String errorType, String topic, String topicType, String fieldName, String errorMsg) {
        this.executorService.execute(() -> {
            this.fetchErrorRecord(t, businessWay, errorType, topic, topicType, fieldName, errorMsg);
            if (StringUtil.isNotEmpty((String)fieldName)) {
                this.etlErrorRecord(t, errorType, topic, fieldName, errorMsg);
            }
        });
    }

    private <T extends BaseFetchModel> int fetchErrorRecord(T t, String businessWay, String errorType, String topic, String topicType, String fieldName, String errorMsg) {
        return 1;
    }

    private <T extends BaseFetchModel> void etlErrorRecord(T t, String errorType, String topic, String fieldName, String errorMsg) {
        String errMessage = FetchErrorType.CODE_TO_ID.getMsg() + " " + fieldName;
        JSONObject json = new JSONObject();
        json.put("topic", (Object)topic);
        t.setTopicName(topic);
        t.setErrorInfo(errorMsg);
        JSONArray jsonArray = new JSONArray();
        jsonArray.add(t);
        json.put("data", (Object)jsonArray);
        if ("memberCode".equals(fieldName)) {
            json.put("type", (Object)"1");
        } else {
            json.put("type", (Object)"0");
        }
        try {
            log.info("\u8c03\u7528etl\u8bb0\u5f55\u9519\u8bef:{}" + jsonArray);
            this.errorRecordProviderRpc.receiveErrorJSONObject(json);
        }
        catch (Exception e) {
            log.info("\u8c03\u7528etl\u9519\u8bef\u8bb0\u5f55\u51fa\u9519!");
            log.error("error:{}", (Throwable)e);
        }
    }

    public <T> CodeToId codeTransformId(Object obj, T t) {
        MemberOrderFetchModel memberOrderFetchModel;
        MemberOrderDetailFetchModel memberOrderDetailFetchModel;
        MemberIntegralFetchModel memberIntegralFetchModel;
        MemberCardInfoFetchModel memberCardInfoFetchModel;
        MemberBalanceModel memberBalanceModel;
        IntegralRecordFetchModel integralRecordFetchModel;
        EuCurrencyFetchModel euCurrencyFetchModel;
        CodeToId codeToId = new CodeToId();
        if (obj instanceof EuCurrencyFetchModel) {
            euCurrencyFetchModel = (EuCurrencyFetchModel)obj;
            codeToId.setOfflineCompanyCode(euCurrencyFetchModel.getOfflineCompanyCode());
            codeToId.setOfflineBrandCode(euCurrencyFetchModel.getOfflineBrandCode());
            codeToId.setErpId(euCurrencyFetchModel.getErpId());
            codeToId.setBussinessNo(euCurrencyFetchModel.getBussinessNo());
        } else if (obj instanceof IntegralRecordFetchModel) {
            integralRecordFetchModel = (IntegralRecordFetchModel)obj;
            codeToId.setOfflineCompanyCode(integralRecordFetchModel.getOfflineCompanyCode());
            codeToId.setOfflineBrandCode(integralRecordFetchModel.getOfflineBrandCode());
            codeToId.setErpId(integralRecordFetchModel.getErpId());
        } else if (obj instanceof MemberBalanceModel) {
            memberBalanceModel = (MemberBalanceModel)obj;
            codeToId.setOfflineCompanyCode(memberBalanceModel.getOfflineCompanyCode());
            codeToId.setOfflineBrandCode(memberBalanceModel.getOfflineBrandCode());
            codeToId.setPetCard(memberBalanceModel.getPetCard());
            codeToId.setErpId(memberBalanceModel.getErpId());
        } else if (obj instanceof MemberCardInfoFetchModel) {
            memberCardInfoFetchModel = (MemberCardInfoFetchModel)obj;
            codeToId.setOfflineCompanyCode(memberCardInfoFetchModel.getOfflineCompanyCode());
            codeToId.setOfflineBrandCode(memberCardInfoFetchModel.getOfflineBrandCode());
            codeToId.setOpenCardGuideCode(memberCardInfoFetchModel.getOpenCardGuideCode());
            codeToId.setOpenCardStoreCode(memberCardInfoFetchModel.getOpenCardStoreCode());
            codeToId.setServiceGuideCode(memberCardInfoFetchModel.getServiceGuideCode());
            codeToId.setServiceStoreCode(memberCardInfoFetchModel.getServiceStoreCode());
            codeToId.setOfflineLevelCode(memberCardInfoFetchModel.getOfflineLevelCode());
            codeToId.setErpId(memberCardInfoFetchModel.getErpId());
            codeToId.setOrgStoreCode(memberCardInfoFetchModel.getOrgStoreCode());
            codeToId.setZipCode(memberCardInfoFetchModel.getZipCode());
            codeToId.setOpenCardStoreId(memberCardInfoFetchModel.getOpenCardStoreId());
            codeToId.setServiceStoreId(memberCardInfoFetchModel.getServiceStoreId());
            codeToId.setOpenCardGuideId(memberCardInfoFetchModel.getOpenCardGuideId());
            codeToId.setServiceGuideId(memberCardInfoFetchModel.getServiceGuideId());
        } else if (obj instanceof MemberIntegralFetchModel) {
            memberIntegralFetchModel = (MemberIntegralFetchModel)obj;
            codeToId.setOfflineCompanyCode(memberIntegralFetchModel.getOfflineCompanyCode());
            codeToId.setOfflineBrandCode(memberIntegralFetchModel.getOfflineBrandCode());
            codeToId.setErpId(memberIntegralFetchModel.getErpId());
        } else if (obj instanceof MemberOrderDetailFetchModel) {
            memberOrderDetailFetchModel = (MemberOrderDetailFetchModel)obj;
            codeToId.setOfflineCompanyCode(memberOrderDetailFetchModel.getOfflineCompanyCode());
            codeToId.setOfflineBrandCode(memberOrderDetailFetchModel.getOfflineBrandCode());
            codeToId.setOfflineProductGuideCode(memberOrderDetailFetchModel.getOfflineProductGuideCode());
            codeToId.setErpId(memberOrderDetailFetchModel.getErpId());
        } else if (obj instanceof MemberOrderFetchModel) {
            memberOrderFetchModel = (MemberOrderFetchModel)obj;
            codeToId.setOfflineCompanyCode(memberOrderFetchModel.getOfflineCompanyCode());
            codeToId.setOfflineBrandCode(memberOrderFetchModel.getOfflineBrandCode());
            codeToId.setServiceStoreCode(memberOrderFetchModel.getServiceStoreCode());
            codeToId.setErpId(memberOrderFetchModel.getErpId());
            codeToId.setOfflineServiceGuideProportions(memberOrderFetchModel.getOfflineServiceGuideProportions());
            codeToId.setOfflineServiceGuideCodes(memberOrderFetchModel.getOfflineServiceGuideCodes());
            codeToId.setOfflineServiceGuideNames(memberOrderFetchModel.getOfflineServiceGuideNames());
        } else if (obj instanceof MemberRelationFetchModel) {
            MemberRelationFetchModel memberRelationFetchModel = (MemberRelationFetchModel)obj;
            codeToId.setOfflineCompanyCode(memberRelationFetchModel.getOfflineCompanyCode());
            codeToId.setOfflineBrandCode(memberRelationFetchModel.getOfflineBrandCode());
            codeToId.setErpId(memberRelationFetchModel.getErpId());
        }
        codeToId = this.codeTransformIdByRedisCanal(codeToId);
        if (obj instanceof EuCurrencyFetchModel && t instanceof MbrEuCurrencyRecordPO) {
            euCurrencyFetchModel = (EuCurrencyFetchModel)obj;
            MbrEuCurrencyRecordPO mbrEuCurrencyRecordPo = (MbrEuCurrencyRecordPO)t;
            mbrEuCurrencyRecordPo.setTotalAmount(euCurrencyFetchModel.getTotalAmount());
            mbrEuCurrencyRecordPo.setAmount(euCurrencyFetchModel.getAmount());
            mbrEuCurrencyRecordPo.setOrderNo(euCurrencyFetchModel.getOrderNo());
            mbrEuCurrencyRecordPo.setPlaceOrderTime(euCurrencyFetchModel.getPlaceOrderTime());
            mbrEuCurrencyRecordPo.setStoreName(euCurrencyFetchModel.getStoreName());
            mbrEuCurrencyRecordPo.setOfflineCompanyCode(euCurrencyFetchModel.getOfflineCompanyCode());
            euCurrencyFetchModel.getOfflineBrandCode();
            mbrEuCurrencyRecordPo.setOfflineUpdateDate(euCurrencyFetchModel.getOfflineUpdateDate());
            euCurrencyFetchModel.getTopicName();
            euCurrencyFetchModel.getErrorInfo();
            mbrEuCurrencyRecordPo.setErpId(euCurrencyFetchModel.getErpId());
            mbrEuCurrencyRecordPo.setOfflineCompanyCode(codeToId.getOfflineCompanyCode());
            mbrEuCurrencyRecordPo.setBrandCode(euCurrencyFetchModel.getOfflineBrandCode());
            mbrEuCurrencyRecordPo.setSysCompanyId(codeToId.getSysCompanyId());
            mbrEuCurrencyRecordPo.setBrandId(codeToId.getBrandId());
            mbrEuCurrencyRecordPo.setErpId(codeToId.getErpId());
            mbrEuCurrencyRecordPo.setMemberCode(codeToId.getMemberCode());
            mbrEuCurrencyRecordPo.setBussinessNo(codeToId.getBussinessNo());
        } else if (obj instanceof IntegralRecordFetchModel && t instanceof IntegralRecordModel) {
            integralRecordFetchModel = (IntegralRecordFetchModel)obj;
            IntegralRecordModel integralRecordModel = (IntegralRecordModel)t;
            integralRecordModel.setChangeBills(integralRecordFetchModel.getChangeBills());
            integralRecordModel.setChangeIntegral(integralRecordFetchModel.getChangeIntegral());
            integralRecordModel.setChangeDate(integralRecordFetchModel.getChangeDate());
            integralRecordModel.setChangeWay(integralRecordFetchModel.getChangeWay());
            integralRecordModel.setChangeDetails(integralRecordFetchModel.getChangeDetails());
            integralRecordModel.setBusinessWay(integralRecordFetchModel.getBusinessWay());
            integralRecordModel.setEffectiveTime(integralRecordFetchModel.getEffectiveTime());
            integralRecordModel.setRemark(integralRecordFetchModel.getRemark());
            integralRecordModel.setOfflineIntegralId(integralRecordFetchModel.getOfflineIntegralId());
            integralRecordModel.setOfflineCompanyCode(integralRecordFetchModel.getOfflineCompanyCode());
            integralRecordModel.setOfflineBrandCode(integralRecordFetchModel.getOfflineBrandCode());
            integralRecordFetchModel.getOfflineUpdateDate();
            integralRecordFetchModel.getTopicName();
            integralRecordFetchModel.getErrorInfo();
            integralRecordModel.setErpId(integralRecordFetchModel.getErpId());
            integralRecordModel.setOfflineCompanyCode(codeToId.getOfflineCompanyCode());
            integralRecordModel.setSysCompanyId(codeToId.getSysCompanyId());
            integralRecordModel.setOfflineBrandCode(codeToId.getOfflineBrandCode());
            integralRecordModel.setBrandId(codeToId.getBrandId());
            integralRecordModel.setErpId(codeToId.getErpId());
            integralRecordModel.setMemberCode(codeToId.getMemberCode());
        } else if (obj instanceof MemberBalanceModel && t instanceof MemberInfoModel) {
            memberBalanceModel = (MemberBalanceModel)obj;
            MemberInfoModel memberInfoModel = (MemberInfoModel)t;
            memberInfoModel.setBalance(memberBalanceModel.getBalance());
            memberInfoModel.setOfflineUpdateBalanceDate(memberBalanceModel.getOfflineUpdateBalanceDate());
            memberInfoModel.setOfflineCompanyCode(memberBalanceModel.getOfflineCompanyCode());
            memberInfoModel.setOfflineBrandCode(memberBalanceModel.getOfflineBrandCode());
            memberInfoModel.setOfflineUpdateDate(memberBalanceModel.getOfflineUpdateDate());
            memberInfoModel.setErpId(memberBalanceModel.getErpId());
            memberInfoModel.setOfflineCompanyCode(codeToId.getOfflineCompanyCode());
            memberInfoModel.setSysCompanyId(codeToId.getSysCompanyId());
            memberInfoModel.setOfflineBrandCode(codeToId.getOfflineBrandCode());
            memberInfoModel.setBrandId(codeToId.getBrandId());
            memberInfoModel.setOpenCardGuideCode(codeToId.getOpenCardGuideCode());
            memberInfoModel.setOpenCardGuideId(codeToId.getOpenCardGuideId());
            memberInfoModel.setOpenCardStoreCode(codeToId.getOpenCardStoreCode());
            memberInfoModel.setOpenCardStoreId(codeToId.getOpenCardStoreId());
            memberInfoModel.setServiceGuideCode(codeToId.getServiceGuideCode());
            memberInfoModel.setServiceGuideId(codeToId.getServiceGuideId());
            memberInfoModel.setServiceStoreCode(codeToId.getServiceStoreCode());
            memberInfoModel.setServiceStoreId(codeToId.getServiceStoreId());
            memberInfoModel.setOfflineLevelCode(codeToId.getOfflineLevelCode());
            memberInfoModel.setLevelId(codeToId.getLevelId());
            memberInfoModel.setErpId(codeToId.getErpId());
            memberInfoModel.setMemberCode(codeToId.getMemberCode());
            memberInfoModel.setFirstOrderTime(codeToId.getFirstOrderTime());
            memberInfoModel.setWxUnionId(codeToId.getWxUnionId());
            memberInfoModel.setPetCard(memberBalanceModel.getPetCard());
        } else if (obj instanceof MemberCardInfoFetchModel && t instanceof MemberInfoModel) {
            memberCardInfoFetchModel = (MemberCardInfoFetchModel)obj;
            MemberInfoModel memberInfoModel = (MemberInfoModel)t;
            memberInfoModel.setCardNo(memberCardInfoFetchModel.getCardNo());
            memberInfoModel.setOfflineCardNo(memberCardInfoFetchModel.getOfflineCardNo());
            memberInfoModel.setName(memberCardInfoFetchModel.getName());
            memberInfoModel.setPhone(memberCardInfoFetchModel.getPhone());
            memberInfoModel.setIdCard(memberCardInfoFetchModel.getIdCard());
            memberInfoModel.setGender(memberCardInfoFetchModel.getGender());
            memberInfoModel.setBirthday(memberCardInfoFetchModel.getBirthday());
            memberInfoModel.setBirthdayMd(memberCardInfoFetchModel.getBirthdayMd());
            memberInfoModel.setProvince(memberCardInfoFetchModel.getProvince());
            memberInfoModel.setCity(memberCardInfoFetchModel.getCity());
            memberInfoModel.setCounty(memberCardInfoFetchModel.getCounty());
            memberInfoModel.setAddress(memberCardInfoFetchModel.getAddress());
            memberInfoModel.setEmail(memberCardInfoFetchModel.getEmail());
            memberInfoModel.setOpenCardTime(memberCardInfoFetchModel.getOpenCardTime());
            memberInfoModel.setBindCardTime(memberCardInfoFetchModel.getBindCardTime());
            memberInfoModel.setEffectiveTime(memberCardInfoFetchModel.getEffectiveTime());
            memberCardInfoFetchModel.getMemberSource();
            memberInfoModel.setOpenCardChannelId(memberCardInfoFetchModel.getOpenCardChannelId() != null ? Long.valueOf(memberCardInfoFetchModel.getOpenCardChannelId().longValue()) : null);
            memberInfoModel.setGeneralizeChannel(memberCardInfoFetchModel.getGeneralizeChannel());
            memberInfoModel.setOpenCardGuideCode(memberCardInfoFetchModel.getOpenCardGuideCode());
            memberInfoModel.setOfflineDealerAttributionCode(memberCardInfoFetchModel.getOfflineDealerAttributionCode());
            memberInfoModel.setDealerAttributionName(memberCardInfoFetchModel.getDealerAttributionName());
            memberInfoModel.setOpenCardStoreCode(memberCardInfoFetchModel.getOpenCardStoreCode());
            memberInfoModel.setServiceStoreCode(memberCardInfoFetchModel.getServiceStoreCode());
            memberInfoModel.setServiceGuideCode(memberCardInfoFetchModel.getServiceGuideCode());
            memberInfoModel.setOfflineLevelCode(memberCardInfoFetchModel.getOfflineLevelCode());
            memberInfoModel.setCountIntegral(memberCardInfoFetchModel.getCountIntegral());
            memberInfoModel.setRemark(memberCardInfoFetchModel.getRemark());
            memberInfoModel.setAddUpIntegral(memberCardInfoFetchModel.getAddUpIntegral());
            memberInfoModel.setAboutExpireIntegral(memberCardInfoFetchModel.getAboutExpireIntegral());
            memberInfoModel.setAboutExpireTime(memberCardInfoFetchModel.getAboutExpireTime());
            memberInfoModel.setPastDueIntegral(memberCardInfoFetchModel.getPastDueIntegral());
            memberInfoModel.setConsumeIntegral(memberCardInfoFetchModel.getConsumeIntegral());
            memberInfoModel.setFreezeIntegral(memberCardInfoFetchModel.getFreezeIntegral());
            memberCardInfoFetchModel.getExtend();
            memberInfoModel.setValid(memberCardInfoFetchModel.getValid());
            memberInfoModel.setBalance(memberCardInfoFetchModel.getBalance());
            memberInfoModel.setPetCard(memberCardInfoFetchModel.getPetCard());
            memberInfoModel.setOfflineCompanyCode(memberCardInfoFetchModel.getOfflineCompanyCode());
            memberInfoModel.setOfflineBrandCode(memberCardInfoFetchModel.getOfflineBrandCode());
            memberInfoModel.setOfflineUpdateDate(memberCardInfoFetchModel.getOfflineUpdateDate());
            memberCardInfoFetchModel.getTopicName();
            memberCardInfoFetchModel.getErrorInfo();
            memberInfoModel.setErpId(memberCardInfoFetchModel.getErpId());
            memberInfoModel.setRegisterType(memberCardInfoFetchModel.getRegisterType());
            memberInfoModel.setOfflineCompanyCode(codeToId.getOfflineCompanyCode());
            memberInfoModel.setSysCompanyId(codeToId.getSysCompanyId());
            memberInfoModel.setOfflineBrandCode(codeToId.getOfflineBrandCode());
            memberInfoModel.setBrandId(codeToId.getBrandId());
            if ("P40079".equals(codeToId.getOfflineCompanyCode()) && "baoguang".equals(codeToId.getOfflineBrandCode()) || "U30079".equals(codeToId.getOfflineCompanyCode()) && "baoguang".equals(codeToId.getOfflineBrandCode())) {
                memberInfoModel.setOpenCardGuideCode(memberCardInfoFetchModel.getOpenCardGuideCode());
                memberInfoModel.setOpenCardGuideId(memberCardInfoFetchModel.getOpenCardGuideId());
                memberInfoModel.setOpenCardStoreCode(memberCardInfoFetchModel.getOpenCardStoreCode());
                memberInfoModel.setOpenCardStoreId(memberCardInfoFetchModel.getOpenCardStoreId());
            } else {
                memberInfoModel.setOpenCardGuideCode(codeToId.getOpenCardGuideCode());
                memberInfoModel.setOpenCardGuideId(codeToId.getOpenCardGuideId());
                memberInfoModel.setOpenCardStoreCode(codeToId.getOpenCardStoreCode());
                memberInfoModel.setOpenCardStoreId(codeToId.getOpenCardStoreId());
                memberInfoModel.setServiceGuideCode(codeToId.getServiceGuideCode());
                memberInfoModel.setServiceGuideId(codeToId.getServiceGuideId());
                memberInfoModel.setServiceStoreCode(codeToId.getServiceStoreCode());
                memberInfoModel.setServiceStoreId(codeToId.getServiceStoreId());
            }
            memberInfoModel.setOfflineLevelCode(codeToId.getOfflineLevelCode());
            memberInfoModel.setLevelId(codeToId.getLevelId());
            memberInfoModel.setErpId(codeToId.getErpId());
            memberInfoModel.setMemberCode(codeToId.getMemberCode());
            memberInfoModel.setFirstOrderTime(codeToId.getFirstOrderTime());
            memberInfoModel.setWxUnionId(codeToId.getWxUnionId());
            memberInfoModel.setCardUseStatus(memberCardInfoFetchModel.getCardUseStatus());
            memberInfoModel.setAreaCode(memberCardInfoFetchModel.getAreaCode());
        } else if (obj instanceof MemberIntegralFetchModel && t instanceof MemberInfoModel) {
            memberIntegralFetchModel = (MemberIntegralFetchModel)obj;
            MemberInfoModel memberInfoModel = (MemberInfoModel)t;
            memberInfoModel.setCountIntegral(memberIntegralFetchModel.getCountIntegral());
            memberInfoModel.setAddUpIntegral(memberIntegralFetchModel.getAddUpIntegral());
            memberInfoModel.setAboutExpireIntegral(memberIntegralFetchModel.getAboutExpireIntegral());
            memberInfoModel.setAboutExpireTime(memberIntegralFetchModel.getAboutExpireTime());
            memberInfoModel.setPastDueIntegral(memberIntegralFetchModel.getPastDueIntegral());
            memberInfoModel.setConsumeIntegral(memberIntegralFetchModel.getConsumeIntegral());
            memberInfoModel.setFreezeIntegral(memberIntegralFetchModel.getFreezeIntegral());
            memberInfoModel.setOfflineUpdateIntegralDate(memberIntegralFetchModel.getOfflineUpdateIntegralDate());
            memberInfoModel.setOfflineCompanyCode(memberIntegralFetchModel.getOfflineCompanyCode());
            memberInfoModel.setOfflineBrandCode(memberIntegralFetchModel.getOfflineBrandCode());
            memberInfoModel.setOfflineUpdateDate(memberIntegralFetchModel.getOfflineUpdateDate());
            memberIntegralFetchModel.getTopicName();
            memberIntegralFetchModel.getErrorInfo();
            memberInfoModel.setErpId(memberIntegralFetchModel.getErpId());
            memberInfoModel.setOfflineCompanyCode(codeToId.getOfflineCompanyCode());
            memberInfoModel.setSysCompanyId(codeToId.getSysCompanyId());
            memberInfoModel.setOfflineBrandCode(codeToId.getOfflineBrandCode());
            memberInfoModel.setBrandId(codeToId.getBrandId());
            memberInfoModel.setOpenCardGuideCode(codeToId.getOpenCardGuideCode());
            memberInfoModel.setOpenCardGuideId(codeToId.getOpenCardGuideId());
            memberInfoModel.setOpenCardStoreCode(codeToId.getOpenCardStoreCode());
            memberInfoModel.setOpenCardStoreId(codeToId.getOpenCardStoreId());
            memberInfoModel.setServiceGuideCode(codeToId.getServiceGuideCode());
            memberInfoModel.setServiceGuideId(codeToId.getServiceGuideId());
            memberInfoModel.setServiceStoreCode(codeToId.getServiceStoreCode());
            memberInfoModel.setServiceStoreId(codeToId.getServiceStoreId());
            memberInfoModel.setOfflineLevelCode(codeToId.getOfflineLevelCode());
            memberInfoModel.setLevelId(codeToId.getLevelId());
            memberInfoModel.setErpId(codeToId.getErpId());
            memberInfoModel.setMemberCode(codeToId.getMemberCode());
            memberInfoModel.setFirstOrderTime(codeToId.getFirstOrderTime());
            memberInfoModel.setWxUnionId(codeToId.getWxUnionId());
        } else if (obj instanceof MemberOrderDetailFetchModel && t instanceof OrderDetailModel) {
            memberOrderDetailFetchModel = (MemberOrderDetailFetchModel)obj;
            OrderDetailModel orderDetailModel = (OrderDetailModel)t;
            orderDetailModel.setOrderNo(memberOrderDetailFetchModel.getOrderNo());
            orderDetailModel.setOrderDetailNo(memberOrderDetailFetchModel.getOrderDetailNo());
            orderDetailModel.setProductItemId(memberOrderDetailFetchModel.getProductItemId());
            orderDetailModel.setQuantity(memberOrderDetailFetchModel.getQuantity());
            orderDetailModel.setSpecification(memberOrderDetailFetchModel.getSpecification());
            orderDetailModel.setColor(memberOrderDetailFetchModel.getColor());
            orderDetailModel.setSize(memberOrderDetailFetchModel.getSize());
            orderDetailModel.setOfflineProductGuideCode(memberOrderDetailFetchModel.getOfflineProductGuideCode());
            orderDetailModel.setProductGuideName(memberOrderDetailFetchModel.getProductGuideName());
            orderDetailModel.setProductNo(memberOrderDetailFetchModel.getProductNo());
            orderDetailModel.setProductName(memberOrderDetailFetchModel.getProductName());
            orderDetailModel.setTagPrice(memberOrderDetailFetchModel.getTagPrice());
            orderDetailModel.setTradeAmountDetail(memberOrderDetailFetchModel.getTradeAmountDetail());
            orderDetailModel.setActivity(memberOrderDetailFetchModel.getActivity());
            orderDetailModel.setRemark(memberOrderDetailFetchModel.getRemark());
            memberOrderDetailFetchModel.getOrderType();
            orderDetailModel.setOfflineCompanyCode(memberOrderDetailFetchModel.getOfflineCompanyCode());
            orderDetailModel.setOfflineBrandCode(memberOrderDetailFetchModel.getOfflineBrandCode());
            orderDetailModel.setOfflineUpdateDate(memberOrderDetailFetchModel.getOfflineUpdateDate());
            memberOrderDetailFetchModel.getTopicName();
            memberOrderDetailFetchModel.getErrorInfo();
            orderDetailModel.setErpId(memberOrderDetailFetchModel.getErpId());
            orderDetailModel.setOfflineCompanyCode(codeToId.getOfflineCompanyCode());
            orderDetailModel.setSysCompanyId(codeToId.getSysCompanyId());
            orderDetailModel.setOfflineBrandCode(codeToId.getOfflineBrandCode());
            orderDetailModel.setBrandId(codeToId.getBrandId());
            orderDetailModel.setOfflineProductGuideCode(codeToId.getOfflineProductGuideCode());
            orderDetailModel.setProductGuideId(codeToId.getProductGuideId());
            orderDetailModel.setErpId(codeToId.getErpId());
            orderDetailModel.setMemberCode(codeToId.getMemberCode());
            orderDetailModel.setSku(memberOrderDetailFetchModel.getSku());
            orderDetailModel.setServiceGuideIds(memberOrderDetailFetchModel.getServiceGuideIds());
            orderDetailModel.setServiceGuideProportion(memberOrderDetailFetchModel.getServiceGuideProportion());
        } else if (obj instanceof MemberOrderFetchModel && t instanceof OrderModel) {
            memberOrderFetchModel = (MemberOrderFetchModel)obj;
            OrderModel orderModel = (OrderModel)t;
            orderModel.setOrderNo(memberOrderFetchModel.getOrderNo());
            orderModel.setOrderFrom(memberOrderFetchModel.getOrderFrom());
            orderModel.setOrderType(memberOrderFetchModel.getOrderType());
            orderModel.setUsedIntegral(memberOrderFetchModel.getUsedIntegral());
            orderModel.setGetedIntegral(memberOrderFetchModel.getGetedIntegral());
            orderModel.setPreferentialAmount(memberOrderFetchModel.getPreferentialAmount());
            orderModel.setDeductibleAmount(memberOrderFetchModel.getDeductibleAmount());
            orderModel.setCommodityAmount(memberOrderFetchModel.getCommodityAmount());
            orderModel.setTradeAmount(memberOrderFetchModel.getTradeAmount());
            orderModel.setOtherPreferentialVolume(memberOrderFetchModel.getOtherPreferentialVolume());
            orderModel.setPlaceOrderTime(memberOrderFetchModel.getPlaceOrderTime());
            orderModel.setPlaceOrderCount(memberOrderFetchModel.getPlaceOrderCount());
            orderModel.setPayTime(memberOrderFetchModel.getPayTime());
            orderModel.setPayMoney(memberOrderFetchModel.getPayMoney());
            orderModel.setProductCount(memberOrderFetchModel.getProductCount());
            memberOrderFetchModel.getLogisticsName();
            orderModel.setConsigneePhone(memberOrderFetchModel.getConsigneePhone());
            orderModel.setConsigneeName(memberOrderFetchModel.getConsigneeName());
            orderModel.setConsigneeDetailed(memberOrderFetchModel.getConsigneeDetailed());
            orderModel.setConsigneeProvince(memberOrderFetchModel.getConsigneeProvince());
            orderModel.setConsigneeCity(memberOrderFetchModel.getConsigneeCity());
            orderModel.setConsigneeArea(memberOrderFetchModel.getConsigneeArea());
            orderModel.setConsigneeStreet(memberOrderFetchModel.getConsigneeStreet());
            orderModel.setComfirmTime(memberOrderFetchModel.getComfirmTime());
            memberOrderFetchModel.getUnsigned();
            orderModel.setPostage(memberOrderFetchModel.getPostage());
            orderModel.setSendTime(memberOrderFetchModel.getSendTime());
            memberOrderFetchModel.getCouponNo();
            orderModel.setServiceStoreCode(memberOrderFetchModel.getServiceStoreCode());
            orderModel.setServiceStoreName(memberOrderFetchModel.getServiceStoreName());
            orderModel.setServiceStoreSite(memberOrderFetchModel.getServiceStoreSite());
            orderModel.setServiceGuideName(memberOrderFetchModel.getServiceGuideName());
            orderModel.setFreePostage(memberOrderFetchModel.getFreePostage());
            orderModel.setEvaluateStatus(memberOrderFetchModel.getEvaluateStatus());
            memberOrderFetchModel.getSendStoreName();
            orderModel.setValid(memberOrderFetchModel.getValid());
            orderModel.setRemark(memberOrderFetchModel.getRemark());
            orderModel.setOfflineCompanyCode(memberOrderFetchModel.getOfflineCompanyCode());
            orderModel.setOfflineBrandCode(memberOrderFetchModel.getOfflineBrandCode());
            orderModel.setOfflineUpdateDate(memberOrderFetchModel.getOfflineUpdateDate());
            orderModel.setErpId(memberOrderFetchModel.getErpId());
            orderModel.setOfflineCompanyCode(codeToId.getOfflineCompanyCode());
            orderModel.setSysCompanyId(codeToId.getSysCompanyId());
            orderModel.setOfflineBrandCode(codeToId.getOfflineBrandCode());
            orderModel.setBrandId(codeToId.getBrandId());
            orderModel.setServiceGuideId(codeToId.getServiceGuideId());
            orderModel.setServiceStoreCode(codeToId.getServiceStoreCode());
            orderModel.setServiceStoreId(codeToId.getServiceStoreId());
            orderModel.setErpId(codeToId.getErpId());
            orderModel.setMemberCode(codeToId.getMemberCode());
            orderModel.setServiceGuideProportion(codeToId.getOfflineServiceGuideProportions());
            orderModel.setServiceGuideIds(codeToId.getOfflineServiceGuideCodes());
            orderModel.setServiceGuideNames(codeToId.getOfflineServiceGuideNames());
            if (memberOrderFetchModel.getBillTime() == null) {
                orderModel.setBillTime(memberOrderFetchModel.getPlaceOrderTime());
            } else {
                DateTime billTime = DateUtil.parse((CharSequence)memberOrderFetchModel.getBillTime(), (String)"yyyy-MM-dd HH:mm:ss");
                orderModel.setBillTime((Date)billTime);
            }
        }
        return codeToId;
    }

    private CodeToId codeTransformIdByRedisCanal(CodeToId codeToId) {
        StoreCacheDto storeCache;
        StaffCacheDto staffCache;
        MemberInfoModel memberInfoModel;
        Long sysCompanyId = null;
        if (StringUtils.isNotEmpty((CharSequence)codeToId.getOfflineCompanyCode())) {
            CompanyCacheDto companyCache = this.iRedisCacheService.getCompanyCache(codeToId.getOfflineCompanyCode());
            if (companyCache == null) {
                return codeToId;
            }
            sysCompanyId = companyCache.getCompanyId();
            if (ParamValidation.isNull((Object)sysCompanyId)) {
                return codeToId;
            }
            codeToId.setSysCompanyId(sysCompanyId);
        }
        Long brandId = null;
        if (StringUtils.isNotEmpty((CharSequence)codeToId.getOfflineBrandCode())) {
            BrandCacheDto brandCache = this.iRedisCacheService.getBrandCache(sysCompanyId, codeToId.getOfflineBrandCode());
            if (brandCache == null) {
                return codeToId;
            }
            brandId = brandCache.getBrandId();
            if (ParamValidation.isNull((Object)brandId)) {
                return codeToId;
            }
            codeToId.setBrandId(brandId);
        }
        if (StringUtils.isNotEmpty((CharSequence)codeToId.getOfflineBrandCode()) && StringUtils.isNotEmpty((CharSequence)codeToId.getErpId()) && brandId != null && (memberInfoModel = this.memberInfoMapper.queryMemberInfoByErpIdAndBrandId(codeToId.getErpId(), brandId)) != null) {
            codeToId.setMemberCode(memberInfoModel.getMemberCode());
            codeToId.setFirstOrderTime(memberInfoModel.getFirstOrderTime());
            codeToId.setWxUnionId(memberInfoModel.getWxUnionId());
            codeToId.setOpenCardStoreId(memberInfoModel.getOpenCardStoreId());
            codeToId.setMemberServiceStoreId(memberInfoModel.getServiceStoreId());
            codeToId.setMemberServiceGuideId(memberInfoModel.getServiceGuideId());
            codeToId.setOfflineCardNo(memberInfoModel.getOfflineCardNo());
        }
        if (StringUtils.isNotEmpty((CharSequence)codeToId.getOpenCardGuideCode())) {
            Long openCardGuideId = null;
            staffCache = this.iRedisCacheService.getStaffCache(sysCompanyId, codeToId.getOpenCardGuideCode());
            if (staffCache != null) {
                openCardGuideId = staffCache.getStaffId();
            }
            codeToId.setOpenCardGuideId(openCardGuideId);
        }
        if (StringUtils.isNotEmpty((CharSequence)codeToId.getOpenCardStoreCode())) {
            Long openCardStoreId = null;
            storeCache = this.iRedisCacheService.getStoreCache(brandId, codeToId.getOpenCardStoreCode());
            if (storeCache != null) {
                openCardStoreId = storeCache.getStoreId();
            }
            codeToId.setOpenCardStoreId(openCardStoreId);
        }
        if (StringUtils.isNotEmpty((CharSequence)codeToId.getServiceGuideCode())) {
            Long serviceGuideId = null;
            staffCache = this.iRedisCacheService.getStaffCache(sysCompanyId, codeToId.getServiceGuideCode());
            if (staffCache != null) {
                serviceGuideId = staffCache.getStaffId();
            }
            codeToId.setServiceGuideId(serviceGuideId);
        }
        if (StringUtils.isNotEmpty((CharSequence)codeToId.getServiceStoreCode())) {
            Long serviceStoreId = null;
            storeCache = this.iRedisCacheService.getStoreCache(brandId, codeToId.getServiceStoreCode());
            if (storeCache != null) {
                serviceStoreId = storeCache.getStoreId();
            }
            codeToId.setServiceStoreId(serviceStoreId);
        }
        if (StringUtils.isNotEmpty((CharSequence)codeToId.getOfflineLevelCode()) && brandId != null) {
            Long levelId = null;
            LevelCacheDto level = this.iRedisCacheService.getLevel(brandId, codeToId.getOfflineLevelCode());
            if (level != null) {
                levelId = level.getMbrLevelId();
            }
            codeToId.setLevelId(levelId);
        }
        if (StringUtils.isNotEmpty((CharSequence)codeToId.getOfflineProductGuideCode())) {
            Long productGuideId = null;
            staffCache = this.iRedisCacheService.getStaffCache(sysCompanyId, codeToId.getOfflineProductGuideCode());
            if (staffCache != null) {
                productGuideId = staffCache.getStaffId();
            }
            codeToId.setProductGuideId(productGuideId);
        }
        if (StringUtils.isNotBlank((CharSequence)codeToId.getOfflineServiceGuideCodes())) {
            StringBuilder serviceGuideIds = new StringBuilder();
            Map batchStaffCache = this.iRedisCacheService.getBatchStaffCache(sysCompanyId, codeToId.getOfflineServiceGuideCodes());
            if (batchStaffCache != null) {
                batchStaffCache.entrySet().stream().forEach(bsc -> serviceGuideIds.append(((StaffCacheDto)bsc.getValue()).getStaffId()).append(","));
            }
            if (serviceGuideIds.length() > 0) {
                serviceGuideIds.deleteCharAt(serviceGuideIds.length() - 1);
            }
            codeToId.setOfflineServiceGuideCodes(serviceGuideIds.toString());
        }
        return codeToId;
    }

    public FetchMessagePo queryMessagePo(String memberCode) {
        FetchMessagePo fetchMessagePo = this.memberInfoMapper.queryMessagePo(memberCode);
        if (fetchMessagePo != null) {
            if (fetchMessagePo.getWxPublicId() != null) {
                ResponseData wxPublicPoResponseData = null;
                try {
                    wxPublicPoResponseData = this.wxPublicServiceFeign.getWxPublicBySysBrandId(fetchMessagePo.getSysBrandId());
                }
                catch (Exception e) {
                    log.error("\u8c03\u7528\u5fae\u4fe1\u63a5\u53e3\u67e5\u8be2\u516c\u4f17\u53f7\u4fe1\u606f\u51fa\u9519!");
                    log.error("error:{}", (Throwable)e);
                }
                if (wxPublicPoResponseData != null && wxPublicPoResponseData.getData() != null) {
                    fetchMessagePo.setNickName(((WxPublicPO)wxPublicPoResponseData.getData()).getNickName());
                }
            }
            if (fetchMessagePo.getSysBrandId() != null) {
                ResponseData brandPoResponseData = null;
                try {
                    brandPoResponseData = this.brandServiceRpc.getBrandByID(fetchMessagePo.getSysBrandId());
                }
                catch (Exception e) {
                    log.error("\u8c03\u7528\u4e2d\u53f0\u63a5\u53e3\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u51fa\u9519!");
                    log.error("error:{}", (Throwable)e);
                }
                if (brandPoResponseData != null && brandPoResponseData.getData() != null) {
                    fetchMessagePo.setBrandName(((SysBrandPo)brandPoResponseData.getData()).getBrandName());
                }
            }
            if (fetchMessagePo.getFocus() != null) {
                if (FocusStatusEnum.FOCUS.getCode().equals(fetchMessagePo.getFocus())) {
                    fetchMessagePo.setSendWxmember("2");
                } else {
                    fetchMessagePo.setSendWxmember("1");
                }
            }
        }
        return fetchMessagePo;
    }
}

