/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.unifiedreg.service.copy.config;

import com.bizvane.utils.redisutils.SpringContextHolder;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ibatis.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;

public class RedisCache
implements Cache {
    private static final Logger logger = LoggerFactory.getLogger(RedisCache.class);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final String id;
    private RedisTemplate<Object, Object> redisTemplate;
    private static final long EXPIRE_TIME = 120L;

    public RedisCache(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Cache instances require an ID");
        }
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void putObject(Object key, Object value) {
        RedisTemplate redisTemplate = this.getRedisTemplate();
        ValueOperations opsForValue = redisTemplate.opsForValue();
        opsForValue.set(key, value, 120L, TimeUnit.SECONDS);
        logger.debug("Put query result to redis");
    }

    public Object getObject(Object key) {
        RedisTemplate redisTemplate = this.getRedisTemplate();
        ValueOperations opsForValue = redisTemplate.opsForValue();
        logger.debug("Get cached query result from redis");
        return opsForValue.get(key);
    }

    public Object removeObject(Object key) {
        RedisTemplate redisTemplate = this.getRedisTemplate();
        redisTemplate.delete(key);
        logger.debug("Remove cached query result from redis");
        return null;
    }

    public void clear() {
        RedisTemplate redisTemplate = this.getRedisTemplate();
        redisTemplate.execute(connection -> {
            connection.flushDb();
            return null;
        });
        logger.debug("Clear all the cached query result from redis");
    }

    public int getSize() {
        RedisTemplate redisTemplate = this.getRedisTemplate();
        return redisTemplate.getConnectionFactory().getConnection().dbSize().intValue();
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    private RedisTemplate<Object, Object> getRedisTemplate() {
        if (this.redisTemplate == null) {
            this.redisTemplate = (RedisTemplate)SpringContextHolder.getBean((String)"redisTemplate");
        }
        return this.redisTemplate;
    }
}

