/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.unifiedreg;

import io.searchbox.client.JestClient;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.data.elasticsearch.ElasticsearchAutoConfiguration;
import org.springframework.boot.autoconfigure.data.elasticsearch.ElasticsearchDataAutoConfiguration;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.data.elasticsearch.repository.config.EnableElasticsearchRepositories;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.web.client.RestTemplate;
import springfox.documentation.swagger2.annotations.EnableSwagger2;
import tk.mybatis.spring.annotation.MapperScan;

@SpringBootApplication(scanBasePackages={"com.bizvane", "cn.hutool.extra.spring", "com.bizvane.utils.*"})
@EnableDiscoveryClient
@EnableSwagger2
@EnableFeignClients(basePackages={"com.bizvane.redis.canal.service", "com.bizvane.connectorservice.interfaces.rpc", "com.bizvane.centerstageservice.rpc", "com.bizvane.couponfacade.interfaces", "com.bizvane.messagefacade.interfaces", "com.bizvane.thirddock.service.rpc", "com.bizvane.channelsservice.rpc", "com.bizvane.wechatfacade.interfaces", "com.bizvane.etlservice.interfaces", "com.bizvane.appletservice.rpc"})
@EnableAutoConfiguration(exclude={ElasticsearchAutoConfiguration.class, ElasticsearchDataAutoConfiguration.class})
@EnableElasticsearchRepositories(basePackages={"com.bizvane.unifiedreg.service.copy.es.repository"})
@MapperScan(value={"com.bizvane.unifiedreg.mapper", "com.bizvane.unifiedreg.service.copy.mapper"})
@EnableAsync
@ConditionalOnClass(value={JestClient.class})
public class UnifiedRegApplication {
    @Bean
    RestTemplate restTemplate(RestTemplateBuilder restTemplateBuilder) {
        return restTemplateBuilder.build();
    }

    public static void main(String[] args) {
        SpringApplication.run(UnifiedRegApplication.class, (String[])args);
    }
}

