/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.trace.service.impl;

import brave.ScopedSpan;
import brave.Tracer;
import brave.Tracing;
import com.bizvane.trace.service.ProvisionalTraceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.sleuth.SpanNamer;

public class CrmProvisionalTraceServiceImpl
implements ProvisionalTraceService {
    private Logger log = LoggerFactory.getLogger(CrmProvisionalTraceServiceImpl.class);
    private Tracing tracing;
    private SpanNamer spanNamer;
    private static final String DEFUALT_SPAN_NAME = "async";
    private static final ThreadLocal<ScopedSpan> SCOPED_SPAN_THREAD_LOCAL = new ThreadLocal();

    public CrmProvisionalTraceServiceImpl(Tracing tracing, SpanNamer spanNamer) {
        this.tracing = tracing;
        this.spanNamer = spanNamer;
    }

    @Override
    public void start() {
        Tracer tracer = this.tracing.tracer();
        ScopedSpan span = tracer.startScopedSpan(this.spanName());
        SCOPED_SPAN_THREAD_LOCAL.set(span);
    }

    @Override
    public void finish() {
        try {
            ScopedSpan span = SCOPED_SPAN_THREAD_LOCAL.get();
            if (span == null) {
                this.log.info("can not find any span");
            } else {
                span.finish();
            }
        }
        catch (Exception e) {
            this.log.error("finish span fail !");
        }
    }

    private String spanName() {
        return this.spanNamer.name((Object)Thread.currentThread(), DEFUALT_SPAN_NAME);
    }
}

