/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.trace.aop;

import com.bizvane.trace.service.TraceService;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=1)
public class RequestTraceAspect {
    private TraceService traceService;
    private HttpServletResponse response;
    private static final String TRACE_NAME = "bizvane-trace";

    public RequestTraceAspect(TraceService traceService, HttpServletResponse response) {
        this.traceService = traceService;
        this.response = response;
    }

    @Pointcut(value="(execution(* com.bizvane..*.*(..))) && (@within(org.springframework.stereotype.Controller) || @within(org.springframework.web.bind.annotation.RestController)) && (@annotation(org.springframework.web.bind.annotation.RequestMapping) || @annotation(org.springframework.web.bind.annotation.PostMapping))")
    public void control() {
    }

    @Before(value="control()")
    public void cutTrace(JoinPoint joinPoint) {
        this.response.setHeader(TRACE_NAME, this.traceService.trace());
    }
}

