/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.trace.aop;

import com.bizvane.trace.service.ProvisionalTraceService;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class MethodTraceAspect {
    private ProvisionalTraceService provisionalTraceService;

    public MethodTraceAspect(ProvisionalTraceService provisionalTraceService) {
        this.provisionalTraceService = provisionalTraceService;
    }

    @Around(value="@annotation(com.bizvane.trace.annotation.TraceWeaving)")
    public Object join(ProceedingJoinPoint joinPoint) throws Throwable {
        this.provisionalTraceService.start();
        try {
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            this.provisionalTraceService.finish();
        }
    }
}

