/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.trace.conf;

import com.bizvane.trace.aop.MethodTraceAspect;
import com.bizvane.trace.aop.RequestTraceAspect;
import com.bizvane.trace.conf.CrmTraceAutoConfiguration;
import com.bizvane.trace.service.ProvisionalTraceService;
import com.bizvane.trace.service.TraceService;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={CrmTraceAutoConfiguration.class})
public class TraceAopAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnWebApplication
    @ConditionalOnBean(value={TraceService.class})
    public RequestTraceAspect traceAspect(TraceService traceService, HttpServletResponse response) {
        return new RequestTraceAspect(traceService, response);
    }

    @Bean
    @ConditionalOnBean(value={ProvisionalTraceService.class})
    @ConditionalOnMissingBean
    public MethodTraceAspect methodTraceAspect(ProvisionalTraceService provisionalTraceService) {
        return new MethodTraceAspect(provisionalTraceService);
    }
}

