/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.trace.conf;

import brave.Tracing;
import com.bizvane.trace.service.ProvisionalTraceService;
import com.bizvane.trace.service.TraceService;
import com.bizvane.trace.service.impl.CrmProvisionalTraceServiceImpl;
import com.bizvane.trace.service.impl.CrmTraceServiceImpl;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.autoconfig.TraceConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={TraceConfiguration.class})
@ConditionalOnProperty(value={"spring.sleuth.enabled"}, matchIfMissing=true)
public class CrmTraceAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public TraceService traceService(Tracing tracing) {
        return new CrmTraceServiceImpl(tracing);
    }

    @Bean
    @ConditionalOnMissingBean
    public ProvisionalTraceService provisionalTraceService(Tracing tracing, SpanNamer spanNamer) {
        return new CrmProvisionalTraceServiceImpl(tracing, spanNamer);
    }
}

