package com.bizvane.thirdparty.feign;

import com.bizvane.thirdparty.model.vo.ThirdCouponExpirationVo;
import com.bizvane.thirdparty.model.vo.ThirdCouponInvalidVo;
import com.bizvane.thirdparty.model.vo.ThirdCouponUseVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(value="${feign.client.third-party.name}",path="${feign.client.third-party.path}/forward")
@Api("业务转发")
public interface ThirdForwardFeign {

    @ApiOperation(value = "优惠券使用", notes = "优惠券使用", tags = {"优惠券"},httpMethod = "POST")
    @RequestMapping(value="/couponUse", method = RequestMethod.POST)
    ResponseData<String> couponUse(@RequestBody ThirdCouponUseVo req);

    @ApiOperation(value = "优惠券作废", notes = "优惠券作废", tags = {"优惠券"},httpMethod = "POST")
    @RequestMapping(value="/couponUse", method = RequestMethod.POST)
    ResponseData<String> couponInvalid(@RequestBody ThirdCouponInvalidVo req);

    @ApiOperation(value = "优惠券过期", notes = "优惠券过期", tags = {"优惠券"},httpMethod = "POST")
    @RequestMapping(value="/couponExpiration", method = RequestMethod.POST)
    ResponseData<String> couponExpiration(@RequestBody ThirdCouponExpirationVo req);
}
