/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.task.center.feign;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.session.Configuration;
import org.springframework.beans.factory.annotation.Autowired;

public class MybatisSqlTemplateParser {
    @Autowired
    private Configuration configuration;

    public static void main(String[] args) throws Exception {
        Configuration configuration = new Configuration();
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!DOCTYPE mapper PUBLIC \"-//mybatis.org//DTD Mapper 3.1//EN\" \"http://mybatis.org/dtd/mybatis-3-mapper.dtd\">\n<mapper namespace=\"your.namespace\">\n  <select id=\"selectUsersByConditions\" parameterType=\"map\" resultType=\"map\">\n      SELECT * FROM users\n      <where>\n          <if test=\"id33 != null\">\n              AND id33 = ${id33}          </if>\n          <if test=\"id44 != null\">\n              AND id44 in (${id44})\n          </if>\n          <if test=\"sq == 333\">\n              AND sq in (SELECT id FROM table1 WHERE a = a\n              <if test=\"id22 != null\">\n                  AND id22 = ${id22}\n              </if>)\n          </if>\n      </where>\n  </select>\n<select id=\"selectUsersById\" parameterType=\"int\" resultType=\"map\">\n        SELECT * FROM users WHERE id = ${id}\n    </select>\n</mapper>";
        System.out.println("xml: " + xml);
        InputStream inputStream = MybatisSqlTemplateParser.toInputStream(xml);
        XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder(inputStream, configuration, "", new HashMap());
        xmlMapperBuilder.parse();
        MappedStatement mappedStatement = configuration.getMappedStatement("selectUsersByConditions", true);
        SqlSource sqlSource = mappedStatement.getSqlSource();
        Object[] intArray = new Object[]{1, 2, 3, 4, 5};
        Object[] stringArray = new Object[]{"Hello", "World", "This", "Is", "Java"};
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("id33", 3);
        params.put("id44", MybatisSqlTemplateParser.formatObjectOrArray(stringArray));
        params.put("sq", MybatisSqlTemplateParser.formatObjectOrArray(333));
        params.put("id22", MybatisSqlTemplateParser.formatObjectOrArray("aa"));
        params.put("id", 4);
        sqlSource.getBoundSql(params);
        BoundSql boundSql = sqlSource.getBoundSql(params);
        System.out.println("boundSql.getSql  " + boundSql.getSql());
    }

    public static String formatArray(Object[] array) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] instanceof String) {
                result.append('\'').append(array[i]).append('\'');
            } else {
                result.append(array[i]);
            }
            if (i >= array.length - 1) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public static String formatObjectOrArray(Object obj) {
        StringBuilder result = new StringBuilder();
        if (obj instanceof Object[]) {
            Object[] array = (Object[])obj;
            for (int i = 0; i < array.length; ++i) {
                if (array[i] instanceof String) {
                    result.append('\'').append(array[i]).append('\'');
                } else {
                    result.append(array[i]);
                }
                if (i >= array.length - 1) continue;
                result.append(", ");
            }
        } else if (obj instanceof String) {
            result.append('\'').append(obj).append('\'');
        } else {
            result.append(obj);
        }
        return result.toString();
    }

    private static InputStream toInputStream(String s) {
        return new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8));
    }
}

