/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.task.center.domain.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bizvane.task.center.domain.config.DateUtils;
import com.bizvane.task.center.domain.mapper.SysTaskMapper;
import com.bizvane.task.center.domain.model.entity.SysTaskPO;
import com.bizvane.task.center.domain.service.ISysTaskService;
import com.bizvane.task.center.feign.model.bo.DataExportRequestParam;
import com.bizvane.task.center.feign.model.bo.ExportTaskListParam;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SysTaskServiceImpl
extends ServiceImpl<SysTaskMapper, SysTaskPO>
implements ISysTaskService {
    @Override
    public String insertTask(SysTaskPO sysTaskPO) {
        SysTaskPO po = new SysTaskPO();
        po.setTaskCode(sysTaskPO.getTaskCode());
        po.setTaskName(sysTaskPO.getTaskName());
        po.setBusinessCode(sysTaskPO.getBusinessCode());
        po.setQueryId(sysTaskPO.getQueryId());
        po.setTaskType(sysTaskPO.getTaskType());
        po.setStartTime(sysTaskPO.getStartTime());
        po.setStatus(sysTaskPO.getStatus());
        po.setProgress(sysTaskPO.getProgress());
        po.setCreateUserCode(sysTaskPO.getCreateUserCode());
        po.setCreateUserName(sysTaskPO.getCreateUserName());
        po.setCreateDate(LocalDateTime.now());
        po.setVersion(sysTaskPO.getVersion());
        this.save(po);
        return null;
    }

    @Override
    public ResponseData<Boolean> updateTaskStatus(int status, SysTaskPO sysTaskPO) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysTaskPO::getTaskCode, (Object)sysTaskPO.getTaskCode());
        SysTaskPO po = new SysTaskPO();
        switch (status) {
            case 2: {
                po.setStatus(status);
                po.setStartTime(DateUtils.getTheCurrentTime());
                po.setProgress(sysTaskPO.getProgress());
                break;
            }
            case 3: {
                po.setStatus(status);
                po.setEndTime(DateUtils.getTheCurrentTime());
                po.setProgress(100);
                po.setFileNumber(sysTaskPO.getFileNumber());
                po.setFileSize(sysTaskPO.getFileSize());
                po.setTotalRows(sysTaskPO.getTotalRows());
                po.setFileUrl(sysTaskPO.getFileUrl());
                break;
            }
            case 0: {
                po.setStatus(status);
                po.setEndTime(DateUtils.getTheCurrentTime());
                po.setFailureReason(sysTaskPO.getFailureReason());
                break;
            }
            default: {
                po.setStatus(0);
                po.setFailureReason("\u6267\u884c\u5931\u8d25" + status + "\u672a\u77e5\u72b6\u6001");
            }
        }
        return new ResponseData((Object)this.update(po, (Wrapper)queryWrapper));
    }

    @Override
    public ResponseData<Boolean> updateTaskToFailed(String taskCode, String failureReason) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysTaskPO::getTaskCode, (Object)taskCode);
        SysTaskPO po = new SysTaskPO();
        po.setStatus(3);
        po.setEndTime(LocalDateTime.now());
        po.setFailureReason(failureReason);
        return null;
    }

    @Override
    public List<SysTaskPO> getTaskList(ExportTaskListParam param) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SysTaskPO::getCreateUserCode, (Object)param.getCreateUseCode());
        if (param.getExportTaskCode() != null && !param.getExportTaskCode().isEmpty()) {
            lambdaQueryWrapper.eq(SysTaskPO::getTaskCode, (Object)param.getExportTaskCode());
        }
        if (param.getExportTaskName() != null && !param.getExportTaskName().isEmpty()) {
            lambdaQueryWrapper.like(SysTaskPO::getTaskName, (Object)param.getExportTaskName());
        }
        if (param.getStartTime() != null) {
            lambdaQueryWrapper.ge(SysTaskPO::getStartTime, (Object)param.getStartTime());
        }
        if (param.getEndTime() != null) {
            lambdaQueryWrapper.le(SysTaskPO::getEndTime, (Object)param.getEndTime());
        }
        return this.list((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public IPage<SysTaskPO> list(DataExportRequestParam param) {
        Page userPage = new Page((long)param.getPageNum(), (long)param.getPageSize());
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.orderByDesc(SysTaskPO::getCreateDate);
        if (param.getExportTaskCode() != null && !param.getExportTaskCode().isEmpty()) {
            queryWrapper.eq(SysTaskPO::getTaskCode, (Object)param.getExportTaskCode());
        }
        if (param.getExportTaskName() != null && !param.getExportTaskName().isEmpty()) {
            queryWrapper.like(SysTaskPO::getTaskName, (Object)param.getExportTaskName());
        }
        if (param.getStartTime() != null) {
            queryWrapper.ge(SysTaskPO::getStartTime, (Object)param.getStartTime());
        }
        if (param.getEndTime() != null) {
            queryWrapper.le(SysTaskPO::getEndTime, (Object)param.getEndTime());
        }
        return this.page((IPage)userPage, (Wrapper)queryWrapper);
    }
}

