/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.task.center.domain.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.task.center.domain.common.NacosComponent;
import com.bizvane.task.center.domain.config.DateUtils;
import com.bizvane.task.center.domain.config.RandomUtils;
import com.bizvane.task.center.domain.service.IGetBuildExportSqlService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.session.Configuration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetBuildExportSqlImpl
implements IGetBuildExportSqlService {
    @Autowired
    private Configuration configuration;
    @Autowired
    private NacosComponent nacosComponent;

    @Override
    public String buildSelectSql(String xmlFile, String selectId, JSONObject dataJson) {
        try {
            InputStream inputStream = GetBuildExportSqlImpl.toInputStream(xmlFile);
            XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder(inputStream, this.configuration, "", new HashMap());
            xmlMapperBuilder.parse();
            MappedStatement mappedStatement = this.configuration.getMappedStatement(selectId, true);
            SqlSource sqlSource = mappedStatement.getSqlSource();
            LinkedHashMap<String, Object> values = GetBuildExportSqlImpl.parseJsonToMap(dataJson);
            BoundSql boundSql = sqlSource.getBoundSql(values);
            return boundSql.getSql();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String buildExportSql(String businessCode, String businessName, String querySql, String filePath) {
        StringBuilder exportSql = new StringBuilder(querySql);
        exportSql.append("\n into outfile \"").append(filePath).append("\"").append("\n").append(this.nacosComponent.getExportProperties()).append(";");
        return exportSql.toString();
    }

    private static InputStream toInputStream(String s) {
        return new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8));
    }

    private static LinkedHashMap<String, Object> parseJsonToMap(JSONObject jsonObject) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String key : jsonObject.keySet()) {
            Object value = jsonObject.get((Object)key);
            map.put(key, GetBuildExportSqlImpl.formatObjectOrArray(value));
        }
        return map;
    }

    public static String formatObjectOrArray(Object obj) {
        StringBuilder result = new StringBuilder();
        if (obj instanceof Object[]) {
            Object[] array = (Object[])obj;
            for (int i = 0; i < array.length; ++i) {
                if (array[i] instanceof String) {
                    result.append('\'').append(array[i]).append('\'');
                } else {
                    result.append(array[i]);
                }
                if (i >= array.length - 1) continue;
                result.append(", ");
            }
        } else if (obj instanceof String) {
            result.append('\'').append(obj).append('\'');
        } else {
            result.append(obj);
        }
        return result.toString();
    }

    @Override
    public String getExportFilePath(String businessCode, String businessName) {
        String exportDate = DateUtils.getCurrentDate();
        String exportHMS = DateUtils.getCurrentTime();
        int exportRandom = RandomUtils.generateRandomNumber(5);
        String path = "/export/" + exportDate + "/" + businessCode + "/" + businessName + "_" + exportHMS + "_" + exportRandom + "_";
        return path;
    }
}

