/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.task.center.domain.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bizvane.task.center.domain.config.BusinessNoUtils;
import com.bizvane.task.center.domain.mapper.CouponManualMapper;
import com.bizvane.task.center.domain.model.entity.CouponManualPO;
import com.bizvane.task.center.domain.service.ICouponManualService;
import com.bizvane.task.center.feign.model.bo.CouponManualAddRequestParam;
import com.bizvane.task.center.feign.model.bo.CouponManualListRequestParam;
import com.bizvane.task.center.feign.model.bo.CouponManualUpdateStatusRequestParam;
import com.bizvane.task.center.feign.model.vo.CouponManualListResponse;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CouponManualServiceImpl
extends ServiceImpl<CouponManualMapper, CouponManualPO>
implements ICouponManualService {
    private static final Logger log = LoggerFactory.getLogger(CouponManualServiceImpl.class);

    @Override
    public ResponseData<String> add(CouponManualAddRequestParam param) {
        log.info("CouponManualServiceImpl.add:{}", (Object)JacksonUtil.bean2Json((Object)param));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CouponManualPO::getTaskName, (Object)param.getTaskName());
        if (this.getOne((Wrapper)queryWrapper) != null) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u4efb\u52a1\u540d\u79f0\u5df2\u5b58\u5728");
        }
        String couponManualCode = BusinessNoUtils.getSystemNo();
        CouponManualPO po = new CouponManualPO();
        po.setTaskName(param.getTaskName());
        po.setCouponType(param.getCouponType());
        po.setMemberCount(param.getMemberCount());
        po.setMemberConditionType(param.getMemberConditionType());
        po.setMbrGroupDefCode(param.getMbrGroupDefCode());
        po.setCouponManualCode(couponManualCode);
        po.setGroupName(param.getGroupName());
        po.setSendTime(LocalDateTime.now());
        po.setCreateDate(LocalDateTime.now());
        po.setCreateUserCode(param.getUserCode());
        po.setCreateUserName(param.getUserName());
        if (this.save(po)) {
            return new ResponseData((Object)couponManualCode);
        }
        return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u6dfb\u52a0\u5931\u8d25");
    }

    @Override
    public IPage<CouponManualListResponse> list(CouponManualListRequestParam param) {
        log.info("CouponManualServiceImpl.list:{}", (Object)JacksonUtil.bean2Json((Object)param));
        Page userPage = new Page((long)param.getPageNum(), (long)param.getPageSize());
        return ((CouponManualMapper)this.baseMapper).listDetail((IPage<CouponManualListResponse>)userPage, param);
    }

    @Override
    public CouponManualPO detail(String couponManualCode) {
        log.info("CouponManualServiceImpl.detail:{}", (Object)couponManualCode);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CouponManualPO::getCouponManualCode, (Object)couponManualCode);
        return (CouponManualPO)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public boolean updateStatus(CouponManualUpdateStatusRequestParam param) {
        String couponManualCode = param.getCouponManualCode();
        Integer taskStatus = param.getTaskStatus();
        Integer successCount = param.getSuccessCount();
        Integer failCount = param.getFailCount();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.eq(CouponManualPO::getCouponManualCode, (Object)couponManualCode)).set(CouponManualPO::getTaskStatus, (Object)taskStatus);
        if (param.getMemberCount() != null) {
            updateWrapper.set(CouponManualPO::getMemberCount, (Object)param.getMemberCount());
        }
        return this.update(null, (Wrapper)updateWrapper);
    }
}

