/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.task.center.domain.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bizvane.task.center.domain.config.BusinessNoUtils;
import com.bizvane.task.center.domain.mapper.BatchTaskMapper;
import com.bizvane.task.center.domain.model.entity.BatchTaskPO;
import com.bizvane.task.center.domain.service.IBatchTaskService;
import com.bizvane.task.center.feign.model.bo.BatchTaskAddRequestDTO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BatchTaskServiceImpl
extends ServiceImpl<BatchTaskMapper, BatchTaskPO>
implements IBatchTaskService {
    private static final Logger log = LoggerFactory.getLogger(BatchTaskServiceImpl.class);

    @Override
    public String add(BatchTaskAddRequestDTO param) {
        log.info("BatchTaskServiceImpl.add:{}", (Object)JacksonUtil.bean2Json((Object)param));
        String batchTaskCode = BusinessNoUtils.getSystemNo();
        BatchTaskPO po = new BatchTaskPO();
        po.setBatchTaskCode(batchTaskCode);
        po.setBusinessBatchCode(param.getBusinessBatchCode());
        po.setBusinessCode(param.getBusinessCode());
        po.setTaskName(param.getTaskName());
        po.setTaskType(param.getTaskType());
        po.setTaskCount(param.getTaskCount());
        po.setParam(param.getParam());
        po.setCreateUserCode(param.getUserCode());
        po.setCreateUserName(param.getUserName());
        po.setCreateDate(LocalDateTime.now());
        if (this.save(po)) {
            return batchTaskCode;
        }
        log.error("\u65b0\u589e\u5931\u8d25:{}", (Object)param.getTaskName());
        return null;
    }

    @Override
    public IPage<BatchTaskPO> page(Integer taskType, Integer executeStatus, int pageNum, int pageSize, String orderBy) {
        log.info("BatchTaskServiceImpl.page");
        Page userPage = new Page((long)pageNum, (long)pageSize);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        if ("desc".equals(orderBy)) {
            queryWrapper.orderByDesc(BatchTaskPO::getCreateDate);
        } else {
            queryWrapper.orderByAsc(BatchTaskPO::getCreateDate);
        }
        if (taskType != null) {
            queryWrapper.eq(BatchTaskPO::getTaskType, (Object)taskType);
        }
        if (executeStatus != null) {
            queryWrapper.eq(BatchTaskPO::getExecuteStatus, (Object)executeStatus);
        }
        return this.page((IPage)userPage, (Wrapper)queryWrapper);
    }

    @Override
    public boolean updateStatus(String batchTaskCode, Integer executeStatus) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.eq(BatchTaskPO::getBatchTaskCode, (Object)batchTaskCode)).set(BatchTaskPO::getExecuteStatus, (Object)executeStatus);
        return this.update(null, (Wrapper)updateWrapper);
    }
}

