/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.task.center.domain;

import com.bizvane.task.center.domain.CosDemo;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.AnonymousCOSCredentials;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.COSObjectInputStream;
import com.qcloud.cos.model.COSObjectSummary;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ListObjectsRequest;
import com.qcloud.cos.model.ObjectListing;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.utils.IOUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosCsvToExcel {
    private static final Logger log = LoggerFactory.getLogger(CosCsvToExcel.class);
    private static ZipOutputStream zos;
    private static File zipFile;

    public static void main(String[] args) throws IOException {
        BasicCOSCredentials cred = new BasicCOSCredentials(CosDemo.secretId, CosDemo.secretKey);
        Region region = new Region(CosDemo.sh);
        ClientConfig clientConfig = new ClientConfig(region);
        clientConfig.setHttpProtocol(HttpProtocol.https);
        COSClient cosClient = new COSClient((COSCredentials)cred, clientConfig);
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest();
        listObjectsRequest.setBucketName(CosDemo.bucketName);
        listObjectsRequest.setPrefix("/demo/222/my_");
        listObjectsRequest.setDelimiter("/");
        listObjectsRequest.setMaxKeys(Integer.valueOf(1000));
        ObjectListing objectListing = null;
        ArrayList<String> keyList = new ArrayList<String>();
        do {
            try {
                objectListing = cosClient.listObjects(listObjectsRequest);
            }
            catch (CosServiceException e) {
                e.printStackTrace();
                return;
            }
            catch (CosClientException e) {
                e.printStackTrace();
                return;
            }
            List commonPrefixs = objectListing.getCommonPrefixes();
            List cosObjectSummaries = objectListing.getObjectSummaries();
            for (COSObjectSummary cosObjectSummary : cosObjectSummaries) {
                String key = cosObjectSummary.getKey();
                String etag = cosObjectSummary.getETag();
                long fileSize = cosObjectSummary.getSize();
                String storageClasses = cosObjectSummary.getStorageClass();
                keyList.add(key);
                System.out.println("key:" + key + ", etag:" + etag + ", fileSize:" + fileSize + ", storageClasses:" + storageClasses);
            }
            String nextMarker = objectListing.getNextMarker();
            listObjectsRequest.setMarker(nextMarker);
        } while (objectListing.isTruncated());
        for (String key : keyList) {
            System.out.println(key);
            String fileUrl = CosCsvToExcel.getObjectUrl(key);
            System.out.println(fileUrl);
            GetObjectRequest getObjectRequest = new GetObjectRequest(CosDemo.bucketName, key);
            CosCsvToExcel.exportZipFile(fileUrl, key, "");
        }
    }

    private static String getObjectUrl(String key) {
        AnonymousCOSCredentials cred = new AnonymousCOSCredentials();
        ClientConfig clientConfig = new ClientConfig(new Region("ap-shanghai"));
        clientConfig.setHttpProtocol(HttpProtocol.https);
        COSClient cosclient = new COSClient((COSCredentials)cred, clientConfig);
        return cosclient.getObjectUrl(CosDemo.bucketName, key).toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String exportZipFile(String fileUrl, String key, String zipFilePath) throws IOException {
        int maxExcelRowNum = 500000;
        File tempDir = Files.createTempDirectory("dorisExport", new FileAttribute[0]).toFile();
        File zipFile = new File(zipFilePath + File.separator + "exportFileName.zip");
        String zipFileName = fileUrl + ".zip";
        GetObjectRequest getObjectRequest = new GetObjectRequest(CosDemo.bucketName, key);
        COSObjectInputStream cosObjectInput = null;
        AnonymousCOSCredentials cred = new AnonymousCOSCredentials();
        ClientConfig clientConfig = new ClientConfig(new Region("ap-shanghai"));
        try {
            COSClient cosClient = new COSClient((COSCredentials)cred, clientConfig);
            COSObject cosObject = cosClient.getObject(getObjectRequest);
            cosObjectInput = cosObject.getObjectContent();
            System.out.println("CRC64: " + cosObject.getObjectMetadata().getCrc64Ecma());
            System.out.println("cosObjectInput: " + cosObjectInput);
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        int fileAfterPrefix = 1;
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));){
            int rowNum = 0;
            SXSSFWorkbook workbook = new SXSSFWorkbook(500);
            SXSSFSheet sheet = workbook.createSheet("Sheet1");
            HashMap<Integer, String> headerNameMap = new HashMap<Integer, String>();
            try (COSObjectInputStream inputStream = cosObjectInput;
                 BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));){
                block30: while (true) {
                    boolean shouldDeleteRow;
                    Row row;
                    String[] columns;
                    String line;
                    if ((line = reader.readLine()) != null) {
                        System.out.println("line : " + line);
                        if (rowNum > maxExcelRowNum) {
                            CosCsvToExcel.writeWorkbookToZip(workbook, String.format("%s_%s.xlsx", "exportFileName", fileAfterPrefix), zos);
                            ++fileAfterPrefix;
                            workbook = new SXSSFWorkbook(500);
                            sheet = workbook.createSheet("Sheet1");
                            rowNum = 0;
                            CosCsvToExcel.writeHeaderRow((Sheet)sheet, headerNameMap);
                        }
                        columns = line.split("_biz_sf_");
                        int n = ++rowNum;
                        row = sheet.createRow(n);
                        if (++rowNum == 1 && headerNameMap.isEmpty()) {
                            int j = 0;
                            while (true) {
                                if (j >= columns.length) continue block30;
                                headerNameMap.put(j, columns[j]);
                                Cell cell = row.createCell(j);
                                cell.setCellValue(columns[j]);
                                ++j;
                            }
                        }
                        shouldDeleteRow = true;
                    } else {
                        if (rowNum <= 0) return zipFile.getAbsolutePath();
                        CosCsvToExcel.writeWorkbookToZip(workbook, String.format("%s_%s.xlsx", "exportFileName", fileAfterPrefix), zos);
                        return zipFile.getAbsolutePath();
                    }
                    for (int j = 0; j < columns.length; ++j) {
                        if (((String)headerNameMap.get(j)).equals(columns[j])) continue;
                        shouldDeleteRow = false;
                        Cell cell = row.createCell(j);
                        cell.setCellValue(columns[j]);
                    }
                    if (!shouldDeleteRow) continue;
                    --rowNum;
                }
            }
        }
    }

    private static void writeWorkbookToZip(SXSSFWorkbook workbook, String fileName, ZipOutputStream zos) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            workbook.write((OutputStream)baos);
            ZipEntry entry = new ZipEntry(fileName);
            zos.putNextEntry(entry);
            zos.write(baos.toByteArray());
            zos.closeEntry();
        }
    }

    private static void writeHeaderRow(Sheet sheet, Map<Integer, String> headerNameMap) {
        Row headerRow = sheet.createRow(0);
        for (int j = 0; j < headerNameMap.size(); ++j) {
            Cell cell = headerRow.createCell(j);
            cell.setCellValue(headerNameMap.get(j));
        }
    }

    private static void initZipFile(String zipFilePath) throws IOException {
        zipFile = new File(zipFilePath);
        zos = new ZipOutputStream(new FileOutputStream(zipFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getObjectInputStreamDemo(String key) throws IOException {
        GetObjectRequest getObjectRequest = new GetObjectRequest(CosDemo.bucketName, key);
        InputStream cosObjectInput = null;
        AnonymousCOSCredentials cred = new AnonymousCOSCredentials();
        ClientConfig clientConfig = new ClientConfig(new Region("ap-shanghai"));
        try {
            COSClient cosClient = new COSClient((COSCredentials)cred, clientConfig);
            COSObject cosObject = cosClient.getObject(getObjectRequest);
            cosObjectInput = cosObject.getObjectContent();
            System.out.println("CRC64: " + cosObject.getObjectMetadata().getCrc64Ecma());
            System.out.println("cosObjectInput: " + cosObjectInput);
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        byte[] bytes = null;
        try {
            bytes = IOUtils.toByteArray(cosObjectInput);
            System.out.println("cosObjectInput bytes:" + new String(bytes) + "aaaaaaa");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            cosObjectInput.close();
        }
    }
}

