/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.task.center.domain.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bizvane.task.center.domain.mapper.CouponManualMapper;
import com.bizvane.task.center.domain.model.entity.CouponManualPO;
import com.bizvane.task.center.domain.service.ICouponManualService;
import com.bizvane.task.center.feign.model.bo.CouponManualAddRequestParam;
import com.bizvane.task.center.feign.model.bo.CouponManualListRequestParam;
import com.bizvane.task.center.feign.model.bo.CouponManualUpdateStatusRequestParam;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDateTime;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CouponManualServiceImpl
extends ServiceImpl<CouponManualMapper, CouponManualPO>
implements ICouponManualService {
    private static final Logger log = LoggerFactory.getLogger(CouponManualServiceImpl.class);

    @Override
    public ResponseData<String> add(CouponManualAddRequestParam param) {
        log.info("CouponManualServiceImpl.add:{}", (Object)JacksonUtil.bean2Json((Object)param));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CouponManualPO::getTaskName, (Object)param.getTaskName());
        if (this.getOne((Wrapper)queryWrapper) != null) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u4efb\u52a1\u540d\u79f0\u5df2\u5b58\u5728");
        }
        String couponManualCode = "BusinessNoUtils.getSystemNo()";
        CouponManualPO po = new CouponManualPO();
        po.setCouponManualCode(couponManualCode);
        po.setTaskName(param.getTaskName());
        po.setMemberCount(param.getMemberCount());
        po.setSendType(param.getSendType());
        po.setCreateDate(LocalDateTime.now());
        po.setCreateUserCode(param.getUserCode());
        po.setCreateUserName(param.getUserName());
        if (this.save(po)) {
            return new ResponseData((Object)couponManualCode);
        }
        return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u6dfb\u52a0\u5931\u8d25");
    }

    @Override
    public IPage<CouponManualPO> list(CouponManualListRequestParam param) {
        log.info("CouponManualServiceImpl.list:{}", (Object)JacksonUtil.bean2Json((Object)param));
        Page userPage = new Page((long)param.getPageNum(), (long)param.getPageSize());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.orderByDesc(CouponManualPO::getCreateDate);
        if (StringUtils.isNotEmpty((CharSequence)param.getTaskName())) {
            queryWrapper.like(CouponManualPO::getTaskName, (Object)param.getTaskName());
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getCouponDefinitionName())) {
            queryWrapper.like(CouponManualPO::getCouponDefinitionName, (Object)param.getCouponDefinitionName());
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getCreateUserName())) {
            queryWrapper.like(CouponManualPO::getCreateUserName, (Object)param.getCreateUserName());
        }
        if (param.getTaskStatus() != null) {
            queryWrapper.eq(CouponManualPO::getTaskStatus, (Object)param.getTaskStatus());
        }
        if (param.getCouponType() != null) {
            queryWrapper.eq(CouponManualPO::getCouponType, (Object)param.getCouponType());
        }
        if (param.getCreateDateStart() != null) {
            queryWrapper.ge(CouponManualPO::getCreateDate, (Object)param.getCreateDateStart());
        }
        if (param.getCreateDateEnd() != null) {
            queryWrapper.le(CouponManualPO::getCreateDate, (Object)param.getCreateDateEnd());
        }
        return this.page((IPage)userPage, (Wrapper)queryWrapper);
    }

    @Override
    public CouponManualPO detail(String couponManualCode) {
        log.info("CouponManualServiceImpl.detail:{}", (Object)couponManualCode);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CouponManualPO::getCouponManualCode, (Object)couponManualCode);
        return (CouponManualPO)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public boolean updateStatus(CouponManualUpdateStatusRequestParam param) {
        String couponManualCode = param.getCouponManualCode();
        Integer taskStatus = param.getTaskStatus();
        Integer successCount = param.getSuccessCount();
        Integer failCount = param.getFailCount();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.eq(CouponManualPO::getCouponManualCode, (Object)couponManualCode)).set(CouponManualPO::getTaskStatus, (Object)taskStatus);
        if (successCount != null) {
            updateWrapper.setSql("success_count = success_count + " + successCount, new Object[0]);
        }
        if (failCount != null) {
            updateWrapper.setSql("fail_count = fail_count + " + failCount, new Object[0]);
        }
        return this.update(null, (Wrapper)updateWrapper);
    }
}

