/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.task.center.domain.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bizvane.task.center.domain.mapper.MbrIntegralBatchDetailMapper;
import com.bizvane.task.center.domain.model.dto.MbrIntegralBatchTaskDetailListRequestDTO;
import com.bizvane.task.center.domain.model.entity.MbrIntegralBatchDetailPO;
import com.bizvane.task.center.domain.service.IMbrIntegralBatchDetailService;
import com.bizvane.task.center.feign.model.bo.MbrIntegralAddBatchTaskDetailRequestParam;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import java.time.LocalDateTime;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MbrIntegralBatchDetailServiceImpl
extends ServiceImpl<MbrIntegralBatchDetailMapper, MbrIntegralBatchDetailPO>
implements IMbrIntegralBatchDetailService {
    private static final Logger log = LoggerFactory.getLogger(MbrIntegralBatchDetailServiceImpl.class);

    @Override
    public String add(MbrIntegralAddBatchTaskDetailRequestParam param) {
        log.info("MbrIntegralBatchDetailServiceImpl.add:{}", (Object)JacksonUtil.bean2Json((Object)param));
        String mbrIntegralBatchCodeDetail = "BusinessNoUtils.getSystemNo()";
        MbrIntegralBatchDetailPO po = new MbrIntegralBatchDetailPO();
        po.setMbrIntegralBatchCodeDetail(mbrIntegralBatchCodeDetail);
        po.setMbrIntegralBatchCode(param.getMbrIntegralBatchCode());
        po.setCardNo(param.getCardNo());
        po.setChangeIntegral(param.getChangeIntegral());
        po.setCreateUserCode(param.getUserCode());
        po.setCreateUserName(param.getUserName());
        po.setCreateDate(LocalDateTime.now());
        if (this.save(po)) {
            return mbrIntegralBatchCodeDetail;
        }
        return null;
    }

    @Override
    public MbrIntegralBatchDetailPO detail(String mbrIntegralBatchCode, String cardNo) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(MbrIntegralBatchDetailPO::getMbrIntegralBatchCode, (Object)mbrIntegralBatchCode);
        queryWrapper.eq(MbrIntegralBatchDetailPO::getCardNo, (Object)cardNo);
        return (MbrIntegralBatchDetailPO)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public IPage<MbrIntegralBatchDetailPO> list(MbrIntegralBatchTaskDetailListRequestDTO dto) {
        String mbrIntegralBatchCode = dto.getMbrIntegralBatchCode();
        String cardNo = dto.getCardNo();
        Integer status = dto.getStatus();
        long minId = dto.getMinId();
        int pageNum = dto.getPageNum();
        int pageSize = dto.getPageSize();
        Page userPage = new Page((long)pageNum, (long)pageSize);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(MbrIntegralBatchDetailPO::getMbrIntegralBatchCode, (Object)mbrIntegralBatchCode);
        queryWrapper.gt(MbrIntegralBatchDetailPO::getId, (Object)minId);
        if (status != null) {
            queryWrapper.eq(MbrIntegralBatchDetailPO::getStatus, (Object)status);
        }
        return this.page((IPage)userPage, (Wrapper)queryWrapper);
    }

    @Override
    public boolean updateStatus(String mbrIntegralBatchCodeDetail, Integer status, String failDetail) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(MbrIntegralBatchDetailPO::getMbrIntegralBatchCodeDetail, (Object)mbrIntegralBatchCodeDetail);
        updateWrapper.ne(MbrIntegralBatchDetailPO::getStatus, (Object)status);
        updateWrapper.set(MbrIntegralBatchDetailPO::getStatus, (Object)status);
        if (StringUtils.isNotBlank((CharSequence)failDetail)) {
            updateWrapper.set(MbrIntegralBatchDetailPO::getFailDetail, (Object)failDetail);
        }
        return this.update(null, (Wrapper)updateWrapper);
    }
}

