/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.task.center.domain.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bizvane.task.center.domain.mapper.MbrIntegralBatchMapper;
import com.bizvane.task.center.domain.model.entity.MbrIntegralBatchPO;
import com.bizvane.task.center.domain.service.IMbrIntegralBatchService;
import com.bizvane.task.center.feign.model.bo.MbrIntegralAddBatchTaskRequestParam;
import com.bizvane.task.center.feign.model.bo.MbrIntegralBatchTaskListRequestParam;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import java.time.LocalDateTime;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MbrIntegralBatchServiceImpl
extends ServiceImpl<MbrIntegralBatchMapper, MbrIntegralBatchPO>
implements IMbrIntegralBatchService {
    private static final Logger log = LoggerFactory.getLogger(MbrIntegralBatchServiceImpl.class);

    @Override
    public String add(MbrIntegralAddBatchTaskRequestParam param) {
        log.info("MbrIntegralBatchServiceImpl.add:{}", (Object)JacksonUtil.bean2Json((Object)param));
        String mbrIntegralBatchCode = "BusinessNoUtils.getSystemNo()";
        MbrIntegralBatchPO po = new MbrIntegralBatchPO();
        po.setMbrIntegralBatchCode(mbrIntegralBatchCode);
        po.setTaskName(param.getTaskName());
        po.setUrl(param.getUrl());
        po.setCreateUserCode(param.getUserCode());
        po.setCreateUserName(param.getUserName());
        po.setCreateDate(LocalDateTime.now());
        if (this.save(po)) {
            return mbrIntegralBatchCode;
        }
        return null;
    }

    @Override
    public boolean updateStatus(String mbrIntegralBatchCode, Integer status, Integer successCount, Integer failCount) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.eq(MbrIntegralBatchPO::getMbrIntegralBatchCode, (Object)mbrIntegralBatchCode)).set(MbrIntegralBatchPO::getStatus, (Object)status);
        if (successCount != null) {
            updateWrapper.setSql("success_count = success_count + " + successCount, new Object[0]);
        }
        if (failCount != null) {
            updateWrapper.setSql("fail_count = fail_count + " + failCount, new Object[0]);
        }
        return this.update(null, (Wrapper)updateWrapper);
    }

    @Override
    public IPage<MbrIntegralBatchPO> list(MbrIntegralBatchTaskListRequestParam param) {
        Page userPage = new Page((long)param.getPageNum(), (long)param.getPageSize());
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.orderByDesc(MbrIntegralBatchPO::getCreateDate);
        if (StringUtils.isNotBlank((CharSequence)param.getTaskName())) {
            queryWrapper.like(MbrIntegralBatchPO::getTaskName, (Object)param.getTaskName());
        }
        if (param.getCreateDateStart() != null) {
            queryWrapper.ge(MbrIntegralBatchPO::getCreateDate, (Object)param.getCreateDateStart());
        }
        if (param.getCreateDateEnd() != null) {
            queryWrapper.lt(MbrIntegralBatchPO::getCreateDate, (Object)param.getCreateDateEnd());
        }
        return this.page((IPage)userPage, (Wrapper)queryWrapper);
    }
}

