/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.task.center.domain.service.impl;

import com.bizvane.task.center.domain.common.NacosComponent;
import com.bizvane.task.center.domain.model.dto.DorisCommonExportResultBO;
import com.bizvane.task.center.domain.service.IExecuteExportService;
import com.bizvane.task.center.domain.service.ISysTaskService;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ExecuteExportImpl
implements IExecuteExportService {
    private static final Logger log = LoggerFactory.getLogger(ExecuteExportImpl.class);
    @Autowired
    private ISysTaskService iSysTaskService;
    @Autowired
    private NacosComponent nacosComponent;

    @Override
    public List<DorisCommonExportResultBO> execute(String exportSql, String taskCode) throws SQLException {
        ArrayList<DorisCommonExportResultBO> results = new ArrayList<DorisCommonExportResultBO>();
        DriverManager.setLoginTimeout(10);
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DriverManager.getConnection(this.nacosComponent.getDorisUrl(), this.nacosComponent.getDorisUsername(), this.nacosComponent.getDorisPassword());
            statement = connection.createStatement();
            log.info("\u6267\u884c\u5bfc\u51faSQL:{}", (Object)exportSql);
            resultSet = statement.executeQuery(exportSql);
            while (resultSet.next()) {
                int fileNumber = resultSet.getInt("FileNumber");
                long totalRows = resultSet.getLong("TotalRows");
                long fileSize = resultSet.getLong("FileSize");
                String url = resultSet.getString("URL");
                DorisCommonExportResultBO result = new DorisCommonExportResultBO(fileNumber, totalRows, fileSize, url);
                results.add(result);
            }
        }
        catch (SQLException e) {
            log.error("\u5904\u7406SQL\u6267\u884c\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            throw e;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error("\u5904\u7406\u8d44\u6e90\u5173\u95ed\u65f6\u7684\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                throw e;
            }
        }
        return results;
    }

    private String exportZipFile(List<DorisCommonExportResultBO> resultList, String exportFileName, String filePath) {
        File tempDir = Files.createTempDirectory("dorisExport", new FileAttribute[0]).toFile();
        File zipFile = new File(tempDir, exportFileName + ".zip");
        String zipFileName = filePath + exportFileName + ".zip";
        boolean fileAfterPrefix = true;
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));){
            boolean rowNum = false;
            SXSSFWorkbook workbook = new SXSSFWorkbook(500);
            SXSSFSheet sheet = workbook.createSheet("Sheet1");
            HashMap headerNameMap = new HashMap();
            for (DorisCommonExportResultBO resultBO : resultList) {
                for (int f = 0; f < resultBO.getFileNumber(); ++f) {
                }
            }
        }
        return "";
    }
}

