/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.task.center.domain;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.AnonymousCOSCredentials;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.COSObjectInputStream;
import com.qcloud.cos.model.COSObjectSummary;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ListObjectsRequest;
import com.qcloud.cos.model.ObjectListing;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.region.Region;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class readCosFileCSVToExcelDemo {
    static String secretId = "AKIDra6ORHtGPW6cjfOuELFuMa7RgyBXot9D";
    static String secretKey = "FMKh1CXmpeGfy73mLhqmbaSCu0wiHj17";
    static String sh = "ap-shanghai";
    static String filePath = "/Users/smzdm/aaaa";
    static String bucketName = "uat-1329502467";
    static COSCredentials cred = new BasicCOSCredentials(secretId, secretKey);
    static Region region = new Region(sh);
    static ClientConfig clientConfig = new ClientConfig(region);
    static COSClient cosClient = new COSClient(cred, clientConfig);
    private static final int MAX_ROWS_PER_WORKBOOK = 500000;
    static boolean shouldDeleteRow = false;

    public static void main(String[] args) {
        try {
            clientConfig.setHttpProtocol(HttpProtocol.https);
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest();
            listObjectsRequest.setBucketName(bucketName);
            listObjectsRequest.setPrefix(filePath);
            listObjectsRequest.setDelimiter("/");
            listObjectsRequest.setMaxKeys(Integer.valueOf(1000));
            ObjectListing objectListing = null;
            ArrayList<String> keyList = new ArrayList<String>();
            do {
                objectListing = cosClient.listObjects(listObjectsRequest);
                List cosObjectSummaries = objectListing.getObjectSummaries();
                for (COSObjectSummary cosObjectSummary : cosObjectSummaries) {
                    String key = cosObjectSummary.getKey();
                    keyList.add(key);
                    System.out.println(key);
                }
                listObjectsRequest.setMarker(objectListing.getNextMarker());
            } while (objectListing.isTruncated());
            readCosFileCSVToExcelDemo.exportZipFile(keyList, filePath);
            cosClient.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getObjectUrl(String key) {
        AnonymousCOSCredentials cred = new AnonymousCOSCredentials();
        ClientConfig clientConfig = new ClientConfig(new Region("ap-shanghai"));
        clientConfig.setHttpProtocol(HttpProtocol.https);
        COSClient cosclient = new COSClient((COSCredentials)cred, clientConfig);
        System.out.println(cosclient.getObjectUrl(bucketName, key));
        return cosclient.getObjectUrl(bucketName, key).toString();
    }

    public static String exportZipFile(List<String> keyList, String zipFilePath) throws IOException {
        File zipFile = new File(zipFilePath + ".zip");
        System.out.println(zipFile.toString());
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));){
            SXSSFWorkbook workbook = new SXSSFWorkbook(500);
            SXSSFSheet sheet = workbook.createSheet("Sheet1");
            HashMap<Integer, String> headerNameMap = new HashMap<Integer, String>();
            int rowNum = 0;
            int fileAfterPrefix = 1;
            boolean headerWritten = false;
            boolean isFirstRow = true;
            for (String key : keyList) {
                if (!key.endsWith(".csv")) continue;
                try {
                    GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, key);
                    COSObject cosObject = cosClient.getObject(getObjectRequest);
                    COSObjectInputStream cosObjectInput = cosObject.getObjectContent();
                    Throwable throwable = null;
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)cosObjectInput, StandardCharsets.UTF_8));
                        Throwable throwable2 = null;
                        try {
                            String line;
                            while ((line = reader.readLine()) != null) {
                                if (rowNum > 500000) {
                                    readCosFileCSVToExcelDemo.writeWorkbookToZip(workbook, String.format("%s_%s.xlsx", "exportFileName", fileAfterPrefix), zos);
                                    ++fileAfterPrefix;
                                    workbook = new SXSSFWorkbook(500);
                                    sheet = workbook.createSheet("Sheet1");
                                    headerWritten = false;
                                    rowNum = 1;
                                }
                                if (!headerWritten) {
                                    readCosFileCSVToExcelDemo.writeHeaderRow((Sheet)sheet, line, headerNameMap);
                                    if (!isFirstRow) {
                                        isFirstRow = true;
                                        readCosFileCSVToExcelDemo.writeDataRow((Sheet)sheet, line, headerNameMap);
                                        ++rowNum;
                                    }
                                    if (isFirstRow) {
                                        isFirstRow = false;
                                    }
                                    headerWritten = true;
                                    ++rowNum;
                                } else {
                                    readCosFileCSVToExcelDemo.writeDataRow((Sheet)sheet, line, headerNameMap);
                                }
                                ++rowNum;
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable2 != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            reader.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (cosObjectInput == null) continue;
                        if (throwable != null) {
                            try {
                                cosObjectInput.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        cosObjectInput.close();
                    }
                }
                catch (Exception e) {
                    throw new IOException("Error processing key: " + key, e);
                }
            }
            if (rowNum > 0 && headerWritten) {
                readCosFileCSVToExcelDemo.writeWorkbookToZip(workbook, String.format("%s_%s.xlsx", "exportFileName", fileAfterPrefix), zos);
            }
        }
        readCosFileCSVToExcelDemo.uploadFileToCOS(zipFile, zipFile.getAbsolutePath());
        System.out.println("Zip file created successfully." + zipFile.getAbsolutePath());
        return readCosFileCSVToExcelDemo.getObjectUrl(zipFile.getAbsolutePath());
    }

    private static void writeHeaderRow(Sheet sheet, String line, Map<Integer, String> headerNameMap) {
        String[] columns = line.split("_biz_sf_");
        Row row = sheet.createRow(0);
        for (int j = 0; j < columns.length; ++j) {
            if (headerNameMap.containsKey(j)) {
                columns[j] = headerNameMap.get(j);
            }
            headerNameMap.put(j, columns[j]);
            Cell cell = row.createCell(j);
            cell.setCellValue(columns[j]);
        }
    }

    private static void writeDataRow(Sheet sheet, String line, Map<Integer, String> headerNameMap) {
        String[] columns = line.split("_biz_sf_");
        Row row = sheet.createRow(sheet.getLastRowNum() + 1);
        for (int j = 0; j < columns.length; ++j) {
            if (headerNameMap.get(j).equals(columns[j])) {
                sheet.removeRow(row);
                continue;
            }
            Cell cell = row.createCell(j);
            cell.setCellValue(columns[j]);
        }
    }

    private static void writeWorkbookToZip(SXSSFWorkbook workbook, String fileName, ZipOutputStream zos) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            workbook.write((OutputStream)bos);
            workbook.dispose();
            byte[] bytes = bos.toByteArray();
            zos.putNextEntry(new ZipEntry(fileName));
            zos.write(bytes, 0, bytes.length);
            zos.closeEntry();
        }
    }

    private static void uploadFileToCOS(File file, String zipFilePath) {
        try {
            String key = zipFilePath;
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, file);
            PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
            System.out.println("File uploaded successfully." + putObjectResult.toString());
            System.out.println("File uploaded getETag." + putObjectResult.getETag());
            cosClient.shutdown();
            boolean isDeleted = file.delete();
            if (isDeleted) {
                System.out.println("Local file deleted successfully.");
            } else {
                System.out.println("Failed to delete local file.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

