/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.task.center.api.service.service;

import com.bizvane.members.feign.model.bo.CouponExternalRecordAddRequestParam;
import com.bizvane.members.feign.model.bo.CouponExternalSumRequestParam;
import com.bizvane.members.feign.model.bo.CouponExternalUpdateStatusRequestParam;
import com.bizvane.members.feign.service.CouponExternalFeign;
import com.bizvane.task.center.api.service.common.enums.BatchExecuteStatusEnum;
import com.bizvane.task.center.api.service.common.enums.BatchTaskTypeEnum;
import com.bizvane.task.center.domain.model.entity.BatchTaskPO;
import com.bizvane.task.center.domain.service.IBatchTaskService;
import com.bizvane.task.center.feign.model.bo.BatchTaskAddRequestDTO;
import com.bizvane.task.center.feign.model.bo.BatchTaskCouponExternalAddRequestParam;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.excel.ExcelImportUtil;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CouponExternalService {
    private static final Logger log = LoggerFactory.getLogger(CouponExternalService.class);
    @Autowired
    private IBatchTaskService iBatchTaskService;
    @Autowired
    private CouponExternalFeign couponExternalFeign;

    @Transactional
    public ResponseData<String> add(BatchTaskCouponExternalAddRequestParam param) {
        log.info("CouponExternalService.add:{}", (Object)JacksonUtil.bean2Json((Object)param));
        CouponExternalSumRequestParam requestParam = CouponExternalSumRequestParam.builder().couponDefinitionCode(param.getCouponDefinitionCode()).importType(Integer.valueOf(1)).airportNoOrg(param.getAirportNoOrg()).userCode(param.getUserCode()).userName(param.getUserName()).build();
        ResponseData addResponse = this.couponExternalFeign.add(requestParam);
        if (SysResponseEnum.SUCCESS.getCode() != addResponse.getCode()) {
            log.error("\u8c03\u7528\u5916\u90e8\u5238\u63a5\u53e3\u5931\u8d25:{}", (Object)JacksonUtil.bean2Json((Object)addResponse));
            return new ResponseData(addResponse.getCode(), addResponse.getMessage());
        }
        String couponExternalSumCode = (String)addResponse.getData();
        BatchTaskAddRequestDTO taskParam = BatchTaskAddRequestDTO.builder().businessBatchCode(couponExternalSumCode).taskName("\u5bfc\u5165\u5916\u90e8\u5238").taskType(BatchTaskTypeEnum.IMPORT_EXTERNAL_COUPON.getType()).param(JacksonUtil.bean2Json((Object)param)).userCode(param.getUserCode()).userName(param.getUserName()).build();
        String batchTaskCode = this.iBatchTaskService.add(taskParam);
        if (StringUtils.isEmpty((CharSequence)batchTaskCode)) {
            log.error("\u65b0\u589e\u5bfc\u5165\u5916\u90e8\u5238\u4efb\u52a1\u8bb0\u5f55\u5931\u8d25");
            throw new BizException(-1, "\u521b\u5efa\u5916\u90e8\u5238\u901a\u7528\u4efb\u52a1\u5931\u8d25");
        }
        return new ResponseData((Object)couponExternalSumCode);
    }

    public void detailGenerating(BatchTaskPO batchTaskPO) {
        String businessBatchCode = batchTaskPO.getBusinessBatchCode();
        BatchTaskCouponExternalAddRequestParam param = (BatchTaskCouponExternalAddRequestParam)JacksonUtil.json2Obj((String)batchTaskPO.getParam(), BatchTaskCouponExternalAddRequestParam.class);
        List couponNoList = (List)this.getImportData(param.getUrl()).getData();
        if (couponNoList.isEmpty()) {
            log.error("\u5bfc\u5165\u5916\u90e8\u5238\u660e\u7ec6\u5931\u8d25:{}", (Object)JacksonUtil.bean2Json((Object)param));
            return;
        }
        for (String couponNo : couponNoList) {
            CouponExternalRecordAddRequestParam addRequestParam = CouponExternalRecordAddRequestParam.builder().couponExternalSumCode(businessBatchCode).couponNo(couponNo).build();
            ResponseData addRequestResponse = this.couponExternalFeign.addRecord(addRequestParam);
            log.info("\u8c03\u7528\u5916\u90e8\u5238\u63a5\u53e3\u751f\u6210\u5238\u660e\u7ec6\u7ed3\u679c:{}", (Object)JacksonUtil.bean2Json((Object)addRequestResponse));
        }
        log.info("\u66f4\u65b0\u6279\u91cf\u8c03\u6574\u4efb\u52a1\u8fdb\u5ea6:{}", (Object)businessBatchCode);
        this.couponExternalFeign.updateStatus(CouponExternalUpdateStatusRequestParam.builder().couponExternalSumCode(businessBatchCode).status(Integer.valueOf(30)).build());
        this.iBatchTaskService.updateStatus(batchTaskPO.getBatchTaskCode(), BatchExecuteStatusEnum.COMPLETE.getType());
    }

    private ResponseData<List<String>> getImportData(String excelUrl) {
        ExcelImportUtil excelImportUtil = new ExcelImportUtil();
        ArrayList importList = new ArrayList();
        List excelData = excelImportUtil.parseExcel(excelUrl);
        for (List row : excelData) {
            importList.add(row.get(0));
        }
        return new ResponseData(importList);
    }
}

