/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.task.center.api.service.common.config;

import com.bizvane.task.center.api.service.common.enums.BatchExecuteStatusEnum;
import com.bizvane.task.center.api.service.common.enums.BatchTaskTypeEnum;
import com.bizvane.task.center.api.service.service.MbrIntegralBatchService;
import com.bizvane.task.center.domain.model.entity.BatchTaskPO;
import com.bizvane.task.center.domain.service.IBatchTaskService;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JobHandler {
    @Autowired
    private IBatchTaskService iBatchTaskService;
    @Autowired
    private MbrIntegralBatchService mbrIntegralBatchService;

    @XxlJob(value="batchTaskNewJobHandle")
    public void batchTaskNewJobHandle() throws Exception {
        XxlJobHelper.log((String)"batchTaskJobHandle.start", (Object[])new Object[0]);
        List batchTaskPOIPage = this.iBatchTaskService.page(null, BatchExecuteStatusEnum.NEW.getType(), 1, 100, "asc").getRecords();
        if (batchTaskPOIPage.isEmpty()) {
            XxlJobHelper.log((String)"batchTaskJobHandle.end", (Object[])new Object[0]);
            return;
        }
        for (BatchTaskPO batchTaskPO : batchTaskPOIPage) {
            XxlJobHelper.log((String)"batchTaskJobHandle.start.batchTaskPO:{}", (Object[])new Object[]{JacksonUtil.bean2Json((Object)batchTaskPO)});
            Integer taskType = batchTaskPO.getTaskType();
            if (BatchTaskTypeEnum.SEND_COUPON.getType().equals(taskType)) {
                this.mbrIntegralBatchService.detailGenerating(batchTaskPO);
            } else if (BatchTaskTypeEnum.CHANGE_INTEGRAL.getType().equals(taskType)) {
                // empty if block
            }
            this.iBatchTaskService.updateStatus(batchTaskPO.getBatchTaskCode(), BatchExecuteStatusEnum.WAIT_EXECUTE_DETAIL.getType());
        }
    }

    @XxlJob(value="batchTaskExecuteDetailJobHandle")
    public void batchTaskExecuteDetailJobHandle() throws Exception {
        XxlJobHelper.log((String)"batchTaskExecuteDetailJobHandle.start", (Object[])new Object[0]);
        List batchTaskPOIPage = this.iBatchTaskService.page(null, BatchExecuteStatusEnum.WAIT_EXECUTE_DETAIL.getType(), 1, 100, "asc").getRecords();
        if (batchTaskPOIPage.isEmpty()) {
            XxlJobHelper.log((String)"batchTaskExecuteDetailJobHandle.end", (Object[])new Object[0]);
            return;
        }
        for (BatchTaskPO batchTaskPO : batchTaskPOIPage) {
            XxlJobHelper.log((String)"batchTaskExecuteDetailJobHandle.start.batchTaskPO:{}", (Object[])new Object[]{JacksonUtil.bean2Json((Object)batchTaskPO)});
            Integer taskType = batchTaskPO.getTaskType();
            if (BatchTaskTypeEnum.SEND_COUPON.getType().equals(taskType)) {
                this.mbrIntegralBatchService.detailExecuting(batchTaskPO);
            } else if (BatchTaskTypeEnum.CHANGE_INTEGRAL.getType().equals(taskType)) {
                // empty if block
            }
            this.iBatchTaskService.updateStatus(batchTaskPO.getBatchTaskCode(), BatchExecuteStatusEnum.COMPLETE.getType());
        }
    }
}

