package com.bizvane.sfcrmfacade.interfaces;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import com.bizvane.utils.responseinfo.ResponseData;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@FeignClient(value="${feign.client.miniso.name}",path="${feign.client.miniso.path}/orderRpc")
@Api("订单管理")
public interface OrderServiceFeign {


  /**
   * 添加订单
   * @param requestVO
   * @return
   */
  @ApiOperation(value = "添加订单", notes = "添加订单", tags = {"订单操作接口"},httpMethod = "POST")
  @RequestMapping(value="/addOrder", method = RequestMethod.POST)
  ResponseData<String> addOrder(@RequestBody(required = false) com.bizvane.sfcrmfacade.models.vo.OrderInfoVo requestVO);

  /**
   * 同步订单信息
   * @param requestVO
   * @return
   */
  @ApiOperation(value = "同步订单信息", notes = "同步订单信息", tags = {"订单操作接口"},httpMethod = "POST")
  @RequestMapping(value="/updateOrder", method = RequestMethod.POST)
  ResponseData<String> updateOrder(@RequestBody(required = false) com.bizvane.sfcrmfacade.models.vo.OrderInfoVo requestVO);

  /**
   * 同步订单备注
   * @param requestVO
   * @return
   */
  @ApiOperation(value = "同步订单备注", notes = "同步订单备注", tags = {"订单操作接口"},httpMethod = "POST")
  @RequestMapping(value="/updateOrderRemark", method = RequestMethod.POST)
  ResponseData<Integer> updateOrderRemark(@RequestBody(required = false) com.bizvane.sfcrmfacade.models.vo.OrderInfoRemarkVo requestVO);

  /**
   * 同步订单物流
   * @param requestVO
   * @return
   */
  @ApiOperation(value = "同步订单物流", notes = "同步订单物流", tags = {"订单操作接口"},httpMethod = "POST")
  @RequestMapping(value="/updateOrderLogistics", method = RequestMethod.POST)
  ResponseData<Integer> updateOrderLogistics(@RequestBody(required = false) com.bizvane.sfcrmfacade.models.vo.OrderInfoLogisticsInfoVo requestVO);

  /**
   * 同步订单状态
   * @param requestVO
   * @return
   */
  @ApiOperation(value = "同步订单状态", notes = "同步订单状态", tags = {"订单操作接口"},httpMethod = "POST")
  @RequestMapping(value="/updateOrderStatus", method = RequestMethod.POST)
  ResponseData<Integer> updateOrderStatus(@RequestBody(required = false) com.bizvane.sfcrmfacade.models.vo.OrderInfoStatusVo requestVO);
}
