/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.exporttask.config;

import com.bizvane.exporttask.common.bean.ErrorInfo;
import com.bizvane.exporttask.common.bean.ResultBean;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResultBean<Serializable> methodArgumentNotValidException(MethodArgumentNotValidException exception) {
        ResultBean resultBean = new ResultBean();
        ObjectError oe = (ObjectError)exception.getBindingResult().getAllErrors().get(0);
        String errorMsg = "\u53c2\u6570\u6709\u8bef";
        if (oe != null) {
            errorMsg = oe.getDefaultMessage();
        }
        resultBean.setSuccess(Boolean.valueOf(false));
        resultBean.setErrorInfo(new ErrorInfo("400", errorMsg));
        return resultBean;
    }

    @ExceptionHandler(value={BindException.class})
    public ResultBean<Serializable> handleBindException(BindException exception) {
        ResultBean resultBean = new ResultBean();
        ObjectError oe = (ObjectError)exception.getBindingResult().getAllErrors().get(0);
        String errorMsg = "\u53c2\u6570\u6709\u8bef";
        if (oe != null) {
            errorMsg = oe.getDefaultMessage();
        }
        resultBean.setSuccess(Boolean.valueOf(false));
        resultBean.setErrorInfo(new ErrorInfo("400", errorMsg));
        return resultBean;
    }

    @ExceptionHandler(value={Exception.class})
    public ResultBean<Serializable> exception(Exception exception) {
        log.error("error:\u5168\u5c40\u5f02\u5e38-\u670d\u52a1\u5668\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f:" + exception.getMessage(), (Throwable)exception);
        ResultBean resultBean = new ResultBean();
        resultBean.setSuccess(Boolean.valueOf(false));
        resultBean.setErrorInfo(new ErrorInfo("500", "\u670d\u52a1\u5668\u5f02\u5e38"));
        return resultBean;
    }
}

