/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.exporttask.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public class ListCopyUtil {
    public static <S, T> List<T> copyListProperties(List<S> sources, Supplier<T> target) {
        if (CollectionUtils.isEmpty(sources)) {
            return new ArrayList();
        }
        ArrayList<T> list = new ArrayList<T>(sources.size());
        for (S source : sources) {
            T t = target.get();
            BeanUtils.copyProperties(source, t);
            list.add(t);
        }
        return list;
    }

    public static <S, T> Set<T> copyListPropertiesToSet(List<S> sources, Supplier<T> target) {
        if (CollectionUtils.isEmpty(sources)) {
            return new HashSet();
        }
        HashSet<T> set = new HashSet<T>(sources.size());
        for (S source : sources) {
            T t = target.get();
            BeanUtils.copyProperties(source, t);
            set.add(t);
        }
        return set;
    }
}

