/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.exporttask.component;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.exporttask.common.bean.ResultBean;
import com.bizvane.exporttask.dao.FileTaskDao;
import com.bizvane.exporttask.dao.entity.FileTask;
import com.bizvane.exporttask.remote.dto.FileTaskDto;
import com.bizvane.exporttask.remote.dto.FileTaskReq;
import com.bizvane.exporttask.remote.dto.base.PageListVo;
import com.bizvane.exporttask.util.ListCopyUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BaseComponent {
    @Autowired
    private FileTaskDao fileTaskDao;

    public FileTask insertTaskFile(Long brandId, Long sysCompanyId, Long sysAccountId, String accountName, String taskName) {
        FileTask fileTask = new FileTask();
        int count = this.fileTaskDao.findFileTaskNum(sysAccountId);
        if (count > 4) {
            return null;
        }
        fileTask.setCreateDate(new Date());
        fileTask.setCreateUserId(sysAccountId);
        fileTask.setCreateUserName(accountName);
        Long taskId = Integer.parseInt(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
        fileTask.setTaskId(taskId);
        fileTask.setValid(Boolean.valueOf(true));
        fileTask.setSysBrandId(brandId);
        fileTask.setSysCompanyId(sysCompanyId);
        fileTask.setTaskName(taskName);
        fileTask.setFileType("EXPORT");
        fileTask.setFileStatus(Long.valueOf(0L));
        this.fileTaskDao.insert((Object)fileTask);
        return fileTask;
    }

    public FileTask insertTaskFile(Long brandId, Long sysCompanyId, Long sysAccountId, String accountName, String taskName, String businessModule, String taskType) {
        FileTask fileTask = new FileTask();
        int count = this.fileTaskDao.findFileTaskNum(sysAccountId);
        if (count > 4) {
            return null;
        }
        fileTask.setCreateDate(new Date());
        fileTask.setCreateUserId(sysAccountId);
        fileTask.setCreateUserName(accountName);
        Long taskId = Integer.parseInt(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
        fileTask.setTaskId(taskId);
        fileTask.setValid(Boolean.valueOf(true));
        fileTask.setSysBrandId(brandId);
        fileTask.setSysCompanyId(sysCompanyId);
        fileTask.setTaskName(taskName);
        fileTask.setFileType("EXPORT");
        fileTask.setFileStatus(Long.valueOf(0L));
        fileTask.setBusinessModule(businessModule);
        fileTask.setTaskType(taskType);
        this.fileTaskDao.insert((Object)fileTask);
        return fileTask;
    }

    public ResultBean<PageListVo<FileTaskDto>> queryPageList(FileTaskReq req) {
        ResultBean resultBean = new ResultBean();
        resultBean.setSuccess(Boolean.valueOf(true));
        PageListVo pageListVo = new PageListVo();
        Page page = new Page((long)req.getPageNum().intValue(), (long)req.getPageSize().intValue());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FileTask::getValid, (Object)true)).eq(FileTask::getSysCompanyId, (Object)req.getSysCompanyId())).eq(FileTask::getSysBrandId, (Object)req.getSysBrandId())).eq(StringUtils.isNotBlank((CharSequence)req.getBusinessModule()), FileTask::getBusinessModule, (Object)req.getBusinessModule())).eq(StringUtils.isNotBlank((CharSequence)req.getTaskType()), FileTask::getTaskType, (Object)req.getTaskType())).eq(StringUtils.isNotBlank((CharSequence)req.getFileType()), FileTask::getFileType, (Object)req.getFileType())).like(StringUtils.isNotBlank((CharSequence)req.getTaskName()), FileTask::getTaskName, (Object)req.getTaskName())).ge(StringUtils.isNotBlank((CharSequence)req.getTimeStart()), FileTask::getCreateDate, (Object)req.getTimeStart())).le(StringUtils.isNotBlank((CharSequence)req.getTimeEnd()), FileTask::getCreateDate, (Object)req.getTimeEnd())).orderByDesc(FileTask::getCreateDate);
        IPage pageResult = this.fileTaskDao.selectPage((IPage)page, (Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
            resultBean.setResult((Serializable)pageListVo);
            return resultBean;
        }
        pageListVo = new PageListVo(ListCopyUtil.copyListProperties((List)pageResult.getRecords(), FileTaskDto::new), Integer.parseInt(String.valueOf(pageResult.getTotal())), Integer.parseInt(String.valueOf(pageResult.getCurrent())), Integer.parseInt(String.valueOf(pageResult.getSize())));
        resultBean.setResult((Serializable)pageListVo);
        return resultBean;
    }
}

