/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.exporttask.service;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.bizvane.exporttask.bean.ExtendPropertyBean;
import com.bizvane.exporttask.bean.GrowthBean;
import com.bizvane.exporttask.bean.LevelBean;
import com.bizvane.exporttask.bean.MbrImportBean;
import com.bizvane.exporttask.bean.MemberTagBean;
import com.bizvane.exporttask.bean.MessageBean;
import com.bizvane.exporttask.bean.PayRechargeBean;
import com.bizvane.exporttask.common.bean.ErrorInfo;
import com.bizvane.exporttask.common.bean.ResultBean;
import com.bizvane.exporttask.component.BaseComponent;
import com.bizvane.exporttask.dao.entity.FileTask;
import com.bizvane.exporttask.enums.ExceptionEnum;
import com.bizvane.exporttask.enums.StrategyTypeEnum;
import com.bizvane.exporttask.service.inter.IExportService;
import com.google.common.base.Joiner;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ExportService
implements IExportService {
    private static final Logger log = LoggerFactory.getLogger(ExportService.class);
    @Autowired
    private BaseComponent baseComponent;
    @Autowired
    private RocketMQTemplate rocketMQTemplate;

    public ResultBean<Boolean> exportLevelDescRecored(LevelBean bean) {
        ResultBean result = new ResultBean();
        result.setResult((Serializable)Boolean.valueOf(true));
        FileTask fileTask = this.baseComponent.insertTaskFile(bean.getBrandId(), bean.getSysCompanyId(), bean.getSysAccountId(), bean.getAccountName(), "\u5bfc\u51fa\u5347\u964d\u7ea7\u8bb0\u5f55");
        if (fileTask == null) {
            result.setResult((Serializable)Boolean.valueOf(false));
            result.setErrorInfo(new ErrorInfo(ExceptionEnum.ONGOING_COUNT_OUT_EXCEPTION.getErrCode(), ExceptionEnum.ONGOING_COUNT_OUT_EXCEPTION.getErrCodeDes()));
            return result;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("opsType", Objects.nonNull(bean.getOpsType()) ? String.valueOf(bean.getOpsType()) : null);
        map.put("brandId", String.valueOf(bean.getBrandId()));
        map.put("sysCompanyId", String.valueOf(bean.getSysCompanyId()));
        map.put("mbrCheckGradeRecord", Objects.nonNull(bean.getMbrCheckGradeRecord()) ? String.valueOf(bean.getMbrCheckGradeRecord()) : null);
        map.put("originLevelId", Objects.nonNull(bean.getOriginLevelId()) ? String.valueOf(bean.getOriginLevelId()) : null);
        map.put("currentLevelId", Objects.nonNull(bean.getCurrentLevelId()) ? String.valueOf(bean.getCurrentLevelId()) : null);
        map.put("resultFlag", Objects.nonNull(bean.getResultFlag()) ? String.valueOf(bean.getResultFlag()) : null);
        map.put("startTime", Objects.nonNull(bean.getStartTime()) ? ExportService.getStringDate((Date)bean.getStartTime()) : null);
        map.put("endTime", Objects.nonNull(bean.getEndTime()) ? ExportService.getStringDate((Date)bean.getEndTime()) : null);
        map.put("name", bean.getName());
        MessageBean messageBean = new MessageBean();
        messageBean.setTaskId(fileTask.getTaskId());
        messageBean.setStrategyType(StrategyTypeEnum.LEVEL_DESC_STRATEGY.getType());
        messageBean.setMap(map);
        log.info("\u53d1\u9001\u964d\u7ea7\u5bfc\u51fa\u8bb0\u5f55\u6d88\u606f\u5165\u53c2,{}", (Object)messageBean);
        try {
            this.rocketMQTemplate.send(Destination.builder().topic("TOPIC_EXPORT_NEW").build(), (Object)messageBean);
        }
        catch (Exception e) {
            log.info("\u53d1\u9001\u5bfc\u51fa\u8bb0\u5f55\u6d88\u606f\u5f02\u5e38,{}", (Object)e.getMessage(), (Object)e);
            result.setResult((Serializable)Boolean.valueOf(false));
            result.setErrorInfo(new ErrorInfo(ExceptionEnum.SEND_MQ_EXCEPTION.getErrCode(), ExceptionEnum.SEND_MQ_EXCEPTION.getErrCodeDes()));
            return result;
        }
        return result;
    }

    public static String getStringDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(date);
        return dateString;
    }

    public ResultBean<Boolean> exportLevelAscRecored(LevelBean bean) {
        ResultBean result = new ResultBean();
        result.setResult((Serializable)Boolean.valueOf(true));
        FileTask fileTask = this.baseComponent.insertTaskFile(bean.getBrandId(), bean.getSysCompanyId(), bean.getSysAccountId(), bean.getAccountName(), "\u5bfc\u51fa\u5347\u964d\u7ea7\u8bb0\u5f55");
        if (fileTask == null) {
            result.setResult((Serializable)Boolean.valueOf(false));
            result.setErrorInfo(new ErrorInfo(ExceptionEnum.ONGOING_COUNT_OUT_EXCEPTION.getErrCode(), ExceptionEnum.ONGOING_COUNT_OUT_EXCEPTION.getErrCodeDes()));
            return result;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("opsType", Objects.nonNull(bean.getOpsType()) ? String.valueOf(bean.getOpsType()) : null);
        map.put("brandId", String.valueOf(bean.getBrandId()));
        map.put("sysCompanyId", String.valueOf(bean.getSysCompanyId()));
        map.put("mbrCheckGradeRecord", Objects.nonNull(bean.getMbrCheckGradeRecord()) ? String.valueOf(bean.getMbrCheckGradeRecord()) : null);
        map.put("originLevelId", Objects.nonNull(bean.getOriginLevelId()) ? String.valueOf(bean.getOriginLevelId()) : null);
        map.put("currentLevelId", Objects.nonNull(bean.getCurrentLevelId()) ? String.valueOf(bean.getCurrentLevelId()) : null);
        map.put("resultFlag", Objects.nonNull(bean.getResultFlag()) ? String.valueOf(bean.getResultFlag()) : null);
        map.put("startTime", Objects.nonNull(bean.getStartTime()) ? ExportService.getStringDate((Date)bean.getStartTime()) : null);
        map.put("endTime", Objects.nonNull(bean.getEndTime()) ? ExportService.getStringDate((Date)bean.getEndTime()) : null);
        map.put("name", bean.getName());
        MessageBean messageBean = new MessageBean();
        messageBean.setTaskId(fileTask.getTaskId());
        messageBean.setStrategyType(StrategyTypeEnum.LEVEL_ASC_STRATEGY.getType());
        messageBean.setMap(map);
        log.info("\u53d1\u9001\u5347\u7ea7\u5bfc\u51fa\u8bb0\u5f55\u6d88\u606f\u5165\u53c2,{}", (Object)messageBean);
        try {
            this.rocketMQTemplate.send(Destination.builder().topic("TOPIC_EXPORT_NEW").build(), (Object)messageBean);
        }
        catch (Exception e) {
            log.info("\u53d1\u9001\u5bfc\u51fa\u8bb0\u5f55\u6d88\u606f\u5f02\u5e38,{}", (Object)e.getMessage(), (Object)e);
            result.setResult((Serializable)Boolean.valueOf(false));
            result.setErrorInfo(new ErrorInfo(ExceptionEnum.SEND_MQ_EXCEPTION.getErrCode(), ExceptionEnum.SEND_MQ_EXCEPTION.getErrCodeDes()));
            return result;
        }
        return result;
    }

    public ResultBean<Boolean> exportGrowthRecord(GrowthBean bean) {
        ResultBean result = new ResultBean();
        result.setResult((Serializable)Boolean.valueOf(true));
        FileTask fileTask = this.baseComponent.insertTaskFile(bean.getBrandId(), bean.getSysCompanyId(), bean.getSysAccountId(), bean.getAccountName(), "\u5bfc\u51fa\u6210\u957f\u503c\u8bb0\u5f55");
        if (fileTask == null) {
            result.setResult((Serializable)Boolean.valueOf(false));
            result.setErrorInfo(new ErrorInfo(ExceptionEnum.ONGOING_COUNT_OUT_EXCEPTION.getErrCode(), ExceptionEnum.ONGOING_COUNT_OUT_EXCEPTION.getErrCodeDes()));
            return result;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("brandId", String.valueOf(bean.getBrandId()));
        map.put("sysCompanyId", String.valueOf(bean.getSysCompanyId()));
        map.put("condition", bean.getCondition());
        map.put("changeType", Objects.nonNull(bean.getChangeType()) ? String.valueOf(bean.getChangeType()) : null);
        map.put("businessType", Objects.nonNull(bean.getBusinessType()) ? String.valueOf(bean.getBusinessType()) : null);
        map.put("beginChangeTime", Objects.nonNull(bean.getBeginChangeTime()) ? ExportService.getStringDate((Date)bean.getBeginChangeTime()) : null);
        map.put("endChangeTime", Objects.nonNull(bean.getEndChangeTime()) ? ExportService.getStringDate((Date)bean.getEndChangeTime()) : null);
        MessageBean messageBean = new MessageBean();
        messageBean.setTaskId(fileTask.getTaskId());
        messageBean.setStrategyType(StrategyTypeEnum.MEMBER_GROWTH_STRATEGY.getType());
        messageBean.setMap(map);
        log.info("\u53d1\u9001\u6210\u957f\u503c\u5bfc\u51fa\u8bb0\u5f55\u6d88\u606f\u5165\u53c2,{}", (Object)messageBean);
        try {
            this.rocketMQTemplate.send(Destination.builder().topic("TOPIC_EXPORT_NEW").build(), (Object)messageBean);
        }
        catch (Exception e) {
            log.info("\u53d1\u9001\u5bfc\u51fa\u8bb0\u5f55\u6d88\u606f\u5f02\u5e38,{}", (Object)e.getMessage(), (Object)e);
            result.setResult((Serializable)Boolean.valueOf(false));
            result.setErrorInfo(new ErrorInfo(ExceptionEnum.SEND_MQ_EXCEPTION.getErrCode(), ExceptionEnum.SEND_MQ_EXCEPTION.getErrCodeDes()));
            return result;
        }
        return result;
    }

    public ResultBean<Boolean> exportExtendProperty(ExtendPropertyBean bean) {
        ResultBean result = new ResultBean();
        result.setResult((Serializable)Boolean.valueOf(true));
        FileTask fileTask = this.baseComponent.insertTaskFile(bean.getBrandId(), bean.getSysCompanyId(), bean.getSysAccountId(), bean.getAccountName(), "\u5bfc\u51fa\u6269\u5c55\u5c5e\u6027");
        if (fileTask == null) {
            result.setResult((Serializable)Boolean.valueOf(false));
            result.setErrorInfo(new ErrorInfo(ExceptionEnum.ONGOING_COUNT_OUT_EXCEPTION.getErrCode(), ExceptionEnum.ONGOING_COUNT_OUT_EXCEPTION.getErrCodeDes()));
            return result;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("brandId", String.valueOf(bean.getBrandId()));
        map.put("sysCompanyId", String.valueOf(bean.getSysCompanyId()));
        map.put("propertyName", bean.getPropertyName());
        map.put("propertyType", bean.getPropertyType());
        map.put("defType", bean.getDefType() == null ? "2" : String.valueOf(bean.getDefType()));
        MessageBean messageBean = new MessageBean();
        messageBean.setTaskId(fileTask.getTaskId());
        messageBean.setStrategyType(StrategyTypeEnum.EXTEND_PROPERTY_STRATEGY.getType());
        messageBean.setMap(map);
        log.info("\u53d1\u9001\u6269\u5c55\u5c5e\u6027\u5bfc\u51fa\u8bb0\u5f55\u6d88\u606f\u5165\u53c2,{}", (Object)messageBean);
        try {
            this.rocketMQTemplate.send(Destination.builder().topic("TOPIC_EXPORT_NEW").build(), (Object)messageBean);
        }
        catch (Exception e) {
            log.info("\u53d1\u9001\u5bfc\u51fa\u8bb0\u5f55\u6d88\u606f\u5f02\u5e38,{}", (Object)e.getMessage(), (Object)e);
            result.setResult((Serializable)Boolean.valueOf(false));
            result.setErrorInfo(new ErrorInfo(ExceptionEnum.SEND_MQ_EXCEPTION.getErrCode(), ExceptionEnum.SEND_MQ_EXCEPTION.getErrCodeDes()));
            return result;
        }
        return result;
    }

    public ResultBean<Boolean> exportMbrImport(MbrImportBean bean) {
        ResultBean result = new ResultBean();
        result.setResult((Serializable)Boolean.valueOf(true));
        FileTask fileTask = this.baseComponent.insertTaskFile(bean.getBrandId(), bean.getSysCompanyId(), bean.getSysAccountId(), bean.getAccountName(), "\u4f1a\u5458\u6570\u636e\u5bfc\u51fa");
        if (fileTask == null) {
            result.setResult((Serializable)Boolean.valueOf(false));
            result.setErrorInfo(new ErrorInfo(ExceptionEnum.ONGOING_COUNT_OUT_EXCEPTION.getErrCode(), ExceptionEnum.ONGOING_COUNT_OUT_EXCEPTION.getErrCodeDes()));
            return result;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("brandId", String.valueOf(bean.getBrandId()));
        map.put("sysCompanyId", String.valueOf(bean.getSysCompanyId()));
        map.put("name", bean.getCondition());
        map.put("createDateStart", bean.getCreateDateStart());
        map.put("createDateEnd", bean.getCreateDateEnd());
        map.put("importStatus", String.valueOf(bean.getImportStatus()));
        map.put("mbrMemberExportIds", bean.getMbrMemberExportIds());
        MessageBean messageBean = new MessageBean();
        messageBean.setTaskId(fileTask.getTaskId());
        messageBean.setStrategyType(StrategyTypeEnum.MEMBER_IMPORT_STRATEGY.getType());
        messageBean.setMap(map);
        log.info("\u53d1\u9001\u4f1a\u5458\u5bfc\u5165\u8bb0\u5f55\u5165\u53c2,{}", (Object)messageBean);
        try {
            this.rocketMQTemplate.send(Destination.builder().topic("TOPIC_EXPORT_NEW").build(), (Object)messageBean);
        }
        catch (Exception e) {
            log.info("\u53d1\u9001\u4f1a\u5458\u5bfc\u5165\u8bb0\u5f55\u6d88\u606f\u5f02\u5e38,{}", (Object)e.getMessage(), (Object)e);
            result.setResult((Serializable)Boolean.valueOf(false));
            result.setErrorInfo(new ErrorInfo(ExceptionEnum.SEND_MQ_EXCEPTION.getErrCode(), ExceptionEnum.SEND_MQ_EXCEPTION.getErrCodeDes()));
            return result;
        }
        return result;
    }

    public ResultBean<Boolean> exportLevelChangeRecord(LevelBean bean) {
        ResultBean result = new ResultBean();
        result.setResult((Serializable)Boolean.valueOf(true));
        FileTask fileTask = this.baseComponent.insertTaskFile(bean.getBrandId(), bean.getSysCompanyId(), bean.getSysAccountId(), bean.getAccountName(), "\u5bfc\u51fa\u5347\u964d\u7ea7\u8bb0\u5f55");
        if (fileTask == null) {
            result.setResult((Serializable)Boolean.valueOf(false));
            result.setErrorInfo(new ErrorInfo(ExceptionEnum.ONGOING_COUNT_OUT_EXCEPTION.getErrCode(), ExceptionEnum.ONGOING_COUNT_OUT_EXCEPTION.getErrCodeDes()));
            return result;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("opsType", Objects.nonNull(bean.getOpsType()) ? String.valueOf(bean.getOpsType()) : null);
        map.put("brandId", String.valueOf(bean.getBrandId()));
        map.put("sysCompanyId", String.valueOf(bean.getSysCompanyId()));
        map.put("mbrCheckGradeRecord", Objects.nonNull(bean.getMbrCheckGradeRecord()) ? String.valueOf(bean.getMbrCheckGradeRecord()) : null);
        map.put("originLevelId", Objects.nonNull(bean.getOriginLevelId()) ? String.valueOf(bean.getOriginLevelId()) : null);
        map.put("currentLevelId", Objects.nonNull(bean.getCurrentLevelId()) ? String.valueOf(bean.getCurrentLevelId()) : null);
        map.put("resultFlag", Objects.nonNull(bean.getResultFlag()) ? String.valueOf(bean.getResultFlag()) : null);
        map.put("startTime", Objects.nonNull(bean.getStartTime()) ? ExportService.getStringDate((Date)bean.getStartTime()) : null);
        map.put("endTime", Objects.nonNull(bean.getEndTime()) ? ExportService.getStringDate((Date)bean.getEndTime()) : null);
        map.put("name", bean.getName());
        MessageBean messageBean = new MessageBean();
        messageBean.setTaskId(fileTask.getTaskId());
        messageBean.setStrategyType(StrategyTypeEnum.LEVEL_CHANGE_STRATEGY.getType());
        messageBean.setMap(map);
        log.info("\u53d1\u9001\u5bfc\u51fa\u7b49\u7ea7\u53d8\u66f4\u8bb0\u5f55\u6d88\u606f\u5165\u53c2,{}", (Object)messageBean);
        try {
            this.rocketMQTemplate.send(Destination.builder().topic("TOPIC_EXPORT_NEW").build(), (Object)messageBean);
        }
        catch (Exception e) {
            log.info("\u53d1\u9001\u5bfc\u51fa\u8bb0\u5f55\u6d88\u606f\u5f02\u5e38,{}", (Object)e.getMessage(), (Object)e);
            result.setResult((Serializable)Boolean.valueOf(false));
            result.setErrorInfo(new ErrorInfo(ExceptionEnum.SEND_MQ_EXCEPTION.getErrCode(), ExceptionEnum.SEND_MQ_EXCEPTION.getErrCodeDes()));
            return result;
        }
        return result;
    }

    public ResultBean<Boolean> exportPayCardRecord(PayRechargeBean bean) {
        ResultBean result = new ResultBean();
        result.setResult((Serializable)Boolean.valueOf(true));
        FileTask fileTask = this.baseComponent.insertTaskFile(bean.getBrandId(), bean.getSysCompanyId(), bean.getSysAccountId(), bean.getAccountName(), "\u5bfc\u51fa\u4ed8\u8d39\u5361\u8bb0\u5f55");
        if (fileTask == null) {
            result.setResult((Serializable)Boolean.valueOf(false));
            result.setErrorInfo(new ErrorInfo(ExceptionEnum.ONGOING_COUNT_OUT_EXCEPTION.getErrCode(), ExceptionEnum.ONGOING_COUNT_OUT_EXCEPTION.getErrCodeDes()));
            return result;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sysCompanyId", String.valueOf(bean.getSysCompanyId()));
        map.put("brandId", String.valueOf(bean.getBrandId()));
        map.put("condition", bean.getCondition());
        map.put("payLevelId", Objects.nonNull(bean.getPayLevelId()) ? String.valueOf(bean.getPayLevelId()) : null);
        map.put("storeIdList", Objects.nonNull(bean.getStoreIdList()) ? Joiner.on((String)",").join((Iterable)bean.getStoreIdList()) : null);
        map.put("guideIdList", Objects.nonNull(bean.getGuideIdList()) ? Joiner.on((String)",").join((Iterable)bean.getGuideIdList()) : null);
        map.put("status", Objects.nonNull(bean.getStatus()) ? String.valueOf(bean.getStatus()) : null);
        map.put("buyTimeBegin", Objects.nonNull(bean.getBuyTimeBegin()) ? ExportService.getStringDate((Date)bean.getBuyTimeBegin()) : null);
        map.put("buyTimeEnd", Objects.nonNull(bean.getBuyTimeEnd()) ? ExportService.getStringDate((Date)bean.getBuyTimeEnd()) : null);
        map.put("expireTimeBegin", Objects.nonNull(bean.getExpireTimeBegin()) ? ExportService.getStringDate((Date)bean.getExpireTimeBegin()) : null);
        map.put("expireTimeEnd", Objects.nonNull(bean.getExpireTimeEnd()) ? ExportService.getStringDate((Date)bean.getExpireTimeEnd()) : null);
        MessageBean messageBean = new MessageBean();
        messageBean.setTaskId(fileTask.getTaskId());
        messageBean.setStrategyType(StrategyTypeEnum.PAY_CARD_RECORD_STRATEGY.getType());
        messageBean.setMap(map);
        log.info("\u53d1\u9001\u4ed8\u8d39\u5361\u8d2d\u4e70\u8bb0\u5f55\u6d88\u606f\u5165\u53c2,{}", (Object)messageBean);
        try {
            this.rocketMQTemplate.send(Destination.builder().topic("TOPIC_EXPORT_NEW").build(), (Object)messageBean);
        }
        catch (Exception e) {
            log.info("\u53d1\u9001\u5bfc\u51fa\u8bb0\u5f55\u6d88\u606f\u5f02\u5e38,{}", (Object)e.getMessage(), (Object)e);
            result.setResult((Serializable)Boolean.valueOf(false));
            result.setErrorInfo(new ErrorInfo(ExceptionEnum.SEND_MQ_EXCEPTION.getErrCode(), ExceptionEnum.SEND_MQ_EXCEPTION.getErrCodeDes()));
            return result;
        }
        return result;
    }

    public ResultBean<Boolean> exportMemberTag(MemberTagBean memberTagBean) {
        ResultBean result = new ResultBean();
        result.setResult((Serializable)Boolean.valueOf(true));
        FileTask fileTask = this.baseComponent.insertTaskFile(memberTagBean.getBrandId(), memberTagBean.getCompanyId(), memberTagBean.getSysAccountId(), memberTagBean.getAccountName(), "\u5bfc\u51fa\u4f1a\u5458\u6807\u7b7e\u8bb0\u5f55");
        if (fileTask == null) {
            result.setResult((Serializable)Boolean.valueOf(false));
            result.setErrorInfo(new ErrorInfo(ExceptionEnum.ONGOING_COUNT_OUT_EXCEPTION.getErrCode(), ExceptionEnum.ONGOING_COUNT_OUT_EXCEPTION.getErrCodeDes()));
            return result;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("companyId", String.valueOf(memberTagBean.getCompanyId()));
        map.put("brandId", String.valueOf(memberTagBean.getBrandId()));
        map.put("labelName", memberTagBean.getLabelName());
        map.put("labelType", memberTagBean.getLabelType());
        map.put("operationUserName", memberTagBean.getOperationUserName());
        map.put("userCode", memberTagBean.getUserCode());
        map.put("operatedMemberName", memberTagBean.getOperatedMemberName());
        map.put("operationStartTime", memberTagBean.getOperationStartTime());
        map.put("operationEndTime", memberTagBean.getOperationEndTime());
        map.put("actions", memberTagBean.getActions());
        MessageBean messageBean = new MessageBean();
        messageBean.setTaskId(fileTask.getTaskId());
        messageBean.setStrategyType(StrategyTypeEnum.MEMBER_TAG_STRATEGY.getType());
        messageBean.setMap(map);
        log.info("\u53d1\u9001\u4f1a\u5458\u6807\u7b7e\u8bb0\u5f55\u6d88\u606f\u5165\u53c2,{}", (Object)messageBean);
        try {
            this.rocketMQTemplate.send(Destination.builder().topic("TOPIC_EXPORT_NEW").build(), (Object)messageBean);
        }
        catch (Exception e) {
            log.info("\u53d1\u9001\u5bfc\u51fa\u8bb0\u5f55\u6d88\u606f\u5f02\u5e38,{}", (Object)e.getMessage(), (Object)e);
            result.setResult((Serializable)Boolean.valueOf(false));
            result.setErrorInfo(new ErrorInfo(ExceptionEnum.SEND_MQ_EXCEPTION.getErrCode(), ExceptionEnum.SEND_MQ_EXCEPTION.getErrCodeDes()));
            return result;
        }
        return result;
    }
}

